<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.EssentialSeriesSeatData StructType
 * @subpackage Structs
 */
class Ticketing_EssentialSeriesSeatData extends Ticketing_EssentialSeatData
{
    /**
     * The NormalizedRowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NormalizedRowName;
    /**
     * The NormalizedSeatName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NormalizedSeatName;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * Constructor method for Ticketing.EssentialSeriesSeatData
     * @uses Ticketing_EssentialSeriesSeatData::setNormalizedRowName()
     * @uses Ticketing_EssentialSeriesSeatData::setNormalizedSeatName()
     * @uses Ticketing_EssentialSeriesSeatData::setSeriesId()
     * @param string $normalizedRowName
     * @param string $normalizedSeatName
     * @param string $seriesId
     */
    public function __construct($normalizedRowName = null, $normalizedSeatName = null, $seriesId = null)
    {
        $this
            ->setNormalizedRowName($normalizedRowName)
            ->setNormalizedSeatName($normalizedSeatName)
            ->setSeriesId($seriesId);
    }
    /**
     * Get NormalizedRowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNormalizedRowName()
    {
        return isset($this->NormalizedRowName) ? $this->NormalizedRowName : null;
    }
    /**
     * Set NormalizedRowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $normalizedRowName
     * @return \patest\StructType\Ticketing_EssentialSeriesSeatData
     */
    public function setNormalizedRowName($normalizedRowName = null)
    {
        // validation for constraint: string
        if (!is_null($normalizedRowName) && !is_string($normalizedRowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($normalizedRowName, true), gettype($normalizedRowName)), __LINE__);
        }
        if (is_null($normalizedRowName) || (is_array($normalizedRowName) && empty($normalizedRowName))) {
            unset($this->NormalizedRowName);
        } else {
            $this->NormalizedRowName = $normalizedRowName;
        }
        return $this;
    }
    /**
     * Get NormalizedSeatName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNormalizedSeatName()
    {
        return isset($this->NormalizedSeatName) ? $this->NormalizedSeatName : null;
    }
    /**
     * Set NormalizedSeatName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $normalizedSeatName
     * @return \patest\StructType\Ticketing_EssentialSeriesSeatData
     */
    public function setNormalizedSeatName($normalizedSeatName = null)
    {
        // validation for constraint: string
        if (!is_null($normalizedSeatName) && !is_string($normalizedSeatName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($normalizedSeatName, true), gettype($normalizedSeatName)), __LINE__);
        }
        if (is_null($normalizedSeatName) || (is_array($normalizedSeatName) && empty($normalizedSeatName))) {
            unset($this->NormalizedSeatName);
        } else {
            $this->NormalizedSeatName = $normalizedSeatName;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\Ticketing_EssentialSeriesSeatData
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
}
