<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.EssentialSeatData StructType
 * @subpackage Structs
 */
class Ticketing_EssentialSeatData extends AnyEntity
{
    /**
     * The AreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaId;
    /**
     * The AreaMapGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaMapGuid;
    /**
     * The HolderCompanyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HolderCompanyId;
    /**
     * The RowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RowName;
    /**
     * The RowOrdinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RowOrdinal;
    /**
     * The SeatIdInAreaMap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeatIdInAreaMap;
    /**
     * The SeatName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatName;
    /**
     * The SeatOrdinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeatOrdinal;
    /**
     * The SectorGlobalName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $SectorGlobalName;
    /**
     * The SectorId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SectorId;
    /**
     * The SectorOrdinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SectorOrdinal;
    /**
     * Constructor method for Ticketing.EssentialSeatData
     * @uses Ticketing_EssentialSeatData::setAreaId()
     * @uses Ticketing_EssentialSeatData::setAreaMapGuid()
     * @uses Ticketing_EssentialSeatData::setHolderCompanyId()
     * @uses Ticketing_EssentialSeatData::setRowName()
     * @uses Ticketing_EssentialSeatData::setRowOrdinal()
     * @uses Ticketing_EssentialSeatData::setSeatIdInAreaMap()
     * @uses Ticketing_EssentialSeatData::setSeatName()
     * @uses Ticketing_EssentialSeatData::setSeatOrdinal()
     * @uses Ticketing_EssentialSeatData::setSectorGlobalName()
     * @uses Ticketing_EssentialSeatData::setSectorId()
     * @uses Ticketing_EssentialSeatData::setSectorOrdinal()
     * @param string $areaId
     * @param string $areaMapGuid
     * @param int $holderCompanyId
     * @param string $rowName
     * @param int $rowOrdinal
     * @param int $seatIdInAreaMap
     * @param string $seatName
     * @param int $seatOrdinal
     * @param \patest\StructType\GlobalString $sectorGlobalName
     * @param string $sectorId
     * @param int $sectorOrdinal
     */
    public function __construct($areaId = null, $areaMapGuid = null, $holderCompanyId = null, $rowName = null, $rowOrdinal = null, $seatIdInAreaMap = null, $seatName = null, $seatOrdinal = null, \patest\StructType\GlobalString $sectorGlobalName = null, $sectorId = null, $sectorOrdinal = null)
    {
        $this
            ->setAreaId($areaId)
            ->setAreaMapGuid($areaMapGuid)
            ->setHolderCompanyId($holderCompanyId)
            ->setRowName($rowName)
            ->setRowOrdinal($rowOrdinal)
            ->setSeatIdInAreaMap($seatIdInAreaMap)
            ->setSeatName($seatName)
            ->setSeatOrdinal($seatOrdinal)
            ->setSectorGlobalName($sectorGlobalName)
            ->setSectorId($sectorId)
            ->setSectorOrdinal($sectorOrdinal);
    }
    /**
     * Get AreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaId()
    {
        return isset($this->AreaId) ? $this->AreaId : null;
    }
    /**
     * Set AreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaId
     * @return \patest\StructType\Ticketing_EssentialSeatData
     */
    public function setAreaId($areaId = null)
    {
        // validation for constraint: string
        if (!is_null($areaId) && !is_string($areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaId, true), gettype($areaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaId, true)), __LINE__);
        }
        if (is_null($areaId) || (is_array($areaId) && empty($areaId))) {
            unset($this->AreaId);
        } else {
            $this->AreaId = $areaId;
        }
        return $this;
    }
    /**
     * Get AreaMapGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaMapGuid()
    {
        return isset($this->AreaMapGuid) ? $this->AreaMapGuid : null;
    }
    /**
     * Set AreaMapGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaMapGuid
     * @return \patest\StructType\Ticketing_EssentialSeatData
     */
    public function setAreaMapGuid($areaMapGuid = null)
    {
        // validation for constraint: string
        if (!is_null($areaMapGuid) && !is_string($areaMapGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaMapGuid, true), gettype($areaMapGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaMapGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaMapGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaMapGuid, true)), __LINE__);
        }
        if (is_null($areaMapGuid) || (is_array($areaMapGuid) && empty($areaMapGuid))) {
            unset($this->AreaMapGuid);
        } else {
            $this->AreaMapGuid = $areaMapGuid;
        }
        return $this;
    }
    /**
     * Get HolderCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHolderCompanyId()
    {
        return isset($this->HolderCompanyId) ? $this->HolderCompanyId : null;
    }
    /**
     * Set HolderCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $holderCompanyId
     * @return \patest\StructType\Ticketing_EssentialSeatData
     */
    public function setHolderCompanyId($holderCompanyId = null)
    {
        // validation for constraint: int
        if (!is_null($holderCompanyId) && !(is_int($holderCompanyId) || ctype_digit($holderCompanyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($holderCompanyId, true), gettype($holderCompanyId)), __LINE__);
        }
        if (is_null($holderCompanyId) || (is_array($holderCompanyId) && empty($holderCompanyId))) {
            unset($this->HolderCompanyId);
        } else {
            $this->HolderCompanyId = $holderCompanyId;
        }
        return $this;
    }
    /**
     * Get RowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRowName()
    {
        return isset($this->RowName) ? $this->RowName : null;
    }
    /**
     * Set RowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $rowName
     * @return \patest\StructType\Ticketing_EssentialSeatData
     */
    public function setRowName($rowName = null)
    {
        // validation for constraint: string
        if (!is_null($rowName) && !is_string($rowName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($rowName, true), gettype($rowName)), __LINE__);
        }
        if (is_null($rowName) || (is_array($rowName) && empty($rowName))) {
            unset($this->RowName);
        } else {
            $this->RowName = $rowName;
        }
        return $this;
    }
    /**
     * Get RowOrdinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRowOrdinal()
    {
        return isset($this->RowOrdinal) ? $this->RowOrdinal : null;
    }
    /**
     * Set RowOrdinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $rowOrdinal
     * @return \patest\StructType\Ticketing_EssentialSeatData
     */
    public function setRowOrdinal($rowOrdinal = null)
    {
        // validation for constraint: int
        if (!is_null($rowOrdinal) && !(is_int($rowOrdinal) || ctype_digit($rowOrdinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rowOrdinal, true), gettype($rowOrdinal)), __LINE__);
        }
        if (is_null($rowOrdinal) || (is_array($rowOrdinal) && empty($rowOrdinal))) {
            unset($this->RowOrdinal);
        } else {
            $this->RowOrdinal = $rowOrdinal;
        }
        return $this;
    }
    /**
     * Get SeatIdInAreaMap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeatIdInAreaMap()
    {
        return isset($this->SeatIdInAreaMap) ? $this->SeatIdInAreaMap : null;
    }
    /**
     * Set SeatIdInAreaMap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seatIdInAreaMap
     * @return \patest\StructType\Ticketing_EssentialSeatData
     */
    public function setSeatIdInAreaMap($seatIdInAreaMap = null)
    {
        // validation for constraint: int
        if (!is_null($seatIdInAreaMap) && !(is_int($seatIdInAreaMap) || ctype_digit($seatIdInAreaMap))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatIdInAreaMap, true), gettype($seatIdInAreaMap)), __LINE__);
        }
        if (is_null($seatIdInAreaMap) || (is_array($seatIdInAreaMap) && empty($seatIdInAreaMap))) {
            unset($this->SeatIdInAreaMap);
        } else {
            $this->SeatIdInAreaMap = $seatIdInAreaMap;
        }
        return $this;
    }
    /**
     * Get SeatName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatName()
    {
        return isset($this->SeatName) ? $this->SeatName : null;
    }
    /**
     * Set SeatName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatName
     * @return \patest\StructType\Ticketing_EssentialSeatData
     */
    public function setSeatName($seatName = null)
    {
        // validation for constraint: string
        if (!is_null($seatName) && !is_string($seatName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatName, true), gettype($seatName)), __LINE__);
        }
        if (is_null($seatName) || (is_array($seatName) && empty($seatName))) {
            unset($this->SeatName);
        } else {
            $this->SeatName = $seatName;
        }
        return $this;
    }
    /**
     * Get SeatOrdinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeatOrdinal()
    {
        return isset($this->SeatOrdinal) ? $this->SeatOrdinal : null;
    }
    /**
     * Set SeatOrdinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seatOrdinal
     * @return \patest\StructType\Ticketing_EssentialSeatData
     */
    public function setSeatOrdinal($seatOrdinal = null)
    {
        // validation for constraint: int
        if (!is_null($seatOrdinal) && !(is_int($seatOrdinal) || ctype_digit($seatOrdinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatOrdinal, true), gettype($seatOrdinal)), __LINE__);
        }
        if (is_null($seatOrdinal) || (is_array($seatOrdinal) && empty($seatOrdinal))) {
            unset($this->SeatOrdinal);
        } else {
            $this->SeatOrdinal = $seatOrdinal;
        }
        return $this;
    }
    /**
     * Get SectorGlobalName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getSectorGlobalName()
    {
        return isset($this->SectorGlobalName) ? $this->SectorGlobalName : null;
    }
    /**
     * Set SectorGlobalName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $sectorGlobalName
     * @return \patest\StructType\Ticketing_EssentialSeatData
     */
    public function setSectorGlobalName(\patest\StructType\GlobalString $sectorGlobalName = null)
    {
        if (is_null($sectorGlobalName) || (is_array($sectorGlobalName) && empty($sectorGlobalName))) {
            unset($this->SectorGlobalName);
        } else {
            $this->SectorGlobalName = $sectorGlobalName;
        }
        return $this;
    }
    /**
     * Get SectorId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectorId()
    {
        return isset($this->SectorId) ? $this->SectorId : null;
    }
    /**
     * Set SectorId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectorId
     * @return \patest\StructType\Ticketing_EssentialSeatData
     */
    public function setSectorId($sectorId = null)
    {
        // validation for constraint: string
        if (!is_null($sectorId) && !is_string($sectorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectorId, true), gettype($sectorId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($sectorId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $sectorId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($sectorId, true)), __LINE__);
        }
        if (is_null($sectorId) || (is_array($sectorId) && empty($sectorId))) {
            unset($this->SectorId);
        } else {
            $this->SectorId = $sectorId;
        }
        return $this;
    }
    /**
     * Get SectorOrdinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSectorOrdinal()
    {
        return isset($this->SectorOrdinal) ? $this->SectorOrdinal : null;
    }
    /**
     * Set SectorOrdinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $sectorOrdinal
     * @return \patest\StructType\Ticketing_EssentialSeatData
     */
    public function setSectorOrdinal($sectorOrdinal = null)
    {
        // validation for constraint: int
        if (!is_null($sectorOrdinal) && !(is_int($sectorOrdinal) || ctype_digit($sectorOrdinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sectorOrdinal, true), gettype($sectorOrdinal)), __LINE__);
        }
        if (is_null($sectorOrdinal) || (is_array($sectorOrdinal) && empty($sectorOrdinal))) {
            unset($this->SectorOrdinal);
        } else {
            $this->SectorOrdinal = $sectorOrdinal;
        }
        return $this;
    }
}
