<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.ClientTicketsRow StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Ticketing.ClientTicketsRow
 * @subpackage Structs
 */
class Ticketing_ClientTicketsRow extends AnyEntity
{
    /**
     * The AgencyGuid
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AgencyGuid;
    /**
     * The Barcode
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Barcode;
    /**
     * The BookingInfo
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BookingInfo;
    /**
     * The DisplayedTicketNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DisplayedTicketNumber;
    /**
     * The Effective
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Effective;
    /**
     * The EventDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDate;
    /**
     * The EventGuid
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventGuid;
    /**
     * The FirstEntryScanDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FirstEntryScanDate;
    /**
     * The FormattedEventDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FormattedEventDate;
    /**
     * The HasHistoryIcon
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HasHistoryIcon;
    /**
     * The History
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $History;
    /**
     * The IsComplimentary
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsComplimentary;
    /**
     * The IsReplaceSubsTicketAllowed
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsReplaceSubsTicketAllowed;
    /**
     * The IsResale
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsResale;
    /**
     * The IsReserved
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsReserved;
    /**
     * The IsReturned
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsReturned;
    /**
     * The IsTurnback
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsTurnback;
    /**
     * The Note
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Note;
    /**
     * The Owner
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Owner;
    /**
     * The OwnerGuid
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnerGuid;
    /**
     * The PrintedIcon
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PrintedIcon;
    /**
     * The PurchaseInfo
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PurchaseInfo;
    /**
     * The PurchaserGuid
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PurchaserGuid;
    /**
     * The Qunatity
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Qunatity;
    /**
     * The ResaleMethod
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResaleMethod;
    /**
     * The ResaleStatus
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ResaleStatus;
    /**
     * The ReservedIcon
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ReservedIcon;
    /**
     * The ReturnIcon
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ReturnIcon;
    /**
     * The ShowGuid
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ShowGuid;
    /**
     * The ShowName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShowName;
    /**
     * The StatusIcons
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StatusIcons;
    /**
     * The SubscriptionIcon
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SubscriptionIcon;
    /**
     * The SubscriptionInstance
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubscriptionInstance;
    /**
     * The TicketIds
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketIds;
    /**
     * The TransactionDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TransactionDate;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The TransactionNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionNumber;
    /**
     * The TransactionReferenceNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionReferenceNumber;
    /**
     * Constructor method for Ticketing.ClientTicketsRow
     * @uses Ticketing_ClientTicketsRow::setAgencyGuid()
     * @uses Ticketing_ClientTicketsRow::setBarcode()
     * @uses Ticketing_ClientTicketsRow::setBookingInfo()
     * @uses Ticketing_ClientTicketsRow::setDisplayedTicketNumber()
     * @uses Ticketing_ClientTicketsRow::setEffective()
     * @uses Ticketing_ClientTicketsRow::setEventDate()
     * @uses Ticketing_ClientTicketsRow::setEventGuid()
     * @uses Ticketing_ClientTicketsRow::setFirstEntryScanDate()
     * @uses Ticketing_ClientTicketsRow::setFormattedEventDate()
     * @uses Ticketing_ClientTicketsRow::setHasHistoryIcon()
     * @uses Ticketing_ClientTicketsRow::setHistory()
     * @uses Ticketing_ClientTicketsRow::setIsComplimentary()
     * @uses Ticketing_ClientTicketsRow::setIsReplaceSubsTicketAllowed()
     * @uses Ticketing_ClientTicketsRow::setIsResale()
     * @uses Ticketing_ClientTicketsRow::setIsReserved()
     * @uses Ticketing_ClientTicketsRow::setIsReturned()
     * @uses Ticketing_ClientTicketsRow::setIsTurnback()
     * @uses Ticketing_ClientTicketsRow::setNote()
     * @uses Ticketing_ClientTicketsRow::setOwner()
     * @uses Ticketing_ClientTicketsRow::setOwnerGuid()
     * @uses Ticketing_ClientTicketsRow::setPrintedIcon()
     * @uses Ticketing_ClientTicketsRow::setPurchaseInfo()
     * @uses Ticketing_ClientTicketsRow::setPurchaserGuid()
     * @uses Ticketing_ClientTicketsRow::setQunatity()
     * @uses Ticketing_ClientTicketsRow::setResaleMethod()
     * @uses Ticketing_ClientTicketsRow::setResaleStatus()
     * @uses Ticketing_ClientTicketsRow::setReservedIcon()
     * @uses Ticketing_ClientTicketsRow::setReturnIcon()
     * @uses Ticketing_ClientTicketsRow::setShowGuid()
     * @uses Ticketing_ClientTicketsRow::setShowName()
     * @uses Ticketing_ClientTicketsRow::setStatusIcons()
     * @uses Ticketing_ClientTicketsRow::setSubscriptionIcon()
     * @uses Ticketing_ClientTicketsRow::setSubscriptionInstance()
     * @uses Ticketing_ClientTicketsRow::setTicketIds()
     * @uses Ticketing_ClientTicketsRow::setTransactionDate()
     * @uses Ticketing_ClientTicketsRow::setTransactionGuid()
     * @uses Ticketing_ClientTicketsRow::setTransactionNumber()
     * @uses Ticketing_ClientTicketsRow::setTransactionReferenceNumber()
     * @param string $agencyGuid
     * @param string $barcode
     * @param string $bookingInfo
     * @param int $displayedTicketNumber
     * @param bool $effective
     * @param string $eventDate
     * @param string $eventGuid
     * @param string $firstEntryScanDate
     * @param string $formattedEventDate
     * @param int $hasHistoryIcon
     * @param bool $history
     * @param bool $isComplimentary
     * @param bool $isReplaceSubsTicketAllowed
     * @param bool $isResale
     * @param bool $isReserved
     * @param bool $isReturned
     * @param bool $isTurnback
     * @param string $note
     * @param string $owner
     * @param string $ownerGuid
     * @param int $printedIcon
     * @param string $purchaseInfo
     * @param string $purchaserGuid
     * @param int $qunatity
     * @param string $resaleMethod
     * @param string $resaleStatus
     * @param int $reservedIcon
     * @param int $returnIcon
     * @param string $showGuid
     * @param string $showName
     * @param string $statusIcons
     * @param int $subscriptionIcon
     * @param string $subscriptionInstance
     * @param string $ticketIds
     * @param string $transactionDate
     * @param string $transactionGuid
     * @param int $transactionNumber
     * @param int $transactionReferenceNumber
     */
    public function __construct($agencyGuid = null, $barcode = null, $bookingInfo = null, $displayedTicketNumber = null, $effective = null, $eventDate = null, $eventGuid = null, $firstEntryScanDate = null, $formattedEventDate = null, $hasHistoryIcon = null, $history = null, $isComplimentary = null, $isReplaceSubsTicketAllowed = null, $isResale = null, $isReserved = null, $isReturned = null, $isTurnback = null, $note = null, $owner = null, $ownerGuid = null, $printedIcon = null, $purchaseInfo = null, $purchaserGuid = null, $qunatity = null, $resaleMethod = null, $resaleStatus = null, $reservedIcon = null, $returnIcon = null, $showGuid = null, $showName = null, $statusIcons = null, $subscriptionIcon = null, $subscriptionInstance = null, $ticketIds = null, $transactionDate = null, $transactionGuid = null, $transactionNumber = null, $transactionReferenceNumber = null)
    {
        $this
            ->setAgencyGuid($agencyGuid)
            ->setBarcode($barcode)
            ->setBookingInfo($bookingInfo)
            ->setDisplayedTicketNumber($displayedTicketNumber)
            ->setEffective($effective)
            ->setEventDate($eventDate)
            ->setEventGuid($eventGuid)
            ->setFirstEntryScanDate($firstEntryScanDate)
            ->setFormattedEventDate($formattedEventDate)
            ->setHasHistoryIcon($hasHistoryIcon)
            ->setHistory($history)
            ->setIsComplimentary($isComplimentary)
            ->setIsReplaceSubsTicketAllowed($isReplaceSubsTicketAllowed)
            ->setIsResale($isResale)
            ->setIsReserved($isReserved)
            ->setIsReturned($isReturned)
            ->setIsTurnback($isTurnback)
            ->setNote($note)
            ->setOwner($owner)
            ->setOwnerGuid($ownerGuid)
            ->setPrintedIcon($printedIcon)
            ->setPurchaseInfo($purchaseInfo)
            ->setPurchaserGuid($purchaserGuid)
            ->setQunatity($qunatity)
            ->setResaleMethod($resaleMethod)
            ->setResaleStatus($resaleStatus)
            ->setReservedIcon($reservedIcon)
            ->setReturnIcon($returnIcon)
            ->setShowGuid($showGuid)
            ->setShowName($showName)
            ->setStatusIcons($statusIcons)
            ->setSubscriptionIcon($subscriptionIcon)
            ->setSubscriptionInstance($subscriptionInstance)
            ->setTicketIds($ticketIds)
            ->setTransactionDate($transactionDate)
            ->setTransactionGuid($transactionGuid)
            ->setTransactionNumber($transactionNumber)
            ->setTransactionReferenceNumber($transactionReferenceNumber);
    }
    /**
     * Get AgencyGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgencyGuid()
    {
        return isset($this->AgencyGuid) ? $this->AgencyGuid : null;
    }
    /**
     * Set AgencyGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agencyGuid
     * @return \patest\StructType\Ticketing_ClientTicketsRow
     */
    public function setAgencyGuid($agencyGuid = null)
    {
        // validation for constraint: string
        if (!is_null($agencyGuid) && !is_string($agencyGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($agencyGuid, true), gettype($agencyGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($agencyGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $agencyGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($agencyGuid, true)), __LINE__);
        }
        if (is_null($agencyGuid) || (is_array($agencyGuid) && empty($agencyGuid))) {
            unset($this->AgencyGuid);
        } else {
            $this->AgencyGuid = $agencyGuid;
        }
        return $this;
    }
    /**
     * Get Barcode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBarcode()
    {
        return isset($this->Barcode) ? $this->Barcode : null;
    }
    /**
     * Set Barcode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $barcode
     * @return \patest\StructType\Ticketing_ClientTicketsRow
     */
    public function setBarcode($barcode = null)
    {
        // validation for constraint: string
        if (!is_null($barcode) && !is_string($barcode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($barcode, true), gettype($barcode)), __LINE__);
        }
        if (is_null($barcode) || (is_array($barcode) && empty($barcode))) {
            unset($this->Barcode);
        } else {
            $this->Barcode = $barcode;
        }
        return $this;
    }
    /**
     * Get BookingInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBookingInfo()
    {
        return isset($this->BookingInfo) ? $this->BookingInfo : null;
    }
    /**
     * Set BookingInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bookingInfo
     * @return \patest\StructType\Ticketing_ClientTicketsRow
     */
    public function setBookingInfo($bookingInfo = null)
    {
        // validation for constraint: string
        if (!is_null($bookingInfo) && !is_string($bookingInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bookingInfo, true), gettype($bookingInfo)), __LINE__);
        }
        if (is_null($bookingInfo) || (is_array($bookingInfo) && empty($bookingInfo))) {
            unset($this->BookingInfo);
        } else {
            $this->BookingInfo = $bookingInfo;
        }
        return $this;
    }
    /**
     * Get DisplayedTicketNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDisplayedTicketNumber()
    {
        return isset($this->DisplayedTicketNumber) ? $this->DisplayedTicketNumber : null;
    }
    /**
     * Set DisplayedTicketNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $displayedTicketNumber
     * @return \patest\StructType\Ticketing_ClientTicketsRow
     */
    public function setDisplayedTicketNumber($displayedTicketNumber = null)
    {
        // validation for constraint: int
        if (!is_null($displayedTicketNumber) && !(is_int($displayedTicketNumber) || ctype_digit($displayedTicketNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($displayedTicketNumber, true), gettype($displayedTicketNumber)), __LINE__);
        }
        if (is_null($displayedTicketNumber) || (is_array($displayedTicketNumber) && empty($displayedTicketNumber))) {
            unset($this->DisplayedTicketNumber);
        } else {
            $this->DisplayedTicketNumber = $displayedTicketNumber;
        }
        return $this;
    }
    /**
     * Get Effective value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEffective()
    {
        return isset($this->Effective) ? $this->Effective : null;
    }
    /**
     * Set Effective value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $effective
     * @return \patest\StructType\Ticketing_ClientTicketsRow
     */
    public function setEffective($effective = null)
    {
        // validation for constraint: boolean
        if (!is_null($effective) && !is_bool($effective)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($effective, true), gettype($effective)), __LINE__);
        }
        if (is_null($effective) || (is_array($effective) && empty($effective))) {
            unset($this->Effective);
        } else {
            $this->Effective = $effective;
        }
        return $this;
    }
    /**
     * Get EventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDate()
    {
        return isset($this->EventDate) ? $this->EventDate : null;
    }
    /**
     * Set EventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDate
     * @return \patest\StructType\Ticketing_ClientTicketsRow
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDate, true), gettype($eventDate)), __LINE__);
        }
        if (is_null($eventDate) || (is_array($eventDate) && empty($eventDate))) {
            unset($this->EventDate);
        } else {
            $this->EventDate = $eventDate;
        }
        return $this;
    }
    /**
     * Get EventGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventGuid()
    {
        return isset($this->EventGuid) ? $this->EventGuid : null;
    }
    /**
     * Set EventGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventGuid
     * @return \patest\StructType\Ticketing_ClientTicketsRow
     */
    public function setEventGuid($eventGuid = null)
    {
        // validation for constraint: string
        if (!is_null($eventGuid) && !is_string($eventGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventGuid, true), gettype($eventGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventGuid, true)), __LINE__);
        }
        if (is_null($eventGuid) || (is_array($eventGuid) && empty($eventGuid))) {
            unset($this->EventGuid);
        } else {
            $this->EventGuid = $eventGuid;
        }
        return $this;
    }
    /**
     * Get FirstEntryScanDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirstEntryScanDate()
    {
        return isset($this->FirstEntryScanDate) ? $this->FirstEntryScanDate : null;
    }
    /**
     * Set FirstEntryScanDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $firstEntryScanDate
     * @return \patest\StructType\Ticketing_ClientTicketsRow
     */
    public function setFirstEntryScanDate($firstEntryScanDate = null)
    {
        // validation for constraint: string
        if (!is_null($firstEntryScanDate) && !is_string($firstEntryScanDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($firstEntryScanDate, true), gettype($firstEntryScanDate)), __LINE__);
        }
        if (is_null($firstEntryScanDate) || (is_array($firstEntryScanDate) && empty($firstEntryScanDate))) {
            unset($this->FirstEntryScanDate);
        } else {
            $this->FirstEntryScanDate = $firstEntryScanDate;
        }
        return $this;
    }
    /**
     * Get FormattedEventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormattedEventDate()
    {
        return isset($this->FormattedEventDate) ? $this->FormattedEventDate : null;
    }
    /**
     * Set FormattedEventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formattedEventDate
     * @return \patest\StructType\Ticketing_ClientTicketsRow
     */
    public function setFormattedEventDate($formattedEventDate = null)
    {
        // validation for constraint: string
        if (!is_null($formattedEventDate) && !is_string($formattedEventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($formattedEventDate, true), gettype($formattedEventDate)), __LINE__);
        }
        if (is_null($formattedEventDate) || (is_array($formattedEventDate) && empty($formattedEventDate))) {
            unset($this->FormattedEventDate);
        } else {
            $this->FormattedEventDate = $formattedEventDate;
        }
        return $this;
    }
    /**
     * Get HasHistoryIcon value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHasHistoryIcon()
    {
        return isset($this->HasHistoryIcon) ? $this->HasHistoryIcon : null;
    }
    /**
     * Set HasHistoryIcon value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $hasHistoryIcon
     * @return \patest\StructType\Ticketing_ClientTicketsRow
     */
    public function setHasHistoryIcon($hasHistoryIcon = null)
    {
        // validation for constraint: int
        if (!is_null($hasHistoryIcon) && !(is_int($hasHistoryIcon) || ctype_digit($hasHistoryIcon))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($hasHistoryIcon, true), gettype($hasHistoryIcon)), __LINE__);
        }
        if (is_null($hasHistoryIcon) || (is_array($hasHistoryIcon) && empty($hasHistoryIcon))) {
            unset($this->HasHistoryIcon);
        } else {
            $this->HasHistoryIcon = $hasHistoryIcon;
        }
        return $this;
    }
    /**
     * Get History value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHistory()
    {
        return isset($this->History) ? $this->History : null;
    }
    /**
     * Set History value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $history
     * @return \patest\StructType\Ticketing_ClientTicketsRow
     */
    public function setHistory($history = null)
    {
        // validation for constraint: boolean
        if (!is_null($history) && !is_bool($history)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($history, true), gettype($history)), __LINE__);
        }
        if (is_null($history) || (is_array($history) && empty($history))) {
            unset($this->History);
        } else {
            $this->History = $history;
        }
        return $this;
    }
    /**
     * Get IsComplimentary value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsComplimentary()
    {
        return isset($this->IsComplimentary) ? $this->IsComplimentary : null;
    }
    /**
     * Set IsComplimentary value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isComplimentary
     * @return \patest\StructType\Ticketing_ClientTicketsRow
     */
    public function setIsComplimentary($isComplimentary = null)
    {
        // validation for constraint: boolean
        if (!is_null($isComplimentary) && !is_bool($isComplimentary)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isComplimentary, true), gettype($isComplimentary)), __LINE__);
        }
        if (is_null($isComplimentary) || (is_array($isComplimentary) && empty($isComplimentary))) {
            unset($this->IsComplimentary);
        } else {
            $this->IsComplimentary = $isComplimentary;
        }
        return $this;
    }
    /**
     * Get IsReplaceSubsTicketAllowed value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsReplaceSubsTicketAllowed()
    {
        return isset($this->IsReplaceSubsTicketAllowed) ? $this->IsReplaceSubsTicketAllowed : null;
    }
    /**
     * Set IsReplaceSubsTicketAllowed value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isReplaceSubsTicketAllowed
     * @return \patest\StructType\Ticketing_ClientTicketsRow
     */
    public function setIsReplaceSubsTicketAllowed($isReplaceSubsTicketAllowed = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReplaceSubsTicketAllowed) && !is_bool($isReplaceSubsTicketAllowed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReplaceSubsTicketAllowed, true), gettype($isReplaceSubsTicketAllowed)), __LINE__);
        }
        if (is_null($isReplaceSubsTicketAllowed) || (is_array($isReplaceSubsTicketAllowed) && empty($isReplaceSubsTicketAllowed))) {
            unset($this->IsReplaceSubsTicketAllowed);
        } else {
            $this->IsReplaceSubsTicketAllowed = $isReplaceSubsTicketAllowed;
        }
        return $this;
    }
    /**
     * Get IsResale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsResale()
    {
        return isset($this->IsResale) ? $this->IsResale : null;
    }
    /**
     * Set IsResale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isResale
     * @return \patest\StructType\Ticketing_ClientTicketsRow
     */
    public function setIsResale($isResale = null)
    {
        // validation for constraint: boolean
        if (!is_null($isResale) && !is_bool($isResale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isResale, true), gettype($isResale)), __LINE__);
        }
        if (is_null($isResale) || (is_array($isResale) && empty($isResale))) {
            unset($this->IsResale);
        } else {
            $this->IsResale = $isResale;
        }
        return $this;
    }
    /**
     * Get IsReserved value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsReserved()
    {
        return isset($this->IsReserved) ? $this->IsReserved : null;
    }
    /**
     * Set IsReserved value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isReserved
     * @return \patest\StructType\Ticketing_ClientTicketsRow
     */
    public function setIsReserved($isReserved = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReserved) && !is_bool($isReserved)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReserved, true), gettype($isReserved)), __LINE__);
        }
        if (is_null($isReserved) || (is_array($isReserved) && empty($isReserved))) {
            unset($this->IsReserved);
        } else {
            $this->IsReserved = $isReserved;
        }
        return $this;
    }
    /**
     * Get IsReturned value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsReturned()
    {
        return isset($this->IsReturned) ? $this->IsReturned : null;
    }
    /**
     * Set IsReturned value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isReturned
     * @return \patest\StructType\Ticketing_ClientTicketsRow
     */
    public function setIsReturned($isReturned = null)
    {
        // validation for constraint: boolean
        if (!is_null($isReturned) && !is_bool($isReturned)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isReturned, true), gettype($isReturned)), __LINE__);
        }
        if (is_null($isReturned) || (is_array($isReturned) && empty($isReturned))) {
            unset($this->IsReturned);
        } else {
            $this->IsReturned = $isReturned;
        }
        return $this;
    }
    /**
     * Get IsTurnback value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsTurnback()
    {
        return isset($this->IsTurnback) ? $this->IsTurnback : null;
    }
    /**
     * Set IsTurnback value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isTurnback
     * @return \patest\StructType\Ticketing_ClientTicketsRow
     */
    public function setIsTurnback($isTurnback = null)
    {
        // validation for constraint: boolean
        if (!is_null($isTurnback) && !is_bool($isTurnback)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isTurnback, true), gettype($isTurnback)), __LINE__);
        }
        if (is_null($isTurnback) || (is_array($isTurnback) && empty($isTurnback))) {
            unset($this->IsTurnback);
        } else {
            $this->IsTurnback = $isTurnback;
        }
        return $this;
    }
    /**
     * Get Note value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNote()
    {
        return isset($this->Note) ? $this->Note : null;
    }
    /**
     * Set Note value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $note
     * @return \patest\StructType\Ticketing_ClientTicketsRow
     */
    public function setNote($note = null)
    {
        // validation for constraint: string
        if (!is_null($note) && !is_string($note)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($note, true), gettype($note)), __LINE__);
        }
        if (is_null($note) || (is_array($note) && empty($note))) {
            unset($this->Note);
        } else {
            $this->Note = $note;
        }
        return $this;
    }
    /**
     * Get Owner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwner()
    {
        return isset($this->Owner) ? $this->Owner : null;
    }
    /**
     * Set Owner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $owner
     * @return \patest\StructType\Ticketing_ClientTicketsRow
     */
    public function setOwner($owner = null)
    {
        // validation for constraint: string
        if (!is_null($owner) && !is_string($owner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($owner, true), gettype($owner)), __LINE__);
        }
        if (is_null($owner) || (is_array($owner) && empty($owner))) {
            unset($this->Owner);
        } else {
            $this->Owner = $owner;
        }
        return $this;
    }
    /**
     * Get OwnerGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerGuid()
    {
        return isset($this->OwnerGuid) ? $this->OwnerGuid : null;
    }
    /**
     * Set OwnerGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerGuid
     * @return \patest\StructType\Ticketing_ClientTicketsRow
     */
    public function setOwnerGuid($ownerGuid = null)
    {
        // validation for constraint: string
        if (!is_null($ownerGuid) && !is_string($ownerGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerGuid, true), gettype($ownerGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ownerGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ownerGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ownerGuid, true)), __LINE__);
        }
        if (is_null($ownerGuid) || (is_array($ownerGuid) && empty($ownerGuid))) {
            unset($this->OwnerGuid);
        } else {
            $this->OwnerGuid = $ownerGuid;
        }
        return $this;
    }
    /**
     * Get PrintedIcon value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPrintedIcon()
    {
        return isset($this->PrintedIcon) ? $this->PrintedIcon : null;
    }
    /**
     * Set PrintedIcon value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $printedIcon
     * @return \patest\StructType\Ticketing_ClientTicketsRow
     */
    public function setPrintedIcon($printedIcon = null)
    {
        // validation for constraint: int
        if (!is_null($printedIcon) && !(is_int($printedIcon) || ctype_digit($printedIcon))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($printedIcon, true), gettype($printedIcon)), __LINE__);
        }
        if (is_null($printedIcon) || (is_array($printedIcon) && empty($printedIcon))) {
            unset($this->PrintedIcon);
        } else {
            $this->PrintedIcon = $printedIcon;
        }
        return $this;
    }
    /**
     * Get PurchaseInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPurchaseInfo()
    {
        return isset($this->PurchaseInfo) ? $this->PurchaseInfo : null;
    }
    /**
     * Set PurchaseInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $purchaseInfo
     * @return \patest\StructType\Ticketing_ClientTicketsRow
     */
    public function setPurchaseInfo($purchaseInfo = null)
    {
        // validation for constraint: string
        if (!is_null($purchaseInfo) && !is_string($purchaseInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaseInfo, true), gettype($purchaseInfo)), __LINE__);
        }
        if (is_null($purchaseInfo) || (is_array($purchaseInfo) && empty($purchaseInfo))) {
            unset($this->PurchaseInfo);
        } else {
            $this->PurchaseInfo = $purchaseInfo;
        }
        return $this;
    }
    /**
     * Get PurchaserGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPurchaserGuid()
    {
        return isset($this->PurchaserGuid) ? $this->PurchaserGuid : null;
    }
    /**
     * Set PurchaserGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $purchaserGuid
     * @return \patest\StructType\Ticketing_ClientTicketsRow
     */
    public function setPurchaserGuid($purchaserGuid = null)
    {
        // validation for constraint: string
        if (!is_null($purchaserGuid) && !is_string($purchaserGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaserGuid, true), gettype($purchaserGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($purchaserGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $purchaserGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($purchaserGuid, true)), __LINE__);
        }
        if (is_null($purchaserGuid) || (is_array($purchaserGuid) && empty($purchaserGuid))) {
            unset($this->PurchaserGuid);
        } else {
            $this->PurchaserGuid = $purchaserGuid;
        }
        return $this;
    }
    /**
     * Get Qunatity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQunatity()
    {
        return isset($this->Qunatity) ? $this->Qunatity : null;
    }
    /**
     * Set Qunatity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $qunatity
     * @return \patest\StructType\Ticketing_ClientTicketsRow
     */
    public function setQunatity($qunatity = null)
    {
        // validation for constraint: int
        if (!is_null($qunatity) && !(is_int($qunatity) || ctype_digit($qunatity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($qunatity, true), gettype($qunatity)), __LINE__);
        }
        if (is_null($qunatity) || (is_array($qunatity) && empty($qunatity))) {
            unset($this->Qunatity);
        } else {
            $this->Qunatity = $qunatity;
        }
        return $this;
    }
    /**
     * Get ResaleMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResaleMethod()
    {
        return isset($this->ResaleMethod) ? $this->ResaleMethod : null;
    }
    /**
     * Set ResaleMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketResaleMethod::valueIsValid()
     * @uses \patest\EnumType\TicketResaleMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resaleMethod
     * @return \patest\StructType\Ticketing_ClientTicketsRow
     */
    public function setResaleMethod($resaleMethod = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketResaleMethod::valueIsValid($resaleMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketResaleMethod', is_array($resaleMethod) ? implode(', ', $resaleMethod) : var_export($resaleMethod, true), implode(', ', \patest\EnumType\TicketResaleMethod::getValidValues())), __LINE__);
        }
        if (is_null($resaleMethod) || (is_array($resaleMethod) && empty($resaleMethod))) {
            unset($this->ResaleMethod);
        } else {
            $this->ResaleMethod = $resaleMethod;
        }
        return $this;
    }
    /**
     * Get ResaleStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getResaleStatus()
    {
        return isset($this->ResaleStatus) ? $this->ResaleStatus : null;
    }
    /**
     * Set ResaleStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ResaleStatus::valueIsValid()
     * @uses \patest\EnumType\ResaleStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $resaleStatus
     * @return \patest\StructType\Ticketing_ClientTicketsRow
     */
    public function setResaleStatus($resaleStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ResaleStatus::valueIsValid($resaleStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ResaleStatus', is_array($resaleStatus) ? implode(', ', $resaleStatus) : var_export($resaleStatus, true), implode(', ', \patest\EnumType\ResaleStatus::getValidValues())), __LINE__);
        }
        if (is_null($resaleStatus) || (is_array($resaleStatus) && empty($resaleStatus))) {
            unset($this->ResaleStatus);
        } else {
            $this->ResaleStatus = $resaleStatus;
        }
        return $this;
    }
    /**
     * Get ReservedIcon value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getReservedIcon()
    {
        return isset($this->ReservedIcon) ? $this->ReservedIcon : null;
    }
    /**
     * Set ReservedIcon value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $reservedIcon
     * @return \patest\StructType\Ticketing_ClientTicketsRow
     */
    public function setReservedIcon($reservedIcon = null)
    {
        // validation for constraint: int
        if (!is_null($reservedIcon) && !(is_int($reservedIcon) || ctype_digit($reservedIcon))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($reservedIcon, true), gettype($reservedIcon)), __LINE__);
        }
        if (is_null($reservedIcon) || (is_array($reservedIcon) && empty($reservedIcon))) {
            unset($this->ReservedIcon);
        } else {
            $this->ReservedIcon = $reservedIcon;
        }
        return $this;
    }
    /**
     * Get ReturnIcon value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getReturnIcon()
    {
        return isset($this->ReturnIcon) ? $this->ReturnIcon : null;
    }
    /**
     * Set ReturnIcon value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $returnIcon
     * @return \patest\StructType\Ticketing_ClientTicketsRow
     */
    public function setReturnIcon($returnIcon = null)
    {
        // validation for constraint: int
        if (!is_null($returnIcon) && !(is_int($returnIcon) || ctype_digit($returnIcon))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($returnIcon, true), gettype($returnIcon)), __LINE__);
        }
        if (is_null($returnIcon) || (is_array($returnIcon) && empty($returnIcon))) {
            unset($this->ReturnIcon);
        } else {
            $this->ReturnIcon = $returnIcon;
        }
        return $this;
    }
    /**
     * Get ShowGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowGuid()
    {
        return isset($this->ShowGuid) ? $this->ShowGuid : null;
    }
    /**
     * Set ShowGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showGuid
     * @return \patest\StructType\Ticketing_ClientTicketsRow
     */
    public function setShowGuid($showGuid = null)
    {
        // validation for constraint: string
        if (!is_null($showGuid) && !is_string($showGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showGuid, true), gettype($showGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($showGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $showGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($showGuid, true)), __LINE__);
        }
        if (is_null($showGuid) || (is_array($showGuid) && empty($showGuid))) {
            unset($this->ShowGuid);
        } else {
            $this->ShowGuid = $showGuid;
        }
        return $this;
    }
    /**
     * Get ShowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowName()
    {
        return isset($this->ShowName) ? $this->ShowName : null;
    }
    /**
     * Set ShowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showName
     * @return \patest\StructType\Ticketing_ClientTicketsRow
     */
    public function setShowName($showName = null)
    {
        // validation for constraint: string
        if (!is_null($showName) && !is_string($showName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showName, true), gettype($showName)), __LINE__);
        }
        if (is_null($showName) || (is_array($showName) && empty($showName))) {
            unset($this->ShowName);
        } else {
            $this->ShowName = $showName;
        }
        return $this;
    }
    /**
     * Get StatusIcons value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatusIcons()
    {
        return isset($this->StatusIcons) ? $this->StatusIcons : null;
    }
    /**
     * Set StatusIcons value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $statusIcons
     * @return \patest\StructType\Ticketing_ClientTicketsRow
     */
    public function setStatusIcons($statusIcons = null)
    {
        // validation for constraint: string
        if (!is_null($statusIcons) && !is_string($statusIcons)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($statusIcons, true), gettype($statusIcons)), __LINE__);
        }
        if (is_null($statusIcons) || (is_array($statusIcons) && empty($statusIcons))) {
            unset($this->StatusIcons);
        } else {
            $this->StatusIcons = $statusIcons;
        }
        return $this;
    }
    /**
     * Get SubscriptionIcon value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSubscriptionIcon()
    {
        return isset($this->SubscriptionIcon) ? $this->SubscriptionIcon : null;
    }
    /**
     * Set SubscriptionIcon value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $subscriptionIcon
     * @return \patest\StructType\Ticketing_ClientTicketsRow
     */
    public function setSubscriptionIcon($subscriptionIcon = null)
    {
        // validation for constraint: int
        if (!is_null($subscriptionIcon) && !(is_int($subscriptionIcon) || ctype_digit($subscriptionIcon))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($subscriptionIcon, true), gettype($subscriptionIcon)), __LINE__);
        }
        if (is_null($subscriptionIcon) || (is_array($subscriptionIcon) && empty($subscriptionIcon))) {
            unset($this->SubscriptionIcon);
        } else {
            $this->SubscriptionIcon = $subscriptionIcon;
        }
        return $this;
    }
    /**
     * Get SubscriptionInstance value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionInstance()
    {
        return isset($this->SubscriptionInstance) ? $this->SubscriptionInstance : null;
    }
    /**
     * Set SubscriptionInstance value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionInstance
     * @return \patest\StructType\Ticketing_ClientTicketsRow
     */
    public function setSubscriptionInstance($subscriptionInstance = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionInstance) && !is_string($subscriptionInstance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionInstance, true), gettype($subscriptionInstance)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subscriptionInstance) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subscriptionInstance)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subscriptionInstance, true)), __LINE__);
        }
        if (is_null($subscriptionInstance) || (is_array($subscriptionInstance) && empty($subscriptionInstance))) {
            unset($this->SubscriptionInstance);
        } else {
            $this->SubscriptionInstance = $subscriptionInstance;
        }
        return $this;
    }
    /**
     * Get TicketIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketIds()
    {
        return isset($this->TicketIds) ? $this->TicketIds : null;
    }
    /**
     * Set TicketIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ticketIds
     * @return \patest\StructType\Ticketing_ClientTicketsRow
     */
    public function setTicketIds($ticketIds = null)
    {
        // validation for constraint: string
        if (!is_null($ticketIds) && !is_string($ticketIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketIds, true), gettype($ticketIds)), __LINE__);
        }
        if (is_null($ticketIds) || (is_array($ticketIds) && empty($ticketIds))) {
            unset($this->TicketIds);
        } else {
            $this->TicketIds = $ticketIds;
        }
        return $this;
    }
    /**
     * Get TransactionDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionDate()
    {
        return isset($this->TransactionDate) ? $this->TransactionDate : null;
    }
    /**
     * Set TransactionDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionDate
     * @return \patest\StructType\Ticketing_ClientTicketsRow
     */
    public function setTransactionDate($transactionDate = null)
    {
        // validation for constraint: string
        if (!is_null($transactionDate) && !is_string($transactionDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionDate, true), gettype($transactionDate)), __LINE__);
        }
        if (is_null($transactionDate) || (is_array($transactionDate) && empty($transactionDate))) {
            unset($this->TransactionDate);
        } else {
            $this->TransactionDate = $transactionDate;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return isset($this->TransactionGuid) ? $this->TransactionGuid : null;
    }
    /**
     * Set TransactionGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transactionGuid
     * @return \patest\StructType\Ticketing_ClientTicketsRow
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        if (is_null($transactionGuid) || (is_array($transactionGuid) && empty($transactionGuid))) {
            unset($this->TransactionGuid);
        } else {
            $this->TransactionGuid = $transactionGuid;
        }
        return $this;
    }
    /**
     * Get TransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionNumber()
    {
        return isset($this->TransactionNumber) ? $this->TransactionNumber : null;
    }
    /**
     * Set TransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionNumber
     * @return \patest\StructType\Ticketing_ClientTicketsRow
     */
    public function setTransactionNumber($transactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionNumber) && !(is_int($transactionNumber) || ctype_digit($transactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionNumber, true), gettype($transactionNumber)), __LINE__);
        }
        if (is_null($transactionNumber) || (is_array($transactionNumber) && empty($transactionNumber))) {
            unset($this->TransactionNumber);
        } else {
            $this->TransactionNumber = $transactionNumber;
        }
        return $this;
    }
    /**
     * Get TransactionReferenceNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionReferenceNumber()
    {
        return isset($this->TransactionReferenceNumber) ? $this->TransactionReferenceNumber : null;
    }
    /**
     * Set TransactionReferenceNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionReferenceNumber
     * @return \patest\StructType\Ticketing_ClientTicketsRow
     */
    public function setTransactionReferenceNumber($transactionReferenceNumber = null)
    {
        // validation for constraint: int
        if (!is_null($transactionReferenceNumber) && !(is_int($transactionReferenceNumber) || ctype_digit($transactionReferenceNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionReferenceNumber, true), gettype($transactionReferenceNumber)), __LINE__);
        }
        if (is_null($transactionReferenceNumber) || (is_array($transactionReferenceNumber) && empty($transactionReferenceNumber))) {
            unset($this->TransactionReferenceNumber);
        } else {
            $this->TransactionReferenceNumber = $transactionReferenceNumber;
        }
        return $this;
    }
}
