<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.ChecklistTemplateItem StructType
 * @subpackage Structs
 */
class Ticketing_ChecklistTemplateItem extends PersistableEntity
{
    /**
     * The ChecklistItemId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ChecklistItemId;
    /**
     * The CheckListTemplateId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CheckListTemplateId;
    /**
     * The GroupName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GroupName;
    /**
     * The GroupOrdinal
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GroupOrdinal;
    /**
     * The ItemName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemName;
    /**
     * The Ordinal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Ordinal;
    /**
     * The RelatedPropertyName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RelatedPropertyName;
    /**
     * The Required
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Required;
    /**
     * Constructor method for Ticketing.ChecklistTemplateItem
     * @uses Ticketing_ChecklistTemplateItem::setChecklistItemId()
     * @uses Ticketing_ChecklistTemplateItem::setCheckListTemplateId()
     * @uses Ticketing_ChecklistTemplateItem::setGroupName()
     * @uses Ticketing_ChecklistTemplateItem::setGroupOrdinal()
     * @uses Ticketing_ChecklistTemplateItem::setItemName()
     * @uses Ticketing_ChecklistTemplateItem::setOrdinal()
     * @uses Ticketing_ChecklistTemplateItem::setRelatedPropertyName()
     * @uses Ticketing_ChecklistTemplateItem::setRequired()
     * @param string $checklistItemId
     * @param string $checkListTemplateId
     * @param string $groupName
     * @param int $groupOrdinal
     * @param string $itemName
     * @param int $ordinal
     * @param string $relatedPropertyName
     * @param bool $required
     */
    public function __construct($checklistItemId = null, $checkListTemplateId = null, $groupName = null, $groupOrdinal = null, $itemName = null, $ordinal = null, $relatedPropertyName = null, $required = null)
    {
        $this
            ->setChecklistItemId($checklistItemId)
            ->setCheckListTemplateId($checkListTemplateId)
            ->setGroupName($groupName)
            ->setGroupOrdinal($groupOrdinal)
            ->setItemName($itemName)
            ->setOrdinal($ordinal)
            ->setRelatedPropertyName($relatedPropertyName)
            ->setRequired($required);
    }
    /**
     * Get ChecklistItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getChecklistItemId()
    {
        return isset($this->ChecklistItemId) ? $this->ChecklistItemId : null;
    }
    /**
     * Set ChecklistItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $checklistItemId
     * @return \patest\StructType\Ticketing_ChecklistTemplateItem
     */
    public function setChecklistItemId($checklistItemId = null)
    {
        // validation for constraint: string
        if (!is_null($checklistItemId) && !is_string($checklistItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checklistItemId, true), gettype($checklistItemId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($checklistItemId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $checklistItemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($checklistItemId, true)), __LINE__);
        }
        if (is_null($checklistItemId) || (is_array($checklistItemId) && empty($checklistItemId))) {
            unset($this->ChecklistItemId);
        } else {
            $this->ChecklistItemId = $checklistItemId;
        }
        return $this;
    }
    /**
     * Get CheckListTemplateId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCheckListTemplateId()
    {
        return isset($this->CheckListTemplateId) ? $this->CheckListTemplateId : null;
    }
    /**
     * Set CheckListTemplateId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $checkListTemplateId
     * @return \patest\StructType\Ticketing_ChecklistTemplateItem
     */
    public function setCheckListTemplateId($checkListTemplateId = null)
    {
        // validation for constraint: string
        if (!is_null($checkListTemplateId) && !is_string($checkListTemplateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($checkListTemplateId, true), gettype($checkListTemplateId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($checkListTemplateId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $checkListTemplateId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($checkListTemplateId, true)), __LINE__);
        }
        if (is_null($checkListTemplateId) || (is_array($checkListTemplateId) && empty($checkListTemplateId))) {
            unset($this->CheckListTemplateId);
        } else {
            $this->CheckListTemplateId = $checkListTemplateId;
        }
        return $this;
    }
    /**
     * Get GroupName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGroupName()
    {
        return isset($this->GroupName) ? $this->GroupName : null;
    }
    /**
     * Set GroupName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $groupName
     * @return \patest\StructType\Ticketing_ChecklistTemplateItem
     */
    public function setGroupName($groupName = null)
    {
        // validation for constraint: string
        if (!is_null($groupName) && !is_string($groupName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($groupName, true), gettype($groupName)), __LINE__);
        }
        if (is_null($groupName) || (is_array($groupName) && empty($groupName))) {
            unset($this->GroupName);
        } else {
            $this->GroupName = $groupName;
        }
        return $this;
    }
    /**
     * Get GroupOrdinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGroupOrdinal()
    {
        return isset($this->GroupOrdinal) ? $this->GroupOrdinal : null;
    }
    /**
     * Set GroupOrdinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $groupOrdinal
     * @return \patest\StructType\Ticketing_ChecklistTemplateItem
     */
    public function setGroupOrdinal($groupOrdinal = null)
    {
        // validation for constraint: int
        if (!is_null($groupOrdinal) && !(is_int($groupOrdinal) || ctype_digit($groupOrdinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($groupOrdinal, true), gettype($groupOrdinal)), __LINE__);
        }
        if (is_null($groupOrdinal) || (is_array($groupOrdinal) && empty($groupOrdinal))) {
            unset($this->GroupOrdinal);
        } else {
            $this->GroupOrdinal = $groupOrdinal;
        }
        return $this;
    }
    /**
     * Get ItemName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemName()
    {
        return isset($this->ItemName) ? $this->ItemName : null;
    }
    /**
     * Set ItemName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemName
     * @return \patest\StructType\Ticketing_ChecklistTemplateItem
     */
    public function setItemName($itemName = null)
    {
        // validation for constraint: string
        if (!is_null($itemName) && !is_string($itemName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($itemName, true), gettype($itemName)), __LINE__);
        }
        if (is_null($itemName) || (is_array($itemName) && empty($itemName))) {
            unset($this->ItemName);
        } else {
            $this->ItemName = $itemName;
        }
        return $this;
    }
    /**
     * Get Ordinal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrdinal()
    {
        return isset($this->Ordinal) ? $this->Ordinal : null;
    }
    /**
     * Set Ordinal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ordinal
     * @return \patest\StructType\Ticketing_ChecklistTemplateItem
     */
    public function setOrdinal($ordinal = null)
    {
        // validation for constraint: int
        if (!is_null($ordinal) && !(is_int($ordinal) || ctype_digit($ordinal))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ordinal, true), gettype($ordinal)), __LINE__);
        }
        if (is_null($ordinal) || (is_array($ordinal) && empty($ordinal))) {
            unset($this->Ordinal);
        } else {
            $this->Ordinal = $ordinal;
        }
        return $this;
    }
    /**
     * Get RelatedPropertyName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelatedPropertyName()
    {
        return isset($this->RelatedPropertyName) ? $this->RelatedPropertyName : null;
    }
    /**
     * Set RelatedPropertyName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relatedPropertyName
     * @return \patest\StructType\Ticketing_ChecklistTemplateItem
     */
    public function setRelatedPropertyName($relatedPropertyName = null)
    {
        // validation for constraint: string
        if (!is_null($relatedPropertyName) && !is_string($relatedPropertyName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relatedPropertyName, true), gettype($relatedPropertyName)), __LINE__);
        }
        if (is_null($relatedPropertyName) || (is_array($relatedPropertyName) && empty($relatedPropertyName))) {
            unset($this->RelatedPropertyName);
        } else {
            $this->RelatedPropertyName = $relatedPropertyName;
        }
        return $this;
    }
    /**
     * Get Required value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getRequired()
    {
        return isset($this->Required) ? $this->Required : null;
    }
    /**
     * Set Required value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $required
     * @return \patest\StructType\Ticketing_ChecklistTemplateItem
     */
    public function setRequired($required = null)
    {
        // validation for constraint: boolean
        if (!is_null($required) && !is_bool($required)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($required, true), gettype($required)), __LINE__);
        }
        if (is_null($required) || (is_array($required) && empty($required))) {
            unset($this->Required);
        } else {
            $this->Required = $required;
        }
        return $this;
    }
}
