<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.BucketInfo StructType
 * @subpackage Structs
 */
class Ticketing_BucketInfo extends AnyEntity
{
    /**
     * The BucketId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BucketId;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Description;
    /**
     * The EventIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\EventIds
     */
    public $EventIds;
    /**
     * The MaxNumberOfEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxNumberOfEvents;
    /**
     * The MinNumberOfEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinNumberOfEvents;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * Constructor method for Ticketing.BucketInfo
     * @uses Ticketing_BucketInfo::setBucketId()
     * @uses Ticketing_BucketInfo::setDescription()
     * @uses Ticketing_BucketInfo::setEventIds()
     * @uses Ticketing_BucketInfo::setMaxNumberOfEvents()
     * @uses Ticketing_BucketInfo::setMinNumberOfEvents()
     * @uses Ticketing_BucketInfo::setName()
     * @param string $bucketId
     * @param \patest\StructType\GlobalString $description
     * @param \patest\StructType\EventIds $eventIds
     * @param int $maxNumberOfEvents
     * @param int $minNumberOfEvents
     * @param \patest\StructType\GlobalString $name
     */
    public function __construct($bucketId = null, \patest\StructType\GlobalString $description = null, \patest\StructType\EventIds $eventIds = null, $maxNumberOfEvents = null, $minNumberOfEvents = null, \patest\StructType\GlobalString $name = null)
    {
        $this
            ->setBucketId($bucketId)
            ->setDescription($description)
            ->setEventIds($eventIds)
            ->setMaxNumberOfEvents($maxNumberOfEvents)
            ->setMinNumberOfEvents($minNumberOfEvents)
            ->setName($name);
    }
    /**
     * Get BucketId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBucketId()
    {
        return isset($this->BucketId) ? $this->BucketId : null;
    }
    /**
     * Set BucketId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bucketId
     * @return \patest\StructType\Ticketing_BucketInfo
     */
    public function setBucketId($bucketId = null)
    {
        // validation for constraint: string
        if (!is_null($bucketId) && !is_string($bucketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bucketId, true), gettype($bucketId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($bucketId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $bucketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($bucketId, true)), __LINE__);
        }
        if (is_null($bucketId) || (is_array($bucketId) && empty($bucketId))) {
            unset($this->BucketId);
        } else {
            $this->BucketId = $bucketId;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $description
     * @return \patest\StructType\Ticketing_BucketInfo
     */
    public function setDescription(\patest\StructType\GlobalString $description = null)
    {
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get EventIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\EventIds|null
     */
    public function getEventIds()
    {
        return isset($this->EventIds) ? $this->EventIds : null;
    }
    /**
     * Set EventIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\EventIds $eventIds
     * @return \patest\StructType\Ticketing_BucketInfo
     */
    public function setEventIds(\patest\StructType\EventIds $eventIds = null)
    {
        if (is_null($eventIds) || (is_array($eventIds) && empty($eventIds))) {
            unset($this->EventIds);
        } else {
            $this->EventIds = $eventIds;
        }
        return $this;
    }
    /**
     * Get MaxNumberOfEvents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxNumberOfEvents()
    {
        return isset($this->MaxNumberOfEvents) ? $this->MaxNumberOfEvents : null;
    }
    /**
     * Set MaxNumberOfEvents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxNumberOfEvents
     * @return \patest\StructType\Ticketing_BucketInfo
     */
    public function setMaxNumberOfEvents($maxNumberOfEvents = null)
    {
        // validation for constraint: int
        if (!is_null($maxNumberOfEvents) && !(is_int($maxNumberOfEvents) || ctype_digit($maxNumberOfEvents))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxNumberOfEvents, true), gettype($maxNumberOfEvents)), __LINE__);
        }
        if (is_null($maxNumberOfEvents) || (is_array($maxNumberOfEvents) && empty($maxNumberOfEvents))) {
            unset($this->MaxNumberOfEvents);
        } else {
            $this->MaxNumberOfEvents = $maxNumberOfEvents;
        }
        return $this;
    }
    /**
     * Get MinNumberOfEvents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinNumberOfEvents()
    {
        return isset($this->MinNumberOfEvents) ? $this->MinNumberOfEvents : null;
    }
    /**
     * Set MinNumberOfEvents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minNumberOfEvents
     * @return \patest\StructType\Ticketing_BucketInfo
     */
    public function setMinNumberOfEvents($minNumberOfEvents = null)
    {
        // validation for constraint: int
        if (!is_null($minNumberOfEvents) && !(is_int($minNumberOfEvents) || ctype_digit($minNumberOfEvents))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minNumberOfEvents, true), gettype($minNumberOfEvents)), __LINE__);
        }
        if (is_null($minNumberOfEvents) || (is_array($minNumberOfEvents) && empty($minNumberOfEvents))) {
            unset($this->MinNumberOfEvents);
        } else {
            $this->MinNumberOfEvents = $minNumberOfEvents;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Ticketing_BucketInfo
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
}
