<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.BucketInSeries StructType
 * @subpackage Structs
 */
class Ticketing_BucketInSeries extends Ticketing_Base
{
    /**
     * The BucketId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BucketId;
    /**
     * The BucketName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $BucketName;
    /**
     * The MaxNumberOfEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxNumberOfEvents;
    /**
     * The MinNumberOfEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MinNumberOfEvents;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Priority;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * Constructor method for Ticketing.BucketInSeries
     * @uses Ticketing_BucketInSeries::setBucketId()
     * @uses Ticketing_BucketInSeries::setBucketName()
     * @uses Ticketing_BucketInSeries::setMaxNumberOfEvents()
     * @uses Ticketing_BucketInSeries::setMinNumberOfEvents()
     * @uses Ticketing_BucketInSeries::setPriority()
     * @uses Ticketing_BucketInSeries::setSeriesId()
     * @param string $bucketId
     * @param \patest\StructType\GlobalString $bucketName
     * @param int $maxNumberOfEvents
     * @param int $minNumberOfEvents
     * @param int $priority
     * @param string $seriesId
     */
    public function __construct($bucketId = null, \patest\StructType\GlobalString $bucketName = null, $maxNumberOfEvents = null, $minNumberOfEvents = null, $priority = null, $seriesId = null)
    {
        $this
            ->setBucketId($bucketId)
            ->setBucketName($bucketName)
            ->setMaxNumberOfEvents($maxNumberOfEvents)
            ->setMinNumberOfEvents($minNumberOfEvents)
            ->setPriority($priority)
            ->setSeriesId($seriesId);
    }
    /**
     * Get BucketId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBucketId()
    {
        return isset($this->BucketId) ? $this->BucketId : null;
    }
    /**
     * Set BucketId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bucketId
     * @return \patest\StructType\Ticketing_BucketInSeries
     */
    public function setBucketId($bucketId = null)
    {
        // validation for constraint: string
        if (!is_null($bucketId) && !is_string($bucketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bucketId, true), gettype($bucketId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($bucketId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $bucketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($bucketId, true)), __LINE__);
        }
        if (is_null($bucketId) || (is_array($bucketId) && empty($bucketId))) {
            unset($this->BucketId);
        } else {
            $this->BucketId = $bucketId;
        }
        return $this;
    }
    /**
     * Get BucketName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getBucketName()
    {
        return isset($this->BucketName) ? $this->BucketName : null;
    }
    /**
     * Set BucketName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $bucketName
     * @return \patest\StructType\Ticketing_BucketInSeries
     */
    public function setBucketName(\patest\StructType\GlobalString $bucketName = null)
    {
        if (is_null($bucketName) || (is_array($bucketName) && empty($bucketName))) {
            unset($this->BucketName);
        } else {
            $this->BucketName = $bucketName;
        }
        return $this;
    }
    /**
     * Get MaxNumberOfEvents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxNumberOfEvents()
    {
        return isset($this->MaxNumberOfEvents) ? $this->MaxNumberOfEvents : null;
    }
    /**
     * Set MaxNumberOfEvents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxNumberOfEvents
     * @return \patest\StructType\Ticketing_BucketInSeries
     */
    public function setMaxNumberOfEvents($maxNumberOfEvents = null)
    {
        // validation for constraint: int
        if (!is_null($maxNumberOfEvents) && !(is_int($maxNumberOfEvents) || ctype_digit($maxNumberOfEvents))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxNumberOfEvents, true), gettype($maxNumberOfEvents)), __LINE__);
        }
        if (is_null($maxNumberOfEvents) || (is_array($maxNumberOfEvents) && empty($maxNumberOfEvents))) {
            unset($this->MaxNumberOfEvents);
        } else {
            $this->MaxNumberOfEvents = $maxNumberOfEvents;
        }
        return $this;
    }
    /**
     * Get MinNumberOfEvents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMinNumberOfEvents()
    {
        return isset($this->MinNumberOfEvents) ? $this->MinNumberOfEvents : null;
    }
    /**
     * Set MinNumberOfEvents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $minNumberOfEvents
     * @return \patest\StructType\Ticketing_BucketInSeries
     */
    public function setMinNumberOfEvents($minNumberOfEvents = null)
    {
        // validation for constraint: int
        if (!is_null($minNumberOfEvents) && !(is_int($minNumberOfEvents) || ctype_digit($minNumberOfEvents))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($minNumberOfEvents, true), gettype($minNumberOfEvents)), __LINE__);
        }
        if (is_null($minNumberOfEvents) || (is_array($minNumberOfEvents) && empty($minNumberOfEvents))) {
            unset($this->MinNumberOfEvents);
        } else {
            $this->MinNumberOfEvents = $minNumberOfEvents;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priority
     * @return \patest\StructType\Ticketing_BucketInSeries
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesId()
    {
        return isset($this->SeriesId) ? $this->SeriesId : null;
    }
    /**
     * Set SeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seriesId
     * @return \patest\StructType\Ticketing_BucketInSeries
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        if (is_null($seriesId) || (is_array($seriesId) && empty($seriesId))) {
            unset($this->SeriesId);
        } else {
            $this->SeriesId = $seriesId;
        }
        return $this;
    }
}
