<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.BallotEvent StructType
 * @subpackage Structs
 */
class Ticketing_BallotEvent extends PersistableEntity
{
    /**
     * The AllDayEvent
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllDayEvent;
    /**
     * The BallotId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BallotId;
    /**
     * The DateFormatOptions
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DateFormatOptions;
    /**
     * The EffectiveLargeImageUrl
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveLargeImageUrl;
    /**
     * The EffectiveMediumImageUrl
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveMediumImageUrl;
    /**
     * The EffectiveSmallImageUrl
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EffectiveSmallImageUrl;
    /**
     * The EventCode
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EventCode;
    /**
     * The EventDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDate;
    /**
     * The EventDateUtc
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventDateUtc;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The EventName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $EventName;
    /**
     * The EventNameAndDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventNameAndDate;
    /**
     * The FromEventDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FromEventDate;
    /**
     * The HallName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $HallName;
    /**
     * The MaxSeatsPerClientType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_BallotClientTypeMaxSeats
     */
    public $MaxSeatsPerClientType;
    /**
     * The MaxTicketApplications
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxTicketApplications;
    /**
     * The OnlineDateFormatAdditionalText
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $OnlineDateFormatAdditionalText;
    /**
     * The PriceLevelList
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceLevelList;
    /**
     * The PriceTypeList
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PriceTypeList;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Priority;
    /**
     * The SectionList
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SectionList;
    /**
     * The Sections
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_BallotEventSection
     */
    public $Sections;
    /**
     * The ShowIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\ShowIds
     */
    public $ShowIds;
    /**
     * The ShowMinutes
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ShowMinutes;
    /**
     * The ToEventDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ToEventDate;
    /**
     * The VenueName
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $VenueName;
    /**
     * Constructor method for Ticketing.BallotEvent
     * @uses Ticketing_BallotEvent::setAllDayEvent()
     * @uses Ticketing_BallotEvent::setBallotId()
     * @uses Ticketing_BallotEvent::setDateFormatOptions()
     * @uses Ticketing_BallotEvent::setEffectiveLargeImageUrl()
     * @uses Ticketing_BallotEvent::setEffectiveMediumImageUrl()
     * @uses Ticketing_BallotEvent::setEffectiveSmallImageUrl()
     * @uses Ticketing_BallotEvent::setEventCode()
     * @uses Ticketing_BallotEvent::setEventDate()
     * @uses Ticketing_BallotEvent::setEventDateUtc()
     * @uses Ticketing_BallotEvent::setEventId()
     * @uses Ticketing_BallotEvent::setEventName()
     * @uses Ticketing_BallotEvent::setEventNameAndDate()
     * @uses Ticketing_BallotEvent::setFromEventDate()
     * @uses Ticketing_BallotEvent::setHallName()
     * @uses Ticketing_BallotEvent::setMaxSeatsPerClientType()
     * @uses Ticketing_BallotEvent::setMaxTicketApplications()
     * @uses Ticketing_BallotEvent::setOnlineDateFormatAdditionalText()
     * @uses Ticketing_BallotEvent::setPriceLevelList()
     * @uses Ticketing_BallotEvent::setPriceTypeList()
     * @uses Ticketing_BallotEvent::setPriority()
     * @uses Ticketing_BallotEvent::setSectionList()
     * @uses Ticketing_BallotEvent::setSections()
     * @uses Ticketing_BallotEvent::setShowIds()
     * @uses Ticketing_BallotEvent::setShowMinutes()
     * @uses Ticketing_BallotEvent::setToEventDate()
     * @uses Ticketing_BallotEvent::setVenueName()
     * @param bool $allDayEvent
     * @param string $ballotId
     * @param string $dateFormatOptions
     * @param string $effectiveLargeImageUrl
     * @param string $effectiveMediumImageUrl
     * @param string $effectiveSmallImageUrl
     * @param int $eventCode
     * @param string $eventDate
     * @param string $eventDateUtc
     * @param string $eventId
     * @param \patest\StructType\GlobalString $eventName
     * @param string $eventNameAndDate
     * @param string $fromEventDate
     * @param \patest\StructType\GlobalString $hallName
     * @param \patest\StructType\RecordSetOfTicketing_BallotClientTypeMaxSeats $maxSeatsPerClientType
     * @param int $maxTicketApplications
     * @param \patest\StructType\GlobalString $onlineDateFormatAdditionalText
     * @param string $priceLevelList
     * @param string $priceTypeList
     * @param int $priority
     * @param string $sectionList
     * @param \patest\StructType\RecordSetOfTicketing_BallotEventSection $sections
     * @param \patest\StructType\ShowIds $showIds
     * @param int $showMinutes
     * @param string $toEventDate
     * @param \patest\StructType\GlobalString $venueName
     */
    public function __construct($allDayEvent = null, $ballotId = null, $dateFormatOptions = null, $effectiveLargeImageUrl = null, $effectiveMediumImageUrl = null, $effectiveSmallImageUrl = null, $eventCode = null, $eventDate = null, $eventDateUtc = null, $eventId = null, \patest\StructType\GlobalString $eventName = null, $eventNameAndDate = null, $fromEventDate = null, \patest\StructType\GlobalString $hallName = null, \patest\StructType\RecordSetOfTicketing_BallotClientTypeMaxSeats $maxSeatsPerClientType = null, $maxTicketApplications = null, \patest\StructType\GlobalString $onlineDateFormatAdditionalText = null, $priceLevelList = null, $priceTypeList = null, $priority = null, $sectionList = null, \patest\StructType\RecordSetOfTicketing_BallotEventSection $sections = null, \patest\StructType\ShowIds $showIds = null, $showMinutes = null, $toEventDate = null, \patest\StructType\GlobalString $venueName = null)
    {
        $this
            ->setAllDayEvent($allDayEvent)
            ->setBallotId($ballotId)
            ->setDateFormatOptions($dateFormatOptions)
            ->setEffectiveLargeImageUrl($effectiveLargeImageUrl)
            ->setEffectiveMediumImageUrl($effectiveMediumImageUrl)
            ->setEffectiveSmallImageUrl($effectiveSmallImageUrl)
            ->setEventCode($eventCode)
            ->setEventDate($eventDate)
            ->setEventDateUtc($eventDateUtc)
            ->setEventId($eventId)
            ->setEventName($eventName)
            ->setEventNameAndDate($eventNameAndDate)
            ->setFromEventDate($fromEventDate)
            ->setHallName($hallName)
            ->setMaxSeatsPerClientType($maxSeatsPerClientType)
            ->setMaxTicketApplications($maxTicketApplications)
            ->setOnlineDateFormatAdditionalText($onlineDateFormatAdditionalText)
            ->setPriceLevelList($priceLevelList)
            ->setPriceTypeList($priceTypeList)
            ->setPriority($priority)
            ->setSectionList($sectionList)
            ->setSections($sections)
            ->setShowIds($showIds)
            ->setShowMinutes($showMinutes)
            ->setToEventDate($toEventDate)
            ->setVenueName($venueName);
    }
    /**
     * Get AllDayEvent value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllDayEvent()
    {
        return isset($this->AllDayEvent) ? $this->AllDayEvent : null;
    }
    /**
     * Set AllDayEvent value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allDayEvent
     * @return \patest\StructType\Ticketing_BallotEvent
     */
    public function setAllDayEvent($allDayEvent = null)
    {
        // validation for constraint: boolean
        if (!is_null($allDayEvent) && !is_bool($allDayEvent)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allDayEvent, true), gettype($allDayEvent)), __LINE__);
        }
        if (is_null($allDayEvent) || (is_array($allDayEvent) && empty($allDayEvent))) {
            unset($this->AllDayEvent);
        } else {
            $this->AllDayEvent = $allDayEvent;
        }
        return $this;
    }
    /**
     * Get BallotId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBallotId()
    {
        return isset($this->BallotId) ? $this->BallotId : null;
    }
    /**
     * Set BallotId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ballotId
     * @return \patest\StructType\Ticketing_BallotEvent
     */
    public function setBallotId($ballotId = null)
    {
        // validation for constraint: string
        if (!is_null($ballotId) && !is_string($ballotId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ballotId, true), gettype($ballotId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ballotId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ballotId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ballotId, true)), __LINE__);
        }
        if (is_null($ballotId) || (is_array($ballotId) && empty($ballotId))) {
            unset($this->BallotId);
        } else {
            $this->BallotId = $ballotId;
        }
        return $this;
    }
    /**
     * Get DateFormatOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDateFormatOptions()
    {
        return isset($this->DateFormatOptions) ? $this->DateFormatOptions : null;
    }
    /**
     * Set DateFormatOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EventDateFormatOptions::valueIsValid()
     * @uses \patest\EnumType\EventDateFormatOptions::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $dateFormatOptions
     * @return \patest\StructType\Ticketing_BallotEvent
     */
    public function setDateFormatOptions($dateFormatOptions = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\EventDateFormatOptions::valueIsValid($dateFormatOptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EventDateFormatOptions', is_array($dateFormatOptions) ? implode(', ', $dateFormatOptions) : var_export($dateFormatOptions, true), implode(', ', \patest\EnumType\EventDateFormatOptions::getValidValues())), __LINE__);
        }
        if (is_null($dateFormatOptions) || (is_array($dateFormatOptions) && empty($dateFormatOptions))) {
            unset($this->DateFormatOptions);
        } else {
            $this->DateFormatOptions = $dateFormatOptions;
        }
        return $this;
    }
    /**
     * Get EffectiveLargeImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveLargeImageUrl()
    {
        return isset($this->EffectiveLargeImageUrl) ? $this->EffectiveLargeImageUrl : null;
    }
    /**
     * Set EffectiveLargeImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveLargeImageUrl
     * @return \patest\StructType\Ticketing_BallotEvent
     */
    public function setEffectiveLargeImageUrl($effectiveLargeImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveLargeImageUrl) && !is_string($effectiveLargeImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveLargeImageUrl, true), gettype($effectiveLargeImageUrl)), __LINE__);
        }
        if (is_null($effectiveLargeImageUrl) || (is_array($effectiveLargeImageUrl) && empty($effectiveLargeImageUrl))) {
            unset($this->EffectiveLargeImageUrl);
        } else {
            $this->EffectiveLargeImageUrl = $effectiveLargeImageUrl;
        }
        return $this;
    }
    /**
     * Get EffectiveMediumImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveMediumImageUrl()
    {
        return isset($this->EffectiveMediumImageUrl) ? $this->EffectiveMediumImageUrl : null;
    }
    /**
     * Set EffectiveMediumImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveMediumImageUrl
     * @return \patest\StructType\Ticketing_BallotEvent
     */
    public function setEffectiveMediumImageUrl($effectiveMediumImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveMediumImageUrl) && !is_string($effectiveMediumImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveMediumImageUrl, true), gettype($effectiveMediumImageUrl)), __LINE__);
        }
        if (is_null($effectiveMediumImageUrl) || (is_array($effectiveMediumImageUrl) && empty($effectiveMediumImageUrl))) {
            unset($this->EffectiveMediumImageUrl);
        } else {
            $this->EffectiveMediumImageUrl = $effectiveMediumImageUrl;
        }
        return $this;
    }
    /**
     * Get EffectiveSmallImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEffectiveSmallImageUrl()
    {
        return isset($this->EffectiveSmallImageUrl) ? $this->EffectiveSmallImageUrl : null;
    }
    /**
     * Set EffectiveSmallImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $effectiveSmallImageUrl
     * @return \patest\StructType\Ticketing_BallotEvent
     */
    public function setEffectiveSmallImageUrl($effectiveSmallImageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($effectiveSmallImageUrl) && !is_string($effectiveSmallImageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($effectiveSmallImageUrl, true), gettype($effectiveSmallImageUrl)), __LINE__);
        }
        if (is_null($effectiveSmallImageUrl) || (is_array($effectiveSmallImageUrl) && empty($effectiveSmallImageUrl))) {
            unset($this->EffectiveSmallImageUrl);
        } else {
            $this->EffectiveSmallImageUrl = $effectiveSmallImageUrl;
        }
        return $this;
    }
    /**
     * Get EventCode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEventCode()
    {
        return isset($this->EventCode) ? $this->EventCode : null;
    }
    /**
     * Set EventCode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $eventCode
     * @return \patest\StructType\Ticketing_BallotEvent
     */
    public function setEventCode($eventCode = null)
    {
        // validation for constraint: int
        if (!is_null($eventCode) && !(is_int($eventCode) || ctype_digit($eventCode))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($eventCode, true), gettype($eventCode)), __LINE__);
        }
        if (is_null($eventCode) || (is_array($eventCode) && empty($eventCode))) {
            unset($this->EventCode);
        } else {
            $this->EventCode = $eventCode;
        }
        return $this;
    }
    /**
     * Get EventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDate()
    {
        return isset($this->EventDate) ? $this->EventDate : null;
    }
    /**
     * Set EventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDate
     * @return \patest\StructType\Ticketing_BallotEvent
     */
    public function setEventDate($eventDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventDate) && !is_string($eventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDate, true), gettype($eventDate)), __LINE__);
        }
        if (is_null($eventDate) || (is_array($eventDate) && empty($eventDate))) {
            unset($this->EventDate);
        } else {
            $this->EventDate = $eventDate;
        }
        return $this;
    }
    /**
     * Get EventDateUtc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventDateUtc()
    {
        return isset($this->EventDateUtc) ? $this->EventDateUtc : null;
    }
    /**
     * Set EventDateUtc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventDateUtc
     * @return \patest\StructType\Ticketing_BallotEvent
     */
    public function setEventDateUtc($eventDateUtc = null)
    {
        // validation for constraint: string
        if (!is_null($eventDateUtc) && !is_string($eventDateUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventDateUtc, true), gettype($eventDateUtc)), __LINE__);
        }
        if (is_null($eventDateUtc) || (is_array($eventDateUtc) && empty($eventDateUtc))) {
            unset($this->EventDateUtc);
        } else {
            $this->EventDateUtc = $eventDateUtc;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\Ticketing_BallotEvent
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get EventName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getEventName()
    {
        return isset($this->EventName) ? $this->EventName : null;
    }
    /**
     * Set EventName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $eventName
     * @return \patest\StructType\Ticketing_BallotEvent
     */
    public function setEventName(\patest\StructType\GlobalString $eventName = null)
    {
        if (is_null($eventName) || (is_array($eventName) && empty($eventName))) {
            unset($this->EventName);
        } else {
            $this->EventName = $eventName;
        }
        return $this;
    }
    /**
     * Get EventNameAndDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventNameAndDate()
    {
        return isset($this->EventNameAndDate) ? $this->EventNameAndDate : null;
    }
    /**
     * Set EventNameAndDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventNameAndDate
     * @return \patest\StructType\Ticketing_BallotEvent
     */
    public function setEventNameAndDate($eventNameAndDate = null)
    {
        // validation for constraint: string
        if (!is_null($eventNameAndDate) && !is_string($eventNameAndDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventNameAndDate, true), gettype($eventNameAndDate)), __LINE__);
        }
        if (is_null($eventNameAndDate) || (is_array($eventNameAndDate) && empty($eventNameAndDate))) {
            unset($this->EventNameAndDate);
        } else {
            $this->EventNameAndDate = $eventNameAndDate;
        }
        return $this;
    }
    /**
     * Get FromEventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFromEventDate()
    {
        return isset($this->FromEventDate) ? $this->FromEventDate : null;
    }
    /**
     * Set FromEventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fromEventDate
     * @return \patest\StructType\Ticketing_BallotEvent
     */
    public function setFromEventDate($fromEventDate = null)
    {
        // validation for constraint: string
        if (!is_null($fromEventDate) && !is_string($fromEventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fromEventDate, true), gettype($fromEventDate)), __LINE__);
        }
        if (is_null($fromEventDate) || (is_array($fromEventDate) && empty($fromEventDate))) {
            unset($this->FromEventDate);
        } else {
            $this->FromEventDate = $fromEventDate;
        }
        return $this;
    }
    /**
     * Get HallName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getHallName()
    {
        return isset($this->HallName) ? $this->HallName : null;
    }
    /**
     * Set HallName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $hallName
     * @return \patest\StructType\Ticketing_BallotEvent
     */
    public function setHallName(\patest\StructType\GlobalString $hallName = null)
    {
        if (is_null($hallName) || (is_array($hallName) && empty($hallName))) {
            unset($this->HallName);
        } else {
            $this->HallName = $hallName;
        }
        return $this;
    }
    /**
     * Get MaxSeatsPerClientType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_BallotClientTypeMaxSeats|null
     */
    public function getMaxSeatsPerClientType()
    {
        return isset($this->MaxSeatsPerClientType) ? $this->MaxSeatsPerClientType : null;
    }
    /**
     * Set MaxSeatsPerClientType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_BallotClientTypeMaxSeats $maxSeatsPerClientType
     * @return \patest\StructType\Ticketing_BallotEvent
     */
    public function setMaxSeatsPerClientType(\patest\StructType\RecordSetOfTicketing_BallotClientTypeMaxSeats $maxSeatsPerClientType = null)
    {
        if (is_null($maxSeatsPerClientType) || (is_array($maxSeatsPerClientType) && empty($maxSeatsPerClientType))) {
            unset($this->MaxSeatsPerClientType);
        } else {
            $this->MaxSeatsPerClientType = $maxSeatsPerClientType;
        }
        return $this;
    }
    /**
     * Get MaxTicketApplications value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxTicketApplications()
    {
        return isset($this->MaxTicketApplications) ? $this->MaxTicketApplications : null;
    }
    /**
     * Set MaxTicketApplications value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxTicketApplications
     * @return \patest\StructType\Ticketing_BallotEvent
     */
    public function setMaxTicketApplications($maxTicketApplications = null)
    {
        // validation for constraint: int
        if (!is_null($maxTicketApplications) && !(is_int($maxTicketApplications) || ctype_digit($maxTicketApplications))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxTicketApplications, true), gettype($maxTicketApplications)), __LINE__);
        }
        if (is_null($maxTicketApplications) || (is_array($maxTicketApplications) && empty($maxTicketApplications))) {
            unset($this->MaxTicketApplications);
        } else {
            $this->MaxTicketApplications = $maxTicketApplications;
        }
        return $this;
    }
    /**
     * Get OnlineDateFormatAdditionalText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getOnlineDateFormatAdditionalText()
    {
        return isset($this->OnlineDateFormatAdditionalText) ? $this->OnlineDateFormatAdditionalText : null;
    }
    /**
     * Set OnlineDateFormatAdditionalText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $onlineDateFormatAdditionalText
     * @return \patest\StructType\Ticketing_BallotEvent
     */
    public function setOnlineDateFormatAdditionalText(\patest\StructType\GlobalString $onlineDateFormatAdditionalText = null)
    {
        if (is_null($onlineDateFormatAdditionalText) || (is_array($onlineDateFormatAdditionalText) && empty($onlineDateFormatAdditionalText))) {
            unset($this->OnlineDateFormatAdditionalText);
        } else {
            $this->OnlineDateFormatAdditionalText = $onlineDateFormatAdditionalText;
        }
        return $this;
    }
    /**
     * Get PriceLevelList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceLevelList()
    {
        return isset($this->PriceLevelList) ? $this->PriceLevelList : null;
    }
    /**
     * Set PriceLevelList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceLevelList
     * @return \patest\StructType\Ticketing_BallotEvent
     */
    public function setPriceLevelList($priceLevelList = null)
    {
        // validation for constraint: string
        if (!is_null($priceLevelList) && !is_string($priceLevelList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceLevelList, true), gettype($priceLevelList)), __LINE__);
        }
        if (is_null($priceLevelList) || (is_array($priceLevelList) && empty($priceLevelList))) {
            unset($this->PriceLevelList);
        } else {
            $this->PriceLevelList = $priceLevelList;
        }
        return $this;
    }
    /**
     * Get PriceTypeList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPriceTypeList()
    {
        return isset($this->PriceTypeList) ? $this->PriceTypeList : null;
    }
    /**
     * Set PriceTypeList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $priceTypeList
     * @return \patest\StructType\Ticketing_BallotEvent
     */
    public function setPriceTypeList($priceTypeList = null)
    {
        // validation for constraint: string
        if (!is_null($priceTypeList) && !is_string($priceTypeList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($priceTypeList, true), gettype($priceTypeList)), __LINE__);
        }
        if (is_null($priceTypeList) || (is_array($priceTypeList) && empty($priceTypeList))) {
            unset($this->PriceTypeList);
        } else {
            $this->PriceTypeList = $priceTypeList;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priority
     * @return \patest\StructType\Ticketing_BallotEvent
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
    /**
     * Get SectionList value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSectionList()
    {
        return isset($this->SectionList) ? $this->SectionList : null;
    }
    /**
     * Set SectionList value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sectionList
     * @return \patest\StructType\Ticketing_BallotEvent
     */
    public function setSectionList($sectionList = null)
    {
        // validation for constraint: string
        if (!is_null($sectionList) && !is_string($sectionList)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sectionList, true), gettype($sectionList)), __LINE__);
        }
        if (is_null($sectionList) || (is_array($sectionList) && empty($sectionList))) {
            unset($this->SectionList);
        } else {
            $this->SectionList = $sectionList;
        }
        return $this;
    }
    /**
     * Get Sections value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_BallotEventSection|null
     */
    public function getSections()
    {
        return isset($this->Sections) ? $this->Sections : null;
    }
    /**
     * Set Sections value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_BallotEventSection $sections
     * @return \patest\StructType\Ticketing_BallotEvent
     */
    public function setSections(\patest\StructType\RecordSetOfTicketing_BallotEventSection $sections = null)
    {
        if (is_null($sections) || (is_array($sections) && empty($sections))) {
            unset($this->Sections);
        } else {
            $this->Sections = $sections;
        }
        return $this;
    }
    /**
     * Get ShowIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\ShowIds|null
     */
    public function getShowIds()
    {
        return isset($this->ShowIds) ? $this->ShowIds : null;
    }
    /**
     * Set ShowIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\ShowIds $showIds
     * @return \patest\StructType\Ticketing_BallotEvent
     */
    public function setShowIds(\patest\StructType\ShowIds $showIds = null)
    {
        if (is_null($showIds) || (is_array($showIds) && empty($showIds))) {
            unset($this->ShowIds);
        } else {
            $this->ShowIds = $showIds;
        }
        return $this;
    }
    /**
     * Get ShowMinutes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getShowMinutes()
    {
        return isset($this->ShowMinutes) ? $this->ShowMinutes : null;
    }
    /**
     * Set ShowMinutes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $showMinutes
     * @return \patest\StructType\Ticketing_BallotEvent
     */
    public function setShowMinutes($showMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($showMinutes) && !(is_int($showMinutes) || ctype_digit($showMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($showMinutes, true), gettype($showMinutes)), __LINE__);
        }
        if (is_null($showMinutes) || (is_array($showMinutes) && empty($showMinutes))) {
            unset($this->ShowMinutes);
        } else {
            $this->ShowMinutes = $showMinutes;
        }
        return $this;
    }
    /**
     * Get ToEventDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getToEventDate()
    {
        return isset($this->ToEventDate) ? $this->ToEventDate : null;
    }
    /**
     * Set ToEventDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $toEventDate
     * @return \patest\StructType\Ticketing_BallotEvent
     */
    public function setToEventDate($toEventDate = null)
    {
        // validation for constraint: string
        if (!is_null($toEventDate) && !is_string($toEventDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($toEventDate, true), gettype($toEventDate)), __LINE__);
        }
        if (is_null($toEventDate) || (is_array($toEventDate) && empty($toEventDate))) {
            unset($this->ToEventDate);
        } else {
            $this->ToEventDate = $toEventDate;
        }
        return $this;
    }
    /**
     * Get VenueName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getVenueName()
    {
        return isset($this->VenueName) ? $this->VenueName : null;
    }
    /**
     * Set VenueName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $venueName
     * @return \patest\StructType\Ticketing_BallotEvent
     */
    public function setVenueName(\patest\StructType\GlobalString $venueName = null)
    {
        if (is_null($venueName) || (is_array($venueName) && empty($venueName))) {
            unset($this->VenueName);
        } else {
            $this->VenueName = $venueName;
        }
        return $this;
    }
}
