<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.BallotApplicationGroupedSection StructType
 * @subpackage Structs
 */
class Ticketing_BallotApplicationGroupedSection extends PersistableEntity
{
    /**
     * The BallotApplicationEventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BallotApplicationEventId;
    /**
     * The Details
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_BallotApplicationRowDetail
     */
    public $Details;
    /**
     * The GroupedSectionIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GroupedSectionIds
     */
    public $GroupedSectionIds;
    /**
     * The Priority
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Priority;
    /**
     * Constructor method for Ticketing.BallotApplicationGroupedSection
     * @uses Ticketing_BallotApplicationGroupedSection::setBallotApplicationEventId()
     * @uses Ticketing_BallotApplicationGroupedSection::setDetails()
     * @uses Ticketing_BallotApplicationGroupedSection::setGroupedSectionIds()
     * @uses Ticketing_BallotApplicationGroupedSection::setPriority()
     * @param string $ballotApplicationEventId
     * @param \patest\StructType\RecordSetOfTicketing_BallotApplicationRowDetail $details
     * @param \patest\StructType\GroupedSectionIds $groupedSectionIds
     * @param int $priority
     */
    public function __construct($ballotApplicationEventId = null, \patest\StructType\RecordSetOfTicketing_BallotApplicationRowDetail $details = null, \patest\StructType\GroupedSectionIds $groupedSectionIds = null, $priority = null)
    {
        $this
            ->setBallotApplicationEventId($ballotApplicationEventId)
            ->setDetails($details)
            ->setGroupedSectionIds($groupedSectionIds)
            ->setPriority($priority);
    }
    /**
     * Get BallotApplicationEventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBallotApplicationEventId()
    {
        return isset($this->BallotApplicationEventId) ? $this->BallotApplicationEventId : null;
    }
    /**
     * Set BallotApplicationEventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ballotApplicationEventId
     * @return \patest\StructType\Ticketing_BallotApplicationGroupedSection
     */
    public function setBallotApplicationEventId($ballotApplicationEventId = null)
    {
        // validation for constraint: string
        if (!is_null($ballotApplicationEventId) && !is_string($ballotApplicationEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ballotApplicationEventId, true), gettype($ballotApplicationEventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ballotApplicationEventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ballotApplicationEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ballotApplicationEventId, true)), __LINE__);
        }
        if (is_null($ballotApplicationEventId) || (is_array($ballotApplicationEventId) && empty($ballotApplicationEventId))) {
            unset($this->BallotApplicationEventId);
        } else {
            $this->BallotApplicationEventId = $ballotApplicationEventId;
        }
        return $this;
    }
    /**
     * Get Details value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_BallotApplicationRowDetail|null
     */
    public function getDetails()
    {
        return isset($this->Details) ? $this->Details : null;
    }
    /**
     * Set Details value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_BallotApplicationRowDetail $details
     * @return \patest\StructType\Ticketing_BallotApplicationGroupedSection
     */
    public function setDetails(\patest\StructType\RecordSetOfTicketing_BallotApplicationRowDetail $details = null)
    {
        if (is_null($details) || (is_array($details) && empty($details))) {
            unset($this->Details);
        } else {
            $this->Details = $details;
        }
        return $this;
    }
    /**
     * Get GroupedSectionIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GroupedSectionIds|null
     */
    public function getGroupedSectionIds()
    {
        return isset($this->GroupedSectionIds) ? $this->GroupedSectionIds : null;
    }
    /**
     * Set GroupedSectionIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GroupedSectionIds $groupedSectionIds
     * @return \patest\StructType\Ticketing_BallotApplicationGroupedSection
     */
    public function setGroupedSectionIds(\patest\StructType\GroupedSectionIds $groupedSectionIds = null)
    {
        if (is_null($groupedSectionIds) || (is_array($groupedSectionIds) && empty($groupedSectionIds))) {
            unset($this->GroupedSectionIds);
        } else {
            $this->GroupedSectionIds = $groupedSectionIds;
        }
        return $this;
    }
    /**
     * Get Priority value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPriority()
    {
        return isset($this->Priority) ? $this->Priority : null;
    }
    /**
     * Set Priority value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $priority
     * @return \patest\StructType\Ticketing_BallotApplicationGroupedSection
     */
    public function setPriority($priority = null)
    {
        // validation for constraint: int
        if (!is_null($priority) && !(is_int($priority) || ctype_digit($priority))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($priority, true), gettype($priority)), __LINE__);
        }
        if (is_null($priority) || (is_array($priority) && empty($priority))) {
            unset($this->Priority);
        } else {
            $this->Priority = $priority;
        }
        return $this;
    }
}
