<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.BallotApplicationEventOrdering StructType
 * @subpackage Structs
 */
class Ticketing_BallotApplicationEventOrdering extends PersistableEntity
{
    /**
     * The BallotApplicationEventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BallotApplicationEventId;
    /**
     * The BallotEventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BallotEventId;
    /**
     * The DrawTime
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DrawTime;
    /**
     * The Position
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Position;
    /**
     * Constructor method for Ticketing.BallotApplicationEventOrdering
     * @uses Ticketing_BallotApplicationEventOrdering::setBallotApplicationEventId()
     * @uses Ticketing_BallotApplicationEventOrdering::setBallotEventId()
     * @uses Ticketing_BallotApplicationEventOrdering::setDrawTime()
     * @uses Ticketing_BallotApplicationEventOrdering::setPosition()
     * @param string $ballotApplicationEventId
     * @param string $ballotEventId
     * @param string $drawTime
     * @param int $position
     */
    public function __construct($ballotApplicationEventId = null, $ballotEventId = null, $drawTime = null, $position = null)
    {
        $this
            ->setBallotApplicationEventId($ballotApplicationEventId)
            ->setBallotEventId($ballotEventId)
            ->setDrawTime($drawTime)
            ->setPosition($position);
    }
    /**
     * Get BallotApplicationEventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBallotApplicationEventId()
    {
        return isset($this->BallotApplicationEventId) ? $this->BallotApplicationEventId : null;
    }
    /**
     * Set BallotApplicationEventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ballotApplicationEventId
     * @return \patest\StructType\Ticketing_BallotApplicationEventOrdering
     */
    public function setBallotApplicationEventId($ballotApplicationEventId = null)
    {
        // validation for constraint: string
        if (!is_null($ballotApplicationEventId) && !is_string($ballotApplicationEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ballotApplicationEventId, true), gettype($ballotApplicationEventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ballotApplicationEventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ballotApplicationEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ballotApplicationEventId, true)), __LINE__);
        }
        if (is_null($ballotApplicationEventId) || (is_array($ballotApplicationEventId) && empty($ballotApplicationEventId))) {
            unset($this->BallotApplicationEventId);
        } else {
            $this->BallotApplicationEventId = $ballotApplicationEventId;
        }
        return $this;
    }
    /**
     * Get BallotEventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBallotEventId()
    {
        return isset($this->BallotEventId) ? $this->BallotEventId : null;
    }
    /**
     * Set BallotEventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ballotEventId
     * @return \patest\StructType\Ticketing_BallotApplicationEventOrdering
     */
    public function setBallotEventId($ballotEventId = null)
    {
        // validation for constraint: string
        if (!is_null($ballotEventId) && !is_string($ballotEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ballotEventId, true), gettype($ballotEventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ballotEventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ballotEventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ballotEventId, true)), __LINE__);
        }
        if (is_null($ballotEventId) || (is_array($ballotEventId) && empty($ballotEventId))) {
            unset($this->BallotEventId);
        } else {
            $this->BallotEventId = $ballotEventId;
        }
        return $this;
    }
    /**
     * Get DrawTime value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDrawTime()
    {
        return isset($this->DrawTime) ? $this->DrawTime : null;
    }
    /**
     * Set DrawTime value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $drawTime
     * @return \patest\StructType\Ticketing_BallotApplicationEventOrdering
     */
    public function setDrawTime($drawTime = null)
    {
        // validation for constraint: string
        if (!is_null($drawTime) && !is_string($drawTime)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($drawTime, true), gettype($drawTime)), __LINE__);
        }
        if (is_null($drawTime) || (is_array($drawTime) && empty($drawTime))) {
            unset($this->DrawTime);
        } else {
            $this->DrawTime = $drawTime;
        }
        return $this;
    }
    /**
     * Get Position value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPosition()
    {
        return isset($this->Position) ? $this->Position : null;
    }
    /**
     * Set Position value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $position
     * @return \patest\StructType\Ticketing_BallotApplicationEventOrdering
     */
    public function setPosition($position = null)
    {
        // validation for constraint: int
        if (!is_null($position) && !(is_int($position) || ctype_digit($position))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($position, true), gettype($position)), __LINE__);
        }
        if (is_null($position) || (is_array($position) && empty($position))) {
            unset($this->Position);
        } else {
            $this->Position = $position;
        }
        return $this;
    }
}
