<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.BallotApplicationEvent StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Ticketing.BallotApplicationEvent
 * @subpackage Structs
 */
class Ticketing_BallotApplicationEvent extends PersistableEntity
{
    /**
     * The BallotClientApplicationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BallotClientApplicationId;
    /**
     * The ConsiderOtherSections
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ConsiderOtherSections;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The Lines
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfTicketing_BallotApplicationGroupedSection
     */
    public $Lines;
    /**
     * The MaxPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $MaxPrice;
    /**
     * The MinPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $MinPrice;
    /**
     * The NumberOfSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfSeats;
    /**
     * The RunMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RunMode;
    /**
     * The ScaledModeMinSeats
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ScaledModeMinSeats;
    /**
     * The SectionIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\SectionIds
     */
    public $SectionIds;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * Constructor method for Ticketing.BallotApplicationEvent
     * @uses Ticketing_BallotApplicationEvent::setBallotClientApplicationId()
     * @uses Ticketing_BallotApplicationEvent::setConsiderOtherSections()
     * @uses Ticketing_BallotApplicationEvent::setEventId()
     * @uses Ticketing_BallotApplicationEvent::setLines()
     * @uses Ticketing_BallotApplicationEvent::setMaxPrice()
     * @uses Ticketing_BallotApplicationEvent::setMinPrice()
     * @uses Ticketing_BallotApplicationEvent::setNumberOfSeats()
     * @uses Ticketing_BallotApplicationEvent::setRunMode()
     * @uses Ticketing_BallotApplicationEvent::setScaledModeMinSeats()
     * @uses Ticketing_BallotApplicationEvent::setSectionIds()
     * @uses Ticketing_BallotApplicationEvent::setStatus()
     * @param string $ballotClientApplicationId
     * @param bool $considerOtherSections
     * @param string $eventId
     * @param \patest\StructType\RecordSetOfTicketing_BallotApplicationGroupedSection $lines
     * @param \patest\StructType\Money $maxPrice
     * @param \patest\StructType\Money $minPrice
     * @param int $numberOfSeats
     * @param string $runMode
     * @param int $scaledModeMinSeats
     * @param \patest\StructType\SectionIds $sectionIds
     * @param string $status
     */
    public function __construct($ballotClientApplicationId = null, $considerOtherSections = null, $eventId = null, \patest\StructType\RecordSetOfTicketing_BallotApplicationGroupedSection $lines = null, \patest\StructType\Money $maxPrice = null, \patest\StructType\Money $minPrice = null, $numberOfSeats = null, $runMode = null, $scaledModeMinSeats = null, \patest\StructType\SectionIds $sectionIds = null, $status = null)
    {
        $this
            ->setBallotClientApplicationId($ballotClientApplicationId)
            ->setConsiderOtherSections($considerOtherSections)
            ->setEventId($eventId)
            ->setLines($lines)
            ->setMaxPrice($maxPrice)
            ->setMinPrice($minPrice)
            ->setNumberOfSeats($numberOfSeats)
            ->setRunMode($runMode)
            ->setScaledModeMinSeats($scaledModeMinSeats)
            ->setSectionIds($sectionIds)
            ->setStatus($status);
    }
    /**
     * Get BallotClientApplicationId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBallotClientApplicationId()
    {
        return isset($this->BallotClientApplicationId) ? $this->BallotClientApplicationId : null;
    }
    /**
     * Set BallotClientApplicationId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ballotClientApplicationId
     * @return \patest\StructType\Ticketing_BallotApplicationEvent
     */
    public function setBallotClientApplicationId($ballotClientApplicationId = null)
    {
        // validation for constraint: string
        if (!is_null($ballotClientApplicationId) && !is_string($ballotClientApplicationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ballotClientApplicationId, true), gettype($ballotClientApplicationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ballotClientApplicationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ballotClientApplicationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ballotClientApplicationId, true)), __LINE__);
        }
        if (is_null($ballotClientApplicationId) || (is_array($ballotClientApplicationId) && empty($ballotClientApplicationId))) {
            unset($this->BallotClientApplicationId);
        } else {
            $this->BallotClientApplicationId = $ballotClientApplicationId;
        }
        return $this;
    }
    /**
     * Get ConsiderOtherSections value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getConsiderOtherSections()
    {
        return isset($this->ConsiderOtherSections) ? $this->ConsiderOtherSections : null;
    }
    /**
     * Set ConsiderOtherSections value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $considerOtherSections
     * @return \patest\StructType\Ticketing_BallotApplicationEvent
     */
    public function setConsiderOtherSections($considerOtherSections = null)
    {
        // validation for constraint: boolean
        if (!is_null($considerOtherSections) && !is_bool($considerOtherSections)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($considerOtherSections, true), gettype($considerOtherSections)), __LINE__);
        }
        if (is_null($considerOtherSections) || (is_array($considerOtherSections) && empty($considerOtherSections))) {
            unset($this->ConsiderOtherSections);
        } else {
            $this->ConsiderOtherSections = $considerOtherSections;
        }
        return $this;
    }
    /**
     * Get EventId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventId()
    {
        return isset($this->EventId) ? $this->EventId : null;
    }
    /**
     * Set EventId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eventId
     * @return \patest\StructType\Ticketing_BallotApplicationEvent
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        if (is_null($eventId) || (is_array($eventId) && empty($eventId))) {
            unset($this->EventId);
        } else {
            $this->EventId = $eventId;
        }
        return $this;
    }
    /**
     * Get Lines value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfTicketing_BallotApplicationGroupedSection|null
     */
    public function getLines()
    {
        return isset($this->Lines) ? $this->Lines : null;
    }
    /**
     * Set Lines value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfTicketing_BallotApplicationGroupedSection $lines
     * @return \patest\StructType\Ticketing_BallotApplicationEvent
     */
    public function setLines(\patest\StructType\RecordSetOfTicketing_BallotApplicationGroupedSection $lines = null)
    {
        if (is_null($lines) || (is_array($lines) && empty($lines))) {
            unset($this->Lines);
        } else {
            $this->Lines = $lines;
        }
        return $this;
    }
    /**
     * Get MaxPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getMaxPrice()
    {
        return isset($this->MaxPrice) ? $this->MaxPrice : null;
    }
    /**
     * Set MaxPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $maxPrice
     * @return \patest\StructType\Ticketing_BallotApplicationEvent
     */
    public function setMaxPrice(\patest\StructType\Money $maxPrice = null)
    {
        if (is_null($maxPrice) || (is_array($maxPrice) && empty($maxPrice))) {
            unset($this->MaxPrice);
        } else {
            $this->MaxPrice = $maxPrice;
        }
        return $this;
    }
    /**
     * Get MinPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getMinPrice()
    {
        return isset($this->MinPrice) ? $this->MinPrice : null;
    }
    /**
     * Set MinPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $minPrice
     * @return \patest\StructType\Ticketing_BallotApplicationEvent
     */
    public function setMinPrice(\patest\StructType\Money $minPrice = null)
    {
        if (is_null($minPrice) || (is_array($minPrice) && empty($minPrice))) {
            unset($this->MinPrice);
        } else {
            $this->MinPrice = $minPrice;
        }
        return $this;
    }
    /**
     * Get NumberOfSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfSeats()
    {
        return isset($this->NumberOfSeats) ? $this->NumberOfSeats : null;
    }
    /**
     * Set NumberOfSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfSeats
     * @return \patest\StructType\Ticketing_BallotApplicationEvent
     */
    public function setNumberOfSeats($numberOfSeats = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfSeats) && !(is_int($numberOfSeats) || ctype_digit($numberOfSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfSeats, true), gettype($numberOfSeats)), __LINE__);
        }
        if (is_null($numberOfSeats) || (is_array($numberOfSeats) && empty($numberOfSeats))) {
            unset($this->NumberOfSeats);
        } else {
            $this->NumberOfSeats = $numberOfSeats;
        }
        return $this;
    }
    /**
     * Get RunMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRunMode()
    {
        return isset($this->RunMode) ? $this->RunMode : null;
    }
    /**
     * Set RunMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BallotRunMode::valueIsValid()
     * @uses \patest\EnumType\BallotRunMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $runMode
     * @return \patest\StructType\Ticketing_BallotApplicationEvent
     */
    public function setRunMode($runMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BallotRunMode::valueIsValid($runMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BallotRunMode', is_array($runMode) ? implode(', ', $runMode) : var_export($runMode, true), implode(', ', \patest\EnumType\BallotRunMode::getValidValues())), __LINE__);
        }
        if (is_null($runMode) || (is_array($runMode) && empty($runMode))) {
            unset($this->RunMode);
        } else {
            $this->RunMode = $runMode;
        }
        return $this;
    }
    /**
     * Get ScaledModeMinSeats value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getScaledModeMinSeats()
    {
        return isset($this->ScaledModeMinSeats) ? $this->ScaledModeMinSeats : null;
    }
    /**
     * Set ScaledModeMinSeats value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $scaledModeMinSeats
     * @return \patest\StructType\Ticketing_BallotApplicationEvent
     */
    public function setScaledModeMinSeats($scaledModeMinSeats = null)
    {
        // validation for constraint: int
        if (!is_null($scaledModeMinSeats) && !(is_int($scaledModeMinSeats) || ctype_digit($scaledModeMinSeats))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($scaledModeMinSeats, true), gettype($scaledModeMinSeats)), __LINE__);
        }
        if (is_null($scaledModeMinSeats) || (is_array($scaledModeMinSeats) && empty($scaledModeMinSeats))) {
            unset($this->ScaledModeMinSeats);
        } else {
            $this->ScaledModeMinSeats = $scaledModeMinSeats;
        }
        return $this;
    }
    /**
     * Get SectionIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\SectionIds|null
     */
    public function getSectionIds()
    {
        return isset($this->SectionIds) ? $this->SectionIds : null;
    }
    /**
     * Set SectionIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\SectionIds $sectionIds
     * @return \patest\StructType\Ticketing_BallotApplicationEvent
     */
    public function setSectionIds(\patest\StructType\SectionIds $sectionIds = null)
    {
        if (is_null($sectionIds) || (is_array($sectionIds) && empty($sectionIds))) {
            unset($this->SectionIds);
        } else {
            $this->SectionIds = $sectionIds;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BallotApplicationEventStatus::valueIsValid()
     * @uses \patest\EnumType\BallotApplicationEventStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Ticketing_BallotApplicationEvent
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BallotApplicationEventStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BallotApplicationEventStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\BallotApplicationEventStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
}
