<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.AreaMap StructType
 * @subpackage Structs
 */
class Ticketing_AreaMap extends VolatileEntity
{
    /**
     * The AreaGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AreaGuid;
    /**
     * The AreaLevelViewXaml
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AreaLevelViewXaml;
    /**
     * The BackgroundImageId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BackgroundImageId;
    /**
     * The ConstructionProblems
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ConstructionProblems;
    /**
     * The GateCombinations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GateCombinations;
    /**
     * The IsPrivate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsPrivate;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The RSCapacity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RSCapacity;
    /**
     * The SeatAnglesP100
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatAnglesP100;
    /**
     * The SeatClubAccess
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatClubAccess;
    /**
     * The SeatCustomProperty1
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatCustomProperty1;
    /**
     * The SeatCustomProperty2
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatCustomProperty2;
    /**
     * The SeatCustomProperty3
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatCustomProperty3;
    /**
     * The SeatCustomProperty4
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatCustomProperty4;
    /**
     * The SeatEntryGate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatEntryGate;
    /**
     * The SeatGateCombinationIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatGateCombinationIds;
    /**
     * The SeatGlobalNotes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatGlobalNotes;
    /**
     * The SeatHeightsP100
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatHeightsP100;
    /**
     * The SeatIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatIds;
    /**
     * The SeatLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatLevel;
    /**
     * The SeatLocationOptions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatLocationOptions;
    /**
     * The SeatNames
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatNames;
    /**
     * The SeatOrdinals
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatOrdinals;
    /**
     * The SeatRowIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatRowIds;
    /**
     * The SeatSecondaryClubAccess
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatSecondaryClubAccess;
    /**
     * The SeatTurnstileCombinationIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatTurnstileCombinationIds;
    /**
     * The SeatViewFromSeatImageIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatViewFromSeatImageIds;
    /**
     * The SeatWidthsP100
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatWidthsP100;
    /**
     * The SeatXP100
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatXP100;
    /**
     * The SeatYP100
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeatYP100;
    /**
     * The Status
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The TurnstileCombinations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TurnstileCombinations;
    /**
     * Constructor method for Ticketing.AreaMap
     * @uses Ticketing_AreaMap::setAreaGuid()
     * @uses Ticketing_AreaMap::setAreaLevelViewXaml()
     * @uses Ticketing_AreaMap::setBackgroundImageId()
     * @uses Ticketing_AreaMap::setConstructionProblems()
     * @uses Ticketing_AreaMap::setGateCombinations()
     * @uses Ticketing_AreaMap::setIsPrivate()
     * @uses Ticketing_AreaMap::setName()
     * @uses Ticketing_AreaMap::setRSCapacity()
     * @uses Ticketing_AreaMap::setSeatAnglesP100()
     * @uses Ticketing_AreaMap::setSeatClubAccess()
     * @uses Ticketing_AreaMap::setSeatCustomProperty1()
     * @uses Ticketing_AreaMap::setSeatCustomProperty2()
     * @uses Ticketing_AreaMap::setSeatCustomProperty3()
     * @uses Ticketing_AreaMap::setSeatCustomProperty4()
     * @uses Ticketing_AreaMap::setSeatEntryGate()
     * @uses Ticketing_AreaMap::setSeatGateCombinationIds()
     * @uses Ticketing_AreaMap::setSeatGlobalNotes()
     * @uses Ticketing_AreaMap::setSeatHeightsP100()
     * @uses Ticketing_AreaMap::setSeatIds()
     * @uses Ticketing_AreaMap::setSeatLevel()
     * @uses Ticketing_AreaMap::setSeatLocationOptions()
     * @uses Ticketing_AreaMap::setSeatNames()
     * @uses Ticketing_AreaMap::setSeatOrdinals()
     * @uses Ticketing_AreaMap::setSeatRowIds()
     * @uses Ticketing_AreaMap::setSeatSecondaryClubAccess()
     * @uses Ticketing_AreaMap::setSeatTurnstileCombinationIds()
     * @uses Ticketing_AreaMap::setSeatViewFromSeatImageIds()
     * @uses Ticketing_AreaMap::setSeatWidthsP100()
     * @uses Ticketing_AreaMap::setSeatXP100()
     * @uses Ticketing_AreaMap::setSeatYP100()
     * @uses Ticketing_AreaMap::setStatus()
     * @uses Ticketing_AreaMap::setTurnstileCombinations()
     * @param string $areaGuid
     * @param string $areaLevelViewXaml
     * @param int $backgroundImageId
     * @param string $constructionProblems
     * @param string $gateCombinations
     * @param bool $isPrivate
     * @param \patest\StructType\GlobalString $name
     * @param int $rSCapacity
     * @param string $seatAnglesP100
     * @param string $seatClubAccess
     * @param string $seatCustomProperty1
     * @param string $seatCustomProperty2
     * @param string $seatCustomProperty3
     * @param string $seatCustomProperty4
     * @param string $seatEntryGate
     * @param string $seatGateCombinationIds
     * @param string $seatGlobalNotes
     * @param string $seatHeightsP100
     * @param string $seatIds
     * @param string $seatLevel
     * @param string $seatLocationOptions
     * @param string $seatNames
     * @param string $seatOrdinals
     * @param string $seatRowIds
     * @param string $seatSecondaryClubAccess
     * @param string $seatTurnstileCombinationIds
     * @param string $seatViewFromSeatImageIds
     * @param string $seatWidthsP100
     * @param string $seatXP100
     * @param string $seatYP100
     * @param string $status
     * @param string $turnstileCombinations
     */
    public function __construct($areaGuid = null, $areaLevelViewXaml = null, $backgroundImageId = null, $constructionProblems = null, $gateCombinations = null, $isPrivate = null, \patest\StructType\GlobalString $name = null, $rSCapacity = null, $seatAnglesP100 = null, $seatClubAccess = null, $seatCustomProperty1 = null, $seatCustomProperty2 = null, $seatCustomProperty3 = null, $seatCustomProperty4 = null, $seatEntryGate = null, $seatGateCombinationIds = null, $seatGlobalNotes = null, $seatHeightsP100 = null, $seatIds = null, $seatLevel = null, $seatLocationOptions = null, $seatNames = null, $seatOrdinals = null, $seatRowIds = null, $seatSecondaryClubAccess = null, $seatTurnstileCombinationIds = null, $seatViewFromSeatImageIds = null, $seatWidthsP100 = null, $seatXP100 = null, $seatYP100 = null, $status = null, $turnstileCombinations = null)
    {
        $this
            ->setAreaGuid($areaGuid)
            ->setAreaLevelViewXaml($areaLevelViewXaml)
            ->setBackgroundImageId($backgroundImageId)
            ->setConstructionProblems($constructionProblems)
            ->setGateCombinations($gateCombinations)
            ->setIsPrivate($isPrivate)
            ->setName($name)
            ->setRSCapacity($rSCapacity)
            ->setSeatAnglesP100($seatAnglesP100)
            ->setSeatClubAccess($seatClubAccess)
            ->setSeatCustomProperty1($seatCustomProperty1)
            ->setSeatCustomProperty2($seatCustomProperty2)
            ->setSeatCustomProperty3($seatCustomProperty3)
            ->setSeatCustomProperty4($seatCustomProperty4)
            ->setSeatEntryGate($seatEntryGate)
            ->setSeatGateCombinationIds($seatGateCombinationIds)
            ->setSeatGlobalNotes($seatGlobalNotes)
            ->setSeatHeightsP100($seatHeightsP100)
            ->setSeatIds($seatIds)
            ->setSeatLevel($seatLevel)
            ->setSeatLocationOptions($seatLocationOptions)
            ->setSeatNames($seatNames)
            ->setSeatOrdinals($seatOrdinals)
            ->setSeatRowIds($seatRowIds)
            ->setSeatSecondaryClubAccess($seatSecondaryClubAccess)
            ->setSeatTurnstileCombinationIds($seatTurnstileCombinationIds)
            ->setSeatViewFromSeatImageIds($seatViewFromSeatImageIds)
            ->setSeatWidthsP100($seatWidthsP100)
            ->setSeatXP100($seatXP100)
            ->setSeatYP100($seatYP100)
            ->setStatus($status)
            ->setTurnstileCombinations($turnstileCombinations);
    }
    /**
     * Get AreaGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaGuid()
    {
        return isset($this->AreaGuid) ? $this->AreaGuid : null;
    }
    /**
     * Set AreaGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaGuid
     * @return \patest\StructType\Ticketing_AreaMap
     */
    public function setAreaGuid($areaGuid = null)
    {
        // validation for constraint: string
        if (!is_null($areaGuid) && !is_string($areaGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaGuid, true), gettype($areaGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($areaGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $areaGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($areaGuid, true)), __LINE__);
        }
        if (is_null($areaGuid) || (is_array($areaGuid) && empty($areaGuid))) {
            unset($this->AreaGuid);
        } else {
            $this->AreaGuid = $areaGuid;
        }
        return $this;
    }
    /**
     * Get AreaLevelViewXaml value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAreaLevelViewXaml()
    {
        return isset($this->AreaLevelViewXaml) ? $this->AreaLevelViewXaml : null;
    }
    /**
     * Set AreaLevelViewXaml value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $areaLevelViewXaml
     * @return \patest\StructType\Ticketing_AreaMap
     */
    public function setAreaLevelViewXaml($areaLevelViewXaml = null)
    {
        // validation for constraint: string
        if (!is_null($areaLevelViewXaml) && !is_string($areaLevelViewXaml)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($areaLevelViewXaml, true), gettype($areaLevelViewXaml)), __LINE__);
        }
        if (is_null($areaLevelViewXaml) || (is_array($areaLevelViewXaml) && empty($areaLevelViewXaml))) {
            unset($this->AreaLevelViewXaml);
        } else {
            $this->AreaLevelViewXaml = $areaLevelViewXaml;
        }
        return $this;
    }
    /**
     * Get BackgroundImageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBackgroundImageId()
    {
        return isset($this->BackgroundImageId) ? $this->BackgroundImageId : null;
    }
    /**
     * Set BackgroundImageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $backgroundImageId
     * @return \patest\StructType\Ticketing_AreaMap
     */
    public function setBackgroundImageId($backgroundImageId = null)
    {
        // validation for constraint: int
        if (!is_null($backgroundImageId) && !(is_int($backgroundImageId) || ctype_digit($backgroundImageId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($backgroundImageId, true), gettype($backgroundImageId)), __LINE__);
        }
        if (is_null($backgroundImageId) || (is_array($backgroundImageId) && empty($backgroundImageId))) {
            unset($this->BackgroundImageId);
        } else {
            $this->BackgroundImageId = $backgroundImageId;
        }
        return $this;
    }
    /**
     * Get ConstructionProblems value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConstructionProblems()
    {
        return isset($this->ConstructionProblems) ? $this->ConstructionProblems : null;
    }
    /**
     * Set ConstructionProblems value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $constructionProblems
     * @return \patest\StructType\Ticketing_AreaMap
     */
    public function setConstructionProblems($constructionProblems = null)
    {
        // validation for constraint: string
        if (!is_null($constructionProblems) && !is_string($constructionProblems)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($constructionProblems, true), gettype($constructionProblems)), __LINE__);
        }
        if (is_null($constructionProblems) || (is_array($constructionProblems) && empty($constructionProblems))) {
            unset($this->ConstructionProblems);
        } else {
            $this->ConstructionProblems = $constructionProblems;
        }
        return $this;
    }
    /**
     * Get GateCombinations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGateCombinations()
    {
        return isset($this->GateCombinations) ? $this->GateCombinations : null;
    }
    /**
     * Set GateCombinations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gateCombinations
     * @return \patest\StructType\Ticketing_AreaMap
     */
    public function setGateCombinations($gateCombinations = null)
    {
        // validation for constraint: string
        if (!is_null($gateCombinations) && !is_string($gateCombinations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($gateCombinations, true), gettype($gateCombinations)), __LINE__);
        }
        if (is_null($gateCombinations) || (is_array($gateCombinations) && empty($gateCombinations))) {
            unset($this->GateCombinations);
        } else {
            $this->GateCombinations = $gateCombinations;
        }
        return $this;
    }
    /**
     * Get IsPrivate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsPrivate()
    {
        return isset($this->IsPrivate) ? $this->IsPrivate : null;
    }
    /**
     * Set IsPrivate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isPrivate
     * @return \patest\StructType\Ticketing_AreaMap
     */
    public function setIsPrivate($isPrivate = null)
    {
        // validation for constraint: boolean
        if (!is_null($isPrivate) && !is_bool($isPrivate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isPrivate, true), gettype($isPrivate)), __LINE__);
        }
        if (is_null($isPrivate) || (is_array($isPrivate) && empty($isPrivate))) {
            unset($this->IsPrivate);
        } else {
            $this->IsPrivate = $isPrivate;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Ticketing_AreaMap
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get RSCapacity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRSCapacity()
    {
        return isset($this->RSCapacity) ? $this->RSCapacity : null;
    }
    /**
     * Set RSCapacity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $rSCapacity
     * @return \patest\StructType\Ticketing_AreaMap
     */
    public function setRSCapacity($rSCapacity = null)
    {
        // validation for constraint: int
        if (!is_null($rSCapacity) && !(is_int($rSCapacity) || ctype_digit($rSCapacity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($rSCapacity, true), gettype($rSCapacity)), __LINE__);
        }
        if (is_null($rSCapacity) || (is_array($rSCapacity) && empty($rSCapacity))) {
            unset($this->RSCapacity);
        } else {
            $this->RSCapacity = $rSCapacity;
        }
        return $this;
    }
    /**
     * Get SeatAnglesP100 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatAnglesP100()
    {
        return isset($this->SeatAnglesP100) ? $this->SeatAnglesP100 : null;
    }
    /**
     * Set SeatAnglesP100 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatAnglesP100
     * @return \patest\StructType\Ticketing_AreaMap
     */
    public function setSeatAnglesP100($seatAnglesP100 = null)
    {
        // validation for constraint: string
        if (!is_null($seatAnglesP100) && !is_string($seatAnglesP100)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatAnglesP100, true), gettype($seatAnglesP100)), __LINE__);
        }
        if (is_null($seatAnglesP100) || (is_array($seatAnglesP100) && empty($seatAnglesP100))) {
            unset($this->SeatAnglesP100);
        } else {
            $this->SeatAnglesP100 = $seatAnglesP100;
        }
        return $this;
    }
    /**
     * Get SeatClubAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatClubAccess()
    {
        return isset($this->SeatClubAccess) ? $this->SeatClubAccess : null;
    }
    /**
     * Set SeatClubAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatClubAccess
     * @return \patest\StructType\Ticketing_AreaMap
     */
    public function setSeatClubAccess($seatClubAccess = null)
    {
        // validation for constraint: string
        if (!is_null($seatClubAccess) && !is_string($seatClubAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatClubAccess, true), gettype($seatClubAccess)), __LINE__);
        }
        if (is_null($seatClubAccess) || (is_array($seatClubAccess) && empty($seatClubAccess))) {
            unset($this->SeatClubAccess);
        } else {
            $this->SeatClubAccess = $seatClubAccess;
        }
        return $this;
    }
    /**
     * Get SeatCustomProperty1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatCustomProperty1()
    {
        return isset($this->SeatCustomProperty1) ? $this->SeatCustomProperty1 : null;
    }
    /**
     * Set SeatCustomProperty1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatCustomProperty1
     * @return \patest\StructType\Ticketing_AreaMap
     */
    public function setSeatCustomProperty1($seatCustomProperty1 = null)
    {
        // validation for constraint: string
        if (!is_null($seatCustomProperty1) && !is_string($seatCustomProperty1)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatCustomProperty1, true), gettype($seatCustomProperty1)), __LINE__);
        }
        if (is_null($seatCustomProperty1) || (is_array($seatCustomProperty1) && empty($seatCustomProperty1))) {
            unset($this->SeatCustomProperty1);
        } else {
            $this->SeatCustomProperty1 = $seatCustomProperty1;
        }
        return $this;
    }
    /**
     * Get SeatCustomProperty2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatCustomProperty2()
    {
        return isset($this->SeatCustomProperty2) ? $this->SeatCustomProperty2 : null;
    }
    /**
     * Set SeatCustomProperty2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatCustomProperty2
     * @return \patest\StructType\Ticketing_AreaMap
     */
    public function setSeatCustomProperty2($seatCustomProperty2 = null)
    {
        // validation for constraint: string
        if (!is_null($seatCustomProperty2) && !is_string($seatCustomProperty2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatCustomProperty2, true), gettype($seatCustomProperty2)), __LINE__);
        }
        if (is_null($seatCustomProperty2) || (is_array($seatCustomProperty2) && empty($seatCustomProperty2))) {
            unset($this->SeatCustomProperty2);
        } else {
            $this->SeatCustomProperty2 = $seatCustomProperty2;
        }
        return $this;
    }
    /**
     * Get SeatCustomProperty3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatCustomProperty3()
    {
        return isset($this->SeatCustomProperty3) ? $this->SeatCustomProperty3 : null;
    }
    /**
     * Set SeatCustomProperty3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatCustomProperty3
     * @return \patest\StructType\Ticketing_AreaMap
     */
    public function setSeatCustomProperty3($seatCustomProperty3 = null)
    {
        // validation for constraint: string
        if (!is_null($seatCustomProperty3) && !is_string($seatCustomProperty3)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatCustomProperty3, true), gettype($seatCustomProperty3)), __LINE__);
        }
        if (is_null($seatCustomProperty3) || (is_array($seatCustomProperty3) && empty($seatCustomProperty3))) {
            unset($this->SeatCustomProperty3);
        } else {
            $this->SeatCustomProperty3 = $seatCustomProperty3;
        }
        return $this;
    }
    /**
     * Get SeatCustomProperty4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatCustomProperty4()
    {
        return isset($this->SeatCustomProperty4) ? $this->SeatCustomProperty4 : null;
    }
    /**
     * Set SeatCustomProperty4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatCustomProperty4
     * @return \patest\StructType\Ticketing_AreaMap
     */
    public function setSeatCustomProperty4($seatCustomProperty4 = null)
    {
        // validation for constraint: string
        if (!is_null($seatCustomProperty4) && !is_string($seatCustomProperty4)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatCustomProperty4, true), gettype($seatCustomProperty4)), __LINE__);
        }
        if (is_null($seatCustomProperty4) || (is_array($seatCustomProperty4) && empty($seatCustomProperty4))) {
            unset($this->SeatCustomProperty4);
        } else {
            $this->SeatCustomProperty4 = $seatCustomProperty4;
        }
        return $this;
    }
    /**
     * Get SeatEntryGate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatEntryGate()
    {
        return isset($this->SeatEntryGate) ? $this->SeatEntryGate : null;
    }
    /**
     * Set SeatEntryGate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatEntryGate
     * @return \patest\StructType\Ticketing_AreaMap
     */
    public function setSeatEntryGate($seatEntryGate = null)
    {
        // validation for constraint: string
        if (!is_null($seatEntryGate) && !is_string($seatEntryGate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatEntryGate, true), gettype($seatEntryGate)), __LINE__);
        }
        if (is_null($seatEntryGate) || (is_array($seatEntryGate) && empty($seatEntryGate))) {
            unset($this->SeatEntryGate);
        } else {
            $this->SeatEntryGate = $seatEntryGate;
        }
        return $this;
    }
    /**
     * Get SeatGateCombinationIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatGateCombinationIds()
    {
        return isset($this->SeatGateCombinationIds) ? $this->SeatGateCombinationIds : null;
    }
    /**
     * Set SeatGateCombinationIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatGateCombinationIds
     * @return \patest\StructType\Ticketing_AreaMap
     */
    public function setSeatGateCombinationIds($seatGateCombinationIds = null)
    {
        // validation for constraint: string
        if (!is_null($seatGateCombinationIds) && !is_string($seatGateCombinationIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatGateCombinationIds, true), gettype($seatGateCombinationIds)), __LINE__);
        }
        if (is_null($seatGateCombinationIds) || (is_array($seatGateCombinationIds) && empty($seatGateCombinationIds))) {
            unset($this->SeatGateCombinationIds);
        } else {
            $this->SeatGateCombinationIds = $seatGateCombinationIds;
        }
        return $this;
    }
    /**
     * Get SeatGlobalNotes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatGlobalNotes()
    {
        return isset($this->SeatGlobalNotes) ? $this->SeatGlobalNotes : null;
    }
    /**
     * Set SeatGlobalNotes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatGlobalNotes
     * @return \patest\StructType\Ticketing_AreaMap
     */
    public function setSeatGlobalNotes($seatGlobalNotes = null)
    {
        // validation for constraint: string
        if (!is_null($seatGlobalNotes) && !is_string($seatGlobalNotes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatGlobalNotes, true), gettype($seatGlobalNotes)), __LINE__);
        }
        if (is_null($seatGlobalNotes) || (is_array($seatGlobalNotes) && empty($seatGlobalNotes))) {
            unset($this->SeatGlobalNotes);
        } else {
            $this->SeatGlobalNotes = $seatGlobalNotes;
        }
        return $this;
    }
    /**
     * Get SeatHeightsP100 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatHeightsP100()
    {
        return isset($this->SeatHeightsP100) ? $this->SeatHeightsP100 : null;
    }
    /**
     * Set SeatHeightsP100 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatHeightsP100
     * @return \patest\StructType\Ticketing_AreaMap
     */
    public function setSeatHeightsP100($seatHeightsP100 = null)
    {
        // validation for constraint: string
        if (!is_null($seatHeightsP100) && !is_string($seatHeightsP100)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatHeightsP100, true), gettype($seatHeightsP100)), __LINE__);
        }
        if (is_null($seatHeightsP100) || (is_array($seatHeightsP100) && empty($seatHeightsP100))) {
            unset($this->SeatHeightsP100);
        } else {
            $this->SeatHeightsP100 = $seatHeightsP100;
        }
        return $this;
    }
    /**
     * Get SeatIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatIds()
    {
        return isset($this->SeatIds) ? $this->SeatIds : null;
    }
    /**
     * Set SeatIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatIds
     * @return \patest\StructType\Ticketing_AreaMap
     */
    public function setSeatIds($seatIds = null)
    {
        // validation for constraint: string
        if (!is_null($seatIds) && !is_string($seatIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatIds, true), gettype($seatIds)), __LINE__);
        }
        if (is_null($seatIds) || (is_array($seatIds) && empty($seatIds))) {
            unset($this->SeatIds);
        } else {
            $this->SeatIds = $seatIds;
        }
        return $this;
    }
    /**
     * Get SeatLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatLevel()
    {
        return isset($this->SeatLevel) ? $this->SeatLevel : null;
    }
    /**
     * Set SeatLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatLevel
     * @return \patest\StructType\Ticketing_AreaMap
     */
    public function setSeatLevel($seatLevel = null)
    {
        // validation for constraint: string
        if (!is_null($seatLevel) && !is_string($seatLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatLevel, true), gettype($seatLevel)), __LINE__);
        }
        if (is_null($seatLevel) || (is_array($seatLevel) && empty($seatLevel))) {
            unset($this->SeatLevel);
        } else {
            $this->SeatLevel = $seatLevel;
        }
        return $this;
    }
    /**
     * Get SeatLocationOptions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatLocationOptions()
    {
        return isset($this->SeatLocationOptions) ? $this->SeatLocationOptions : null;
    }
    /**
     * Set SeatLocationOptions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatLocationOptions
     * @return \patest\StructType\Ticketing_AreaMap
     */
    public function setSeatLocationOptions($seatLocationOptions = null)
    {
        // validation for constraint: string
        if (!is_null($seatLocationOptions) && !is_string($seatLocationOptions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatLocationOptions, true), gettype($seatLocationOptions)), __LINE__);
        }
        if (is_null($seatLocationOptions) || (is_array($seatLocationOptions) && empty($seatLocationOptions))) {
            unset($this->SeatLocationOptions);
        } else {
            $this->SeatLocationOptions = $seatLocationOptions;
        }
        return $this;
    }
    /**
     * Get SeatNames value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatNames()
    {
        return isset($this->SeatNames) ? $this->SeatNames : null;
    }
    /**
     * Set SeatNames value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatNames
     * @return \patest\StructType\Ticketing_AreaMap
     */
    public function setSeatNames($seatNames = null)
    {
        // validation for constraint: string
        if (!is_null($seatNames) && !is_string($seatNames)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatNames, true), gettype($seatNames)), __LINE__);
        }
        if (is_null($seatNames) || (is_array($seatNames) && empty($seatNames))) {
            unset($this->SeatNames);
        } else {
            $this->SeatNames = $seatNames;
        }
        return $this;
    }
    /**
     * Get SeatOrdinals value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatOrdinals()
    {
        return isset($this->SeatOrdinals) ? $this->SeatOrdinals : null;
    }
    /**
     * Set SeatOrdinals value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatOrdinals
     * @return \patest\StructType\Ticketing_AreaMap
     */
    public function setSeatOrdinals($seatOrdinals = null)
    {
        // validation for constraint: string
        if (!is_null($seatOrdinals) && !is_string($seatOrdinals)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatOrdinals, true), gettype($seatOrdinals)), __LINE__);
        }
        if (is_null($seatOrdinals) || (is_array($seatOrdinals) && empty($seatOrdinals))) {
            unset($this->SeatOrdinals);
        } else {
            $this->SeatOrdinals = $seatOrdinals;
        }
        return $this;
    }
    /**
     * Get SeatRowIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatRowIds()
    {
        return isset($this->SeatRowIds) ? $this->SeatRowIds : null;
    }
    /**
     * Set SeatRowIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatRowIds
     * @return \patest\StructType\Ticketing_AreaMap
     */
    public function setSeatRowIds($seatRowIds = null)
    {
        // validation for constraint: string
        if (!is_null($seatRowIds) && !is_string($seatRowIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatRowIds, true), gettype($seatRowIds)), __LINE__);
        }
        if (is_null($seatRowIds) || (is_array($seatRowIds) && empty($seatRowIds))) {
            unset($this->SeatRowIds);
        } else {
            $this->SeatRowIds = $seatRowIds;
        }
        return $this;
    }
    /**
     * Get SeatSecondaryClubAccess value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatSecondaryClubAccess()
    {
        return isset($this->SeatSecondaryClubAccess) ? $this->SeatSecondaryClubAccess : null;
    }
    /**
     * Set SeatSecondaryClubAccess value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatSecondaryClubAccess
     * @return \patest\StructType\Ticketing_AreaMap
     */
    public function setSeatSecondaryClubAccess($seatSecondaryClubAccess = null)
    {
        // validation for constraint: string
        if (!is_null($seatSecondaryClubAccess) && !is_string($seatSecondaryClubAccess)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatSecondaryClubAccess, true), gettype($seatSecondaryClubAccess)), __LINE__);
        }
        if (is_null($seatSecondaryClubAccess) || (is_array($seatSecondaryClubAccess) && empty($seatSecondaryClubAccess))) {
            unset($this->SeatSecondaryClubAccess);
        } else {
            $this->SeatSecondaryClubAccess = $seatSecondaryClubAccess;
        }
        return $this;
    }
    /**
     * Get SeatTurnstileCombinationIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatTurnstileCombinationIds()
    {
        return isset($this->SeatTurnstileCombinationIds) ? $this->SeatTurnstileCombinationIds : null;
    }
    /**
     * Set SeatTurnstileCombinationIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatTurnstileCombinationIds
     * @return \patest\StructType\Ticketing_AreaMap
     */
    public function setSeatTurnstileCombinationIds($seatTurnstileCombinationIds = null)
    {
        // validation for constraint: string
        if (!is_null($seatTurnstileCombinationIds) && !is_string($seatTurnstileCombinationIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatTurnstileCombinationIds, true), gettype($seatTurnstileCombinationIds)), __LINE__);
        }
        if (is_null($seatTurnstileCombinationIds) || (is_array($seatTurnstileCombinationIds) && empty($seatTurnstileCombinationIds))) {
            unset($this->SeatTurnstileCombinationIds);
        } else {
            $this->SeatTurnstileCombinationIds = $seatTurnstileCombinationIds;
        }
        return $this;
    }
    /**
     * Get SeatViewFromSeatImageIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatViewFromSeatImageIds()
    {
        return isset($this->SeatViewFromSeatImageIds) ? $this->SeatViewFromSeatImageIds : null;
    }
    /**
     * Set SeatViewFromSeatImageIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatViewFromSeatImageIds
     * @return \patest\StructType\Ticketing_AreaMap
     */
    public function setSeatViewFromSeatImageIds($seatViewFromSeatImageIds = null)
    {
        // validation for constraint: string
        if (!is_null($seatViewFromSeatImageIds) && !is_string($seatViewFromSeatImageIds)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatViewFromSeatImageIds, true), gettype($seatViewFromSeatImageIds)), __LINE__);
        }
        if (is_null($seatViewFromSeatImageIds) || (is_array($seatViewFromSeatImageIds) && empty($seatViewFromSeatImageIds))) {
            unset($this->SeatViewFromSeatImageIds);
        } else {
            $this->SeatViewFromSeatImageIds = $seatViewFromSeatImageIds;
        }
        return $this;
    }
    /**
     * Get SeatWidthsP100 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatWidthsP100()
    {
        return isset($this->SeatWidthsP100) ? $this->SeatWidthsP100 : null;
    }
    /**
     * Set SeatWidthsP100 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatWidthsP100
     * @return \patest\StructType\Ticketing_AreaMap
     */
    public function setSeatWidthsP100($seatWidthsP100 = null)
    {
        // validation for constraint: string
        if (!is_null($seatWidthsP100) && !is_string($seatWidthsP100)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatWidthsP100, true), gettype($seatWidthsP100)), __LINE__);
        }
        if (is_null($seatWidthsP100) || (is_array($seatWidthsP100) && empty($seatWidthsP100))) {
            unset($this->SeatWidthsP100);
        } else {
            $this->SeatWidthsP100 = $seatWidthsP100;
        }
        return $this;
    }
    /**
     * Get SeatXP100 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatXP100()
    {
        return isset($this->SeatXP100) ? $this->SeatXP100 : null;
    }
    /**
     * Set SeatXP100 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatXP100
     * @return \patest\StructType\Ticketing_AreaMap
     */
    public function setSeatXP100($seatXP100 = null)
    {
        // validation for constraint: string
        if (!is_null($seatXP100) && !is_string($seatXP100)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatXP100, true), gettype($seatXP100)), __LINE__);
        }
        if (is_null($seatXP100) || (is_array($seatXP100) && empty($seatXP100))) {
            unset($this->SeatXP100);
        } else {
            $this->SeatXP100 = $seatXP100;
        }
        return $this;
    }
    /**
     * Get SeatYP100 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeatYP100()
    {
        return isset($this->SeatYP100) ? $this->SeatYP100 : null;
    }
    /**
     * Set SeatYP100 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seatYP100
     * @return \patest\StructType\Ticketing_AreaMap
     */
    public function setSeatYP100($seatYP100 = null)
    {
        // validation for constraint: string
        if (!is_null($seatYP100) && !is_string($seatYP100)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seatYP100, true), gettype($seatYP100)), __LINE__);
        }
        if (is_null($seatYP100) || (is_array($seatYP100) && empty($seatYP100))) {
            unset($this->SeatYP100);
        } else {
            $this->SeatYP100 = $seatYP100;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\AreaMapStatus::valueIsValid()
     * @uses \patest\EnumType\AreaMapStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $status
     * @return \patest\StructType\Ticketing_AreaMap
     */
    public function setStatus($status = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\AreaMapStatus::valueIsValid($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\AreaMapStatus', is_array($status) ? implode(', ', $status) : var_export($status, true), implode(', ', \patest\EnumType\AreaMapStatus::getValidValues())), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get TurnstileCombinations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTurnstileCombinations()
    {
        return isset($this->TurnstileCombinations) ? $this->TurnstileCombinations : null;
    }
    /**
     * Set TurnstileCombinations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $turnstileCombinations
     * @return \patest\StructType\Ticketing_AreaMap
     */
    public function setTurnstileCombinations($turnstileCombinations = null)
    {
        // validation for constraint: string
        if (!is_null($turnstileCombinations) && !is_string($turnstileCombinations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($turnstileCombinations, true), gettype($turnstileCombinations)), __LINE__);
        }
        if (is_null($turnstileCombinations) || (is_array($turnstileCombinations) && empty($turnstileCombinations))) {
            unset($this->TurnstileCombinations);
        } else {
            $this->TurnstileCombinations = $turnstileCombinations;
        }
        return $this;
    }
}
