<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Ticketing.AccessCode StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Ticketing.AccessCode
 * @subpackage Structs
 */
class Ticketing_AccessCode extends DistributableEntity
{
    /**
     * The CodeText
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodeText;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The LastTransactionNumber
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LastTransactionNumber;
    /**
     * The LastUsageDate
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastUsageDate;
    /**
     * The PresaleId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PresaleId;
    /**
     * The TicketCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TicketCount;
    /**
     * The TransactionCount
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TransactionCount;
    /**
     * Constructor method for Ticketing.AccessCode
     * @uses Ticketing_AccessCode::setCodeText()
     * @uses Ticketing_AccessCode::setIsActive()
     * @uses Ticketing_AccessCode::setLastTransactionNumber()
     * @uses Ticketing_AccessCode::setLastUsageDate()
     * @uses Ticketing_AccessCode::setPresaleId()
     * @uses Ticketing_AccessCode::setTicketCount()
     * @uses Ticketing_AccessCode::setTransactionCount()
     * @param string $codeText
     * @param bool $isActive
     * @param int $lastTransactionNumber
     * @param string $lastUsageDate
     * @param string $presaleId
     * @param int $ticketCount
     * @param int $transactionCount
     */
    public function __construct($codeText = null, $isActive = null, $lastTransactionNumber = null, $lastUsageDate = null, $presaleId = null, $ticketCount = null, $transactionCount = null)
    {
        $this
            ->setCodeText($codeText)
            ->setIsActive($isActive)
            ->setLastTransactionNumber($lastTransactionNumber)
            ->setLastUsageDate($lastUsageDate)
            ->setPresaleId($presaleId)
            ->setTicketCount($ticketCount)
            ->setTransactionCount($transactionCount);
    }
    /**
     * Get CodeText value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodeText()
    {
        return isset($this->CodeText) ? $this->CodeText : null;
    }
    /**
     * Set CodeText value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codeText
     * @return \patest\StructType\Ticketing_AccessCode
     */
    public function setCodeText($codeText = null)
    {
        // validation for constraint: string
        if (!is_null($codeText) && !is_string($codeText)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($codeText, true), gettype($codeText)), __LINE__);
        }
        if (is_null($codeText) || (is_array($codeText) && empty($codeText))) {
            unset($this->CodeText);
        } else {
            $this->CodeText = $codeText;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Ticketing_AccessCode
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get LastTransactionNumber value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLastTransactionNumber()
    {
        return isset($this->LastTransactionNumber) ? $this->LastTransactionNumber : null;
    }
    /**
     * Set LastTransactionNumber value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lastTransactionNumber
     * @return \patest\StructType\Ticketing_AccessCode
     */
    public function setLastTransactionNumber($lastTransactionNumber = null)
    {
        // validation for constraint: int
        if (!is_null($lastTransactionNumber) && !(is_int($lastTransactionNumber) || ctype_digit($lastTransactionNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lastTransactionNumber, true), gettype($lastTransactionNumber)), __LINE__);
        }
        if (is_null($lastTransactionNumber) || (is_array($lastTransactionNumber) && empty($lastTransactionNumber))) {
            unset($this->LastTransactionNumber);
        } else {
            $this->LastTransactionNumber = $lastTransactionNumber;
        }
        return $this;
    }
    /**
     * Get LastUsageDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastUsageDate()
    {
        return isset($this->LastUsageDate) ? $this->LastUsageDate : null;
    }
    /**
     * Set LastUsageDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastUsageDate
     * @return \patest\StructType\Ticketing_AccessCode
     */
    public function setLastUsageDate($lastUsageDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastUsageDate) && !is_string($lastUsageDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastUsageDate, true), gettype($lastUsageDate)), __LINE__);
        }
        if (is_null($lastUsageDate) || (is_array($lastUsageDate) && empty($lastUsageDate))) {
            unset($this->LastUsageDate);
        } else {
            $this->LastUsageDate = $lastUsageDate;
        }
        return $this;
    }
    /**
     * Get PresaleId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPresaleId()
    {
        return isset($this->PresaleId) ? $this->PresaleId : null;
    }
    /**
     * Set PresaleId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $presaleId
     * @return \patest\StructType\Ticketing_AccessCode
     */
    public function setPresaleId($presaleId = null)
    {
        // validation for constraint: string
        if (!is_null($presaleId) && !is_string($presaleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($presaleId, true), gettype($presaleId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($presaleId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $presaleId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($presaleId, true)), __LINE__);
        }
        if (is_null($presaleId) || (is_array($presaleId) && empty($presaleId))) {
            unset($this->PresaleId);
        } else {
            $this->PresaleId = $presaleId;
        }
        return $this;
    }
    /**
     * Get TicketCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTicketCount()
    {
        return isset($this->TicketCount) ? $this->TicketCount : null;
    }
    /**
     * Set TicketCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ticketCount
     * @return \patest\StructType\Ticketing_AccessCode
     */
    public function setTicketCount($ticketCount = null)
    {
        // validation for constraint: int
        if (!is_null($ticketCount) && !(is_int($ticketCount) || ctype_digit($ticketCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ticketCount, true), gettype($ticketCount)), __LINE__);
        }
        if (is_null($ticketCount) || (is_array($ticketCount) && empty($ticketCount))) {
            unset($this->TicketCount);
        } else {
            $this->TicketCount = $ticketCount;
        }
        return $this;
    }
    /**
     * Get TransactionCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTransactionCount()
    {
        return isset($this->TransactionCount) ? $this->TransactionCount : null;
    }
    /**
     * Set TransactionCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $transactionCount
     * @return \patest\StructType\Ticketing_AccessCode
     */
    public function setTransactionCount($transactionCount = null)
    {
        // validation for constraint: int
        if (!is_null($transactionCount) && !(is_int($transactionCount) || ctype_digit($transactionCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($transactionCount, true), gettype($transactionCount)), __LINE__);
        }
        if (is_null($transactionCount) || (is_array($transactionCount) && empty($transactionCount))) {
            unset($this->TransactionCount);
        } else {
            $this->TransactionCount = $transactionCount;
        }
        return $this;
    }
}
