<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketViewSeatAttribute StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TicketViewSeatAttribute
 * @subpackage Structs
 */
class TicketViewSeatAttribute extends ExtensibleDataContract
{
    /**
     * The AttributeType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $AttributeType;
    /**
     * The Label
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Label;
    /**
     * Constructor method for TicketViewSeatAttribute
     * @uses TicketViewSeatAttribute::setAttributeType()
     * @uses TicketViewSeatAttribute::setLabel()
     * @param string $attributeType
     * @param string $label
     */
    public function __construct($attributeType = null, $label = null)
    {
        $this
            ->setAttributeType($attributeType)
            ->setLabel($label);
    }
    /**
     * Get AttributeType value
     * @return string|null
     */
    public function getAttributeType()
    {
        return $this->AttributeType;
    }
    /**
     * Set AttributeType value
     * @uses \patest\EnumType\TicketViewSeatAttributeType::valueIsValid()
     * @uses \patest\EnumType\TicketViewSeatAttributeType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $attributeType
     * @return \patest\StructType\TicketViewSeatAttribute
     */
    public function setAttributeType($attributeType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketViewSeatAttributeType::valueIsValid($attributeType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketViewSeatAttributeType', is_array($attributeType) ? implode(', ', $attributeType) : var_export($attributeType, true), implode(', ', \patest\EnumType\TicketViewSeatAttributeType::getValidValues())), __LINE__);
        }
        $this->AttributeType = $attributeType;
        return $this;
    }
    /**
     * Get Label value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLabel()
    {
        return isset($this->Label) ? $this->Label : null;
    }
    /**
     * Set Label value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $label
     * @return \patest\StructType\TicketViewSeatAttribute
     */
    public function setLabel($label = null)
    {
        // validation for constraint: string
        if (!is_null($label) && !is_string($label)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($label, true), gettype($label)), __LINE__);
        }
        if (is_null($label) || (is_array($label) && empty($label))) {
            unset($this->Label);
        } else {
            $this->Label = $label;
        }
        return $this;
    }
}
