<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketViewConfigurationImageResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TicketViewConfigurationImageResponse
 * @subpackage Structs
 */
class TicketViewConfigurationImageResponse extends AbstractStructBase
{
    /**
     * The AdaDominantColor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AdaDominantColor;
    /**
     * The FileExtension
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FileExtension;
    /**
     * The ImageGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ImageGuid;
    /**
     * The ImageType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ImageType;
    /**
     * The ImageUrl
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ImageUrl;
    /**
     * The IsHidden
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsHidden;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * Constructor method for TicketViewConfigurationImageResponse
     * @uses TicketViewConfigurationImageResponse::setAdaDominantColor()
     * @uses TicketViewConfigurationImageResponse::setFileExtension()
     * @uses TicketViewConfigurationImageResponse::setImageGuid()
     * @uses TicketViewConfigurationImageResponse::setImageType()
     * @uses TicketViewConfigurationImageResponse::setImageUrl()
     * @uses TicketViewConfigurationImageResponse::setIsHidden()
     * @uses TicketViewConfigurationImageResponse::setName()
     * @uses TicketViewConfigurationImageResponse::setOrganizationUnitId()
     * @param string $adaDominantColor
     * @param string $fileExtension
     * @param string $imageGuid
     * @param string $imageType
     * @param string $imageUrl
     * @param bool $isHidden
     * @param string $name
     * @param string $organizationUnitId
     */
    public function __construct($adaDominantColor = null, $fileExtension = null, $imageGuid = null, $imageType = null, $imageUrl = null, $isHidden = null, $name = null, $organizationUnitId = null)
    {
        $this
            ->setAdaDominantColor($adaDominantColor)
            ->setFileExtension($fileExtension)
            ->setImageGuid($imageGuid)
            ->setImageType($imageType)
            ->setImageUrl($imageUrl)
            ->setIsHidden($isHidden)
            ->setName($name)
            ->setOrganizationUnitId($organizationUnitId);
    }
    /**
     * Get AdaDominantColor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAdaDominantColor()
    {
        return isset($this->AdaDominantColor) ? $this->AdaDominantColor : null;
    }
    /**
     * Set AdaDominantColor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $adaDominantColor
     * @return \patest\StructType\TicketViewConfigurationImageResponse
     */
    public function setAdaDominantColor($adaDominantColor = null)
    {
        // validation for constraint: string
        if (!is_null($adaDominantColor) && !is_string($adaDominantColor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($adaDominantColor, true), gettype($adaDominantColor)), __LINE__);
        }
        if (is_null($adaDominantColor) || (is_array($adaDominantColor) && empty($adaDominantColor))) {
            unset($this->AdaDominantColor);
        } else {
            $this->AdaDominantColor = $adaDominantColor;
        }
        return $this;
    }
    /**
     * Get FileExtension value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFileExtension()
    {
        return isset($this->FileExtension) ? $this->FileExtension : null;
    }
    /**
     * Set FileExtension value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $fileExtension
     * @return \patest\StructType\TicketViewConfigurationImageResponse
     */
    public function setFileExtension($fileExtension = null)
    {
        // validation for constraint: string
        if (!is_null($fileExtension) && !is_string($fileExtension)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($fileExtension, true), gettype($fileExtension)), __LINE__);
        }
        if (is_null($fileExtension) || (is_array($fileExtension) && empty($fileExtension))) {
            unset($this->FileExtension);
        } else {
            $this->FileExtension = $fileExtension;
        }
        return $this;
    }
    /**
     * Get ImageGuid value
     * @return string|null
     */
    public function getImageGuid()
    {
        return $this->ImageGuid;
    }
    /**
     * Set ImageGuid value
     * @param string $imageGuid
     * @return \patest\StructType\TicketViewConfigurationImageResponse
     */
    public function setImageGuid($imageGuid = null)
    {
        // validation for constraint: string
        if (!is_null($imageGuid) && !is_string($imageGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imageGuid, true), gettype($imageGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($imageGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $imageGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($imageGuid, true)), __LINE__);
        }
        $this->ImageGuid = $imageGuid;
        return $this;
    }
    /**
     * Get ImageType value
     * @return string|null
     */
    public function getImageType()
    {
        return $this->ImageType;
    }
    /**
     * Set ImageType value
     * @uses \patest\EnumType\TicketViewConfigurationImageType::valueIsValid()
     * @uses \patest\EnumType\TicketViewConfigurationImageType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $imageType
     * @return \patest\StructType\TicketViewConfigurationImageResponse
     */
    public function setImageType($imageType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketViewConfigurationImageType::valueIsValid($imageType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketViewConfigurationImageType', is_array($imageType) ? implode(', ', $imageType) : var_export($imageType, true), implode(', ', \patest\EnumType\TicketViewConfigurationImageType::getValidValues())), __LINE__);
        }
        $this->ImageType = $imageType;
        return $this;
    }
    /**
     * Get ImageUrl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getImageUrl()
    {
        return isset($this->ImageUrl) ? $this->ImageUrl : null;
    }
    /**
     * Set ImageUrl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $imageUrl
     * @return \patest\StructType\TicketViewConfigurationImageResponse
     */
    public function setImageUrl($imageUrl = null)
    {
        // validation for constraint: string
        if (!is_null($imageUrl) && !is_string($imageUrl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($imageUrl, true), gettype($imageUrl)), __LINE__);
        }
        if (is_null($imageUrl) || (is_array($imageUrl) && empty($imageUrl))) {
            unset($this->ImageUrl);
        } else {
            $this->ImageUrl = $imageUrl;
        }
        return $this;
    }
    /**
     * Get IsHidden value
     * @return bool|null
     */
    public function getIsHidden()
    {
        return $this->IsHidden;
    }
    /**
     * Set IsHidden value
     * @param bool $isHidden
     * @return \patest\StructType\TicketViewConfigurationImageResponse
     */
    public function setIsHidden($isHidden = null)
    {
        // validation for constraint: boolean
        if (!is_null($isHidden) && !is_bool($isHidden)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isHidden, true), gettype($isHidden)), __LINE__);
        }
        $this->IsHidden = $isHidden;
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\TicketViewConfigurationImageResponse
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\TicketViewConfigurationImageResponse
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
}
