<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketViewComponentGet-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TicketViewComponentGet-Request
 * @subpackage Structs
 */
class TicketViewComponentGet_Request extends ExtensibleDataContract
{
    /**
     * The ComponentId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ComponentId;
    /**
     * The IncludeReferences
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IncludeReferences;
    /**
     * Constructor method for TicketViewComponentGet-Request
     * @uses TicketViewComponentGet_Request::setComponentId()
     * @uses TicketViewComponentGet_Request::setIncludeReferences()
     * @param string $componentId
     * @param bool $includeReferences
     */
    public function __construct($componentId = null, $includeReferences = null)
    {
        $this
            ->setComponentId($componentId)
            ->setIncludeReferences($includeReferences);
    }
    /**
     * Get ComponentId value
     * @return string|null
     */
    public function getComponentId()
    {
        return $this->ComponentId;
    }
    /**
     * Set ComponentId value
     * @param string $componentId
     * @return \patest\StructType\TicketViewComponentGet_Request
     */
    public function setComponentId($componentId = null)
    {
        // validation for constraint: string
        if (!is_null($componentId) && !is_string($componentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($componentId, true), gettype($componentId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($componentId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $componentId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($componentId, true)), __LINE__);
        }
        $this->ComponentId = $componentId;
        return $this;
    }
    /**
     * Get IncludeReferences value
     * @return bool|null
     */
    public function getIncludeReferences()
    {
        return $this->IncludeReferences;
    }
    /**
     * Set IncludeReferences value
     * @param bool $includeReferences
     * @return \patest\StructType\TicketViewComponentGet_Request
     */
    public function setIncludeReferences($includeReferences = null)
    {
        // validation for constraint: boolean
        if (!is_null($includeReferences) && !is_bool($includeReferences)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($includeReferences, true), gettype($includeReferences)), __LINE__);
        }
        $this->IncludeReferences = $includeReferences;
        return $this;
    }
}
