<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketViewComponentAssociationReference StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TicketViewComponentAssociationReference
 * @subpackage Structs
 */
class TicketViewComponentAssociationReference extends ExtensibleDataContract
{
    /**
     * The ApplicationLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $ApplicationLevel;
    /**
     * The ApplicationObjectIdentifier
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ApplicationObjectIdentifier;
    /**
     * The ApplicationObjectName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ApplicationObjectName;
    /**
     * The AssociationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AssociationId;
    /**
     * The AssociationName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AssociationName;
    /**
     * Constructor method for TicketViewComponentAssociationReference
     * @uses TicketViewComponentAssociationReference::setApplicationLevel()
     * @uses TicketViewComponentAssociationReference::setApplicationObjectIdentifier()
     * @uses TicketViewComponentAssociationReference::setApplicationObjectName()
     * @uses TicketViewComponentAssociationReference::setAssociationId()
     * @uses TicketViewComponentAssociationReference::setAssociationName()
     * @param string $applicationLevel
     * @param string $applicationObjectIdentifier
     * @param string $applicationObjectName
     * @param string $associationId
     * @param string $associationName
     */
    public function __construct($applicationLevel = null, $applicationObjectIdentifier = null, $applicationObjectName = null, $associationId = null, $associationName = null)
    {
        $this
            ->setApplicationLevel($applicationLevel)
            ->setApplicationObjectIdentifier($applicationObjectIdentifier)
            ->setApplicationObjectName($applicationObjectName)
            ->setAssociationId($associationId)
            ->setAssociationName($associationName);
    }
    /**
     * Get ApplicationLevel value
     * @return string|null
     */
    public function getApplicationLevel()
    {
        return $this->ApplicationLevel;
    }
    /**
     * Set ApplicationLevel value
     * @uses \patest\EnumType\TicketConfigurationApplicationLevel::valueIsValid()
     * @uses \patest\EnumType\TicketConfigurationApplicationLevel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $applicationLevel
     * @return \patest\StructType\TicketViewComponentAssociationReference
     */
    public function setApplicationLevel($applicationLevel = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketConfigurationApplicationLevel::valueIsValid($applicationLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketConfigurationApplicationLevel', is_array($applicationLevel) ? implode(', ', $applicationLevel) : var_export($applicationLevel, true), implode(', ', \patest\EnumType\TicketConfigurationApplicationLevel::getValidValues())), __LINE__);
        }
        $this->ApplicationLevel = $applicationLevel;
        return $this;
    }
    /**
     * Get ApplicationObjectIdentifier value
     * @return string|null
     */
    public function getApplicationObjectIdentifier()
    {
        return $this->ApplicationObjectIdentifier;
    }
    /**
     * Set ApplicationObjectIdentifier value
     * @param string $applicationObjectIdentifier
     * @return \patest\StructType\TicketViewComponentAssociationReference
     */
    public function setApplicationObjectIdentifier($applicationObjectIdentifier = null)
    {
        // validation for constraint: string
        if (!is_null($applicationObjectIdentifier) && !is_string($applicationObjectIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationObjectIdentifier, true), gettype($applicationObjectIdentifier)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($applicationObjectIdentifier) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $applicationObjectIdentifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($applicationObjectIdentifier, true)), __LINE__);
        }
        $this->ApplicationObjectIdentifier = $applicationObjectIdentifier;
        return $this;
    }
    /**
     * Get ApplicationObjectName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getApplicationObjectName()
    {
        return isset($this->ApplicationObjectName) ? $this->ApplicationObjectName : null;
    }
    /**
     * Set ApplicationObjectName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $applicationObjectName
     * @return \patest\StructType\TicketViewComponentAssociationReference
     */
    public function setApplicationObjectName($applicationObjectName = null)
    {
        // validation for constraint: string
        if (!is_null($applicationObjectName) && !is_string($applicationObjectName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($applicationObjectName, true), gettype($applicationObjectName)), __LINE__);
        }
        if (is_null($applicationObjectName) || (is_array($applicationObjectName) && empty($applicationObjectName))) {
            unset($this->ApplicationObjectName);
        } else {
            $this->ApplicationObjectName = $applicationObjectName;
        }
        return $this;
    }
    /**
     * Get AssociationId value
     * @return string|null
     */
    public function getAssociationId()
    {
        return $this->AssociationId;
    }
    /**
     * Set AssociationId value
     * @param string $associationId
     * @return \patest\StructType\TicketViewComponentAssociationReference
     */
    public function setAssociationId($associationId = null)
    {
        // validation for constraint: string
        if (!is_null($associationId) && !is_string($associationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($associationId, true), gettype($associationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($associationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $associationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($associationId, true)), __LINE__);
        }
        $this->AssociationId = $associationId;
        return $this;
    }
    /**
     * Get AssociationName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAssociationName()
    {
        return isset($this->AssociationName) ? $this->AssociationName : null;
    }
    /**
     * Set AssociationName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $associationName
     * @return \patest\StructType\TicketViewComponentAssociationReference
     */
    public function setAssociationName($associationName = null)
    {
        // validation for constraint: string
        if (!is_null($associationName) && !is_string($associationName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($associationName, true), gettype($associationName)), __LINE__);
        }
        if (is_null($associationName) || (is_array($associationName) && empty($associationName))) {
            unset($this->AssociationName);
        } else {
            $this->AssociationName = $associationName;
        }
        return $this;
    }
}
