<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketSchemeToEnrollItemInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TicketSchemeToEnrollItemInfo
 * @subpackage Structs
 */
class TicketSchemeToEnrollItemInfo extends AbstractStructBase
{
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The PaymentMethodTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodTokenId;
    /**
     * The TicketSchemeId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketSchemeId;
    /**
     * The UsePaymentDetailsAlsoForAutomaticSchemes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $UsePaymentDetailsAlsoForAutomaticSchemes;
    /**
     * Constructor method for TicketSchemeToEnrollItemInfo
     * @uses TicketSchemeToEnrollItemInfo::setPaymentMethodId()
     * @uses TicketSchemeToEnrollItemInfo::setPaymentMethodTokenId()
     * @uses TicketSchemeToEnrollItemInfo::setTicketSchemeId()
     * @uses TicketSchemeToEnrollItemInfo::setUsePaymentDetailsAlsoForAutomaticSchemes()
     * @param string $paymentMethodId
     * @param string $paymentMethodTokenId
     * @param string $ticketSchemeId
     * @param bool $usePaymentDetailsAlsoForAutomaticSchemes
     */
    public function __construct($paymentMethodId = null, $paymentMethodTokenId = null, $ticketSchemeId = null, $usePaymentDetailsAlsoForAutomaticSchemes = null)
    {
        $this
            ->setPaymentMethodId($paymentMethodId)
            ->setPaymentMethodTokenId($paymentMethodTokenId)
            ->setTicketSchemeId($ticketSchemeId)
            ->setUsePaymentDetailsAlsoForAutomaticSchemes($usePaymentDetailsAlsoForAutomaticSchemes);
    }
    /**
     * Get PaymentMethodId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return isset($this->PaymentMethodId) ? $this->PaymentMethodId : null;
    }
    /**
     * Set PaymentMethodId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodId
     * @return \patest\StructType\TicketSchemeToEnrollItemInfo
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        if (is_null($paymentMethodId) || (is_array($paymentMethodId) && empty($paymentMethodId))) {
            unset($this->PaymentMethodId);
        } else {
            $this->PaymentMethodId = $paymentMethodId;
        }
        return $this;
    }
    /**
     * Get PaymentMethodTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPaymentMethodTokenId()
    {
        return isset($this->PaymentMethodTokenId) ? $this->PaymentMethodTokenId : null;
    }
    /**
     * Set PaymentMethodTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $paymentMethodTokenId
     * @return \patest\StructType\TicketSchemeToEnrollItemInfo
     */
    public function setPaymentMethodTokenId($paymentMethodTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodTokenId) && !is_string($paymentMethodTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodTokenId, true), gettype($paymentMethodTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodTokenId, true)), __LINE__);
        }
        if (is_null($paymentMethodTokenId) || (is_array($paymentMethodTokenId) && empty($paymentMethodTokenId))) {
            unset($this->PaymentMethodTokenId);
        } else {
            $this->PaymentMethodTokenId = $paymentMethodTokenId;
        }
        return $this;
    }
    /**
     * Get TicketSchemeId value
     * @return string|null
     */
    public function getTicketSchemeId()
    {
        return $this->TicketSchemeId;
    }
    /**
     * Set TicketSchemeId value
     * @param string $ticketSchemeId
     * @return \patest\StructType\TicketSchemeToEnrollItemInfo
     */
    public function setTicketSchemeId($ticketSchemeId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketSchemeId) && !is_string($ticketSchemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketSchemeId, true), gettype($ticketSchemeId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketSchemeId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketSchemeId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketSchemeId, true)), __LINE__);
        }
        $this->TicketSchemeId = $ticketSchemeId;
        return $this;
    }
    /**
     * Get UsePaymentDetailsAlsoForAutomaticSchemes value
     * @return bool|null
     */
    public function getUsePaymentDetailsAlsoForAutomaticSchemes()
    {
        return $this->UsePaymentDetailsAlsoForAutomaticSchemes;
    }
    /**
     * Set UsePaymentDetailsAlsoForAutomaticSchemes value
     * @param bool $usePaymentDetailsAlsoForAutomaticSchemes
     * @return \patest\StructType\TicketSchemeToEnrollItemInfo
     */
    public function setUsePaymentDetailsAlsoForAutomaticSchemes($usePaymentDetailsAlsoForAutomaticSchemes = null)
    {
        // validation for constraint: boolean
        if (!is_null($usePaymentDetailsAlsoForAutomaticSchemes) && !is_bool($usePaymentDetailsAlsoForAutomaticSchemes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($usePaymentDetailsAlsoForAutomaticSchemes, true), gettype($usePaymentDetailsAlsoForAutomaticSchemes)), __LINE__);
        }
        $this->UsePaymentDetailsAlsoForAutomaticSchemes = $usePaymentDetailsAlsoForAutomaticSchemes;
        return $this;
    }
}
