<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketResaleInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TicketResaleInfo
 * @subpackage Structs
 */
class TicketResaleInfo extends AbstractStructBase
{
    /**
     * The RequestedPrice
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $RequestedPrice;
    /**
     * The ResaleFee
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $ResaleFee;
    /**
     * The TicketId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketId;
    /**
     * Constructor method for TicketResaleInfo
     * @uses TicketResaleInfo::setRequestedPrice()
     * @uses TicketResaleInfo::setResaleFee()
     * @uses TicketResaleInfo::setTicketId()
     * @param \patest\StructType\Money $requestedPrice
     * @param \patest\StructType\Money $resaleFee
     * @param string $ticketId
     */
    public function __construct(\patest\StructType\Money $requestedPrice = null, \patest\StructType\Money $resaleFee = null, $ticketId = null)
    {
        $this
            ->setRequestedPrice($requestedPrice)
            ->setResaleFee($resaleFee)
            ->setTicketId($ticketId);
    }
    /**
     * Get RequestedPrice value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getRequestedPrice()
    {
        return isset($this->RequestedPrice) ? $this->RequestedPrice : null;
    }
    /**
     * Set RequestedPrice value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $requestedPrice
     * @return \patest\StructType\TicketResaleInfo
     */
    public function setRequestedPrice(\patest\StructType\Money $requestedPrice = null)
    {
        if (is_null($requestedPrice) || (is_array($requestedPrice) && empty($requestedPrice))) {
            unset($this->RequestedPrice);
        } else {
            $this->RequestedPrice = $requestedPrice;
        }
        return $this;
    }
    /**
     * Get ResaleFee value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getResaleFee()
    {
        return isset($this->ResaleFee) ? $this->ResaleFee : null;
    }
    /**
     * Set ResaleFee value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $resaleFee
     * @return \patest\StructType\TicketResaleInfo
     */
    public function setResaleFee(\patest\StructType\Money $resaleFee = null)
    {
        if (is_null($resaleFee) || (is_array($resaleFee) && empty($resaleFee))) {
            unset($this->ResaleFee);
        } else {
            $this->ResaleFee = $resaleFee;
        }
        return $this;
    }
    /**
     * Get TicketId value
     * @return string|null
     */
    public function getTicketId()
    {
        return $this->TicketId;
    }
    /**
     * Set TicketId value
     * @param string $ticketId
     * @return \patest\StructType\TicketResaleInfo
     */
    public function setTicketId($ticketId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketId) && !is_string($ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketId, true), gettype($ticketId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketId, true)), __LINE__);
        }
        $this->TicketId = $ticketId;
        return $this;
    }
}
