<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketPriceTypes StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TicketPriceTypes
 * @subpackage Structs
 */
class TicketPriceTypes extends AbstractStructBase
{
    /**
     * The PriceTypes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfguidstring
     */
    public $PriceTypes;
    /**
     * The TicketId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketId;
    /**
     * Constructor method for TicketPriceTypes
     * @uses TicketPriceTypes::setPriceTypes()
     * @uses TicketPriceTypes::setTicketId()
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidstring $priceTypes
     * @param string $ticketId
     */
    public function __construct(\patest\ArrayType\ArrayOfKeyValueOfguidstring $priceTypes = null, $ticketId = null)
    {
        $this
            ->setPriceTypes($priceTypes)
            ->setTicketId($ticketId);
    }
    /**
     * Get PriceTypes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfguidstring|null
     */
    public function getPriceTypes()
    {
        return isset($this->PriceTypes) ? $this->PriceTypes : null;
    }
    /**
     * Set PriceTypes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfguidstring $priceTypes
     * @return \patest\StructType\TicketPriceTypes
     */
    public function setPriceTypes(\patest\ArrayType\ArrayOfKeyValueOfguidstring $priceTypes = null)
    {
        if (is_null($priceTypes) || (is_array($priceTypes) && empty($priceTypes))) {
            unset($this->PriceTypes);
        } else {
            $this->PriceTypes = $priceTypes;
        }
        return $this;
    }
    /**
     * Get TicketId value
     * @return string|null
     */
    public function getTicketId()
    {
        return $this->TicketId;
    }
    /**
     * Set TicketId value
     * @param string $ticketId
     * @return \patest\StructType\TicketPriceTypes
     */
    public function setTicketId($ticketId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketId) && !is_string($ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketId, true), gettype($ticketId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketId, true)), __LINE__);
        }
        $this->TicketId = $ticketId;
        return $this;
    }
}
