<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketOwnershipChangeDetails StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TicketOwnershipChangeDetails
 * @subpackage Structs
 */
class TicketOwnershipChangeDetails extends AbstractStructBase
{
    /**
     * The NewOwner
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewOwner;
    /**
     * Constructor method for TicketOwnershipChangeDetails
     * @uses TicketOwnershipChangeDetails::setNewOwner()
     * @param string $newOwner
     */
    public function __construct($newOwner = null)
    {
        $this
            ->setNewOwner($newOwner);
    }
    /**
     * Get NewOwner value
     * @return string|null
     */
    public function getNewOwner()
    {
        return $this->NewOwner;
    }
    /**
     * Set NewOwner value
     * @param string $newOwner
     * @return \patest\StructType\TicketOwnershipChangeDetails
     */
    public function setNewOwner($newOwner = null)
    {
        // validation for constraint: string
        if (!is_null($newOwner) && !is_string($newOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newOwner, true), gettype($newOwner)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newOwner) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newOwner, true)), __LINE__);
        }
        $this->NewOwner = $newOwner;
        return $this;
    }
}
