<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketIdData StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TicketIdData
 * @subpackage Structs
 */
class TicketIdData extends SearchResultDataChunk
{
    /**
     * The TicketId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TicketId;
    /**
     * Constructor method for TicketIdData
     * @uses TicketIdData::setTicketId()
     * @param string $ticketId
     */
    public function __construct($ticketId = null)
    {
        $this
            ->setTicketId($ticketId);
    }
    /**
     * Get TicketId value
     * @return string|null
     */
    public function getTicketId()
    {
        return $this->TicketId;
    }
    /**
     * Set TicketId value
     * @param string $ticketId
     * @return \patest\StructType\TicketIdData
     */
    public function setTicketId($ticketId = null)
    {
        // validation for constraint: string
        if (!is_null($ticketId) && !is_string($ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ticketId, true), gettype($ticketId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ticketId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ticketId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ticketId, true)), __LINE__);
        }
        $this->TicketId = $ticketId;
        return $this;
    }
}
