<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for TicketDataMin StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:TicketDataMin
 * @subpackage Structs
 */
class TicketDataMin extends TicketIdData
{
    /**
     * The Active
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Active;
    /**
     * The Date
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Date;
    /**
     * The EventId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $EventId;
    /**
     * The Expiry
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Expiry;
    /**
     * The Printed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Printed;
    /**
     * The ShowName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ShowName;
    /**
     * The TicketNumber
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $TicketNumber;
    /**
     * The TransactionGuids
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $TransactionGuids;
    /**
     * Constructor method for TicketDataMin
     * @uses TicketDataMin::setActive()
     * @uses TicketDataMin::setDate()
     * @uses TicketDataMin::setEventId()
     * @uses TicketDataMin::setExpiry()
     * @uses TicketDataMin::setPrinted()
     * @uses TicketDataMin::setShowName()
     * @uses TicketDataMin::setTicketNumber()
     * @uses TicketDataMin::setTransactionGuids()
     * @param bool $active
     * @param string $date
     * @param string $eventId
     * @param string $expiry
     * @param bool $printed
     * @param string $showName
     * @param int $ticketNumber
     * @param \patest\ArrayType\ArrayOfguid $transactionGuids
     */
    public function __construct($active = null, $date = null, $eventId = null, $expiry = null, $printed = null, $showName = null, $ticketNumber = null, \patest\ArrayType\ArrayOfguid $transactionGuids = null)
    {
        $this
            ->setActive($active)
            ->setDate($date)
            ->setEventId($eventId)
            ->setExpiry($expiry)
            ->setPrinted($printed)
            ->setShowName($showName)
            ->setTicketNumber($ticketNumber)
            ->setTransactionGuids($transactionGuids);
    }
    /**
     * Get Active value
     * @return bool|null
     */
    public function getActive()
    {
        return $this->Active;
    }
    /**
     * Set Active value
     * @param bool $active
     * @return \patest\StructType\TicketDataMin
     */
    public function setActive($active = null)
    {
        // validation for constraint: boolean
        if (!is_null($active) && !is_bool($active)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($active, true), gettype($active)), __LINE__);
        }
        $this->Active = $active;
        return $this;
    }
    /**
     * Get Date value
     * @return string|null
     */
    public function getDate()
    {
        return $this->Date;
    }
    /**
     * Set Date value
     * @param string $date
     * @return \patest\StructType\TicketDataMin
     */
    public function setDate($date = null)
    {
        // validation for constraint: string
        if (!is_null($date) && !is_string($date)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($date, true), gettype($date)), __LINE__);
        }
        $this->Date = $date;
        return $this;
    }
    /**
     * Get EventId value
     * @return string|null
     */
    public function getEventId()
    {
        return $this->EventId;
    }
    /**
     * Set EventId value
     * @param string $eventId
     * @return \patest\StructType\TicketDataMin
     */
    public function setEventId($eventId = null)
    {
        // validation for constraint: string
        if (!is_null($eventId) && !is_string($eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($eventId, true), gettype($eventId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($eventId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $eventId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($eventId, true)), __LINE__);
        }
        $this->EventId = $eventId;
        return $this;
    }
    /**
     * Get Expiry value
     * @return string|null
     */
    public function getExpiry()
    {
        return $this->Expiry;
    }
    /**
     * Set Expiry value
     * @param string $expiry
     * @return \patest\StructType\TicketDataMin
     */
    public function setExpiry($expiry = null)
    {
        // validation for constraint: string
        if (!is_null($expiry) && !is_string($expiry)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiry, true), gettype($expiry)), __LINE__);
        }
        $this->Expiry = $expiry;
        return $this;
    }
    /**
     * Get Printed value
     * @return bool|null
     */
    public function getPrinted()
    {
        return $this->Printed;
    }
    /**
     * Set Printed value
     * @param bool $printed
     * @return \patest\StructType\TicketDataMin
     */
    public function setPrinted($printed = null)
    {
        // validation for constraint: boolean
        if (!is_null($printed) && !is_bool($printed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($printed, true), gettype($printed)), __LINE__);
        }
        $this->Printed = $printed;
        return $this;
    }
    /**
     * Get ShowName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getShowName()
    {
        return isset($this->ShowName) ? $this->ShowName : null;
    }
    /**
     * Set ShowName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $showName
     * @return \patest\StructType\TicketDataMin
     */
    public function setShowName($showName = null)
    {
        // validation for constraint: string
        if (!is_null($showName) && !is_string($showName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($showName, true), gettype($showName)), __LINE__);
        }
        if (is_null($showName) || (is_array($showName) && empty($showName))) {
            unset($this->ShowName);
        } else {
            $this->ShowName = $showName;
        }
        return $this;
    }
    /**
     * Get TicketNumber value
     * @return int|null
     */
    public function getTicketNumber()
    {
        return $this->TicketNumber;
    }
    /**
     * Set TicketNumber value
     * @param int $ticketNumber
     * @return \patest\StructType\TicketDataMin
     */
    public function setTicketNumber($ticketNumber = null)
    {
        // validation for constraint: int
        if (!is_null($ticketNumber) && !(is_int($ticketNumber) || ctype_digit($ticketNumber))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ticketNumber, true), gettype($ticketNumber)), __LINE__);
        }
        $this->TicketNumber = $ticketNumber;
        return $this;
    }
    /**
     * Get TransactionGuids value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getTransactionGuids()
    {
        return isset($this->TransactionGuids) ? $this->TransactionGuids : null;
    }
    /**
     * Set TransactionGuids value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $transactionGuids
     * @return \patest\StructType\TicketDataMin
     */
    public function setTransactionGuids(\patest\ArrayType\ArrayOfguid $transactionGuids = null)
    {
        if (is_null($transactionGuids) || (is_array($transactionGuids) && empty($transactionGuids))) {
            unset($this->TransactionGuids);
        } else {
            $this->TransactionGuids = $transactionGuids;
        }
        return $this;
    }
}
