<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SysInfo.CacheInfo StructType
 * @subpackage Structs
 */
class SysInfo_CacheInfo extends SysInfoObject
{
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The Expiration
     * Meta information extracted from the WSDL
     * - base: xs:duration
     * - maxInclusive: P10675199DT2H48M5.4775807S
     * - minInclusive: -P10675199DT2H48M5.4775808S
     * - minOccurs: 0
     * - nillable: true
     * - pattern: \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?
     * - type: tns:duration
     * @var string
     */
    public $Expiration;
    /**
     * The HandleCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HandleCount;
    /**
     * The HasChildren
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $HasChildren;
    /**
     * The IdleTimeout
     * Meta information extracted from the WSDL
     * - base: xs:duration
     * - maxInclusive: P10675199DT2H48M5.4775807S
     * - minInclusive: -P10675199DT2H48M5.4775808S
     * - minOccurs: 0
     * - nillable: true
     * - pattern: \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?
     * - type: tns:duration
     * @var string
     */
    public $IdleTimeout;
    /**
     * The IsEvictable
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsEvictable;
    /**
     * The ItemCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemCount;
    /**
     * The ItemCountLimit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemCountLimit;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The OwnerPath
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OwnerPath;
    /**
     * The Path
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Path;
    /**
     * The PeakItemCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PeakItemCount;
    /**
     * The PeakSizeKb
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $PeakSizeKb;
    /**
     * The SizeKb
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SizeKb;
    /**
     * The SizeLimitKb
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SizeLimitKb;
    /**
     * The Type
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Type;
    /**
     * Constructor method for SysInfo.CacheInfo
     * @uses SysInfo_CacheInfo::setDescription()
     * @uses SysInfo_CacheInfo::setExpiration()
     * @uses SysInfo_CacheInfo::setHandleCount()
     * @uses SysInfo_CacheInfo::setHasChildren()
     * @uses SysInfo_CacheInfo::setIdleTimeout()
     * @uses SysInfo_CacheInfo::setIsEvictable()
     * @uses SysInfo_CacheInfo::setItemCount()
     * @uses SysInfo_CacheInfo::setItemCountLimit()
     * @uses SysInfo_CacheInfo::setName()
     * @uses SysInfo_CacheInfo::setOwnerPath()
     * @uses SysInfo_CacheInfo::setPath()
     * @uses SysInfo_CacheInfo::setPeakItemCount()
     * @uses SysInfo_CacheInfo::setPeakSizeKb()
     * @uses SysInfo_CacheInfo::setSizeKb()
     * @uses SysInfo_CacheInfo::setSizeLimitKb()
     * @uses SysInfo_CacheInfo::setType()
     * @param string $description
     * @param string $expiration
     * @param int $handleCount
     * @param bool $hasChildren
     * @param string $idleTimeout
     * @param bool $isEvictable
     * @param int $itemCount
     * @param int $itemCountLimit
     * @param string $name
     * @param string $ownerPath
     * @param string $path
     * @param int $peakItemCount
     * @param int $peakSizeKb
     * @param int $sizeKb
     * @param int $sizeLimitKb
     * @param string $type
     */
    public function __construct($description = null, $expiration = null, $handleCount = null, $hasChildren = null, $idleTimeout = null, $isEvictable = null, $itemCount = null, $itemCountLimit = null, $name = null, $ownerPath = null, $path = null, $peakItemCount = null, $peakSizeKb = null, $sizeKb = null, $sizeLimitKb = null, $type = null)
    {
        $this
            ->setDescription($description)
            ->setExpiration($expiration)
            ->setHandleCount($handleCount)
            ->setHasChildren($hasChildren)
            ->setIdleTimeout($idleTimeout)
            ->setIsEvictable($isEvictable)
            ->setItemCount($itemCount)
            ->setItemCountLimit($itemCountLimit)
            ->setName($name)
            ->setOwnerPath($ownerPath)
            ->setPath($path)
            ->setPeakItemCount($peakItemCount)
            ->setPeakSizeKb($peakSizeKb)
            ->setSizeKb($sizeKb)
            ->setSizeLimitKb($sizeLimitKb)
            ->setType($type);
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \patest\StructType\SysInfo_CacheInfo
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get Expiration value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpiration()
    {
        return isset($this->Expiration) ? $this->Expiration : null;
    }
    /**
     * Set Expiration value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expiration
     * @return \patest\StructType\SysInfo_CacheInfo
     */
    public function setExpiration($expiration = null)
    {
        // validation for constraint: string
        if (!is_null($expiration) && !is_string($expiration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expiration, true), gettype($expiration)), __LINE__);
        }
        // validation for constraint: maxInclusive(P10675199DT2H48M5.4775807S)
        if (!is_null($expiration) && false === mb_strpos($expiration, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $expiration)))) > \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775807S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically less than or equal to P10675199DT2H48M5.4775807S', var_export($expiration, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-P10675199DT2H48M5.4775808S)
        if (!is_null($expiration) && false !== mb_strpos($expiration, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $expiration)))) < \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775808S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically greater than or equal to -P10675199DT2H48M5.4775808S', var_export($expiration, true)), __LINE__);
        }
        // validation for constraint: pattern(\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?)
        if (!is_null($expiration) && !preg_match('/\\-?P(\\d*D)?(T(\\d*H)?(\\d*M)?(\\d*(\\.\\d*)?S)?)?/', $expiration)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?', var_export($expiration, true)), __LINE__);
        }
        if (is_null($expiration) || (is_array($expiration) && empty($expiration))) {
            unset($this->Expiration);
        } else {
            $this->Expiration = $expiration;
        }
        return $this;
    }
    /**
     * Get HandleCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHandleCount()
    {
        return isset($this->HandleCount) ? $this->HandleCount : null;
    }
    /**
     * Set HandleCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $handleCount
     * @return \patest\StructType\SysInfo_CacheInfo
     */
    public function setHandleCount($handleCount = null)
    {
        // validation for constraint: int
        if (!is_null($handleCount) && !(is_int($handleCount) || ctype_digit($handleCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($handleCount, true), gettype($handleCount)), __LINE__);
        }
        if (is_null($handleCount) || (is_array($handleCount) && empty($handleCount))) {
            unset($this->HandleCount);
        } else {
            $this->HandleCount = $handleCount;
        }
        return $this;
    }
    /**
     * Get HasChildren value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getHasChildren()
    {
        return isset($this->HasChildren) ? $this->HasChildren : null;
    }
    /**
     * Set HasChildren value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $hasChildren
     * @return \patest\StructType\SysInfo_CacheInfo
     */
    public function setHasChildren($hasChildren = null)
    {
        // validation for constraint: boolean
        if (!is_null($hasChildren) && !is_bool($hasChildren)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($hasChildren, true), gettype($hasChildren)), __LINE__);
        }
        if (is_null($hasChildren) || (is_array($hasChildren) && empty($hasChildren))) {
            unset($this->HasChildren);
        } else {
            $this->HasChildren = $hasChildren;
        }
        return $this;
    }
    /**
     * Get IdleTimeout value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdleTimeout()
    {
        return isset($this->IdleTimeout) ? $this->IdleTimeout : null;
    }
    /**
     * Set IdleTimeout value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idleTimeout
     * @return \patest\StructType\SysInfo_CacheInfo
     */
    public function setIdleTimeout($idleTimeout = null)
    {
        // validation for constraint: string
        if (!is_null($idleTimeout) && !is_string($idleTimeout)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($idleTimeout, true), gettype($idleTimeout)), __LINE__);
        }
        // validation for constraint: maxInclusive(P10675199DT2H48M5.4775807S)
        if (!is_null($idleTimeout) && false === mb_strpos($idleTimeout, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $idleTimeout)))) > \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775807S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically less than or equal to P10675199DT2H48M5.4775807S', var_export($idleTimeout, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-P10675199DT2H48M5.4775808S)
        if (!is_null($idleTimeout) && false !== mb_strpos($idleTimeout, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $idleTimeout)))) < \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775808S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically greater than or equal to -P10675199DT2H48M5.4775808S', var_export($idleTimeout, true)), __LINE__);
        }
        // validation for constraint: pattern(\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?)
        if (!is_null($idleTimeout) && !preg_match('/\\-?P(\\d*D)?(T(\\d*H)?(\\d*M)?(\\d*(\\.\\d*)?S)?)?/', $idleTimeout)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?', var_export($idleTimeout, true)), __LINE__);
        }
        if (is_null($idleTimeout) || (is_array($idleTimeout) && empty($idleTimeout))) {
            unset($this->IdleTimeout);
        } else {
            $this->IdleTimeout = $idleTimeout;
        }
        return $this;
    }
    /**
     * Get IsEvictable value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsEvictable()
    {
        return isset($this->IsEvictable) ? $this->IsEvictable : null;
    }
    /**
     * Set IsEvictable value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isEvictable
     * @return \patest\StructType\SysInfo_CacheInfo
     */
    public function setIsEvictable($isEvictable = null)
    {
        // validation for constraint: boolean
        if (!is_null($isEvictable) && !is_bool($isEvictable)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isEvictable, true), gettype($isEvictable)), __LINE__);
        }
        if (is_null($isEvictable) || (is_array($isEvictable) && empty($isEvictable))) {
            unset($this->IsEvictable);
        } else {
            $this->IsEvictable = $isEvictable;
        }
        return $this;
    }
    /**
     * Get ItemCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemCount()
    {
        return isset($this->ItemCount) ? $this->ItemCount : null;
    }
    /**
     * Set ItemCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemCount
     * @return \patest\StructType\SysInfo_CacheInfo
     */
    public function setItemCount($itemCount = null)
    {
        // validation for constraint: int
        if (!is_null($itemCount) && !(is_int($itemCount) || ctype_digit($itemCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemCount, true), gettype($itemCount)), __LINE__);
        }
        if (is_null($itemCount) || (is_array($itemCount) && empty($itemCount))) {
            unset($this->ItemCount);
        } else {
            $this->ItemCount = $itemCount;
        }
        return $this;
    }
    /**
     * Get ItemCountLimit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemCountLimit()
    {
        return isset($this->ItemCountLimit) ? $this->ItemCountLimit : null;
    }
    /**
     * Set ItemCountLimit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemCountLimit
     * @return \patest\StructType\SysInfo_CacheInfo
     */
    public function setItemCountLimit($itemCountLimit = null)
    {
        // validation for constraint: int
        if (!is_null($itemCountLimit) && !(is_int($itemCountLimit) || ctype_digit($itemCountLimit))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemCountLimit, true), gettype($itemCountLimit)), __LINE__);
        }
        if (is_null($itemCountLimit) || (is_array($itemCountLimit) && empty($itemCountLimit))) {
            unset($this->ItemCountLimit);
        } else {
            $this->ItemCountLimit = $itemCountLimit;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\SysInfo_CacheInfo
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OwnerPath value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerPath()
    {
        return isset($this->OwnerPath) ? $this->OwnerPath : null;
    }
    /**
     * Set OwnerPath value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerPath
     * @return \patest\StructType\SysInfo_CacheInfo
     */
    public function setOwnerPath($ownerPath = null)
    {
        // validation for constraint: string
        if (!is_null($ownerPath) && !is_string($ownerPath)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerPath, true), gettype($ownerPath)), __LINE__);
        }
        if (is_null($ownerPath) || (is_array($ownerPath) && empty($ownerPath))) {
            unset($this->OwnerPath);
        } else {
            $this->OwnerPath = $ownerPath;
        }
        return $this;
    }
    /**
     * Get Path value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPath()
    {
        return isset($this->Path) ? $this->Path : null;
    }
    /**
     * Set Path value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $path
     * @return \patest\StructType\SysInfo_CacheInfo
     */
    public function setPath($path = null)
    {
        // validation for constraint: string
        if (!is_null($path) && !is_string($path)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($path, true), gettype($path)), __LINE__);
        }
        if (is_null($path) || (is_array($path) && empty($path))) {
            unset($this->Path);
        } else {
            $this->Path = $path;
        }
        return $this;
    }
    /**
     * Get PeakItemCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPeakItemCount()
    {
        return isset($this->PeakItemCount) ? $this->PeakItemCount : null;
    }
    /**
     * Set PeakItemCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $peakItemCount
     * @return \patest\StructType\SysInfo_CacheInfo
     */
    public function setPeakItemCount($peakItemCount = null)
    {
        // validation for constraint: int
        if (!is_null($peakItemCount) && !(is_int($peakItemCount) || ctype_digit($peakItemCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($peakItemCount, true), gettype($peakItemCount)), __LINE__);
        }
        if (is_null($peakItemCount) || (is_array($peakItemCount) && empty($peakItemCount))) {
            unset($this->PeakItemCount);
        } else {
            $this->PeakItemCount = $peakItemCount;
        }
        return $this;
    }
    /**
     * Get PeakSizeKb value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getPeakSizeKb()
    {
        return isset($this->PeakSizeKb) ? $this->PeakSizeKb : null;
    }
    /**
     * Set PeakSizeKb value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $peakSizeKb
     * @return \patest\StructType\SysInfo_CacheInfo
     */
    public function setPeakSizeKb($peakSizeKb = null)
    {
        // validation for constraint: int
        if (!is_null($peakSizeKb) && !(is_int($peakSizeKb) || ctype_digit($peakSizeKb))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($peakSizeKb, true), gettype($peakSizeKb)), __LINE__);
        }
        if (is_null($peakSizeKb) || (is_array($peakSizeKb) && empty($peakSizeKb))) {
            unset($this->PeakSizeKb);
        } else {
            $this->PeakSizeKb = $peakSizeKb;
        }
        return $this;
    }
    /**
     * Get SizeKb value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSizeKb()
    {
        return isset($this->SizeKb) ? $this->SizeKb : null;
    }
    /**
     * Set SizeKb value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $sizeKb
     * @return \patest\StructType\SysInfo_CacheInfo
     */
    public function setSizeKb($sizeKb = null)
    {
        // validation for constraint: int
        if (!is_null($sizeKb) && !(is_int($sizeKb) || ctype_digit($sizeKb))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sizeKb, true), gettype($sizeKb)), __LINE__);
        }
        if (is_null($sizeKb) || (is_array($sizeKb) && empty($sizeKb))) {
            unset($this->SizeKb);
        } else {
            $this->SizeKb = $sizeKb;
        }
        return $this;
    }
    /**
     * Get SizeLimitKb value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSizeLimitKb()
    {
        return isset($this->SizeLimitKb) ? $this->SizeLimitKb : null;
    }
    /**
     * Set SizeLimitKb value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $sizeLimitKb
     * @return \patest\StructType\SysInfo_CacheInfo
     */
    public function setSizeLimitKb($sizeLimitKb = null)
    {
        // validation for constraint: int
        if (!is_null($sizeLimitKb) && !(is_int($sizeLimitKb) || ctype_digit($sizeLimitKb))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($sizeLimitKb, true), gettype($sizeLimitKb)), __LINE__);
        }
        if (is_null($sizeLimitKb) || (is_array($sizeLimitKb) && empty($sizeLimitKb))) {
            unset($this->SizeLimitKb);
        } else {
            $this->SizeLimitKb = $sizeLimitKb;
        }
        return $this;
    }
    /**
     * Get Type value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getType()
    {
        return isset($this->Type) ? $this->Type : null;
    }
    /**
     * Set Type value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $type
     * @return \patest\StructType\SysInfo_CacheInfo
     */
    public function setType($type = null)
    {
        // validation for constraint: string
        if (!is_null($type) && !is_string($type)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($type, true), gettype($type)), __LINE__);
        }
        if (is_null($type) || (is_array($type) && empty($type))) {
            unset($this->Type);
        } else {
            $this->Type = $type;
        }
        return $this;
    }
}
