<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SyncEntitiesFromExternalSourceRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SyncEntitiesFromExternalSourceRequest
 * @subpackage Structs
 */
class SyncEntitiesFromExternalSourceRequest extends AbstractStructBase
{
    /**
     * The Entities
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfAnyEntity
     */
    public $Entities;
    /**
     * The EntityName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntityName;
    /**
     * The IsInitialSync
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsInitialSync;
    /**
     * The SimulationMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SimulationMode;
    /**
     * Constructor method for SyncEntitiesFromExternalSourceRequest
     * @uses SyncEntitiesFromExternalSourceRequest::setEntities()
     * @uses SyncEntitiesFromExternalSourceRequest::setEntityName()
     * @uses SyncEntitiesFromExternalSourceRequest::setIsInitialSync()
     * @uses SyncEntitiesFromExternalSourceRequest::setSimulationMode()
     * @param \patest\ArrayType\ArrayOfAnyEntity $entities
     * @param string $entityName
     * @param bool $isInitialSync
     * @param bool $simulationMode
     */
    public function __construct(\patest\ArrayType\ArrayOfAnyEntity $entities = null, $entityName = null, $isInitialSync = null, $simulationMode = null)
    {
        $this
            ->setEntities($entities)
            ->setEntityName($entityName)
            ->setIsInitialSync($isInitialSync)
            ->setSimulationMode($simulationMode);
    }
    /**
     * Get Entities value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfAnyEntity|null
     */
    public function getEntities()
    {
        return isset($this->Entities) ? $this->Entities : null;
    }
    /**
     * Set Entities value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfAnyEntity $entities
     * @return \patest\StructType\SyncEntitiesFromExternalSourceRequest
     */
    public function setEntities(\patest\ArrayType\ArrayOfAnyEntity $entities = null)
    {
        if (is_null($entities) || (is_array($entities) && empty($entities))) {
            unset($this->Entities);
        } else {
            $this->Entities = $entities;
        }
        return $this;
    }
    /**
     * Get EntityName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntityName()
    {
        return isset($this->EntityName) ? $this->EntityName : null;
    }
    /**
     * Set EntityName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entityName
     * @return \patest\StructType\SyncEntitiesFromExternalSourceRequest
     */
    public function setEntityName($entityName = null)
    {
        // validation for constraint: string
        if (!is_null($entityName) && !is_string($entityName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($entityName, true), gettype($entityName)), __LINE__);
        }
        if (is_null($entityName) || (is_array($entityName) && empty($entityName))) {
            unset($this->EntityName);
        } else {
            $this->EntityName = $entityName;
        }
        return $this;
    }
    /**
     * Get IsInitialSync value
     * @return bool|null
     */
    public function getIsInitialSync()
    {
        return $this->IsInitialSync;
    }
    /**
     * Set IsInitialSync value
     * @param bool $isInitialSync
     * @return \patest\StructType\SyncEntitiesFromExternalSourceRequest
     */
    public function setIsInitialSync($isInitialSync = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInitialSync) && !is_bool($isInitialSync)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInitialSync, true), gettype($isInitialSync)), __LINE__);
        }
        $this->IsInitialSync = $isInitialSync;
        return $this;
    }
    /**
     * Get SimulationMode value
     * @return bool|null
     */
    public function getSimulationMode()
    {
        return $this->SimulationMode;
    }
    /**
     * Set SimulationMode value
     * @param bool $simulationMode
     * @return \patest\StructType\SyncEntitiesFromExternalSourceRequest
     */
    public function setSimulationMode($simulationMode = null)
    {
        // validation for constraint: boolean
        if (!is_null($simulationMode) && !is_bool($simulationMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($simulationMode, true), gettype($simulationMode)), __LINE__);
        }
        $this->SimulationMode = $simulationMode;
        return $this;
    }
}
