<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubsidyPriceModifier StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SubsidyPriceModifier
 * @subpackage Structs
 */
class SubsidyPriceModifier extends AbstractPriceModifier
{
    /**
     * The OrganizationId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationId;
    /**
     * Constructor method for SubsidyPriceModifier
     * @uses SubsidyPriceModifier::setOrganizationId()
     * @param string $organizationId
     */
    public function __construct($organizationId = null)
    {
        $this
            ->setOrganizationId($organizationId);
    }
    /**
     * Get OrganizationId value
     * @return string|null
     */
    public function getOrganizationId()
    {
        return $this->OrganizationId;
    }
    /**
     * Set OrganizationId value
     * @param string $organizationId
     * @return \patest\StructType\SubsidyPriceModifier
     */
    public function setOrganizationId($organizationId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationId) && !is_string($organizationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationId, true), gettype($organizationId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationId, true)), __LINE__);
        }
        $this->OrganizationId = $organizationId;
        return $this;
    }
}
