<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Subscription.InitiateRenewProcessItem StructType
 * @subpackage Structs
 */
class Subscription_InitiateRenewProcessItem extends AnyEntity
{
    /**
     * The ClientName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ClientName;
    /**
     * The CurrentPriceTypeName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrentPriceTypeName;
    /**
     * The CurrentSeasonId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $CurrentSeasonId;
    /**
     * The CurrentSeatLocationDescription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrentSeatLocationDescription;
    /**
     * The CurrentSeriesName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CurrentSeriesName;
    /**
     * The NewAreaId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewAreaId;
    /**
     * The NewSeatId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NewSeatId;
    /**
     * The NewSeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $NewSeriesId;
    /**
     * The OwnerClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OwnerClientId;
    /**
     * The OwnerClientRelationToMe
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OwnerClientRelationToMe;
    /**
     * The PurchaserClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PurchaserClientId;
    /**
     * The PurchaserClientRelationToMe
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PurchaserClientRelationToMe;
    /**
     * The SubscriptionInstanceId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SubscriptionInstanceId;
    /**
     * The TargetRenewStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TargetRenewStatus;
    /**
     * Constructor method for Subscription.InitiateRenewProcessItem
     * @uses Subscription_InitiateRenewProcessItem::setClientName()
     * @uses Subscription_InitiateRenewProcessItem::setCurrentPriceTypeName()
     * @uses Subscription_InitiateRenewProcessItem::setCurrentSeasonId()
     * @uses Subscription_InitiateRenewProcessItem::setCurrentSeatLocationDescription()
     * @uses Subscription_InitiateRenewProcessItem::setCurrentSeriesName()
     * @uses Subscription_InitiateRenewProcessItem::setNewAreaId()
     * @uses Subscription_InitiateRenewProcessItem::setNewSeatId()
     * @uses Subscription_InitiateRenewProcessItem::setNewSeriesId()
     * @uses Subscription_InitiateRenewProcessItem::setOwnerClientId()
     * @uses Subscription_InitiateRenewProcessItem::setOwnerClientRelationToMe()
     * @uses Subscription_InitiateRenewProcessItem::setPurchaserClientId()
     * @uses Subscription_InitiateRenewProcessItem::setPurchaserClientRelationToMe()
     * @uses Subscription_InitiateRenewProcessItem::setSubscriptionInstanceId()
     * @uses Subscription_InitiateRenewProcessItem::setTargetRenewStatus()
     * @param string $clientName
     * @param string $currentPriceTypeName
     * @param string $currentSeasonId
     * @param string $currentSeatLocationDescription
     * @param string $currentSeriesName
     * @param string $newAreaId
     * @param int $newSeatId
     * @param string $newSeriesId
     * @param string $ownerClientId
     * @param string $ownerClientRelationToMe
     * @param string $purchaserClientId
     * @param string $purchaserClientRelationToMe
     * @param string $subscriptionInstanceId
     * @param string $targetRenewStatus
     */
    public function __construct($clientName = null, $currentPriceTypeName = null, $currentSeasonId = null, $currentSeatLocationDescription = null, $currentSeriesName = null, $newAreaId = null, $newSeatId = null, $newSeriesId = null, $ownerClientId = null, $ownerClientRelationToMe = null, $purchaserClientId = null, $purchaserClientRelationToMe = null, $subscriptionInstanceId = null, $targetRenewStatus = null)
    {
        $this
            ->setClientName($clientName)
            ->setCurrentPriceTypeName($currentPriceTypeName)
            ->setCurrentSeasonId($currentSeasonId)
            ->setCurrentSeatLocationDescription($currentSeatLocationDescription)
            ->setCurrentSeriesName($currentSeriesName)
            ->setNewAreaId($newAreaId)
            ->setNewSeatId($newSeatId)
            ->setNewSeriesId($newSeriesId)
            ->setOwnerClientId($ownerClientId)
            ->setOwnerClientRelationToMe($ownerClientRelationToMe)
            ->setPurchaserClientId($purchaserClientId)
            ->setPurchaserClientRelationToMe($purchaserClientRelationToMe)
            ->setSubscriptionInstanceId($subscriptionInstanceId)
            ->setTargetRenewStatus($targetRenewStatus);
    }
    /**
     * Get ClientName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClientName()
    {
        return isset($this->ClientName) ? $this->ClientName : null;
    }
    /**
     * Set ClientName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $clientName
     * @return \patest\StructType\Subscription_InitiateRenewProcessItem
     */
    public function setClientName($clientName = null)
    {
        // validation for constraint: string
        if (!is_null($clientName) && !is_string($clientName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientName, true), gettype($clientName)), __LINE__);
        }
        if (is_null($clientName) || (is_array($clientName) && empty($clientName))) {
            unset($this->ClientName);
        } else {
            $this->ClientName = $clientName;
        }
        return $this;
    }
    /**
     * Get CurrentPriceTypeName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentPriceTypeName()
    {
        return isset($this->CurrentPriceTypeName) ? $this->CurrentPriceTypeName : null;
    }
    /**
     * Set CurrentPriceTypeName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentPriceTypeName
     * @return \patest\StructType\Subscription_InitiateRenewProcessItem
     */
    public function setCurrentPriceTypeName($currentPriceTypeName = null)
    {
        // validation for constraint: string
        if (!is_null($currentPriceTypeName) && !is_string($currentPriceTypeName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentPriceTypeName, true), gettype($currentPriceTypeName)), __LINE__);
        }
        if (is_null($currentPriceTypeName) || (is_array($currentPriceTypeName) && empty($currentPriceTypeName))) {
            unset($this->CurrentPriceTypeName);
        } else {
            $this->CurrentPriceTypeName = $currentPriceTypeName;
        }
        return $this;
    }
    /**
     * Get CurrentSeasonId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentSeasonId()
    {
        return isset($this->CurrentSeasonId) ? $this->CurrentSeasonId : null;
    }
    /**
     * Set CurrentSeasonId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentSeasonId
     * @return \patest\StructType\Subscription_InitiateRenewProcessItem
     */
    public function setCurrentSeasonId($currentSeasonId = null)
    {
        // validation for constraint: string
        if (!is_null($currentSeasonId) && !is_string($currentSeasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentSeasonId, true), gettype($currentSeasonId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($currentSeasonId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $currentSeasonId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($currentSeasonId, true)), __LINE__);
        }
        if (is_null($currentSeasonId) || (is_array($currentSeasonId) && empty($currentSeasonId))) {
            unset($this->CurrentSeasonId);
        } else {
            $this->CurrentSeasonId = $currentSeasonId;
        }
        return $this;
    }
    /**
     * Get CurrentSeatLocationDescription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentSeatLocationDescription()
    {
        return isset($this->CurrentSeatLocationDescription) ? $this->CurrentSeatLocationDescription : null;
    }
    /**
     * Set CurrentSeatLocationDescription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentSeatLocationDescription
     * @return \patest\StructType\Subscription_InitiateRenewProcessItem
     */
    public function setCurrentSeatLocationDescription($currentSeatLocationDescription = null)
    {
        // validation for constraint: string
        if (!is_null($currentSeatLocationDescription) && !is_string($currentSeatLocationDescription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentSeatLocationDescription, true), gettype($currentSeatLocationDescription)), __LINE__);
        }
        if (is_null($currentSeatLocationDescription) || (is_array($currentSeatLocationDescription) && empty($currentSeatLocationDescription))) {
            unset($this->CurrentSeatLocationDescription);
        } else {
            $this->CurrentSeatLocationDescription = $currentSeatLocationDescription;
        }
        return $this;
    }
    /**
     * Get CurrentSeriesName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCurrentSeriesName()
    {
        return isset($this->CurrentSeriesName) ? $this->CurrentSeriesName : null;
    }
    /**
     * Set CurrentSeriesName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $currentSeriesName
     * @return \patest\StructType\Subscription_InitiateRenewProcessItem
     */
    public function setCurrentSeriesName($currentSeriesName = null)
    {
        // validation for constraint: string
        if (!is_null($currentSeriesName) && !is_string($currentSeriesName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($currentSeriesName, true), gettype($currentSeriesName)), __LINE__);
        }
        if (is_null($currentSeriesName) || (is_array($currentSeriesName) && empty($currentSeriesName))) {
            unset($this->CurrentSeriesName);
        } else {
            $this->CurrentSeriesName = $currentSeriesName;
        }
        return $this;
    }
    /**
     * Get NewAreaId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewAreaId()
    {
        return isset($this->NewAreaId) ? $this->NewAreaId : null;
    }
    /**
     * Set NewAreaId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newAreaId
     * @return \patest\StructType\Subscription_InitiateRenewProcessItem
     */
    public function setNewAreaId($newAreaId = null)
    {
        // validation for constraint: string
        if (!is_null($newAreaId) && !is_string($newAreaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newAreaId, true), gettype($newAreaId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newAreaId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newAreaId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newAreaId, true)), __LINE__);
        }
        if (is_null($newAreaId) || (is_array($newAreaId) && empty($newAreaId))) {
            unset($this->NewAreaId);
        } else {
            $this->NewAreaId = $newAreaId;
        }
        return $this;
    }
    /**
     * Get NewSeatId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNewSeatId()
    {
        return isset($this->NewSeatId) ? $this->NewSeatId : null;
    }
    /**
     * Set NewSeatId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $newSeatId
     * @return \patest\StructType\Subscription_InitiateRenewProcessItem
     */
    public function setNewSeatId($newSeatId = null)
    {
        // validation for constraint: int
        if (!is_null($newSeatId) && !(is_int($newSeatId) || ctype_digit($newSeatId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($newSeatId, true), gettype($newSeatId)), __LINE__);
        }
        if (is_null($newSeatId) || (is_array($newSeatId) && empty($newSeatId))) {
            unset($this->NewSeatId);
        } else {
            $this->NewSeatId = $newSeatId;
        }
        return $this;
    }
    /**
     * Get NewSeriesId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewSeriesId()
    {
        return isset($this->NewSeriesId) ? $this->NewSeriesId : null;
    }
    /**
     * Set NewSeriesId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newSeriesId
     * @return \patest\StructType\Subscription_InitiateRenewProcessItem
     */
    public function setNewSeriesId($newSeriesId = null)
    {
        // validation for constraint: string
        if (!is_null($newSeriesId) && !is_string($newSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newSeriesId, true), gettype($newSeriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($newSeriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $newSeriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($newSeriesId, true)), __LINE__);
        }
        if (is_null($newSeriesId) || (is_array($newSeriesId) && empty($newSeriesId))) {
            unset($this->NewSeriesId);
        } else {
            $this->NewSeriesId = $newSeriesId;
        }
        return $this;
    }
    /**
     * Get OwnerClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerClientId()
    {
        return isset($this->OwnerClientId) ? $this->OwnerClientId : null;
    }
    /**
     * Set OwnerClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $ownerClientId
     * @return \patest\StructType\Subscription_InitiateRenewProcessItem
     */
    public function setOwnerClientId($ownerClientId = null)
    {
        // validation for constraint: string
        if (!is_null($ownerClientId) && !is_string($ownerClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($ownerClientId, true), gettype($ownerClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($ownerClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $ownerClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($ownerClientId, true)), __LINE__);
        }
        if (is_null($ownerClientId) || (is_array($ownerClientId) && empty($ownerClientId))) {
            unset($this->OwnerClientId);
        } else {
            $this->OwnerClientId = $ownerClientId;
        }
        return $this;
    }
    /**
     * Get OwnerClientRelationToMe value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOwnerClientRelationToMe()
    {
        return isset($this->OwnerClientRelationToMe) ? $this->OwnerClientRelationToMe : null;
    }
    /**
     * Set OwnerClientRelationToMe value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SubscriptionRenewClientRelationKind::valueIsValid()
     * @uses \patest\EnumType\SubscriptionRenewClientRelationKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ownerClientRelationToMe
     * @return \patest\StructType\Subscription_InitiateRenewProcessItem
     */
    public function setOwnerClientRelationToMe($ownerClientRelationToMe = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SubscriptionRenewClientRelationKind::valueIsValid($ownerClientRelationToMe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SubscriptionRenewClientRelationKind', is_array($ownerClientRelationToMe) ? implode(', ', $ownerClientRelationToMe) : var_export($ownerClientRelationToMe, true), implode(', ', \patest\EnumType\SubscriptionRenewClientRelationKind::getValidValues())), __LINE__);
        }
        if (is_null($ownerClientRelationToMe) || (is_array($ownerClientRelationToMe) && empty($ownerClientRelationToMe))) {
            unset($this->OwnerClientRelationToMe);
        } else {
            $this->OwnerClientRelationToMe = $ownerClientRelationToMe;
        }
        return $this;
    }
    /**
     * Get PurchaserClientId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPurchaserClientId()
    {
        return isset($this->PurchaserClientId) ? $this->PurchaserClientId : null;
    }
    /**
     * Set PurchaserClientId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $purchaserClientId
     * @return \patest\StructType\Subscription_InitiateRenewProcessItem
     */
    public function setPurchaserClientId($purchaserClientId = null)
    {
        // validation for constraint: string
        if (!is_null($purchaserClientId) && !is_string($purchaserClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($purchaserClientId, true), gettype($purchaserClientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($purchaserClientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $purchaserClientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($purchaserClientId, true)), __LINE__);
        }
        if (is_null($purchaserClientId) || (is_array($purchaserClientId) && empty($purchaserClientId))) {
            unset($this->PurchaserClientId);
        } else {
            $this->PurchaserClientId = $purchaserClientId;
        }
        return $this;
    }
    /**
     * Get PurchaserClientRelationToMe value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPurchaserClientRelationToMe()
    {
        return isset($this->PurchaserClientRelationToMe) ? $this->PurchaserClientRelationToMe : null;
    }
    /**
     * Set PurchaserClientRelationToMe value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SubscriptionRenewClientRelationKind::valueIsValid()
     * @uses \patest\EnumType\SubscriptionRenewClientRelationKind::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $purchaserClientRelationToMe
     * @return \patest\StructType\Subscription_InitiateRenewProcessItem
     */
    public function setPurchaserClientRelationToMe($purchaserClientRelationToMe = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SubscriptionRenewClientRelationKind::valueIsValid($purchaserClientRelationToMe)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SubscriptionRenewClientRelationKind', is_array($purchaserClientRelationToMe) ? implode(', ', $purchaserClientRelationToMe) : var_export($purchaserClientRelationToMe, true), implode(', ', \patest\EnumType\SubscriptionRenewClientRelationKind::getValidValues())), __LINE__);
        }
        if (is_null($purchaserClientRelationToMe) || (is_array($purchaserClientRelationToMe) && empty($purchaserClientRelationToMe))) {
            unset($this->PurchaserClientRelationToMe);
        } else {
            $this->PurchaserClientRelationToMe = $purchaserClientRelationToMe;
        }
        return $this;
    }
    /**
     * Get SubscriptionInstanceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSubscriptionInstanceId()
    {
        return isset($this->SubscriptionInstanceId) ? $this->SubscriptionInstanceId : null;
    }
    /**
     * Set SubscriptionInstanceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $subscriptionInstanceId
     * @return \patest\StructType\Subscription_InitiateRenewProcessItem
     */
    public function setSubscriptionInstanceId($subscriptionInstanceId = null)
    {
        // validation for constraint: string
        if (!is_null($subscriptionInstanceId) && !is_string($subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($subscriptionInstanceId, true), gettype($subscriptionInstanceId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($subscriptionInstanceId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $subscriptionInstanceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($subscriptionInstanceId, true)), __LINE__);
        }
        if (is_null($subscriptionInstanceId) || (is_array($subscriptionInstanceId) && empty($subscriptionInstanceId))) {
            unset($this->SubscriptionInstanceId);
        } else {
            $this->SubscriptionInstanceId = $subscriptionInstanceId;
        }
        return $this;
    }
    /**
     * Get TargetRenewStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetRenewStatus()
    {
        return isset($this->TargetRenewStatus) ? $this->TargetRenewStatus : null;
    }
    /**
     * Set TargetRenewStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SubscriptionRenewStatus::valueIsValid()
     * @uses \patest\EnumType\SubscriptionRenewStatus::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $targetRenewStatus
     * @return \patest\StructType\Subscription_InitiateRenewProcessItem
     */
    public function setTargetRenewStatus($targetRenewStatus = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SubscriptionRenewStatus::valueIsValid($targetRenewStatus)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SubscriptionRenewStatus', is_array($targetRenewStatus) ? implode(', ', $targetRenewStatus) : var_export($targetRenewStatus, true), implode(', ', \patest\EnumType\SubscriptionRenewStatus::getValidValues())), __LINE__);
        }
        if (is_null($targetRenewStatus) || (is_array($targetRenewStatus) && empty($targetRenewStatus))) {
            unset($this->TargetRenewStatus);
        } else {
            $this->TargetRenewStatus = $targetRenewStatus;
        }
        return $this;
    }
}
