<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubscriptionPeriodDateRange StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SubscriptionPeriodDateRange
 * @subpackage Structs
 */
class SubscriptionPeriodDateRange extends AbstractStructBase
{
    /**
     * The Identifier
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Identifier;
    /**
     * The Period
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\DateRange
     */
    public $Period;
    /**
     * The SeriesId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SeriesId;
    /**
     * Constructor method for SubscriptionPeriodDateRange
     * @uses SubscriptionPeriodDateRange::setIdentifier()
     * @uses SubscriptionPeriodDateRange::setPeriod()
     * @uses SubscriptionPeriodDateRange::setSeriesId()
     * @param string $identifier
     * @param \patest\StructType\DateRange $period
     * @param string $seriesId
     */
    public function __construct($identifier = null, \patest\StructType\DateRange $period = null, $seriesId = null)
    {
        $this
            ->setIdentifier($identifier)
            ->setPeriod($period)
            ->setSeriesId($seriesId);
    }
    /**
     * Get Identifier value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdentifier()
    {
        return isset($this->Identifier) ? $this->Identifier : null;
    }
    /**
     * Set Identifier value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $identifier
     * @return \patest\StructType\SubscriptionPeriodDateRange
     */
    public function setIdentifier($identifier = null)
    {
        // validation for constraint: string
        if (!is_null($identifier) && !is_string($identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($identifier, true), gettype($identifier)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($identifier) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $identifier)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($identifier, true)), __LINE__);
        }
        if (is_null($identifier) || (is_array($identifier) && empty($identifier))) {
            unset($this->Identifier);
        } else {
            $this->Identifier = $identifier;
        }
        return $this;
    }
    /**
     * Get Period value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\DateRange|null
     */
    public function getPeriod()
    {
        return isset($this->Period) ? $this->Period : null;
    }
    /**
     * Set Period value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\DateRange $period
     * @return \patest\StructType\SubscriptionPeriodDateRange
     */
    public function setPeriod(\patest\StructType\DateRange $period = null)
    {
        if (is_null($period) || (is_array($period) && empty($period))) {
            unset($this->Period);
        } else {
            $this->Period = $period;
        }
        return $this;
    }
    /**
     * Get SeriesId value
     * @return string|null
     */
    public function getSeriesId()
    {
        return $this->SeriesId;
    }
    /**
     * Set SeriesId value
     * @param string $seriesId
     * @return \patest\StructType\SubscriptionPeriodDateRange
     */
    public function setSeriesId($seriesId = null)
    {
        // validation for constraint: string
        if (!is_null($seriesId) && !is_string($seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($seriesId, true), gettype($seriesId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($seriesId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $seriesId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($seriesId, true)), __LINE__);
        }
        $this->SeriesId = $seriesId;
        return $this;
    }
}
