<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubscriberDetails StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SubscriberDetails
 * @subpackage Structs
 */
class SubscriberDetails extends AbstractStructBase
{
    /**
     * The Broker
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Broker;
    /**
     * The BrokerSpecificParameters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfKeyValueOfstringstring
     */
    public $BrokerSpecificParameters;
    /**
     * The MessageFormat
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MessageFormat;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Name;
    /**
     * The Topics
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfSubscriberTopicDetails
     */
    public $Topics;
    /**
     * Constructor method for SubscriberDetails
     * @uses SubscriberDetails::setBroker()
     * @uses SubscriberDetails::setBrokerSpecificParameters()
     * @uses SubscriberDetails::setMessageFormat()
     * @uses SubscriberDetails::setName()
     * @uses SubscriberDetails::setTopics()
     * @param string $broker
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $brokerSpecificParameters
     * @param string $messageFormat
     * @param string $name
     * @param \patest\ArrayType\ArrayOfSubscriberTopicDetails $topics
     */
    public function __construct($broker = null, \patest\ArrayType\ArrayOfKeyValueOfstringstring $brokerSpecificParameters = null, $messageFormat = null, $name = null, \patest\ArrayType\ArrayOfSubscriberTopicDetails $topics = null)
    {
        $this
            ->setBroker($broker)
            ->setBrokerSpecificParameters($brokerSpecificParameters)
            ->setMessageFormat($messageFormat)
            ->setName($name)
            ->setTopics($topics);
    }
    /**
     * Get Broker value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBroker()
    {
        return isset($this->Broker) ? $this->Broker : null;
    }
    /**
     * Set Broker value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $broker
     * @return \patest\StructType\SubscriberDetails
     */
    public function setBroker($broker = null)
    {
        // validation for constraint: string
        if (!is_null($broker) && !is_string($broker)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($broker, true), gettype($broker)), __LINE__);
        }
        if (is_null($broker) || (is_array($broker) && empty($broker))) {
            unset($this->Broker);
        } else {
            $this->Broker = $broker;
        }
        return $this;
    }
    /**
     * Get BrokerSpecificParameters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfKeyValueOfstringstring|null
     */
    public function getBrokerSpecificParameters()
    {
        return isset($this->BrokerSpecificParameters) ? $this->BrokerSpecificParameters : null;
    }
    /**
     * Set BrokerSpecificParameters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfKeyValueOfstringstring $brokerSpecificParameters
     * @return \patest\StructType\SubscriberDetails
     */
    public function setBrokerSpecificParameters(\patest\ArrayType\ArrayOfKeyValueOfstringstring $brokerSpecificParameters = null)
    {
        if (is_null($brokerSpecificParameters) || (is_array($brokerSpecificParameters) && empty($brokerSpecificParameters))) {
            unset($this->BrokerSpecificParameters);
        } else {
            $this->BrokerSpecificParameters = $brokerSpecificParameters;
        }
        return $this;
    }
    /**
     * Get MessageFormat value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMessageFormat()
    {
        return isset($this->MessageFormat) ? $this->MessageFormat : null;
    }
    /**
     * Set MessageFormat value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $messageFormat
     * @return \patest\StructType\SubscriberDetails
     */
    public function setMessageFormat($messageFormat = null)
    {
        // validation for constraint: string
        if (!is_null($messageFormat) && !is_string($messageFormat)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($messageFormat, true), gettype($messageFormat)), __LINE__);
        }
        if (is_null($messageFormat) || (is_array($messageFormat) && empty($messageFormat))) {
            unset($this->MessageFormat);
        } else {
            $this->MessageFormat = $messageFormat;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $name
     * @return \patest\StructType\SubscriberDetails
     */
    public function setName($name = null)
    {
        // validation for constraint: string
        if (!is_null($name) && !is_string($name)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($name, true), gettype($name)), __LINE__);
        }
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get Topics value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfSubscriberTopicDetails|null
     */
    public function getTopics()
    {
        return isset($this->Topics) ? $this->Topics : null;
    }
    /**
     * Set Topics value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfSubscriberTopicDetails $topics
     * @return \patest\StructType\SubscriberDetails
     */
    public function setTopics(\patest\ArrayType\ArrayOfSubscriberTopicDetails $topics = null)
    {
        if (is_null($topics) || (is_array($topics) && empty($topics))) {
            unset($this->Topics);
        } else {
            $this->Topics = $topics;
        }
        return $this;
    }
}
