<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SubscribeForTraceRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SubscribeForTraceRequest
 * @subpackage Structs
 */
class SubscribeForTraceRequest extends AbstractStructBase
{
    /**
     * The Filter
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\TraceFilter
     */
    public $Filter;
    /**
     * The IsLimitToCurrentAppServer
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsLimitToCurrentAppServer;
    /**
     * The IsExtendedRetainMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsExtendedRetainMode;
    /**
     * Constructor method for SubscribeForTraceRequest
     * @uses SubscribeForTraceRequest::setFilter()
     * @uses SubscribeForTraceRequest::setIsLimitToCurrentAppServer()
     * @uses SubscribeForTraceRequest::setIsExtendedRetainMode()
     * @param \patest\StructType\TraceFilter $filter
     * @param bool $isLimitToCurrentAppServer
     * @param bool $isExtendedRetainMode
     */
    public function __construct(\patest\StructType\TraceFilter $filter = null, $isLimitToCurrentAppServer = null, $isExtendedRetainMode = null)
    {
        $this
            ->setFilter($filter)
            ->setIsLimitToCurrentAppServer($isLimitToCurrentAppServer)
            ->setIsExtendedRetainMode($isExtendedRetainMode);
    }
    /**
     * Get Filter value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\TraceFilter|null
     */
    public function getFilter()
    {
        return isset($this->Filter) ? $this->Filter : null;
    }
    /**
     * Set Filter value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\TraceFilter $filter
     * @return \patest\StructType\SubscribeForTraceRequest
     */
    public function setFilter(\patest\StructType\TraceFilter $filter = null)
    {
        if (is_null($filter) || (is_array($filter) && empty($filter))) {
            unset($this->Filter);
        } else {
            $this->Filter = $filter;
        }
        return $this;
    }
    /**
     * Get IsLimitToCurrentAppServer value
     * @return bool|null
     */
    public function getIsLimitToCurrentAppServer()
    {
        return $this->IsLimitToCurrentAppServer;
    }
    /**
     * Set IsLimitToCurrentAppServer value
     * @param bool $isLimitToCurrentAppServer
     * @return \patest\StructType\SubscribeForTraceRequest
     */
    public function setIsLimitToCurrentAppServer($isLimitToCurrentAppServer = null)
    {
        // validation for constraint: boolean
        if (!is_null($isLimitToCurrentAppServer) && !is_bool($isLimitToCurrentAppServer)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isLimitToCurrentAppServer, true), gettype($isLimitToCurrentAppServer)), __LINE__);
        }
        $this->IsLimitToCurrentAppServer = $isLimitToCurrentAppServer;
        return $this;
    }
    /**
     * Get IsExtendedRetainMode value
     * @return bool|null
     */
    public function getIsExtendedRetainMode()
    {
        return $this->IsExtendedRetainMode;
    }
    /**
     * Set IsExtendedRetainMode value
     * @param bool $isExtendedRetainMode
     * @return \patest\StructType\SubscribeForTraceRequest
     */
    public function setIsExtendedRetainMode($isExtendedRetainMode = null)
    {
        // validation for constraint: boolean
        if (!is_null($isExtendedRetainMode) && !is_bool($isExtendedRetainMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isExtendedRetainMode, true), gettype($isExtendedRetainMode)), __LINE__);
        }
        $this->IsExtendedRetainMode = $isExtendedRetainMode;
        return $this;
    }
}
