<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StoreCreditCardTokenResponse StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:StoreCreditCardTokenResponse
 * @subpackage Structs
 */
class StoreCreditCardTokenResponse extends ExtensibleDataContract
{
    /**
     * The CardNumberMask
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CardNumberMask;
    /**
     * The TokenEntityGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TokenEntityGuid;
    /**
     * Constructor method for StoreCreditCardTokenResponse
     * @uses StoreCreditCardTokenResponse::setCardNumberMask()
     * @uses StoreCreditCardTokenResponse::setTokenEntityGuid()
     * @param string $cardNumberMask
     * @param string $tokenEntityGuid
     */
    public function __construct($cardNumberMask = null, $tokenEntityGuid = null)
    {
        $this
            ->setCardNumberMask($cardNumberMask)
            ->setTokenEntityGuid($tokenEntityGuid);
    }
    /**
     * Get CardNumberMask value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCardNumberMask()
    {
        return isset($this->CardNumberMask) ? $this->CardNumberMask : null;
    }
    /**
     * Set CardNumberMask value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cardNumberMask
     * @return \patest\StructType\StoreCreditCardTokenResponse
     */
    public function setCardNumberMask($cardNumberMask = null)
    {
        // validation for constraint: string
        if (!is_null($cardNumberMask) && !is_string($cardNumberMask)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($cardNumberMask, true), gettype($cardNumberMask)), __LINE__);
        }
        if (is_null($cardNumberMask) || (is_array($cardNumberMask) && empty($cardNumberMask))) {
            unset($this->CardNumberMask);
        } else {
            $this->CardNumberMask = $cardNumberMask;
        }
        return $this;
    }
    /**
     * Get TokenEntityGuid value
     * @return string|null
     */
    public function getTokenEntityGuid()
    {
        return $this->TokenEntityGuid;
    }
    /**
     * Set TokenEntityGuid value
     * @param string $tokenEntityGuid
     * @return \patest\StructType\StoreCreditCardTokenResponse
     */
    public function setTokenEntityGuid($tokenEntityGuid = null)
    {
        // validation for constraint: string
        if (!is_null($tokenEntityGuid) && !is_string($tokenEntityGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($tokenEntityGuid, true), gettype($tokenEntityGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($tokenEntityGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $tokenEntityGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($tokenEntityGuid, true)), __LINE__);
        }
        $this->TokenEntityGuid = $tokenEntityGuid;
        return $this;
    }
}
