<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Stat StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:Stat
 * @subpackage Structs
 */
class Stat extends AbstractStructBase
{
    /**
     * The ProcessingTimeMs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ProcessingTimeMs;
    /**
     * The HitCategory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HitCategory;
    /**
     * The CpuTimeMs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CpuTimeMs;
    /**
     * The DbTimeMs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $DbTimeMs;
    /**
     * Constructor method for Stat
     * @uses Stat::setProcessingTimeMs()
     * @uses Stat::setHitCategory()
     * @uses Stat::setCpuTimeMs()
     * @uses Stat::setDbTimeMs()
     * @param int $processingTimeMs
     * @param string $hitCategory
     * @param float $cpuTimeMs
     * @param float $dbTimeMs
     */
    public function __construct($processingTimeMs = null, $hitCategory = null, $cpuTimeMs = null, $dbTimeMs = null)
    {
        $this
            ->setProcessingTimeMs($processingTimeMs)
            ->setHitCategory($hitCategory)
            ->setCpuTimeMs($cpuTimeMs)
            ->setDbTimeMs($dbTimeMs);
    }
    /**
     * Get ProcessingTimeMs value
     * @return int|null
     */
    public function getProcessingTimeMs()
    {
        return $this->ProcessingTimeMs;
    }
    /**
     * Set ProcessingTimeMs value
     * @param int $processingTimeMs
     * @return \patest\StructType\Stat
     */
    public function setProcessingTimeMs($processingTimeMs = null)
    {
        // validation for constraint: int
        if (!is_null($processingTimeMs) && !(is_int($processingTimeMs) || ctype_digit($processingTimeMs))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($processingTimeMs, true), gettype($processingTimeMs)), __LINE__);
        }
        $this->ProcessingTimeMs = $processingTimeMs;
        return $this;
    }
    /**
     * Get HitCategory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHitCategory()
    {
        return isset($this->HitCategory) ? $this->HitCategory : null;
    }
    /**
     * Set HitCategory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hitCategory
     * @return \patest\StructType\Stat
     */
    public function setHitCategory($hitCategory = null)
    {
        // validation for constraint: string
        if (!is_null($hitCategory) && !is_string($hitCategory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hitCategory, true), gettype($hitCategory)), __LINE__);
        }
        if (is_null($hitCategory) || (is_array($hitCategory) && empty($hitCategory))) {
            unset($this->HitCategory);
        } else {
            $this->HitCategory = $hitCategory;
        }
        return $this;
    }
    /**
     * Get CpuTimeMs value
     * @return float|null
     */
    public function getCpuTimeMs()
    {
        return $this->CpuTimeMs;
    }
    /**
     * Set CpuTimeMs value
     * @param float $cpuTimeMs
     * @return \patest\StructType\Stat
     */
    public function setCpuTimeMs($cpuTimeMs = null)
    {
        // validation for constraint: float
        if (!is_null($cpuTimeMs) && !(is_float($cpuTimeMs) || is_numeric($cpuTimeMs))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($cpuTimeMs, true), gettype($cpuTimeMs)), __LINE__);
        }
        $this->CpuTimeMs = $cpuTimeMs;
        return $this;
    }
    /**
     * Get DbTimeMs value
     * @return float|null
     */
    public function getDbTimeMs()
    {
        return $this->DbTimeMs;
    }
    /**
     * Set DbTimeMs value
     * @param float $dbTimeMs
     * @return \patest\StructType\Stat
     */
    public function setDbTimeMs($dbTimeMs = null)
    {
        // validation for constraint: float
        if (!is_null($dbTimeMs) && !(is_float($dbTimeMs) || is_numeric($dbTimeMs))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a float value, %s given', var_export($dbTimeMs, true), gettype($dbTimeMs)), __LINE__);
        }
        $this->DbTimeMs = $dbTimeMs;
        return $this;
    }
}
