<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for StandId StructType
 * @subpackage Structs
 */
class StandId extends AbstractStructBase
{
    /**
     * The Key
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string[]
     */
    public $Key;
    /**
     * Constructor method for StandId
     * @uses StandId::setKey()
     * @param string[] $key
     */
    public function __construct(array $key = array())
    {
        $this
            ->setKey($key);
    }
    /**
     * Get Key value
     * @return string[]|null
     */
    public function getKey()
    {
        return $this->Key;
    }
    /**
     * This method is responsible for validating the values passed to the setKey method
     * This method is willingly generated in order to preserve the one-line inline validation within the setKey method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateKeyForArrayConstraintsFromSetKey(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $standIdKeyItem) {
            // validation for constraint: itemType
            if (!is_string($standIdKeyItem)) {
                $invalidValues[] = is_object($standIdKeyItem) ? get_class($standIdKeyItem) : sprintf('%s(%s)', gettype($standIdKeyItem), var_export($standIdKeyItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('The Key property can only contain items of type string, %s given', is_object($invalidValues) ? get_class($invalidValues) : (is_array($invalidValues) ? implode(', ', $invalidValues) : gettype($invalidValues)));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set Key value
     * @throws \InvalidArgumentException
     * @param string[] $key
     * @return \patest\StructType\StandId
     */
    public function setKey(array $key = array())
    {
        // validation for constraint: array
        if ('' !== ($keyArrayErrorMessage = self::validateKeyForArrayConstraintsFromSetKey($key))) {
            throw new \InvalidArgumentException($keyArrayErrorMessage, __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($key) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($key, true)), __LINE__);
        }
        $this->Key = $key;
        return $this;
    }
    /**
     * Add item to Key value
     * @throws \InvalidArgumentException
     * @param string $item
     * @return \patest\StructType\StandId
     */
    public function addToKey($item)
    {
        // validation for constraint: itemType
        if (!is_string($item)) {
            throw new \InvalidArgumentException(sprintf('The Key property can only contain items of type string, %s given', is_object($item) ? get_class($item) : (is_array($item) ? implode(', ', $item) : gettype($item))), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $item)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($item, true)), __LINE__);
        }
        $this->Key[] = $item;
        return $this;
    }
}
