<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SroSyncInfo StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SroSyncInfo
 * @subpackage Structs
 */
class SroSyncInfo extends ExtensibleDataContract
{
    /**
     * The Error
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Error;
    /**
     * The Failed
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Failed;
    /**
     * The GuidId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $GuidId;
    /**
     * The SroId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SroId;
    /**
     * The StackTrace
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StackTrace;
    /**
     * Constructor method for SroSyncInfo
     * @uses SroSyncInfo::setError()
     * @uses SroSyncInfo::setFailed()
     * @uses SroSyncInfo::setGuidId()
     * @uses SroSyncInfo::setSroId()
     * @uses SroSyncInfo::setStackTrace()
     * @param string $error
     * @param bool $failed
     * @param string $guidId
     * @param string $sroId
     * @param string $stackTrace
     */
    public function __construct($error = null, $failed = null, $guidId = null, $sroId = null, $stackTrace = null)
    {
        $this
            ->setError($error)
            ->setFailed($failed)
            ->setGuidId($guidId)
            ->setSroId($sroId)
            ->setStackTrace($stackTrace);
    }
    /**
     * Get Error value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getError()
    {
        return isset($this->Error) ? $this->Error : null;
    }
    /**
     * Set Error value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $error
     * @return \patest\StructType\SroSyncInfo
     */
    public function setError($error = null)
    {
        // validation for constraint: string
        if (!is_null($error) && !is_string($error)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($error, true), gettype($error)), __LINE__);
        }
        if (is_null($error) || (is_array($error) && empty($error))) {
            unset($this->Error);
        } else {
            $this->Error = $error;
        }
        return $this;
    }
    /**
     * Get Failed value
     * @return bool|null
     */
    public function getFailed()
    {
        return $this->Failed;
    }
    /**
     * Set Failed value
     * @param bool $failed
     * @return \patest\StructType\SroSyncInfo
     */
    public function setFailed($failed = null)
    {
        // validation for constraint: boolean
        if (!is_null($failed) && !is_bool($failed)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($failed, true), gettype($failed)), __LINE__);
        }
        $this->Failed = $failed;
        return $this;
    }
    /**
     * Get GuidId value
     * @return string|null
     */
    public function getGuidId()
    {
        return $this->GuidId;
    }
    /**
     * Set GuidId value
     * @param string $guidId
     * @return \patest\StructType\SroSyncInfo
     */
    public function setGuidId($guidId = null)
    {
        // validation for constraint: string
        if (!is_null($guidId) && !is_string($guidId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($guidId, true), gettype($guidId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($guidId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $guidId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($guidId, true)), __LINE__);
        }
        $this->GuidId = $guidId;
        return $this;
    }
    /**
     * Get SroId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSroId()
    {
        return isset($this->SroId) ? $this->SroId : null;
    }
    /**
     * Set SroId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sroId
     * @return \patest\StructType\SroSyncInfo
     */
    public function setSroId($sroId = null)
    {
        // validation for constraint: string
        if (!is_null($sroId) && !is_string($sroId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($sroId, true), gettype($sroId)), __LINE__);
        }
        if (is_null($sroId) || (is_array($sroId) && empty($sroId))) {
            unset($this->SroId);
        } else {
            $this->SroId = $sroId;
        }
        return $this;
    }
    /**
     * Get StackTrace value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStackTrace()
    {
        return isset($this->StackTrace) ? $this->StackTrace : null;
    }
    /**
     * Set StackTrace value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $stackTrace
     * @return \patest\StructType\SroSyncInfo
     */
    public function setStackTrace($stackTrace = null)
    {
        // validation for constraint: string
        if (!is_null($stackTrace) && !is_string($stackTrace)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($stackTrace, true), gettype($stackTrace)), __LINE__);
        }
        if (is_null($stackTrace) || (is_array($stackTrace) && empty($stackTrace))) {
            unset($this->StackTrace);
        } else {
            $this->StackTrace = $stackTrace;
        }
        return $this;
    }
}
