<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SimulateBasketItemsConfirmation-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SimulateBasketItemsConfirmation-Request
 * @subpackage Structs
 */
class SimulateBasketItemsConfirmation_Request extends AbstractStructBase
{
    /**
     * The ClientId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ClientId;
    /**
     * The DestinationTransactionSnapshotType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DestinationTransactionSnapshotType;
    /**
     * The ItemIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfItemIdentity
     */
    public $ItemIds;
    /**
     * The IteractionChannel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IteractionChannel;
    /**
     * The SaleMode
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SaleMode;
    /**
     * The ServiceSpecificItemIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfServiceSpecificItemIdentity
     */
    public $ServiceSpecificItemIds;
    /**
     * The IsConvertPricingErrorsIntoIncomplete
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsConvertPricingErrorsIntoIncomplete;
    /**
     * Constructor method for SimulateBasketItemsConfirmation-Request
     * @uses SimulateBasketItemsConfirmation_Request::setClientId()
     * @uses SimulateBasketItemsConfirmation_Request::setDestinationTransactionSnapshotType()
     * @uses SimulateBasketItemsConfirmation_Request::setItemIds()
     * @uses SimulateBasketItemsConfirmation_Request::setIteractionChannel()
     * @uses SimulateBasketItemsConfirmation_Request::setSaleMode()
     * @uses SimulateBasketItemsConfirmation_Request::setServiceSpecificItemIds()
     * @uses SimulateBasketItemsConfirmation_Request::setIsConvertPricingErrorsIntoIncomplete()
     * @param string $clientId
     * @param string $destinationTransactionSnapshotType
     * @param \patest\ArrayType\ArrayOfItemIdentity $itemIds
     * @param string $iteractionChannel
     * @param string $saleMode
     * @param \patest\ArrayType\ArrayOfServiceSpecificItemIdentity $serviceSpecificItemIds
     * @param bool $isConvertPricingErrorsIntoIncomplete
     */
    public function __construct($clientId = null, $destinationTransactionSnapshotType = null, \patest\ArrayType\ArrayOfItemIdentity $itemIds = null, $iteractionChannel = null, $saleMode = null, \patest\ArrayType\ArrayOfServiceSpecificItemIdentity $serviceSpecificItemIds = null, $isConvertPricingErrorsIntoIncomplete = null)
    {
        $this
            ->setClientId($clientId)
            ->setDestinationTransactionSnapshotType($destinationTransactionSnapshotType)
            ->setItemIds($itemIds)
            ->setIteractionChannel($iteractionChannel)
            ->setSaleMode($saleMode)
            ->setServiceSpecificItemIds($serviceSpecificItemIds)
            ->setIsConvertPricingErrorsIntoIncomplete($isConvertPricingErrorsIntoIncomplete);
    }
    /**
     * Get ClientId value
     * @return string|null
     */
    public function getClientId()
    {
        return $this->ClientId;
    }
    /**
     * Set ClientId value
     * @param string $clientId
     * @return \patest\StructType\SimulateBasketItemsConfirmation_Request
     */
    public function setClientId($clientId = null)
    {
        // validation for constraint: string
        if (!is_null($clientId) && !is_string($clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($clientId, true), gettype($clientId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($clientId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $clientId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($clientId, true)), __LINE__);
        }
        $this->ClientId = $clientId;
        return $this;
    }
    /**
     * Get DestinationTransactionSnapshotType value
     * @return string|null
     */
    public function getDestinationTransactionSnapshotType()
    {
        return $this->DestinationTransactionSnapshotType;
    }
    /**
     * Set DestinationTransactionSnapshotType value
     * @uses \patest\EnumType\TransactionSnapshotType::valueIsValid()
     * @uses \patest\EnumType\TransactionSnapshotType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $destinationTransactionSnapshotType
     * @return \patest\StructType\SimulateBasketItemsConfirmation_Request
     */
    public function setDestinationTransactionSnapshotType($destinationTransactionSnapshotType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionSnapshotType::valueIsValid($destinationTransactionSnapshotType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionSnapshotType', is_array($destinationTransactionSnapshotType) ? implode(', ', $destinationTransactionSnapshotType) : var_export($destinationTransactionSnapshotType, true), implode(', ', \patest\EnumType\TransactionSnapshotType::getValidValues())), __LINE__);
        }
        $this->DestinationTransactionSnapshotType = $destinationTransactionSnapshotType;
        return $this;
    }
    /**
     * Get ItemIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfItemIdentity|null
     */
    public function getItemIds()
    {
        return isset($this->ItemIds) ? $this->ItemIds : null;
    }
    /**
     * Set ItemIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfItemIdentity $itemIds
     * @return \patest\StructType\SimulateBasketItemsConfirmation_Request
     */
    public function setItemIds(\patest\ArrayType\ArrayOfItemIdentity $itemIds = null)
    {
        if (is_null($itemIds) || (is_array($itemIds) && empty($itemIds))) {
            unset($this->ItemIds);
        } else {
            $this->ItemIds = $itemIds;
        }
        return $this;
    }
    /**
     * Get IteractionChannel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIteractionChannel()
    {
        return isset($this->IteractionChannel) ? $this->IteractionChannel : null;
    }
    /**
     * Set IteractionChannel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TransactionInteractionChannel::valueIsValid()
     * @uses \patest\EnumType\TransactionInteractionChannel::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $iteractionChannel
     * @return \patest\StructType\SimulateBasketItemsConfirmation_Request
     */
    public function setIteractionChannel($iteractionChannel = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TransactionInteractionChannel::valueIsValid($iteractionChannel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TransactionInteractionChannel', is_array($iteractionChannel) ? implode(', ', $iteractionChannel) : var_export($iteractionChannel, true), implode(', ', \patest\EnumType\TransactionInteractionChannel::getValidValues())), __LINE__);
        }
        if (is_null($iteractionChannel) || (is_array($iteractionChannel) && empty($iteractionChannel))) {
            unset($this->IteractionChannel);
        } else {
            $this->IteractionChannel = $iteractionChannel;
        }
        return $this;
    }
    /**
     * Get SaleMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSaleMode()
    {
        return isset($this->SaleMode) ? $this->SaleMode : null;
    }
    /**
     * Set SaleMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $saleMode
     * @return \patest\StructType\SimulateBasketItemsConfirmation_Request
     */
    public function setSaleMode($saleMode = null)
    {
        // validation for constraint: string
        if (!is_null($saleMode) && !is_string($saleMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($saleMode, true), gettype($saleMode)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($saleMode) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $saleMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($saleMode, true)), __LINE__);
        }
        if (is_null($saleMode) || (is_array($saleMode) && empty($saleMode))) {
            unset($this->SaleMode);
        } else {
            $this->SaleMode = $saleMode;
        }
        return $this;
    }
    /**
     * Get ServiceSpecificItemIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfServiceSpecificItemIdentity|null
     */
    public function getServiceSpecificItemIds()
    {
        return isset($this->ServiceSpecificItemIds) ? $this->ServiceSpecificItemIds : null;
    }
    /**
     * Set ServiceSpecificItemIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfServiceSpecificItemIdentity $serviceSpecificItemIds
     * @return \patest\StructType\SimulateBasketItemsConfirmation_Request
     */
    public function setServiceSpecificItemIds(\patest\ArrayType\ArrayOfServiceSpecificItemIdentity $serviceSpecificItemIds = null)
    {
        if (is_null($serviceSpecificItemIds) || (is_array($serviceSpecificItemIds) && empty($serviceSpecificItemIds))) {
            unset($this->ServiceSpecificItemIds);
        } else {
            $this->ServiceSpecificItemIds = $serviceSpecificItemIds;
        }
        return $this;
    }
    /**
     * Get IsConvertPricingErrorsIntoIncomplete value
     * @return bool|null
     */
    public function getIsConvertPricingErrorsIntoIncomplete()
    {
        return $this->IsConvertPricingErrorsIntoIncomplete;
    }
    /**
     * Set IsConvertPricingErrorsIntoIncomplete value
     * @param bool $isConvertPricingErrorsIntoIncomplete
     * @return \patest\StructType\SimulateBasketItemsConfirmation_Request
     */
    public function setIsConvertPricingErrorsIntoIncomplete($isConvertPricingErrorsIntoIncomplete = null)
    {
        // validation for constraint: boolean
        if (!is_null($isConvertPricingErrorsIntoIncomplete) && !is_bool($isConvertPricingErrorsIntoIncomplete)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isConvertPricingErrorsIntoIncomplete, true), gettype($isConvertPricingErrorsIntoIncomplete)), __LINE__);
        }
        $this->IsConvertPricingErrorsIntoIncomplete = $isConvertPricingErrorsIntoIncomplete;
        return $this;
    }
}
