<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetUniversalFlagRequest StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SetUniversalFlagRequest
 * @subpackage Structs
 */
class SetUniversalFlagRequest extends AbstractStructBase
{
    /**
     * The ExpirationDateTimeUtc
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExpirationDateTimeUtc;
    /**
     * The FlagName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FlagName;
    /**
     * The FlagValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FlagValue;
    /**
     * The IsAutoReset
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IsAutoReset;
    /**
     * Constructor method for SetUniversalFlagRequest
     * @uses SetUniversalFlagRequest::setExpirationDateTimeUtc()
     * @uses SetUniversalFlagRequest::setFlagName()
     * @uses SetUniversalFlagRequest::setFlagValue()
     * @uses SetUniversalFlagRequest::setIsAutoReset()
     * @param string $expirationDateTimeUtc
     * @param string $flagName
     * @param string $flagValue
     * @param bool $isAutoReset
     */
    public function __construct($expirationDateTimeUtc = null, $flagName = null, $flagValue = null, $isAutoReset = null)
    {
        $this
            ->setExpirationDateTimeUtc($expirationDateTimeUtc)
            ->setFlagName($flagName)
            ->setFlagValue($flagValue)
            ->setIsAutoReset($isAutoReset);
    }
    /**
     * Get ExpirationDateTimeUtc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExpirationDateTimeUtc()
    {
        return isset($this->ExpirationDateTimeUtc) ? $this->ExpirationDateTimeUtc : null;
    }
    /**
     * Set ExpirationDateTimeUtc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $expirationDateTimeUtc
     * @return \patest\StructType\SetUniversalFlagRequest
     */
    public function setExpirationDateTimeUtc($expirationDateTimeUtc = null)
    {
        // validation for constraint: string
        if (!is_null($expirationDateTimeUtc) && !is_string($expirationDateTimeUtc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($expirationDateTimeUtc, true), gettype($expirationDateTimeUtc)), __LINE__);
        }
        if (is_null($expirationDateTimeUtc) || (is_array($expirationDateTimeUtc) && empty($expirationDateTimeUtc))) {
            unset($this->ExpirationDateTimeUtc);
        } else {
            $this->ExpirationDateTimeUtc = $expirationDateTimeUtc;
        }
        return $this;
    }
    /**
     * Get FlagName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFlagName()
    {
        return isset($this->FlagName) ? $this->FlagName : null;
    }
    /**
     * Set FlagName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $flagName
     * @return \patest\StructType\SetUniversalFlagRequest
     */
    public function setFlagName($flagName = null)
    {
        // validation for constraint: string
        if (!is_null($flagName) && !is_string($flagName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flagName, true), gettype($flagName)), __LINE__);
        }
        if (is_null($flagName) || (is_array($flagName) && empty($flagName))) {
            unset($this->FlagName);
        } else {
            $this->FlagName = $flagName;
        }
        return $this;
    }
    /**
     * Get FlagValue value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFlagValue()
    {
        return isset($this->FlagValue) ? $this->FlagValue : null;
    }
    /**
     * Set FlagValue value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $flagValue
     * @return \patest\StructType\SetUniversalFlagRequest
     */
    public function setFlagValue($flagValue = null)
    {
        // validation for constraint: string
        if (!is_null($flagValue) && !is_string($flagValue)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($flagValue, true), gettype($flagValue)), __LINE__);
        }
        if (is_null($flagValue) || (is_array($flagValue) && empty($flagValue))) {
            unset($this->FlagValue);
        } else {
            $this->FlagValue = $flagValue;
        }
        return $this;
    }
    /**
     * Get IsAutoReset value
     * @return bool|null
     */
    public function getIsAutoReset()
    {
        return $this->IsAutoReset;
    }
    /**
     * Set IsAutoReset value
     * @param bool $isAutoReset
     * @return \patest\StructType\SetUniversalFlagRequest
     */
    public function setIsAutoReset($isAutoReset = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAutoReset) && !is_bool($isAutoReset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAutoReset, true), gettype($isAutoReset)), __LINE__);
        }
        $this->IsAutoReset = $isAutoReset;
        return $this;
    }
}
