<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SetTicketSchemeEnrollmentsOfBasketSubscriptionsRequest
 * StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SetTicketSchemeEnrollmentsOfBasketSubscriptionsRequest
 * @subpackage Structs
 */
class SetTicketSchemeEnrollmentsOfBasketSubscriptionsRequest extends ExtensibleDataContract
{
    /**
     * The PaymentMethodId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentMethodId;
    /**
     * The PaymentTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $PaymentTokenId;
    /**
     * The TicketSchemeIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfguid
     */
    public $TicketSchemeIds;
    /**
     * The TransactionGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TransactionGuid;
    /**
     * The SetPaymentForAutoTicketSchemes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SetPaymentForAutoTicketSchemes;
    /**
     * The ItemIds
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfint
     */
    public $ItemIds;
    /**
     * Constructor method for SetTicketSchemeEnrollmentsOfBasketSubscriptionsRequest
     * @uses SetTicketSchemeEnrollmentsOfBasketSubscriptionsRequest::setPaymentMethodId()
     * @uses SetTicketSchemeEnrollmentsOfBasketSubscriptionsRequest::setPaymentTokenId()
     * @uses SetTicketSchemeEnrollmentsOfBasketSubscriptionsRequest::setTicketSchemeIds()
     * @uses SetTicketSchemeEnrollmentsOfBasketSubscriptionsRequest::setTransactionGuid()
     * @uses SetTicketSchemeEnrollmentsOfBasketSubscriptionsRequest::setSetPaymentForAutoTicketSchemes()
     * @uses SetTicketSchemeEnrollmentsOfBasketSubscriptionsRequest::setItemIds()
     * @param string $paymentMethodId
     * @param string $paymentTokenId
     * @param \patest\ArrayType\ArrayOfguid $ticketSchemeIds
     * @param string $transactionGuid
     * @param bool $setPaymentForAutoTicketSchemes
     * @param \patest\ArrayType\ArrayOfint $itemIds
     */
    public function __construct($paymentMethodId = null, $paymentTokenId = null, \patest\ArrayType\ArrayOfguid $ticketSchemeIds = null, $transactionGuid = null, $setPaymentForAutoTicketSchemes = null, \patest\ArrayType\ArrayOfint $itemIds = null)
    {
        $this
            ->setPaymentMethodId($paymentMethodId)
            ->setPaymentTokenId($paymentTokenId)
            ->setTicketSchemeIds($ticketSchemeIds)
            ->setTransactionGuid($transactionGuid)
            ->setSetPaymentForAutoTicketSchemes($setPaymentForAutoTicketSchemes)
            ->setItemIds($itemIds);
    }
    /**
     * Get PaymentMethodId value
     * @return string|null
     */
    public function getPaymentMethodId()
    {
        return $this->PaymentMethodId;
    }
    /**
     * Set PaymentMethodId value
     * @param string $paymentMethodId
     * @return \patest\StructType\SetTicketSchemeEnrollmentsOfBasketSubscriptionsRequest
     */
    public function setPaymentMethodId($paymentMethodId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentMethodId) && !is_string($paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentMethodId, true), gettype($paymentMethodId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentMethodId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentMethodId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentMethodId, true)), __LINE__);
        }
        $this->PaymentMethodId = $paymentMethodId;
        return $this;
    }
    /**
     * Get PaymentTokenId value
     * @return string|null
     */
    public function getPaymentTokenId()
    {
        return $this->PaymentTokenId;
    }
    /**
     * Set PaymentTokenId value
     * @param string $paymentTokenId
     * @return \patest\StructType\SetTicketSchemeEnrollmentsOfBasketSubscriptionsRequest
     */
    public function setPaymentTokenId($paymentTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($paymentTokenId) && !is_string($paymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($paymentTokenId, true), gettype($paymentTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($paymentTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $paymentTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($paymentTokenId, true)), __LINE__);
        }
        $this->PaymentTokenId = $paymentTokenId;
        return $this;
    }
    /**
     * Get TicketSchemeIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfguid|null
     */
    public function getTicketSchemeIds()
    {
        return isset($this->TicketSchemeIds) ? $this->TicketSchemeIds : null;
    }
    /**
     * Set TicketSchemeIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfguid $ticketSchemeIds
     * @return \patest\StructType\SetTicketSchemeEnrollmentsOfBasketSubscriptionsRequest
     */
    public function setTicketSchemeIds(\patest\ArrayType\ArrayOfguid $ticketSchemeIds = null)
    {
        if (is_null($ticketSchemeIds) || (is_array($ticketSchemeIds) && empty($ticketSchemeIds))) {
            unset($this->TicketSchemeIds);
        } else {
            $this->TicketSchemeIds = $ticketSchemeIds;
        }
        return $this;
    }
    /**
     * Get TransactionGuid value
     * @return string|null
     */
    public function getTransactionGuid()
    {
        return $this->TransactionGuid;
    }
    /**
     * Set TransactionGuid value
     * @param string $transactionGuid
     * @return \patest\StructType\SetTicketSchemeEnrollmentsOfBasketSubscriptionsRequest
     */
    public function setTransactionGuid($transactionGuid = null)
    {
        // validation for constraint: string
        if (!is_null($transactionGuid) && !is_string($transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($transactionGuid, true), gettype($transactionGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($transactionGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $transactionGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($transactionGuid, true)), __LINE__);
        }
        $this->TransactionGuid = $transactionGuid;
        return $this;
    }
    /**
     * Get SetPaymentForAutoTicketSchemes value
     * @return bool|null
     */
    public function getSetPaymentForAutoTicketSchemes()
    {
        return $this->SetPaymentForAutoTicketSchemes;
    }
    /**
     * Set SetPaymentForAutoTicketSchemes value
     * @param bool $setPaymentForAutoTicketSchemes
     * @return \patest\StructType\SetTicketSchemeEnrollmentsOfBasketSubscriptionsRequest
     */
    public function setSetPaymentForAutoTicketSchemes($setPaymentForAutoTicketSchemes = null)
    {
        // validation for constraint: boolean
        if (!is_null($setPaymentForAutoTicketSchemes) && !is_bool($setPaymentForAutoTicketSchemes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($setPaymentForAutoTicketSchemes, true), gettype($setPaymentForAutoTicketSchemes)), __LINE__);
        }
        $this->SetPaymentForAutoTicketSchemes = $setPaymentForAutoTicketSchemes;
        return $this;
    }
    /**
     * Get ItemIds value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfint|null
     */
    public function getItemIds()
    {
        return isset($this->ItemIds) ? $this->ItemIds : null;
    }
    /**
     * Set ItemIds value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfint $itemIds
     * @return \patest\StructType\SetTicketSchemeEnrollmentsOfBasketSubscriptionsRequest
     */
    public function setItemIds(\patest\ArrayType\ArrayOfint $itemIds = null)
    {
        if (is_null($itemIds) || (is_array($itemIds) && empty($itemIds))) {
            unset($this->ItemIds);
        } else {
            $this->ItemIds = $itemIds;
        }
        return $this;
    }
}
