<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SerializedCompactListOfOptionsOfint StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SerializedCompactListOfOptionsOfint
 * @subpackage Structs
 */
class SerializedCompactListOfOptionsOfint extends SerializedCompactListOfint
{
    /**
     * The DefaultValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DefaultValue;
    /**
     * The Options
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfint
     */
    public $Options;
    /**
     * Constructor method for SerializedCompactListOfOptionsOfint
     * @uses SerializedCompactListOfOptionsOfint::setDefaultValue()
     * @uses SerializedCompactListOfOptionsOfint::setOptions()
     * @param int $defaultValue
     * @param \patest\ArrayType\ArrayOfint $options
     */
    public function __construct($defaultValue = null, \patest\ArrayType\ArrayOfint $options = null)
    {
        $this
            ->setDefaultValue($defaultValue)
            ->setOptions($options);
    }
    /**
     * Get DefaultValue value
     * @return int|null
     */
    public function getDefaultValue()
    {
        return $this->DefaultValue;
    }
    /**
     * Set DefaultValue value
     * @param int $defaultValue
     * @return \patest\StructType\SerializedCompactListOfOptionsOfint
     */
    public function setDefaultValue($defaultValue = null)
    {
        // validation for constraint: int
        if (!is_null($defaultValue) && !(is_int($defaultValue) || ctype_digit($defaultValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($defaultValue, true), gettype($defaultValue)), __LINE__);
        }
        $this->DefaultValue = $defaultValue;
        return $this;
    }
    /**
     * Get Options value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfint|null
     */
    public function getOptions()
    {
        return isset($this->Options) ? $this->Options : null;
    }
    /**
     * Set Options value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfint $options
     * @return \patest\StructType\SerializedCompactListOfOptionsOfint
     */
    public function setOptions(\patest\ArrayType\ArrayOfint $options = null)
    {
        if (is_null($options) || (is_array($options) && empty($options))) {
            unset($this->Options);
        } else {
            $this->Options = $options;
        }
        return $this;
    }
}
