<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SerializedCompactListBase StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SerializedCompactListBase
 * @subpackage Structs
 */
class SerializedCompactListBase extends AbstractStructBase
{
    /**
     * The BitCountPerCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BitCountPerCount;
    /**
     * The BitCountPerItem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $BitCountPerItem;
    /**
     * The Data
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Data;
    /**
     * The ItemCountInData
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ItemCountInData;
    /**
     * The SerializationMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var string[]
     */
    public $SerializationMethod;
    /**
     * Constructor method for SerializedCompactListBase
     * @uses SerializedCompactListBase::setBitCountPerCount()
     * @uses SerializedCompactListBase::setBitCountPerItem()
     * @uses SerializedCompactListBase::setData()
     * @uses SerializedCompactListBase::setItemCountInData()
     * @uses SerializedCompactListBase::setSerializationMethod()
     * @param string $bitCountPerCount
     * @param string $bitCountPerItem
     * @param string $data
     * @param int $itemCountInData
     * @param string[] $serializationMethod
     */
    public function __construct($bitCountPerCount = null, $bitCountPerItem = null, $data = null, $itemCountInData = null, array $serializationMethod = array())
    {
        $this
            ->setBitCountPerCount($bitCountPerCount)
            ->setBitCountPerItem($bitCountPerItem)
            ->setData($data)
            ->setItemCountInData($itemCountInData)
            ->setSerializationMethod($serializationMethod);
    }
    /**
     * Get BitCountPerCount value
     * @return string|null
     */
    public function getBitCountPerCount()
    {
        return $this->BitCountPerCount;
    }
    /**
     * Set BitCountPerCount value
     * @param string $bitCountPerCount
     * @return \patest\StructType\SerializedCompactListBase
     */
    public function setBitCountPerCount($bitCountPerCount = null)
    {
        // validation for constraint: string
        if (!is_null($bitCountPerCount) && !is_string($bitCountPerCount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bitCountPerCount, true), gettype($bitCountPerCount)), __LINE__);
        }
        $this->BitCountPerCount = $bitCountPerCount;
        return $this;
    }
    /**
     * Get BitCountPerItem value
     * @return string|null
     */
    public function getBitCountPerItem()
    {
        return $this->BitCountPerItem;
    }
    /**
     * Set BitCountPerItem value
     * @param string $bitCountPerItem
     * @return \patest\StructType\SerializedCompactListBase
     */
    public function setBitCountPerItem($bitCountPerItem = null)
    {
        // validation for constraint: string
        if (!is_null($bitCountPerItem) && !is_string($bitCountPerItem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bitCountPerItem, true), gettype($bitCountPerItem)), __LINE__);
        }
        $this->BitCountPerItem = $bitCountPerItem;
        return $this;
    }
    /**
     * Get Data value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getData()
    {
        return isset($this->Data) ? $this->Data : null;
    }
    /**
     * Set Data value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $data
     * @return \patest\StructType\SerializedCompactListBase
     */
    public function setData($data = null)
    {
        // validation for constraint: string
        if (!is_null($data) && !is_string($data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($data, true), gettype($data)), __LINE__);
        }
        if (is_null($data) || (is_array($data) && empty($data))) {
            unset($this->Data);
        } else {
            $this->Data = $data;
        }
        return $this;
    }
    /**
     * Get ItemCountInData value
     * @return int|null
     */
    public function getItemCountInData()
    {
        return $this->ItemCountInData;
    }
    /**
     * Set ItemCountInData value
     * @param int $itemCountInData
     * @return \patest\StructType\SerializedCompactListBase
     */
    public function setItemCountInData($itemCountInData = null)
    {
        // validation for constraint: int
        if (!is_null($itemCountInData) && !(is_int($itemCountInData) || ctype_digit($itemCountInData))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($itemCountInData, true), gettype($itemCountInData)), __LINE__);
        }
        $this->ItemCountInData = $itemCountInData;
        return $this;
    }
    /**
     * Get SerializationMethod value
     * @return string[]|null
     */
    public function getSerializationMethod()
    {
        return $this->SerializationMethod;
    }
    /**
     * This method is responsible for validating the values passed to the setSerializationMethod method
     * This method is willingly generated in order to preserve the one-line inline validation within the setSerializationMethod method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateSerializationMethodForArrayConstraintsFromSetSerializationMethod(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $serializedCompactListBaseSerializationMethodItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\CompactListSerializationMethod::valueIsValid($serializedCompactListBaseSerializationMethodItem)) {
                $invalidValues[] = is_object($serializedCompactListBaseSerializationMethodItem) ? get_class($serializedCompactListBaseSerializationMethodItem) : sprintf('%s(%s)', gettype($serializedCompactListBaseSerializationMethodItem), var_export($serializedCompactListBaseSerializationMethodItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CompactListSerializationMethod', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\CompactListSerializationMethod::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set SerializationMethod value
     * @uses \patest\EnumType\CompactListSerializationMethod::valueIsValid()
     * @uses \patest\EnumType\CompactListSerializationMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $serializationMethod
     * @return \patest\StructType\SerializedCompactListBase
     */
    public function setSerializationMethod(array $serializationMethod = array())
    {
        // validation for constraint: list
        if ('' !== ($serializationMethodArrayErrorMessage = self::validateSerializationMethodForArrayConstraintsFromSetSerializationMethod($serializationMethod))) {
            throw new \InvalidArgumentException($serializationMethodArrayErrorMessage, __LINE__);
        }
        $this->SerializationMethod = is_array($serializationMethod) ? implode(' ', $serializationMethod) : null;
        return $this;
    }
}
