<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SerializedCompactIntList StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SerializedCompactIntList
 * @subpackage Structs
 */
class SerializedCompactIntList extends SerializedCompactListOfint
{
    /**
     * The BaseValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $BaseValue;
    /**
     * The DefaultValue
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DefaultValue;
    /**
     * Constructor method for SerializedCompactIntList
     * @uses SerializedCompactIntList::setBaseValue()
     * @uses SerializedCompactIntList::setDefaultValue()
     * @param int $baseValue
     * @param int $defaultValue
     */
    public function __construct($baseValue = null, $defaultValue = null)
    {
        $this
            ->setBaseValue($baseValue)
            ->setDefaultValue($defaultValue);
    }
    /**
     * Get BaseValue value
     * @return int|null
     */
    public function getBaseValue()
    {
        return $this->BaseValue;
    }
    /**
     * Set BaseValue value
     * @param int $baseValue
     * @return \patest\StructType\SerializedCompactIntList
     */
    public function setBaseValue($baseValue = null)
    {
        // validation for constraint: int
        if (!is_null($baseValue) && !(is_int($baseValue) || ctype_digit($baseValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($baseValue, true), gettype($baseValue)), __LINE__);
        }
        $this->BaseValue = $baseValue;
        return $this;
    }
    /**
     * Get DefaultValue value
     * @return int|null
     */
    public function getDefaultValue()
    {
        return $this->DefaultValue;
    }
    /**
     * Set DefaultValue value
     * @param int $defaultValue
     * @return \patest\StructType\SerializedCompactIntList
     */
    public function setDefaultValue($defaultValue = null)
    {
        // validation for constraint: int
        if (!is_null($defaultValue) && !(is_int($defaultValue) || ctype_digit($defaultValue))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($defaultValue, true), gettype($defaultValue)), __LINE__);
        }
        $this->DefaultValue = $defaultValue;
        return $this;
    }
}
