<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendToPrintRequestBase StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SendToPrintRequestBase
 * @subpackage Structs
 */
class SendToPrintRequestBase extends ExtensibleDataContract
{
    /**
     * The TargetPrinterId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetPrinterId;
    /**
     * The TargetPrinterTrayId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $TargetPrinterTrayId;
    /**
     * Constructor method for SendToPrintRequestBase
     * @uses SendToPrintRequestBase::setTargetPrinterId()
     * @uses SendToPrintRequestBase::setTargetPrinterTrayId()
     * @param string $targetPrinterId
     * @param string $targetPrinterTrayId
     */
    public function __construct($targetPrinterId = null, $targetPrinterTrayId = null)
    {
        $this
            ->setTargetPrinterId($targetPrinterId)
            ->setTargetPrinterTrayId($targetPrinterTrayId);
    }
    /**
     * Get TargetPrinterId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetPrinterId()
    {
        return isset($this->TargetPrinterId) ? $this->TargetPrinterId : null;
    }
    /**
     * Set TargetPrinterId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetPrinterId
     * @return \patest\StructType\SendToPrintRequestBase
     */
    public function setTargetPrinterId($targetPrinterId = null)
    {
        // validation for constraint: string
        if (!is_null($targetPrinterId) && !is_string($targetPrinterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetPrinterId, true), gettype($targetPrinterId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetPrinterId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetPrinterId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetPrinterId, true)), __LINE__);
        }
        if (is_null($targetPrinterId) || (is_array($targetPrinterId) && empty($targetPrinterId))) {
            unset($this->TargetPrinterId);
        } else {
            $this->TargetPrinterId = $targetPrinterId;
        }
        return $this;
    }
    /**
     * Get TargetPrinterTrayId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTargetPrinterTrayId()
    {
        return isset($this->TargetPrinterTrayId) ? $this->TargetPrinterTrayId : null;
    }
    /**
     * Set TargetPrinterTrayId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $targetPrinterTrayId
     * @return \patest\StructType\SendToPrintRequestBase
     */
    public function setTargetPrinterTrayId($targetPrinterTrayId = null)
    {
        // validation for constraint: string
        if (!is_null($targetPrinterTrayId) && !is_string($targetPrinterTrayId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($targetPrinterTrayId, true), gettype($targetPrinterTrayId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($targetPrinterTrayId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $targetPrinterTrayId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($targetPrinterTrayId, true)), __LINE__);
        }
        if (is_null($targetPrinterTrayId) || (is_array($targetPrinterTrayId) && empty($targetPrinterTrayId))) {
            unset($this->TargetPrinterTrayId);
        } else {
            $this->TargetPrinterTrayId = $targetPrinterTrayId;
        }
        return $this;
    }
}
