<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SendBasketToPrintStandalone-Request StructType
 * Meta information extracted from the WSDL
 * - nillable: true
 * - type: tns:SendBasketToPrintStandalone-Request
 * @subpackage Structs
 */
class SendBasketToPrintStandalone_Request extends SendBasketToPrint_Request
{
    /**
     * The DocumentTypesToPrint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\ArrayType\ArrayOfstring
     */
    public $DocumentTypesToPrint;
    /**
     * The KeepOriginalBarcodesOnReprint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $KeepOriginalBarcodesOnReprint;
    /**
     * The Reprint
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Reprint;
    /**
     * The StandAlonePrintingScenario
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $StandAlonePrintingScenario;
    /**
     * Constructor method for SendBasketToPrintStandalone-Request
     * @uses SendBasketToPrintStandalone_Request::setDocumentTypesToPrint()
     * @uses SendBasketToPrintStandalone_Request::setKeepOriginalBarcodesOnReprint()
     * @uses SendBasketToPrintStandalone_Request::setReprint()
     * @uses SendBasketToPrintStandalone_Request::setStandAlonePrintingScenario()
     * @param \patest\ArrayType\ArrayOfstring $documentTypesToPrint
     * @param bool $keepOriginalBarcodesOnReprint
     * @param bool $reprint
     * @param string $standAlonePrintingScenario
     */
    public function __construct(\patest\ArrayType\ArrayOfstring $documentTypesToPrint = null, $keepOriginalBarcodesOnReprint = null, $reprint = null, $standAlonePrintingScenario = null)
    {
        $this
            ->setDocumentTypesToPrint($documentTypesToPrint)
            ->setKeepOriginalBarcodesOnReprint($keepOriginalBarcodesOnReprint)
            ->setReprint($reprint)
            ->setStandAlonePrintingScenario($standAlonePrintingScenario);
    }
    /**
     * Get DocumentTypesToPrint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\ArrayType\ArrayOfstring|null
     */
    public function getDocumentTypesToPrint()
    {
        return isset($this->DocumentTypesToPrint) ? $this->DocumentTypesToPrint : null;
    }
    /**
     * Set DocumentTypesToPrint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\ArrayType\ArrayOfstring $documentTypesToPrint
     * @return \patest\StructType\SendBasketToPrintStandalone_Request
     */
    public function setDocumentTypesToPrint(\patest\ArrayType\ArrayOfstring $documentTypesToPrint = null)
    {
        if (is_null($documentTypesToPrint) || (is_array($documentTypesToPrint) && empty($documentTypesToPrint))) {
            unset($this->DocumentTypesToPrint);
        } else {
            $this->DocumentTypesToPrint = $documentTypesToPrint;
        }
        return $this;
    }
    /**
     * Get KeepOriginalBarcodesOnReprint value
     * @return bool|null
     */
    public function getKeepOriginalBarcodesOnReprint()
    {
        return $this->KeepOriginalBarcodesOnReprint;
    }
    /**
     * Set KeepOriginalBarcodesOnReprint value
     * @param bool $keepOriginalBarcodesOnReprint
     * @return \patest\StructType\SendBasketToPrintStandalone_Request
     */
    public function setKeepOriginalBarcodesOnReprint($keepOriginalBarcodesOnReprint = null)
    {
        // validation for constraint: boolean
        if (!is_null($keepOriginalBarcodesOnReprint) && !is_bool($keepOriginalBarcodesOnReprint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($keepOriginalBarcodesOnReprint, true), gettype($keepOriginalBarcodesOnReprint)), __LINE__);
        }
        $this->KeepOriginalBarcodesOnReprint = $keepOriginalBarcodesOnReprint;
        return $this;
    }
    /**
     * Get Reprint value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getReprint()
    {
        return isset($this->Reprint) ? $this->Reprint : null;
    }
    /**
     * Set Reprint value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $reprint
     * @return \patest\StructType\SendBasketToPrintStandalone_Request
     */
    public function setReprint($reprint = null)
    {
        // validation for constraint: boolean
        if (!is_null($reprint) && !is_bool($reprint)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($reprint, true), gettype($reprint)), __LINE__);
        }
        if (is_null($reprint) || (is_array($reprint) && empty($reprint))) {
            unset($this->Reprint);
        } else {
            $this->Reprint = $reprint;
        }
        return $this;
    }
    /**
     * Get StandAlonePrintingScenario value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStandAlonePrintingScenario()
    {
        return isset($this->StandAlonePrintingScenario) ? $this->StandAlonePrintingScenario : null;
    }
    /**
     * Set StandAlonePrintingScenario value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\StandAlonePrintingScenario::valueIsValid()
     * @uses \patest\EnumType\StandAlonePrintingScenario::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $standAlonePrintingScenario
     * @return \patest\StructType\SendBasketToPrintStandalone_Request
     */
    public function setStandAlonePrintingScenario($standAlonePrintingScenario = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\StandAlonePrintingScenario::valueIsValid($standAlonePrintingScenario)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\StandAlonePrintingScenario', is_array($standAlonePrintingScenario) ? implode(', ', $standAlonePrintingScenario) : var_export($standAlonePrintingScenario, true), implode(', ', \patest\EnumType\StandAlonePrintingScenario::getValidValues())), __LINE__);
        }
        if (is_null($standAlonePrintingScenario) || (is_array($standAlonePrintingScenario) && empty($standAlonePrintingScenario))) {
            unset($this->StandAlonePrintingScenario);
        } else {
            $this->StandAlonePrintingScenario = $standAlonePrintingScenario;
        }
        return $this;
    }
}
