<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.UserProfile StructType
 * @subpackage Structs
 */
class Security_UserProfile extends PersistableEntity
{
    /**
     * The CanCustomFromScreen
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanCustomFromScreen;
    /**
     * The CreationAuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CreationAuditId;
    /**
     * The CreationDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CreationDate;
    /**
     * The Description
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Description;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The LastModifiedAuditId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $LastModifiedAuditId;
    /**
     * The LastModifiedDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LastModifiedDate;
    /**
     * The Name
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $Name;
    /**
     * The OperationsThatRequireSpecialPermission
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string[]
     */
    public $OperationsThatRequireSpecialPermission;
    /**
     * The OperationsThatRequireSpecialPermissionAsString
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OperationsThatRequireSpecialPermissionAsString;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The UserMayGrantPermissionForSomeOperations
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UserMayGrantPermissionForSomeOperations;
    /**
     * The VisibleBySubordinates
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VisibleBySubordinates;
    /**
     * Constructor method for Security.UserProfile
     * @uses Security_UserProfile::setCanCustomFromScreen()
     * @uses Security_UserProfile::setCreationAuditId()
     * @uses Security_UserProfile::setCreationDate()
     * @uses Security_UserProfile::setDescription()
     * @uses Security_UserProfile::setIsActive()
     * @uses Security_UserProfile::setLastModifiedAuditId()
     * @uses Security_UserProfile::setLastModifiedDate()
     * @uses Security_UserProfile::setName()
     * @uses Security_UserProfile::setOperationsThatRequireSpecialPermission()
     * @uses Security_UserProfile::setOperationsThatRequireSpecialPermissionAsString()
     * @uses Security_UserProfile::setOrganizationUnitId()
     * @uses Security_UserProfile::setUserMayGrantPermissionForSomeOperations()
     * @uses Security_UserProfile::setVisibleBySubordinates()
     * @param bool $canCustomFromScreen
     * @param int $creationAuditId
     * @param string $creationDate
     * @param string $description
     * @param bool $isActive
     * @param int $lastModifiedAuditId
     * @param string $lastModifiedDate
     * @param \patest\StructType\GlobalString $name
     * @param string[] $operationsThatRequireSpecialPermission
     * @param string $operationsThatRequireSpecialPermissionAsString
     * @param string $organizationUnitId
     * @param bool $userMayGrantPermissionForSomeOperations
     * @param bool $visibleBySubordinates
     */
    public function __construct($canCustomFromScreen = null, $creationAuditId = null, $creationDate = null, $description = null, $isActive = null, $lastModifiedAuditId = null, $lastModifiedDate = null, \patest\StructType\GlobalString $name = null, array $operationsThatRequireSpecialPermission = array(), $operationsThatRequireSpecialPermissionAsString = null, $organizationUnitId = null, $userMayGrantPermissionForSomeOperations = null, $visibleBySubordinates = null)
    {
        $this
            ->setCanCustomFromScreen($canCustomFromScreen)
            ->setCreationAuditId($creationAuditId)
            ->setCreationDate($creationDate)
            ->setDescription($description)
            ->setIsActive($isActive)
            ->setLastModifiedAuditId($lastModifiedAuditId)
            ->setLastModifiedDate($lastModifiedDate)
            ->setName($name)
            ->setOperationsThatRequireSpecialPermission($operationsThatRequireSpecialPermission)
            ->setOperationsThatRequireSpecialPermissionAsString($operationsThatRequireSpecialPermissionAsString)
            ->setOrganizationUnitId($organizationUnitId)
            ->setUserMayGrantPermissionForSomeOperations($userMayGrantPermissionForSomeOperations)
            ->setVisibleBySubordinates($visibleBySubordinates);
    }
    /**
     * Get CanCustomFromScreen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanCustomFromScreen()
    {
        return isset($this->CanCustomFromScreen) ? $this->CanCustomFromScreen : null;
    }
    /**
     * Set CanCustomFromScreen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canCustomFromScreen
     * @return \patest\StructType\Security_UserProfile
     */
    public function setCanCustomFromScreen($canCustomFromScreen = null)
    {
        // validation for constraint: boolean
        if (!is_null($canCustomFromScreen) && !is_bool($canCustomFromScreen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canCustomFromScreen, true), gettype($canCustomFromScreen)), __LINE__);
        }
        if (is_null($canCustomFromScreen) || (is_array($canCustomFromScreen) && empty($canCustomFromScreen))) {
            unset($this->CanCustomFromScreen);
        } else {
            $this->CanCustomFromScreen = $canCustomFromScreen;
        }
        return $this;
    }
    /**
     * Get CreationAuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCreationAuditId()
    {
        return isset($this->CreationAuditId) ? $this->CreationAuditId : null;
    }
    /**
     * Set CreationAuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $creationAuditId
     * @return \patest\StructType\Security_UserProfile
     */
    public function setCreationAuditId($creationAuditId = null)
    {
        // validation for constraint: int
        if (!is_null($creationAuditId) && !(is_int($creationAuditId) || ctype_digit($creationAuditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($creationAuditId, true), gettype($creationAuditId)), __LINE__);
        }
        if (is_null($creationAuditId) || (is_array($creationAuditId) && empty($creationAuditId))) {
            unset($this->CreationAuditId);
        } else {
            $this->CreationAuditId = $creationAuditId;
        }
        return $this;
    }
    /**
     * Get CreationDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCreationDate()
    {
        return isset($this->CreationDate) ? $this->CreationDate : null;
    }
    /**
     * Set CreationDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $creationDate
     * @return \patest\StructType\Security_UserProfile
     */
    public function setCreationDate($creationDate = null)
    {
        // validation for constraint: string
        if (!is_null($creationDate) && !is_string($creationDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($creationDate, true), gettype($creationDate)), __LINE__);
        }
        if (is_null($creationDate) || (is_array($creationDate) && empty($creationDate))) {
            unset($this->CreationDate);
        } else {
            $this->CreationDate = $creationDate;
        }
        return $this;
    }
    /**
     * Get Description value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescription()
    {
        return isset($this->Description) ? $this->Description : null;
    }
    /**
     * Set Description value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $description
     * @return \patest\StructType\Security_UserProfile
     */
    public function setDescription($description = null)
    {
        // validation for constraint: string
        if (!is_null($description) && !is_string($description)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($description, true), gettype($description)), __LINE__);
        }
        if (is_null($description) || (is_array($description) && empty($description))) {
            unset($this->Description);
        } else {
            $this->Description = $description;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Security_UserProfile
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get LastModifiedAuditId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getLastModifiedAuditId()
    {
        return isset($this->LastModifiedAuditId) ? $this->LastModifiedAuditId : null;
    }
    /**
     * Set LastModifiedAuditId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $lastModifiedAuditId
     * @return \patest\StructType\Security_UserProfile
     */
    public function setLastModifiedAuditId($lastModifiedAuditId = null)
    {
        // validation for constraint: int
        if (!is_null($lastModifiedAuditId) && !(is_int($lastModifiedAuditId) || ctype_digit($lastModifiedAuditId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($lastModifiedAuditId, true), gettype($lastModifiedAuditId)), __LINE__);
        }
        if (is_null($lastModifiedAuditId) || (is_array($lastModifiedAuditId) && empty($lastModifiedAuditId))) {
            unset($this->LastModifiedAuditId);
        } else {
            $this->LastModifiedAuditId = $lastModifiedAuditId;
        }
        return $this;
    }
    /**
     * Get LastModifiedDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLastModifiedDate()
    {
        return isset($this->LastModifiedDate) ? $this->LastModifiedDate : null;
    }
    /**
     * Set LastModifiedDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lastModifiedDate
     * @return \patest\StructType\Security_UserProfile
     */
    public function setLastModifiedDate($lastModifiedDate = null)
    {
        // validation for constraint: string
        if (!is_null($lastModifiedDate) && !is_string($lastModifiedDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($lastModifiedDate, true), gettype($lastModifiedDate)), __LINE__);
        }
        if (is_null($lastModifiedDate) || (is_array($lastModifiedDate) && empty($lastModifiedDate))) {
            unset($this->LastModifiedDate);
        } else {
            $this->LastModifiedDate = $lastModifiedDate;
        }
        return $this;
    }
    /**
     * Get Name value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getName()
    {
        return isset($this->Name) ? $this->Name : null;
    }
    /**
     * Set Name value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $name
     * @return \patest\StructType\Security_UserProfile
     */
    public function setName(\patest\StructType\GlobalString $name = null)
    {
        if (is_null($name) || (is_array($name) && empty($name))) {
            unset($this->Name);
        } else {
            $this->Name = $name;
        }
        return $this;
    }
    /**
     * Get OperationsThatRequireSpecialPermission value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string[]|null
     */
    public function getOperationsThatRequireSpecialPermission()
    {
        return isset($this->OperationsThatRequireSpecialPermission) ? $this->OperationsThatRequireSpecialPermission : null;
    }
    /**
     * This method is responsible for validating the values passed to the setOperationsThatRequireSpecialPermission method
     * This method is willingly generated in order to preserve the one-line inline validation within the setOperationsThatRequireSpecialPermission method
     * @param array $values
     * @return string A non-empty message if the values does not match the validation rules
     */
    public static function validateOperationsThatRequireSpecialPermissionForArrayConstraintsFromSetOperationsThatRequireSpecialPermission(array $values = array())
    {
        $message = '';
        $invalidValues = [];
        foreach ($values as $security_UserProfileOperationsThatRequireSpecialPermissionItem) {
            // validation for constraint: enumeration
            if (!\patest\EnumType\OperationForApprovalType::valueIsValid($security_UserProfileOperationsThatRequireSpecialPermissionItem)) {
                $invalidValues[] = is_object($security_UserProfileOperationsThatRequireSpecialPermissionItem) ? get_class($security_UserProfileOperationsThatRequireSpecialPermissionItem) : sprintf('%s(%s)', gettype($security_UserProfileOperationsThatRequireSpecialPermissionItem), var_export($security_UserProfileOperationsThatRequireSpecialPermissionItem, true));
            }
        }
        if (!empty($invalidValues)) {
            $message = sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\OperationForApprovalType', is_array($invalidValues) ? implode(', ', $invalidValues) : var_export($invalidValues, true), implode(', ', \patest\EnumType\OperationForApprovalType::getValidValues()));
        }
        unset($invalidValues);
        return $message;
    }
    /**
     * Set OperationsThatRequireSpecialPermission value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\OperationForApprovalType::valueIsValid()
     * @uses \patest\EnumType\OperationForApprovalType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string[] $operationsThatRequireSpecialPermission
     * @return \patest\StructType\Security_UserProfile
     */
    public function setOperationsThatRequireSpecialPermission(array $operationsThatRequireSpecialPermission = array())
    {
        // validation for constraint: list
        if ('' !== ($operationsThatRequireSpecialPermissionArrayErrorMessage = self::validateOperationsThatRequireSpecialPermissionForArrayConstraintsFromSetOperationsThatRequireSpecialPermission($operationsThatRequireSpecialPermission))) {
            throw new \InvalidArgumentException($operationsThatRequireSpecialPermissionArrayErrorMessage, __LINE__);
        }
        if (is_null($operationsThatRequireSpecialPermission) || (is_array($operationsThatRequireSpecialPermission) && empty($operationsThatRequireSpecialPermission))) {
            unset($this->OperationsThatRequireSpecialPermission);
        } else {
            $this->OperationsThatRequireSpecialPermission = is_array($operationsThatRequireSpecialPermission) ? implode(' ', $operationsThatRequireSpecialPermission) : null;
        }
        return $this;
    }
    /**
     * Get OperationsThatRequireSpecialPermissionAsString value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOperationsThatRequireSpecialPermissionAsString()
    {
        return isset($this->OperationsThatRequireSpecialPermissionAsString) ? $this->OperationsThatRequireSpecialPermissionAsString : null;
    }
    /**
     * Set OperationsThatRequireSpecialPermissionAsString value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $operationsThatRequireSpecialPermissionAsString
     * @return \patest\StructType\Security_UserProfile
     */
    public function setOperationsThatRequireSpecialPermissionAsString($operationsThatRequireSpecialPermissionAsString = null)
    {
        // validation for constraint: string
        if (!is_null($operationsThatRequireSpecialPermissionAsString) && !is_string($operationsThatRequireSpecialPermissionAsString)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($operationsThatRequireSpecialPermissionAsString, true), gettype($operationsThatRequireSpecialPermissionAsString)), __LINE__);
        }
        if (is_null($operationsThatRequireSpecialPermissionAsString) || (is_array($operationsThatRequireSpecialPermissionAsString) && empty($operationsThatRequireSpecialPermissionAsString))) {
            unset($this->OperationsThatRequireSpecialPermissionAsString);
        } else {
            $this->OperationsThatRequireSpecialPermissionAsString = $operationsThatRequireSpecialPermissionAsString;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Security_UserProfile
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get UserMayGrantPermissionForSomeOperations value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUserMayGrantPermissionForSomeOperations()
    {
        return isset($this->UserMayGrantPermissionForSomeOperations) ? $this->UserMayGrantPermissionForSomeOperations : null;
    }
    /**
     * Set UserMayGrantPermissionForSomeOperations value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $userMayGrantPermissionForSomeOperations
     * @return \patest\StructType\Security_UserProfile
     */
    public function setUserMayGrantPermissionForSomeOperations($userMayGrantPermissionForSomeOperations = null)
    {
        // validation for constraint: boolean
        if (!is_null($userMayGrantPermissionForSomeOperations) && !is_bool($userMayGrantPermissionForSomeOperations)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($userMayGrantPermissionForSomeOperations, true), gettype($userMayGrantPermissionForSomeOperations)), __LINE__);
        }
        if (is_null($userMayGrantPermissionForSomeOperations) || (is_array($userMayGrantPermissionForSomeOperations) && empty($userMayGrantPermissionForSomeOperations))) {
            unset($this->UserMayGrantPermissionForSomeOperations);
        } else {
            $this->UserMayGrantPermissionForSomeOperations = $userMayGrantPermissionForSomeOperations;
        }
        return $this;
    }
    /**
     * Get VisibleBySubordinates value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVisibleBySubordinates()
    {
        return isset($this->VisibleBySubordinates) ? $this->VisibleBySubordinates : null;
    }
    /**
     * Set VisibleBySubordinates value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $visibleBySubordinates
     * @return \patest\StructType\Security_UserProfile
     */
    public function setVisibleBySubordinates($visibleBySubordinates = null)
    {
        // validation for constraint: boolean
        if (!is_null($visibleBySubordinates) && !is_bool($visibleBySubordinates)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($visibleBySubordinates, true), gettype($visibleBySubordinates)), __LINE__);
        }
        if (is_null($visibleBySubordinates) || (is_array($visibleBySubordinates) && empty($visibleBySubordinates))) {
            unset($this->VisibleBySubordinates);
        } else {
            $this->VisibleBySubordinates = $visibleBySubordinates;
        }
        return $this;
    }
}
