<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.UserDepartmentXref StructType
 * @subpackage Structs
 */
class Security_UserDepartmentXref extends AnyEntity
{
    /**
     * The DepartmentGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DepartmentGuid;
    /**
     * The HolderCompanyId
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $HolderCompanyId;
    /**
     * The UserGuid
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $UserGuid;
    /**
     * Constructor method for Security.UserDepartmentXref
     * @uses Security_UserDepartmentXref::setDepartmentGuid()
     * @uses Security_UserDepartmentXref::setHolderCompanyId()
     * @uses Security_UserDepartmentXref::setUserGuid()
     * @param string $departmentGuid
     * @param int $holderCompanyId
     * @param string $userGuid
     */
    public function __construct($departmentGuid = null, $holderCompanyId = null, $userGuid = null)
    {
        $this
            ->setDepartmentGuid($departmentGuid)
            ->setHolderCompanyId($holderCompanyId)
            ->setUserGuid($userGuid);
    }
    /**
     * Get DepartmentGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDepartmentGuid()
    {
        return isset($this->DepartmentGuid) ? $this->DepartmentGuid : null;
    }
    /**
     * Set DepartmentGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $departmentGuid
     * @return \patest\StructType\Security_UserDepartmentXref
     */
    public function setDepartmentGuid($departmentGuid = null)
    {
        // validation for constraint: string
        if (!is_null($departmentGuid) && !is_string($departmentGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($departmentGuid, true), gettype($departmentGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($departmentGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $departmentGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($departmentGuid, true)), __LINE__);
        }
        if (is_null($departmentGuid) || (is_array($departmentGuid) && empty($departmentGuid))) {
            unset($this->DepartmentGuid);
        } else {
            $this->DepartmentGuid = $departmentGuid;
        }
        return $this;
    }
    /**
     * Get HolderCompanyId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getHolderCompanyId()
    {
        return isset($this->HolderCompanyId) ? $this->HolderCompanyId : null;
    }
    /**
     * Set HolderCompanyId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $holderCompanyId
     * @return \patest\StructType\Security_UserDepartmentXref
     */
    public function setHolderCompanyId($holderCompanyId = null)
    {
        // validation for constraint: int
        if (!is_null($holderCompanyId) && !(is_int($holderCompanyId) || ctype_digit($holderCompanyId))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($holderCompanyId, true), gettype($holderCompanyId)), __LINE__);
        }
        if (is_null($holderCompanyId) || (is_array($holderCompanyId) && empty($holderCompanyId))) {
            unset($this->HolderCompanyId);
        } else {
            $this->HolderCompanyId = $holderCompanyId;
        }
        return $this;
    }
    /**
     * Get UserGuid value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserGuid()
    {
        return isset($this->UserGuid) ? $this->UserGuid : null;
    }
    /**
     * Set UserGuid value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userGuid
     * @return \patest\StructType\Security_UserDepartmentXref
     */
    public function setUserGuid($userGuid = null)
    {
        // validation for constraint: string
        if (!is_null($userGuid) && !is_string($userGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userGuid, true), gettype($userGuid)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($userGuid) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $userGuid)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($userGuid, true)), __LINE__);
        }
        if (is_null($userGuid) || (is_array($userGuid) && empty($userGuid))) {
            unset($this->UserGuid);
        } else {
            $this->UserGuid = $userGuid;
        }
        return $this;
    }
}
