<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.User StructType
 * @subpackage Structs
 */
class Security_User extends MaintainableNotDistributableEntity
{
    /**
     * The AffiliateAccountId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AffiliateAccountId;
    /**
     * The AllowChangeTill
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowChangeTill;
    /**
     * The AllowCloseTills
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AllowCloseTills;
    /**
     * The AllowedToImpersonate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AllowedToImpersonate;
    /**
     * The AllowMultiStationLogin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowMultiStationLogin;
    /**
     * The AllowPrintTicketsMinutesAfterEventStarts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AllowPrintTicketsMinutesAfterEventStarts;
    /**
     * The AuthenticationData
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Security_UpdateUserAuthenticationData
     */
    public $AuthenticationData;
    /**
     * The AuthorizationKey
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AuthorizationKey;
    /**
     * The AvailableRoles
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\RecordSetOfSecurity_UserRole
     */
    public $AvailableRoles;
    /**
     * The BelongsToDepartments
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\BelongsToDepartments
     */
    public $BelongsToDepartments;
    /**
     * The CanChangeOrganizationUnit
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanChangeOrganizationUnit;
    /**
     * The CanLogin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanLogin;
    /**
     * The Culture
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Culture;
    /**
     * The DefaultTillId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefaultTillId;
    /**
     * The EmailAddress
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EmailAddress;
    /**
     * The IsActive
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsActive;
    /**
     * The IsInternal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsInternal;
    /**
     * The IsSystem
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSystem;
    /**
     * The IsUsingSeatGeekConnector
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsUsingSeatGeekConnector;
    /**
     * The OrganizationUnitId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $OrganizationUnitId;
    /**
     * The ProfileId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProfileId;
    /**
     * The SecurityTokenId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SecurityTokenId;
    /**
     * The UserImageId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserImageId;
    /**
     * The UserInterfaceId
     * Meta information extracted from the WSDL
     * - documentation: Calculated.
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserInterfaceId;
    /**
     * The UserType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UserType;
    /**
     * Constructor method for Security.User
     * @uses Security_User::setAffiliateAccountId()
     * @uses Security_User::setAllowChangeTill()
     * @uses Security_User::setAllowCloseTills()
     * @uses Security_User::setAllowedToImpersonate()
     * @uses Security_User::setAllowMultiStationLogin()
     * @uses Security_User::setAllowPrintTicketsMinutesAfterEventStarts()
     * @uses Security_User::setAuthenticationData()
     * @uses Security_User::setAuthorizationKey()
     * @uses Security_User::setAvailableRoles()
     * @uses Security_User::setBelongsToDepartments()
     * @uses Security_User::setCanChangeOrganizationUnit()
     * @uses Security_User::setCanLogin()
     * @uses Security_User::setCulture()
     * @uses Security_User::setDefaultTillId()
     * @uses Security_User::setEmailAddress()
     * @uses Security_User::setIsActive()
     * @uses Security_User::setIsInternal()
     * @uses Security_User::setIsSystem()
     * @uses Security_User::setIsUsingSeatGeekConnector()
     * @uses Security_User::setOrganizationUnitId()
     * @uses Security_User::setProfileId()
     * @uses Security_User::setSecurityTokenId()
     * @uses Security_User::setUserImageId()
     * @uses Security_User::setUserInterfaceId()
     * @uses Security_User::setUserType()
     * @param string $affiliateAccountId
     * @param bool $allowChangeTill
     * @param string $allowCloseTills
     * @param string $allowedToImpersonate
     * @param bool $allowMultiStationLogin
     * @param int $allowPrintTicketsMinutesAfterEventStarts
     * @param \patest\StructType\Security_UpdateUserAuthenticationData $authenticationData
     * @param string $authorizationKey
     * @param \patest\StructType\RecordSetOfSecurity_UserRole $availableRoles
     * @param \patest\StructType\BelongsToDepartments $belongsToDepartments
     * @param bool $canChangeOrganizationUnit
     * @param bool $canLogin
     * @param int $culture
     * @param string $defaultTillId
     * @param string $emailAddress
     * @param bool $isActive
     * @param bool $isInternal
     * @param bool $isSystem
     * @param bool $isUsingSeatGeekConnector
     * @param string $organizationUnitId
     * @param string $profileId
     * @param string $securityTokenId
     * @param string $userImageId
     * @param string $userInterfaceId
     * @param string $userType
     */
    public function __construct($affiliateAccountId = null, $allowChangeTill = null, $allowCloseTills = null, $allowedToImpersonate = null, $allowMultiStationLogin = null, $allowPrintTicketsMinutesAfterEventStarts = null, \patest\StructType\Security_UpdateUserAuthenticationData $authenticationData = null, $authorizationKey = null, \patest\StructType\RecordSetOfSecurity_UserRole $availableRoles = null, \patest\StructType\BelongsToDepartments $belongsToDepartments = null, $canChangeOrganizationUnit = null, $canLogin = null, $culture = null, $defaultTillId = null, $emailAddress = null, $isActive = null, $isInternal = null, $isSystem = null, $isUsingSeatGeekConnector = null, $organizationUnitId = null, $profileId = null, $securityTokenId = null, $userImageId = null, $userInterfaceId = null, $userType = null)
    {
        $this
            ->setAffiliateAccountId($affiliateAccountId)
            ->setAllowChangeTill($allowChangeTill)
            ->setAllowCloseTills($allowCloseTills)
            ->setAllowedToImpersonate($allowedToImpersonate)
            ->setAllowMultiStationLogin($allowMultiStationLogin)
            ->setAllowPrintTicketsMinutesAfterEventStarts($allowPrintTicketsMinutesAfterEventStarts)
            ->setAuthenticationData($authenticationData)
            ->setAuthorizationKey($authorizationKey)
            ->setAvailableRoles($availableRoles)
            ->setBelongsToDepartments($belongsToDepartments)
            ->setCanChangeOrganizationUnit($canChangeOrganizationUnit)
            ->setCanLogin($canLogin)
            ->setCulture($culture)
            ->setDefaultTillId($defaultTillId)
            ->setEmailAddress($emailAddress)
            ->setIsActive($isActive)
            ->setIsInternal($isInternal)
            ->setIsSystem($isSystem)
            ->setIsUsingSeatGeekConnector($isUsingSeatGeekConnector)
            ->setOrganizationUnitId($organizationUnitId)
            ->setProfileId($profileId)
            ->setSecurityTokenId($securityTokenId)
            ->setUserImageId($userImageId)
            ->setUserInterfaceId($userInterfaceId)
            ->setUserType($userType);
    }
    /**
     * Get AffiliateAccountId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAffiliateAccountId()
    {
        return isset($this->AffiliateAccountId) ? $this->AffiliateAccountId : null;
    }
    /**
     * Set AffiliateAccountId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $affiliateAccountId
     * @return \patest\StructType\Security_User
     */
    public function setAffiliateAccountId($affiliateAccountId = null)
    {
        // validation for constraint: string
        if (!is_null($affiliateAccountId) && !is_string($affiliateAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($affiliateAccountId, true), gettype($affiliateAccountId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($affiliateAccountId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $affiliateAccountId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($affiliateAccountId, true)), __LINE__);
        }
        if (is_null($affiliateAccountId) || (is_array($affiliateAccountId) && empty($affiliateAccountId))) {
            unset($this->AffiliateAccountId);
        } else {
            $this->AffiliateAccountId = $affiliateAccountId;
        }
        return $this;
    }
    /**
     * Get AllowChangeTill value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowChangeTill()
    {
        return isset($this->AllowChangeTill) ? $this->AllowChangeTill : null;
    }
    /**
     * Set AllowChangeTill value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowChangeTill
     * @return \patest\StructType\Security_User
     */
    public function setAllowChangeTill($allowChangeTill = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowChangeTill) && !is_bool($allowChangeTill)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowChangeTill, true), gettype($allowChangeTill)), __LINE__);
        }
        if (is_null($allowChangeTill) || (is_array($allowChangeTill) && empty($allowChangeTill))) {
            unset($this->AllowChangeTill);
        } else {
            $this->AllowChangeTill = $allowChangeTill;
        }
        return $this;
    }
    /**
     * Get AllowCloseTills value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAllowCloseTills()
    {
        return isset($this->AllowCloseTills) ? $this->AllowCloseTills : null;
    }
    /**
     * Set AllowCloseTills value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TillCloseOption::valueIsValid()
     * @uses \patest\EnumType\TillCloseOption::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $allowCloseTills
     * @return \patest\StructType\Security_User
     */
    public function setAllowCloseTills($allowCloseTills = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TillCloseOption::valueIsValid($allowCloseTills)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TillCloseOption', is_array($allowCloseTills) ? implode(', ', $allowCloseTills) : var_export($allowCloseTills, true), implode(', ', \patest\EnumType\TillCloseOption::getValidValues())), __LINE__);
        }
        if (is_null($allowCloseTills) || (is_array($allowCloseTills) && empty($allowCloseTills))) {
            unset($this->AllowCloseTills);
        } else {
            $this->AllowCloseTills = $allowCloseTills;
        }
        return $this;
    }
    /**
     * Get AllowedToImpersonate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAllowedToImpersonate()
    {
        return isset($this->AllowedToImpersonate) ? $this->AllowedToImpersonate : null;
    }
    /**
     * Set AllowedToImpersonate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $allowedToImpersonate
     * @return \patest\StructType\Security_User
     */
    public function setAllowedToImpersonate($allowedToImpersonate = null)
    {
        // validation for constraint: string
        if (!is_null($allowedToImpersonate) && !is_string($allowedToImpersonate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($allowedToImpersonate, true), gettype($allowedToImpersonate)), __LINE__);
        }
        if (is_null($allowedToImpersonate) || (is_array($allowedToImpersonate) && empty($allowedToImpersonate))) {
            unset($this->AllowedToImpersonate);
        } else {
            $this->AllowedToImpersonate = $allowedToImpersonate;
        }
        return $this;
    }
    /**
     * Get AllowMultiStationLogin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowMultiStationLogin()
    {
        return isset($this->AllowMultiStationLogin) ? $this->AllowMultiStationLogin : null;
    }
    /**
     * Set AllowMultiStationLogin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowMultiStationLogin
     * @return \patest\StructType\Security_User
     */
    public function setAllowMultiStationLogin($allowMultiStationLogin = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowMultiStationLogin) && !is_bool($allowMultiStationLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowMultiStationLogin, true), gettype($allowMultiStationLogin)), __LINE__);
        }
        if (is_null($allowMultiStationLogin) || (is_array($allowMultiStationLogin) && empty($allowMultiStationLogin))) {
            unset($this->AllowMultiStationLogin);
        } else {
            $this->AllowMultiStationLogin = $allowMultiStationLogin;
        }
        return $this;
    }
    /**
     * Get AllowPrintTicketsMinutesAfterEventStarts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAllowPrintTicketsMinutesAfterEventStarts()
    {
        return isset($this->AllowPrintTicketsMinutesAfterEventStarts) ? $this->AllowPrintTicketsMinutesAfterEventStarts : null;
    }
    /**
     * Set AllowPrintTicketsMinutesAfterEventStarts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $allowPrintTicketsMinutesAfterEventStarts
     * @return \patest\StructType\Security_User
     */
    public function setAllowPrintTicketsMinutesAfterEventStarts($allowPrintTicketsMinutesAfterEventStarts = null)
    {
        // validation for constraint: int
        if (!is_null($allowPrintTicketsMinutesAfterEventStarts) && !(is_int($allowPrintTicketsMinutesAfterEventStarts) || ctype_digit($allowPrintTicketsMinutesAfterEventStarts))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($allowPrintTicketsMinutesAfterEventStarts, true), gettype($allowPrintTicketsMinutesAfterEventStarts)), __LINE__);
        }
        if (is_null($allowPrintTicketsMinutesAfterEventStarts) || (is_array($allowPrintTicketsMinutesAfterEventStarts) && empty($allowPrintTicketsMinutesAfterEventStarts))) {
            unset($this->AllowPrintTicketsMinutesAfterEventStarts);
        } else {
            $this->AllowPrintTicketsMinutesAfterEventStarts = $allowPrintTicketsMinutesAfterEventStarts;
        }
        return $this;
    }
    /**
     * Get AuthenticationData value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Security_UpdateUserAuthenticationData|null
     */
    public function getAuthenticationData()
    {
        return isset($this->AuthenticationData) ? $this->AuthenticationData : null;
    }
    /**
     * Set AuthenticationData value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Security_UpdateUserAuthenticationData $authenticationData
     * @return \patest\StructType\Security_User
     */
    public function setAuthenticationData(\patest\StructType\Security_UpdateUserAuthenticationData $authenticationData = null)
    {
        if (is_null($authenticationData) || (is_array($authenticationData) && empty($authenticationData))) {
            unset($this->AuthenticationData);
        } else {
            $this->AuthenticationData = $authenticationData;
        }
        return $this;
    }
    /**
     * Get AuthorizationKey value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAuthorizationKey()
    {
        return isset($this->AuthorizationKey) ? $this->AuthorizationKey : null;
    }
    /**
     * Set AuthorizationKey value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $authorizationKey
     * @return \patest\StructType\Security_User
     */
    public function setAuthorizationKey($authorizationKey = null)
    {
        // validation for constraint: string
        if (!is_null($authorizationKey) && !is_string($authorizationKey)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($authorizationKey, true), gettype($authorizationKey)), __LINE__);
        }
        if (is_null($authorizationKey) || (is_array($authorizationKey) && empty($authorizationKey))) {
            unset($this->AuthorizationKey);
        } else {
            $this->AuthorizationKey = $authorizationKey;
        }
        return $this;
    }
    /**
     * Get AvailableRoles value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\RecordSetOfSecurity_UserRole|null
     */
    public function getAvailableRoles()
    {
        return isset($this->AvailableRoles) ? $this->AvailableRoles : null;
    }
    /**
     * Set AvailableRoles value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\RecordSetOfSecurity_UserRole $availableRoles
     * @return \patest\StructType\Security_User
     */
    public function setAvailableRoles(\patest\StructType\RecordSetOfSecurity_UserRole $availableRoles = null)
    {
        if (is_null($availableRoles) || (is_array($availableRoles) && empty($availableRoles))) {
            unset($this->AvailableRoles);
        } else {
            $this->AvailableRoles = $availableRoles;
        }
        return $this;
    }
    /**
     * Get BelongsToDepartments value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\BelongsToDepartments|null
     */
    public function getBelongsToDepartments()
    {
        return isset($this->BelongsToDepartments) ? $this->BelongsToDepartments : null;
    }
    /**
     * Set BelongsToDepartments value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\BelongsToDepartments $belongsToDepartments
     * @return \patest\StructType\Security_User
     */
    public function setBelongsToDepartments(\patest\StructType\BelongsToDepartments $belongsToDepartments = null)
    {
        if (is_null($belongsToDepartments) || (is_array($belongsToDepartments) && empty($belongsToDepartments))) {
            unset($this->BelongsToDepartments);
        } else {
            $this->BelongsToDepartments = $belongsToDepartments;
        }
        return $this;
    }
    /**
     * Get CanChangeOrganizationUnit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanChangeOrganizationUnit()
    {
        return isset($this->CanChangeOrganizationUnit) ? $this->CanChangeOrganizationUnit : null;
    }
    /**
     * Set CanChangeOrganizationUnit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canChangeOrganizationUnit
     * @return \patest\StructType\Security_User
     */
    public function setCanChangeOrganizationUnit($canChangeOrganizationUnit = null)
    {
        // validation for constraint: boolean
        if (!is_null($canChangeOrganizationUnit) && !is_bool($canChangeOrganizationUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canChangeOrganizationUnit, true), gettype($canChangeOrganizationUnit)), __LINE__);
        }
        if (is_null($canChangeOrganizationUnit) || (is_array($canChangeOrganizationUnit) && empty($canChangeOrganizationUnit))) {
            unset($this->CanChangeOrganizationUnit);
        } else {
            $this->CanChangeOrganizationUnit = $canChangeOrganizationUnit;
        }
        return $this;
    }
    /**
     * Get CanLogin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanLogin()
    {
        return isset($this->CanLogin) ? $this->CanLogin : null;
    }
    /**
     * Set CanLogin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canLogin
     * @return \patest\StructType\Security_User
     */
    public function setCanLogin($canLogin = null)
    {
        // validation for constraint: boolean
        if (!is_null($canLogin) && !is_bool($canLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canLogin, true), gettype($canLogin)), __LINE__);
        }
        if (is_null($canLogin) || (is_array($canLogin) && empty($canLogin))) {
            unset($this->CanLogin);
        } else {
            $this->CanLogin = $canLogin;
        }
        return $this;
    }
    /**
     * Get Culture value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCulture()
    {
        return isset($this->Culture) ? $this->Culture : null;
    }
    /**
     * Set Culture value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $culture
     * @return \patest\StructType\Security_User
     */
    public function setCulture($culture = null)
    {
        // validation for constraint: int
        if (!is_null($culture) && !(is_int($culture) || ctype_digit($culture))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($culture, true), gettype($culture)), __LINE__);
        }
        if (is_null($culture) || (is_array($culture) && empty($culture))) {
            unset($this->Culture);
        } else {
            $this->Culture = $culture;
        }
        return $this;
    }
    /**
     * Get DefaultTillId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultTillId()
    {
        return isset($this->DefaultTillId) ? $this->DefaultTillId : null;
    }
    /**
     * Set DefaultTillId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultTillId
     * @return \patest\StructType\Security_User
     */
    public function setDefaultTillId($defaultTillId = null)
    {
        // validation for constraint: string
        if (!is_null($defaultTillId) && !is_string($defaultTillId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultTillId, true), gettype($defaultTillId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($defaultTillId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $defaultTillId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($defaultTillId, true)), __LINE__);
        }
        if (is_null($defaultTillId) || (is_array($defaultTillId) && empty($defaultTillId))) {
            unset($this->DefaultTillId);
        } else {
            $this->DefaultTillId = $defaultTillId;
        }
        return $this;
    }
    /**
     * Get EmailAddress value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmailAddress()
    {
        return isset($this->EmailAddress) ? $this->EmailAddress : null;
    }
    /**
     * Set EmailAddress value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $emailAddress
     * @return \patest\StructType\Security_User
     */
    public function setEmailAddress($emailAddress = null)
    {
        // validation for constraint: string
        if (!is_null($emailAddress) && !is_string($emailAddress)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($emailAddress, true), gettype($emailAddress)), __LINE__);
        }
        if (is_null($emailAddress) || (is_array($emailAddress) && empty($emailAddress))) {
            unset($this->EmailAddress);
        } else {
            $this->EmailAddress = $emailAddress;
        }
        return $this;
    }
    /**
     * Get IsActive value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsActive()
    {
        return isset($this->IsActive) ? $this->IsActive : null;
    }
    /**
     * Set IsActive value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isActive
     * @return \patest\StructType\Security_User
     */
    public function setIsActive($isActive = null)
    {
        // validation for constraint: boolean
        if (!is_null($isActive) && !is_bool($isActive)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isActive, true), gettype($isActive)), __LINE__);
        }
        if (is_null($isActive) || (is_array($isActive) && empty($isActive))) {
            unset($this->IsActive);
        } else {
            $this->IsActive = $isActive;
        }
        return $this;
    }
    /**
     * Get IsInternal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsInternal()
    {
        return isset($this->IsInternal) ? $this->IsInternal : null;
    }
    /**
     * Set IsInternal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isInternal
     * @return \patest\StructType\Security_User
     */
    public function setIsInternal($isInternal = null)
    {
        // validation for constraint: boolean
        if (!is_null($isInternal) && !is_bool($isInternal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isInternal, true), gettype($isInternal)), __LINE__);
        }
        if (is_null($isInternal) || (is_array($isInternal) && empty($isInternal))) {
            unset($this->IsInternal);
        } else {
            $this->IsInternal = $isInternal;
        }
        return $this;
    }
    /**
     * Get IsSystem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSystem()
    {
        return isset($this->IsSystem) ? $this->IsSystem : null;
    }
    /**
     * Set IsSystem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSystem
     * @return \patest\StructType\Security_User
     */
    public function setIsSystem($isSystem = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSystem) && !is_bool($isSystem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSystem, true), gettype($isSystem)), __LINE__);
        }
        if (is_null($isSystem) || (is_array($isSystem) && empty($isSystem))) {
            unset($this->IsSystem);
        } else {
            $this->IsSystem = $isSystem;
        }
        return $this;
    }
    /**
     * Get IsUsingSeatGeekConnector value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsUsingSeatGeekConnector()
    {
        return isset($this->IsUsingSeatGeekConnector) ? $this->IsUsingSeatGeekConnector : null;
    }
    /**
     * Set IsUsingSeatGeekConnector value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isUsingSeatGeekConnector
     * @return \patest\StructType\Security_User
     */
    public function setIsUsingSeatGeekConnector($isUsingSeatGeekConnector = null)
    {
        // validation for constraint: boolean
        if (!is_null($isUsingSeatGeekConnector) && !is_bool($isUsingSeatGeekConnector)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isUsingSeatGeekConnector, true), gettype($isUsingSeatGeekConnector)), __LINE__);
        }
        if (is_null($isUsingSeatGeekConnector) || (is_array($isUsingSeatGeekConnector) && empty($isUsingSeatGeekConnector))) {
            unset($this->IsUsingSeatGeekConnector);
        } else {
            $this->IsUsingSeatGeekConnector = $isUsingSeatGeekConnector;
        }
        return $this;
    }
    /**
     * Get OrganizationUnitId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganizationUnitId()
    {
        return isset($this->OrganizationUnitId) ? $this->OrganizationUnitId : null;
    }
    /**
     * Set OrganizationUnitId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organizationUnitId
     * @return \patest\StructType\Security_User
     */
    public function setOrganizationUnitId($organizationUnitId = null)
    {
        // validation for constraint: string
        if (!is_null($organizationUnitId) && !is_string($organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($organizationUnitId, true), gettype($organizationUnitId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($organizationUnitId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $organizationUnitId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($organizationUnitId, true)), __LINE__);
        }
        if (is_null($organizationUnitId) || (is_array($organizationUnitId) && empty($organizationUnitId))) {
            unset($this->OrganizationUnitId);
        } else {
            $this->OrganizationUnitId = $organizationUnitId;
        }
        return $this;
    }
    /**
     * Get ProfileId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProfileId()
    {
        return isset($this->ProfileId) ? $this->ProfileId : null;
    }
    /**
     * Set ProfileId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $profileId
     * @return \patest\StructType\Security_User
     */
    public function setProfileId($profileId = null)
    {
        // validation for constraint: string
        if (!is_null($profileId) && !is_string($profileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($profileId, true), gettype($profileId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($profileId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $profileId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($profileId, true)), __LINE__);
        }
        if (is_null($profileId) || (is_array($profileId) && empty($profileId))) {
            unset($this->ProfileId);
        } else {
            $this->ProfileId = $profileId;
        }
        return $this;
    }
    /**
     * Get SecurityTokenId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSecurityTokenId()
    {
        return isset($this->SecurityTokenId) ? $this->SecurityTokenId : null;
    }
    /**
     * Set SecurityTokenId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $securityTokenId
     * @return \patest\StructType\Security_User
     */
    public function setSecurityTokenId($securityTokenId = null)
    {
        // validation for constraint: string
        if (!is_null($securityTokenId) && !is_string($securityTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($securityTokenId, true), gettype($securityTokenId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($securityTokenId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $securityTokenId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($securityTokenId, true)), __LINE__);
        }
        if (is_null($securityTokenId) || (is_array($securityTokenId) && empty($securityTokenId))) {
            unset($this->SecurityTokenId);
        } else {
            $this->SecurityTokenId = $securityTokenId;
        }
        return $this;
    }
    /**
     * Get UserImageId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserImageId()
    {
        return isset($this->UserImageId) ? $this->UserImageId : null;
    }
    /**
     * Set UserImageId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userImageId
     * @return \patest\StructType\Security_User
     */
    public function setUserImageId($userImageId = null)
    {
        // validation for constraint: string
        if (!is_null($userImageId) && !is_string($userImageId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userImageId, true), gettype($userImageId)), __LINE__);
        }
        if (is_null($userImageId) || (is_array($userImageId) && empty($userImageId))) {
            unset($this->UserImageId);
        } else {
            $this->UserImageId = $userImageId;
        }
        return $this;
    }
    /**
     * Get UserInterfaceId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserInterfaceId()
    {
        return isset($this->UserInterfaceId) ? $this->UserInterfaceId : null;
    }
    /**
     * Set UserInterfaceId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $userInterfaceId
     * @return \patest\StructType\Security_User
     */
    public function setUserInterfaceId($userInterfaceId = null)
    {
        // validation for constraint: string
        if (!is_null($userInterfaceId) && !is_string($userInterfaceId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($userInterfaceId, true), gettype($userInterfaceId)), __LINE__);
        }
        if (is_null($userInterfaceId) || (is_array($userInterfaceId) && empty($userInterfaceId))) {
            unset($this->UserInterfaceId);
        } else {
            $this->UserInterfaceId = $userInterfaceId;
        }
        return $this;
    }
    /**
     * Get UserType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUserType()
    {
        return isset($this->UserType) ? $this->UserType : null;
    }
    /**
     * Set UserType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\UserType::valueIsValid()
     * @uses \patest\EnumType\UserType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $userType
     * @return \patest\StructType\Security_User
     */
    public function setUserType($userType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\UserType::valueIsValid($userType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\UserType', is_array($userType) ? implode(', ', $userType) : var_export($userType, true), implode(', ', \patest\EnumType\UserType::getValidValues())), __LINE__);
        }
        if (is_null($userType) || (is_array($userType) && empty($userType))) {
            unset($this->UserType);
        } else {
            $this->UserType = $userType;
        }
        return $this;
    }
}
