<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.TicketingCompanyParameters StructType
 * @subpackage Structs
 */
class Security_TicketingCompanyParameters extends Security_CompanyParameterBase
{
    /**
     * The AfterMidnightEventAssociationTimeOffset
     * Meta information extracted from the WSDL
     * - base: xs:duration
     * - maxInclusive: P10675199DT2H48M5.4775807S
     * - minInclusive: -P10675199DT2H48M5.4775808S
     * - minOccurs: 0
     * - nillable: true
     * - pattern: \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?
     * - type: tns:duration
     * @var string
     */
    public $AfterMidnightEventAssociationTimeOffset;
    /**
     * The AllowEventsToOverlap
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowEventsToOverlap;
    /**
     * The AllowIsolatedSeatsWhenNoOtherOption
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowIsolatedSeatsWhenNoOtherOption;
    /**
     * The ApplyPerPersonLimitationsToAccounts
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ApplyPerPersonLimitationsToAccounts;
    /**
     * The AutoReleaseSeatsTimeoutMin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AutoReleaseSeatsTimeoutMin;
    /**
     * The BestAvailableAtHallLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $BestAvailableAtHallLevel;
    /**
     * The BypassDataSecurityInTicketsTab
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $BypassDataSecurityInTicketsTab;
    /**
     * The CheckMinimumLimitationsAtConfirmPhase
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CheckMinimumLimitationsAtConfirmPhase;
    /**
     * The CheckPerUserLimitationsOnEveryBasketChange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CheckPerUserLimitationsOnEveryBasketChange;
    /**
     * The DisplayStageInHallDesigner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DisplayStageInHallDesigner;
    /**
     * The DisplayStageInSalesApps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DisplayStageInSalesApps;
    /**
     * The DisplayStageInSelfServiceApps
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DisplayStageInSelfServiceApps;
    /**
     * The EventEffectiveDateType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventEffectiveDateType;
    /**
     * The EventTagClass1Translation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $EventTagClass1Translation;
    /**
     * The EventTagClass2Translation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $EventTagClass2Translation;
    /**
     * The EventTagClass3Translation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\GlobalString
     */
    public $EventTagClass3Translation;
    /**
     * The IsAllowGALocksAndCapacityBelowUsage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsAllowGALocksAndCapacityBelowUsage;
    /**
     * The IsSocialDistancingMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsSocialDistancingMode;
    /**
     * The IsVerifyIsolatedSeatsOnSeries
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsVerifyIsolatedSeatsOnSeries;
    /**
     * The KeepOnlyConsumedAllocationOnTicketSale
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $KeepOnlyConsumedAllocationOnTicketSale;
    /**
     * The LimitSellersAccessToSeatInformation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $LimitSellersAccessToSeatInformation;
    /**
     * The MultiAllocateSeatsByDefault
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MultiAllocateSeatsByDefault;
    /**
     * The PerUserLimitationIdentificationMethods
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $PerUserLimitationIdentificationMethods;
    /**
     * The RetainAllocationsOnMoveAudience
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $RetainAllocationsOnMoveAudience;
    /**
     * The SellWithoutAllocationsPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SellWithoutAllocationsPolicy;
    /**
     * The SocailDistancingIsAutoApplyLockOnExistingSales
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SocailDistancingIsAutoApplyLockOnExistingSales;
    /**
     * The SocialDistanceRows
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SocialDistanceRows;
    /**
     * The SocialDistanceSide
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SocialDistanceSide;
    /**
     * The SocialDistancingLockId
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $SocialDistancingLockId;
    /**
     * The SocialDistancingMaxCapacityPct
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SocialDistancingMaxCapacityPct;
    /**
     * The TicketRegularPriceCalcMethod
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketRegularPriceCalcMethod;
    /**
     * The TicketResalePolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketResalePolicy;
    /**
     * The TicketSchemeLevelOfParallelism
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TicketSchemeLevelOfParallelism;
    /**
     * The UnloadFutureEventSeatingPlanManagerTimeoutHr
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $UnloadFutureEventSeatingPlanManagerTimeoutHr;
    /**
     * The UnloadPastEventSeatingPlanManagerTimeoutHr
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $UnloadPastEventSeatingPlanManagerTimeoutHr;
    /**
     * The UpdateCustomSeatPricesClusterNotificationChunkSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $UpdateCustomSeatPricesClusterNotificationChunkSize;
    /**
     * The UpdateCustomSeatPricesSQLChunkSize
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $UpdateCustomSeatPricesSQLChunkSize;
    /**
     * The VerifyIsolatedSeatsOnAppChannels
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $VerifyIsolatedSeatsOnAppChannels;
    /**
     * The VerifyNewEventsAreInTheFuture
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $VerifyNewEventsAreInTheFuture;
    /**
     * Constructor method for Security.TicketingCompanyParameters
     * @uses Security_TicketingCompanyParameters::setAfterMidnightEventAssociationTimeOffset()
     * @uses Security_TicketingCompanyParameters::setAllowEventsToOverlap()
     * @uses Security_TicketingCompanyParameters::setAllowIsolatedSeatsWhenNoOtherOption()
     * @uses Security_TicketingCompanyParameters::setApplyPerPersonLimitationsToAccounts()
     * @uses Security_TicketingCompanyParameters::setAutoReleaseSeatsTimeoutMin()
     * @uses Security_TicketingCompanyParameters::setBestAvailableAtHallLevel()
     * @uses Security_TicketingCompanyParameters::setBypassDataSecurityInTicketsTab()
     * @uses Security_TicketingCompanyParameters::setCheckMinimumLimitationsAtConfirmPhase()
     * @uses Security_TicketingCompanyParameters::setCheckPerUserLimitationsOnEveryBasketChange()
     * @uses Security_TicketingCompanyParameters::setDisplayStageInHallDesigner()
     * @uses Security_TicketingCompanyParameters::setDisplayStageInSalesApps()
     * @uses Security_TicketingCompanyParameters::setDisplayStageInSelfServiceApps()
     * @uses Security_TicketingCompanyParameters::setEventEffectiveDateType()
     * @uses Security_TicketingCompanyParameters::setEventTagClass1Translation()
     * @uses Security_TicketingCompanyParameters::setEventTagClass2Translation()
     * @uses Security_TicketingCompanyParameters::setEventTagClass3Translation()
     * @uses Security_TicketingCompanyParameters::setIsAllowGALocksAndCapacityBelowUsage()
     * @uses Security_TicketingCompanyParameters::setIsSocialDistancingMode()
     * @uses Security_TicketingCompanyParameters::setIsVerifyIsolatedSeatsOnSeries()
     * @uses Security_TicketingCompanyParameters::setKeepOnlyConsumedAllocationOnTicketSale()
     * @uses Security_TicketingCompanyParameters::setLimitSellersAccessToSeatInformation()
     * @uses Security_TicketingCompanyParameters::setMultiAllocateSeatsByDefault()
     * @uses Security_TicketingCompanyParameters::setPerUserLimitationIdentificationMethods()
     * @uses Security_TicketingCompanyParameters::setRetainAllocationsOnMoveAudience()
     * @uses Security_TicketingCompanyParameters::setSellWithoutAllocationsPolicy()
     * @uses Security_TicketingCompanyParameters::setSocailDistancingIsAutoApplyLockOnExistingSales()
     * @uses Security_TicketingCompanyParameters::setSocialDistanceRows()
     * @uses Security_TicketingCompanyParameters::setSocialDistanceSide()
     * @uses Security_TicketingCompanyParameters::setSocialDistancingLockId()
     * @uses Security_TicketingCompanyParameters::setSocialDistancingMaxCapacityPct()
     * @uses Security_TicketingCompanyParameters::setTicketRegularPriceCalcMethod()
     * @uses Security_TicketingCompanyParameters::setTicketResalePolicy()
     * @uses Security_TicketingCompanyParameters::setTicketSchemeLevelOfParallelism()
     * @uses Security_TicketingCompanyParameters::setUnloadFutureEventSeatingPlanManagerTimeoutHr()
     * @uses Security_TicketingCompanyParameters::setUnloadPastEventSeatingPlanManagerTimeoutHr()
     * @uses Security_TicketingCompanyParameters::setUpdateCustomSeatPricesClusterNotificationChunkSize()
     * @uses Security_TicketingCompanyParameters::setUpdateCustomSeatPricesSQLChunkSize()
     * @uses Security_TicketingCompanyParameters::setVerifyIsolatedSeatsOnAppChannels()
     * @uses Security_TicketingCompanyParameters::setVerifyNewEventsAreInTheFuture()
     * @param string $afterMidnightEventAssociationTimeOffset
     * @param bool $allowEventsToOverlap
     * @param bool $allowIsolatedSeatsWhenNoOtherOption
     * @param bool $applyPerPersonLimitationsToAccounts
     * @param int $autoReleaseSeatsTimeoutMin
     * @param bool $bestAvailableAtHallLevel
     * @param bool $bypassDataSecurityInTicketsTab
     * @param bool $checkMinimumLimitationsAtConfirmPhase
     * @param bool $checkPerUserLimitationsOnEveryBasketChange
     * @param bool $displayStageInHallDesigner
     * @param bool $displayStageInSalesApps
     * @param bool $displayStageInSelfServiceApps
     * @param string $eventEffectiveDateType
     * @param \patest\StructType\GlobalString $eventTagClass1Translation
     * @param \patest\StructType\GlobalString $eventTagClass2Translation
     * @param \patest\StructType\GlobalString $eventTagClass3Translation
     * @param bool $isAllowGALocksAndCapacityBelowUsage
     * @param bool $isSocialDistancingMode
     * @param bool $isVerifyIsolatedSeatsOnSeries
     * @param bool $keepOnlyConsumedAllocationOnTicketSale
     * @param bool $limitSellersAccessToSeatInformation
     * @param bool $multiAllocateSeatsByDefault
     * @param string $perUserLimitationIdentificationMethods
     * @param bool $retainAllocationsOnMoveAudience
     * @param string $sellWithoutAllocationsPolicy
     * @param bool $socailDistancingIsAutoApplyLockOnExistingSales
     * @param int $socialDistanceRows
     * @param int $socialDistanceSide
     * @param string $socialDistancingLockId
     * @param int $socialDistancingMaxCapacityPct
     * @param string $ticketRegularPriceCalcMethod
     * @param string $ticketResalePolicy
     * @param int $ticketSchemeLevelOfParallelism
     * @param int $unloadFutureEventSeatingPlanManagerTimeoutHr
     * @param int $unloadPastEventSeatingPlanManagerTimeoutHr
     * @param int $updateCustomSeatPricesClusterNotificationChunkSize
     * @param int $updateCustomSeatPricesSQLChunkSize
     * @param string $verifyIsolatedSeatsOnAppChannels
     * @param bool $verifyNewEventsAreInTheFuture
     */
    public function __construct($afterMidnightEventAssociationTimeOffset = null, $allowEventsToOverlap = null, $allowIsolatedSeatsWhenNoOtherOption = null, $applyPerPersonLimitationsToAccounts = null, $autoReleaseSeatsTimeoutMin = null, $bestAvailableAtHallLevel = null, $bypassDataSecurityInTicketsTab = null, $checkMinimumLimitationsAtConfirmPhase = null, $checkPerUserLimitationsOnEveryBasketChange = null, $displayStageInHallDesigner = null, $displayStageInSalesApps = null, $displayStageInSelfServiceApps = null, $eventEffectiveDateType = null, \patest\StructType\GlobalString $eventTagClass1Translation = null, \patest\StructType\GlobalString $eventTagClass2Translation = null, \patest\StructType\GlobalString $eventTagClass3Translation = null, $isAllowGALocksAndCapacityBelowUsage = null, $isSocialDistancingMode = null, $isVerifyIsolatedSeatsOnSeries = null, $keepOnlyConsumedAllocationOnTicketSale = null, $limitSellersAccessToSeatInformation = null, $multiAllocateSeatsByDefault = null, $perUserLimitationIdentificationMethods = null, $retainAllocationsOnMoveAudience = null, $sellWithoutAllocationsPolicy = null, $socailDistancingIsAutoApplyLockOnExistingSales = null, $socialDistanceRows = null, $socialDistanceSide = null, $socialDistancingLockId = null, $socialDistancingMaxCapacityPct = null, $ticketRegularPriceCalcMethod = null, $ticketResalePolicy = null, $ticketSchemeLevelOfParallelism = null, $unloadFutureEventSeatingPlanManagerTimeoutHr = null, $unloadPastEventSeatingPlanManagerTimeoutHr = null, $updateCustomSeatPricesClusterNotificationChunkSize = null, $updateCustomSeatPricesSQLChunkSize = null, $verifyIsolatedSeatsOnAppChannels = null, $verifyNewEventsAreInTheFuture = null)
    {
        $this
            ->setAfterMidnightEventAssociationTimeOffset($afterMidnightEventAssociationTimeOffset)
            ->setAllowEventsToOverlap($allowEventsToOverlap)
            ->setAllowIsolatedSeatsWhenNoOtherOption($allowIsolatedSeatsWhenNoOtherOption)
            ->setApplyPerPersonLimitationsToAccounts($applyPerPersonLimitationsToAccounts)
            ->setAutoReleaseSeatsTimeoutMin($autoReleaseSeatsTimeoutMin)
            ->setBestAvailableAtHallLevel($bestAvailableAtHallLevel)
            ->setBypassDataSecurityInTicketsTab($bypassDataSecurityInTicketsTab)
            ->setCheckMinimumLimitationsAtConfirmPhase($checkMinimumLimitationsAtConfirmPhase)
            ->setCheckPerUserLimitationsOnEveryBasketChange($checkPerUserLimitationsOnEveryBasketChange)
            ->setDisplayStageInHallDesigner($displayStageInHallDesigner)
            ->setDisplayStageInSalesApps($displayStageInSalesApps)
            ->setDisplayStageInSelfServiceApps($displayStageInSelfServiceApps)
            ->setEventEffectiveDateType($eventEffectiveDateType)
            ->setEventTagClass1Translation($eventTagClass1Translation)
            ->setEventTagClass2Translation($eventTagClass2Translation)
            ->setEventTagClass3Translation($eventTagClass3Translation)
            ->setIsAllowGALocksAndCapacityBelowUsage($isAllowGALocksAndCapacityBelowUsage)
            ->setIsSocialDistancingMode($isSocialDistancingMode)
            ->setIsVerifyIsolatedSeatsOnSeries($isVerifyIsolatedSeatsOnSeries)
            ->setKeepOnlyConsumedAllocationOnTicketSale($keepOnlyConsumedAllocationOnTicketSale)
            ->setLimitSellersAccessToSeatInformation($limitSellersAccessToSeatInformation)
            ->setMultiAllocateSeatsByDefault($multiAllocateSeatsByDefault)
            ->setPerUserLimitationIdentificationMethods($perUserLimitationIdentificationMethods)
            ->setRetainAllocationsOnMoveAudience($retainAllocationsOnMoveAudience)
            ->setSellWithoutAllocationsPolicy($sellWithoutAllocationsPolicy)
            ->setSocailDistancingIsAutoApplyLockOnExistingSales($socailDistancingIsAutoApplyLockOnExistingSales)
            ->setSocialDistanceRows($socialDistanceRows)
            ->setSocialDistanceSide($socialDistanceSide)
            ->setSocialDistancingLockId($socialDistancingLockId)
            ->setSocialDistancingMaxCapacityPct($socialDistancingMaxCapacityPct)
            ->setTicketRegularPriceCalcMethod($ticketRegularPriceCalcMethod)
            ->setTicketResalePolicy($ticketResalePolicy)
            ->setTicketSchemeLevelOfParallelism($ticketSchemeLevelOfParallelism)
            ->setUnloadFutureEventSeatingPlanManagerTimeoutHr($unloadFutureEventSeatingPlanManagerTimeoutHr)
            ->setUnloadPastEventSeatingPlanManagerTimeoutHr($unloadPastEventSeatingPlanManagerTimeoutHr)
            ->setUpdateCustomSeatPricesClusterNotificationChunkSize($updateCustomSeatPricesClusterNotificationChunkSize)
            ->setUpdateCustomSeatPricesSQLChunkSize($updateCustomSeatPricesSQLChunkSize)
            ->setVerifyIsolatedSeatsOnAppChannels($verifyIsolatedSeatsOnAppChannels)
            ->setVerifyNewEventsAreInTheFuture($verifyNewEventsAreInTheFuture);
    }
    /**
     * Get AfterMidnightEventAssociationTimeOffset value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAfterMidnightEventAssociationTimeOffset()
    {
        return isset($this->AfterMidnightEventAssociationTimeOffset) ? $this->AfterMidnightEventAssociationTimeOffset : null;
    }
    /**
     * Set AfterMidnightEventAssociationTimeOffset value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $afterMidnightEventAssociationTimeOffset
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setAfterMidnightEventAssociationTimeOffset($afterMidnightEventAssociationTimeOffset = null)
    {
        // validation for constraint: string
        if (!is_null($afterMidnightEventAssociationTimeOffset) && !is_string($afterMidnightEventAssociationTimeOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($afterMidnightEventAssociationTimeOffset, true), gettype($afterMidnightEventAssociationTimeOffset)), __LINE__);
        }
        // validation for constraint: maxInclusive(P10675199DT2H48M5.4775807S)
        if (!is_null($afterMidnightEventAssociationTimeOffset) && false === mb_strpos($afterMidnightEventAssociationTimeOffset, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $afterMidnightEventAssociationTimeOffset)))) > \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775807S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically less than or equal to P10675199DT2H48M5.4775807S', var_export($afterMidnightEventAssociationTimeOffset, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-P10675199DT2H48M5.4775808S)
        if (!is_null($afterMidnightEventAssociationTimeOffset) && false !== mb_strpos($afterMidnightEventAssociationTimeOffset, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $afterMidnightEventAssociationTimeOffset)))) < \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775808S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically greater than or equal to -P10675199DT2H48M5.4775808S', var_export($afterMidnightEventAssociationTimeOffset, true)), __LINE__);
        }
        // validation for constraint: pattern(\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?)
        if (!is_null($afterMidnightEventAssociationTimeOffset) && !preg_match('/\\-?P(\\d*D)?(T(\\d*H)?(\\d*M)?(\\d*(\\.\\d*)?S)?)?/', $afterMidnightEventAssociationTimeOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?', var_export($afterMidnightEventAssociationTimeOffset, true)), __LINE__);
        }
        if (is_null($afterMidnightEventAssociationTimeOffset) || (is_array($afterMidnightEventAssociationTimeOffset) && empty($afterMidnightEventAssociationTimeOffset))) {
            unset($this->AfterMidnightEventAssociationTimeOffset);
        } else {
            $this->AfterMidnightEventAssociationTimeOffset = $afterMidnightEventAssociationTimeOffset;
        }
        return $this;
    }
    /**
     * Get AllowEventsToOverlap value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowEventsToOverlap()
    {
        return isset($this->AllowEventsToOverlap) ? $this->AllowEventsToOverlap : null;
    }
    /**
     * Set AllowEventsToOverlap value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowEventsToOverlap
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setAllowEventsToOverlap($allowEventsToOverlap = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowEventsToOverlap) && !is_bool($allowEventsToOverlap)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowEventsToOverlap, true), gettype($allowEventsToOverlap)), __LINE__);
        }
        if (is_null($allowEventsToOverlap) || (is_array($allowEventsToOverlap) && empty($allowEventsToOverlap))) {
            unset($this->AllowEventsToOverlap);
        } else {
            $this->AllowEventsToOverlap = $allowEventsToOverlap;
        }
        return $this;
    }
    /**
     * Get AllowIsolatedSeatsWhenNoOtherOption value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowIsolatedSeatsWhenNoOtherOption()
    {
        return isset($this->AllowIsolatedSeatsWhenNoOtherOption) ? $this->AllowIsolatedSeatsWhenNoOtherOption : null;
    }
    /**
     * Set AllowIsolatedSeatsWhenNoOtherOption value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowIsolatedSeatsWhenNoOtherOption
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setAllowIsolatedSeatsWhenNoOtherOption($allowIsolatedSeatsWhenNoOtherOption = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowIsolatedSeatsWhenNoOtherOption) && !is_bool($allowIsolatedSeatsWhenNoOtherOption)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowIsolatedSeatsWhenNoOtherOption, true), gettype($allowIsolatedSeatsWhenNoOtherOption)), __LINE__);
        }
        if (is_null($allowIsolatedSeatsWhenNoOtherOption) || (is_array($allowIsolatedSeatsWhenNoOtherOption) && empty($allowIsolatedSeatsWhenNoOtherOption))) {
            unset($this->AllowIsolatedSeatsWhenNoOtherOption);
        } else {
            $this->AllowIsolatedSeatsWhenNoOtherOption = $allowIsolatedSeatsWhenNoOtherOption;
        }
        return $this;
    }
    /**
     * Get ApplyPerPersonLimitationsToAccounts value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getApplyPerPersonLimitationsToAccounts()
    {
        return isset($this->ApplyPerPersonLimitationsToAccounts) ? $this->ApplyPerPersonLimitationsToAccounts : null;
    }
    /**
     * Set ApplyPerPersonLimitationsToAccounts value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $applyPerPersonLimitationsToAccounts
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setApplyPerPersonLimitationsToAccounts($applyPerPersonLimitationsToAccounts = null)
    {
        // validation for constraint: boolean
        if (!is_null($applyPerPersonLimitationsToAccounts) && !is_bool($applyPerPersonLimitationsToAccounts)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($applyPerPersonLimitationsToAccounts, true), gettype($applyPerPersonLimitationsToAccounts)), __LINE__);
        }
        if (is_null($applyPerPersonLimitationsToAccounts) || (is_array($applyPerPersonLimitationsToAccounts) && empty($applyPerPersonLimitationsToAccounts))) {
            unset($this->ApplyPerPersonLimitationsToAccounts);
        } else {
            $this->ApplyPerPersonLimitationsToAccounts = $applyPerPersonLimitationsToAccounts;
        }
        return $this;
    }
    /**
     * Get AutoReleaseSeatsTimeoutMin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAutoReleaseSeatsTimeoutMin()
    {
        return isset($this->AutoReleaseSeatsTimeoutMin) ? $this->AutoReleaseSeatsTimeoutMin : null;
    }
    /**
     * Set AutoReleaseSeatsTimeoutMin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $autoReleaseSeatsTimeoutMin
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setAutoReleaseSeatsTimeoutMin($autoReleaseSeatsTimeoutMin = null)
    {
        // validation for constraint: int
        if (!is_null($autoReleaseSeatsTimeoutMin) && !(is_int($autoReleaseSeatsTimeoutMin) || ctype_digit($autoReleaseSeatsTimeoutMin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($autoReleaseSeatsTimeoutMin, true), gettype($autoReleaseSeatsTimeoutMin)), __LINE__);
        }
        if (is_null($autoReleaseSeatsTimeoutMin) || (is_array($autoReleaseSeatsTimeoutMin) && empty($autoReleaseSeatsTimeoutMin))) {
            unset($this->AutoReleaseSeatsTimeoutMin);
        } else {
            $this->AutoReleaseSeatsTimeoutMin = $autoReleaseSeatsTimeoutMin;
        }
        return $this;
    }
    /**
     * Get BestAvailableAtHallLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getBestAvailableAtHallLevel()
    {
        return isset($this->BestAvailableAtHallLevel) ? $this->BestAvailableAtHallLevel : null;
    }
    /**
     * Set BestAvailableAtHallLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $bestAvailableAtHallLevel
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setBestAvailableAtHallLevel($bestAvailableAtHallLevel = null)
    {
        // validation for constraint: boolean
        if (!is_null($bestAvailableAtHallLevel) && !is_bool($bestAvailableAtHallLevel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bestAvailableAtHallLevel, true), gettype($bestAvailableAtHallLevel)), __LINE__);
        }
        if (is_null($bestAvailableAtHallLevel) || (is_array($bestAvailableAtHallLevel) && empty($bestAvailableAtHallLevel))) {
            unset($this->BestAvailableAtHallLevel);
        } else {
            $this->BestAvailableAtHallLevel = $bestAvailableAtHallLevel;
        }
        return $this;
    }
    /**
     * Get BypassDataSecurityInTicketsTab value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getBypassDataSecurityInTicketsTab()
    {
        return isset($this->BypassDataSecurityInTicketsTab) ? $this->BypassDataSecurityInTicketsTab : null;
    }
    /**
     * Set BypassDataSecurityInTicketsTab value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $bypassDataSecurityInTicketsTab
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setBypassDataSecurityInTicketsTab($bypassDataSecurityInTicketsTab = null)
    {
        // validation for constraint: boolean
        if (!is_null($bypassDataSecurityInTicketsTab) && !is_bool($bypassDataSecurityInTicketsTab)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bypassDataSecurityInTicketsTab, true), gettype($bypassDataSecurityInTicketsTab)), __LINE__);
        }
        if (is_null($bypassDataSecurityInTicketsTab) || (is_array($bypassDataSecurityInTicketsTab) && empty($bypassDataSecurityInTicketsTab))) {
            unset($this->BypassDataSecurityInTicketsTab);
        } else {
            $this->BypassDataSecurityInTicketsTab = $bypassDataSecurityInTicketsTab;
        }
        return $this;
    }
    /**
     * Get CheckMinimumLimitationsAtConfirmPhase value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCheckMinimumLimitationsAtConfirmPhase()
    {
        return isset($this->CheckMinimumLimitationsAtConfirmPhase) ? $this->CheckMinimumLimitationsAtConfirmPhase : null;
    }
    /**
     * Set CheckMinimumLimitationsAtConfirmPhase value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $checkMinimumLimitationsAtConfirmPhase
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setCheckMinimumLimitationsAtConfirmPhase($checkMinimumLimitationsAtConfirmPhase = null)
    {
        // validation for constraint: boolean
        if (!is_null($checkMinimumLimitationsAtConfirmPhase) && !is_bool($checkMinimumLimitationsAtConfirmPhase)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($checkMinimumLimitationsAtConfirmPhase, true), gettype($checkMinimumLimitationsAtConfirmPhase)), __LINE__);
        }
        if (is_null($checkMinimumLimitationsAtConfirmPhase) || (is_array($checkMinimumLimitationsAtConfirmPhase) && empty($checkMinimumLimitationsAtConfirmPhase))) {
            unset($this->CheckMinimumLimitationsAtConfirmPhase);
        } else {
            $this->CheckMinimumLimitationsAtConfirmPhase = $checkMinimumLimitationsAtConfirmPhase;
        }
        return $this;
    }
    /**
     * Get CheckPerUserLimitationsOnEveryBasketChange value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCheckPerUserLimitationsOnEveryBasketChange()
    {
        return isset($this->CheckPerUserLimitationsOnEveryBasketChange) ? $this->CheckPerUserLimitationsOnEveryBasketChange : null;
    }
    /**
     * Set CheckPerUserLimitationsOnEveryBasketChange value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $checkPerUserLimitationsOnEveryBasketChange
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setCheckPerUserLimitationsOnEveryBasketChange($checkPerUserLimitationsOnEveryBasketChange = null)
    {
        // validation for constraint: boolean
        if (!is_null($checkPerUserLimitationsOnEveryBasketChange) && !is_bool($checkPerUserLimitationsOnEveryBasketChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($checkPerUserLimitationsOnEveryBasketChange, true), gettype($checkPerUserLimitationsOnEveryBasketChange)), __LINE__);
        }
        if (is_null($checkPerUserLimitationsOnEveryBasketChange) || (is_array($checkPerUserLimitationsOnEveryBasketChange) && empty($checkPerUserLimitationsOnEveryBasketChange))) {
            unset($this->CheckPerUserLimitationsOnEveryBasketChange);
        } else {
            $this->CheckPerUserLimitationsOnEveryBasketChange = $checkPerUserLimitationsOnEveryBasketChange;
        }
        return $this;
    }
    /**
     * Get DisplayStageInHallDesigner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDisplayStageInHallDesigner()
    {
        return isset($this->DisplayStageInHallDesigner) ? $this->DisplayStageInHallDesigner : null;
    }
    /**
     * Set DisplayStageInHallDesigner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $displayStageInHallDesigner
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setDisplayStageInHallDesigner($displayStageInHallDesigner = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayStageInHallDesigner) && !is_bool($displayStageInHallDesigner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayStageInHallDesigner, true), gettype($displayStageInHallDesigner)), __LINE__);
        }
        if (is_null($displayStageInHallDesigner) || (is_array($displayStageInHallDesigner) && empty($displayStageInHallDesigner))) {
            unset($this->DisplayStageInHallDesigner);
        } else {
            $this->DisplayStageInHallDesigner = $displayStageInHallDesigner;
        }
        return $this;
    }
    /**
     * Get DisplayStageInSalesApps value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDisplayStageInSalesApps()
    {
        return isset($this->DisplayStageInSalesApps) ? $this->DisplayStageInSalesApps : null;
    }
    /**
     * Set DisplayStageInSalesApps value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $displayStageInSalesApps
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setDisplayStageInSalesApps($displayStageInSalesApps = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayStageInSalesApps) && !is_bool($displayStageInSalesApps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayStageInSalesApps, true), gettype($displayStageInSalesApps)), __LINE__);
        }
        if (is_null($displayStageInSalesApps) || (is_array($displayStageInSalesApps) && empty($displayStageInSalesApps))) {
            unset($this->DisplayStageInSalesApps);
        } else {
            $this->DisplayStageInSalesApps = $displayStageInSalesApps;
        }
        return $this;
    }
    /**
     * Get DisplayStageInSelfServiceApps value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDisplayStageInSelfServiceApps()
    {
        return isset($this->DisplayStageInSelfServiceApps) ? $this->DisplayStageInSelfServiceApps : null;
    }
    /**
     * Set DisplayStageInSelfServiceApps value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $displayStageInSelfServiceApps
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setDisplayStageInSelfServiceApps($displayStageInSelfServiceApps = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayStageInSelfServiceApps) && !is_bool($displayStageInSelfServiceApps)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayStageInSelfServiceApps, true), gettype($displayStageInSelfServiceApps)), __LINE__);
        }
        if (is_null($displayStageInSelfServiceApps) || (is_array($displayStageInSelfServiceApps) && empty($displayStageInSelfServiceApps))) {
            unset($this->DisplayStageInSelfServiceApps);
        } else {
            $this->DisplayStageInSelfServiceApps = $displayStageInSelfServiceApps;
        }
        return $this;
    }
    /**
     * Get EventEffectiveDateType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventEffectiveDateType()
    {
        return isset($this->EventEffectiveDateType) ? $this->EventEffectiveDateType : null;
    }
    /**
     * Set EventEffectiveDateType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\EventEffectiveDateType::valueIsValid()
     * @uses \patest\EnumType\EventEffectiveDateType::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $eventEffectiveDateType
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setEventEffectiveDateType($eventEffectiveDateType = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\EventEffectiveDateType::valueIsValid($eventEffectiveDateType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\EventEffectiveDateType', is_array($eventEffectiveDateType) ? implode(', ', $eventEffectiveDateType) : var_export($eventEffectiveDateType, true), implode(', ', \patest\EnumType\EventEffectiveDateType::getValidValues())), __LINE__);
        }
        if (is_null($eventEffectiveDateType) || (is_array($eventEffectiveDateType) && empty($eventEffectiveDateType))) {
            unset($this->EventEffectiveDateType);
        } else {
            $this->EventEffectiveDateType = $eventEffectiveDateType;
        }
        return $this;
    }
    /**
     * Get EventTagClass1Translation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getEventTagClass1Translation()
    {
        return isset($this->EventTagClass1Translation) ? $this->EventTagClass1Translation : null;
    }
    /**
     * Set EventTagClass1Translation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $eventTagClass1Translation
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setEventTagClass1Translation(\patest\StructType\GlobalString $eventTagClass1Translation = null)
    {
        if (is_null($eventTagClass1Translation) || (is_array($eventTagClass1Translation) && empty($eventTagClass1Translation))) {
            unset($this->EventTagClass1Translation);
        } else {
            $this->EventTagClass1Translation = $eventTagClass1Translation;
        }
        return $this;
    }
    /**
     * Get EventTagClass2Translation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getEventTagClass2Translation()
    {
        return isset($this->EventTagClass2Translation) ? $this->EventTagClass2Translation : null;
    }
    /**
     * Set EventTagClass2Translation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $eventTagClass2Translation
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setEventTagClass2Translation(\patest\StructType\GlobalString $eventTagClass2Translation = null)
    {
        if (is_null($eventTagClass2Translation) || (is_array($eventTagClass2Translation) && empty($eventTagClass2Translation))) {
            unset($this->EventTagClass2Translation);
        } else {
            $this->EventTagClass2Translation = $eventTagClass2Translation;
        }
        return $this;
    }
    /**
     * Get EventTagClass3Translation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\GlobalString|null
     */
    public function getEventTagClass3Translation()
    {
        return isset($this->EventTagClass3Translation) ? $this->EventTagClass3Translation : null;
    }
    /**
     * Set EventTagClass3Translation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\GlobalString $eventTagClass3Translation
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setEventTagClass3Translation(\patest\StructType\GlobalString $eventTagClass3Translation = null)
    {
        if (is_null($eventTagClass3Translation) || (is_array($eventTagClass3Translation) && empty($eventTagClass3Translation))) {
            unset($this->EventTagClass3Translation);
        } else {
            $this->EventTagClass3Translation = $eventTagClass3Translation;
        }
        return $this;
    }
    /**
     * Get IsAllowGALocksAndCapacityBelowUsage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsAllowGALocksAndCapacityBelowUsage()
    {
        return isset($this->IsAllowGALocksAndCapacityBelowUsage) ? $this->IsAllowGALocksAndCapacityBelowUsage : null;
    }
    /**
     * Set IsAllowGALocksAndCapacityBelowUsage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isAllowGALocksAndCapacityBelowUsage
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setIsAllowGALocksAndCapacityBelowUsage($isAllowGALocksAndCapacityBelowUsage = null)
    {
        // validation for constraint: boolean
        if (!is_null($isAllowGALocksAndCapacityBelowUsage) && !is_bool($isAllowGALocksAndCapacityBelowUsage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isAllowGALocksAndCapacityBelowUsage, true), gettype($isAllowGALocksAndCapacityBelowUsage)), __LINE__);
        }
        if (is_null($isAllowGALocksAndCapacityBelowUsage) || (is_array($isAllowGALocksAndCapacityBelowUsage) && empty($isAllowGALocksAndCapacityBelowUsage))) {
            unset($this->IsAllowGALocksAndCapacityBelowUsage);
        } else {
            $this->IsAllowGALocksAndCapacityBelowUsage = $isAllowGALocksAndCapacityBelowUsage;
        }
        return $this;
    }
    /**
     * Get IsSocialDistancingMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsSocialDistancingMode()
    {
        return isset($this->IsSocialDistancingMode) ? $this->IsSocialDistancingMode : null;
    }
    /**
     * Set IsSocialDistancingMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isSocialDistancingMode
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setIsSocialDistancingMode($isSocialDistancingMode = null)
    {
        // validation for constraint: boolean
        if (!is_null($isSocialDistancingMode) && !is_bool($isSocialDistancingMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isSocialDistancingMode, true), gettype($isSocialDistancingMode)), __LINE__);
        }
        if (is_null($isSocialDistancingMode) || (is_array($isSocialDistancingMode) && empty($isSocialDistancingMode))) {
            unset($this->IsSocialDistancingMode);
        } else {
            $this->IsSocialDistancingMode = $isSocialDistancingMode;
        }
        return $this;
    }
    /**
     * Get IsVerifyIsolatedSeatsOnSeries value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsVerifyIsolatedSeatsOnSeries()
    {
        return isset($this->IsVerifyIsolatedSeatsOnSeries) ? $this->IsVerifyIsolatedSeatsOnSeries : null;
    }
    /**
     * Set IsVerifyIsolatedSeatsOnSeries value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isVerifyIsolatedSeatsOnSeries
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setIsVerifyIsolatedSeatsOnSeries($isVerifyIsolatedSeatsOnSeries = null)
    {
        // validation for constraint: boolean
        if (!is_null($isVerifyIsolatedSeatsOnSeries) && !is_bool($isVerifyIsolatedSeatsOnSeries)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isVerifyIsolatedSeatsOnSeries, true), gettype($isVerifyIsolatedSeatsOnSeries)), __LINE__);
        }
        if (is_null($isVerifyIsolatedSeatsOnSeries) || (is_array($isVerifyIsolatedSeatsOnSeries) && empty($isVerifyIsolatedSeatsOnSeries))) {
            unset($this->IsVerifyIsolatedSeatsOnSeries);
        } else {
            $this->IsVerifyIsolatedSeatsOnSeries = $isVerifyIsolatedSeatsOnSeries;
        }
        return $this;
    }
    /**
     * Get KeepOnlyConsumedAllocationOnTicketSale value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getKeepOnlyConsumedAllocationOnTicketSale()
    {
        return isset($this->KeepOnlyConsumedAllocationOnTicketSale) ? $this->KeepOnlyConsumedAllocationOnTicketSale : null;
    }
    /**
     * Set KeepOnlyConsumedAllocationOnTicketSale value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $keepOnlyConsumedAllocationOnTicketSale
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setKeepOnlyConsumedAllocationOnTicketSale($keepOnlyConsumedAllocationOnTicketSale = null)
    {
        // validation for constraint: boolean
        if (!is_null($keepOnlyConsumedAllocationOnTicketSale) && !is_bool($keepOnlyConsumedAllocationOnTicketSale)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($keepOnlyConsumedAllocationOnTicketSale, true), gettype($keepOnlyConsumedAllocationOnTicketSale)), __LINE__);
        }
        if (is_null($keepOnlyConsumedAllocationOnTicketSale) || (is_array($keepOnlyConsumedAllocationOnTicketSale) && empty($keepOnlyConsumedAllocationOnTicketSale))) {
            unset($this->KeepOnlyConsumedAllocationOnTicketSale);
        } else {
            $this->KeepOnlyConsumedAllocationOnTicketSale = $keepOnlyConsumedAllocationOnTicketSale;
        }
        return $this;
    }
    /**
     * Get LimitSellersAccessToSeatInformation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getLimitSellersAccessToSeatInformation()
    {
        return isset($this->LimitSellersAccessToSeatInformation) ? $this->LimitSellersAccessToSeatInformation : null;
    }
    /**
     * Set LimitSellersAccessToSeatInformation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $limitSellersAccessToSeatInformation
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setLimitSellersAccessToSeatInformation($limitSellersAccessToSeatInformation = null)
    {
        // validation for constraint: boolean
        if (!is_null($limitSellersAccessToSeatInformation) && !is_bool($limitSellersAccessToSeatInformation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($limitSellersAccessToSeatInformation, true), gettype($limitSellersAccessToSeatInformation)), __LINE__);
        }
        if (is_null($limitSellersAccessToSeatInformation) || (is_array($limitSellersAccessToSeatInformation) && empty($limitSellersAccessToSeatInformation))) {
            unset($this->LimitSellersAccessToSeatInformation);
        } else {
            $this->LimitSellersAccessToSeatInformation = $limitSellersAccessToSeatInformation;
        }
        return $this;
    }
    /**
     * Get MultiAllocateSeatsByDefault value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMultiAllocateSeatsByDefault()
    {
        return isset($this->MultiAllocateSeatsByDefault) ? $this->MultiAllocateSeatsByDefault : null;
    }
    /**
     * Set MultiAllocateSeatsByDefault value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $multiAllocateSeatsByDefault
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setMultiAllocateSeatsByDefault($multiAllocateSeatsByDefault = null)
    {
        // validation for constraint: boolean
        if (!is_null($multiAllocateSeatsByDefault) && !is_bool($multiAllocateSeatsByDefault)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($multiAllocateSeatsByDefault, true), gettype($multiAllocateSeatsByDefault)), __LINE__);
        }
        if (is_null($multiAllocateSeatsByDefault) || (is_array($multiAllocateSeatsByDefault) && empty($multiAllocateSeatsByDefault))) {
            unset($this->MultiAllocateSeatsByDefault);
        } else {
            $this->MultiAllocateSeatsByDefault = $multiAllocateSeatsByDefault;
        }
        return $this;
    }
    /**
     * Get PerUserLimitationIdentificationMethods value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPerUserLimitationIdentificationMethods()
    {
        return isset($this->PerUserLimitationIdentificationMethods) ? $this->PerUserLimitationIdentificationMethods : null;
    }
    /**
     * Set PerUserLimitationIdentificationMethods value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $perUserLimitationIdentificationMethods
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setPerUserLimitationIdentificationMethods($perUserLimitationIdentificationMethods = null)
    {
        // validation for constraint: string
        if (!is_null($perUserLimitationIdentificationMethods) && !is_string($perUserLimitationIdentificationMethods)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($perUserLimitationIdentificationMethods, true), gettype($perUserLimitationIdentificationMethods)), __LINE__);
        }
        if (is_null($perUserLimitationIdentificationMethods) || (is_array($perUserLimitationIdentificationMethods) && empty($perUserLimitationIdentificationMethods))) {
            unset($this->PerUserLimitationIdentificationMethods);
        } else {
            $this->PerUserLimitationIdentificationMethods = $perUserLimitationIdentificationMethods;
        }
        return $this;
    }
    /**
     * Get RetainAllocationsOnMoveAudience value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getRetainAllocationsOnMoveAudience()
    {
        return isset($this->RetainAllocationsOnMoveAudience) ? $this->RetainAllocationsOnMoveAudience : null;
    }
    /**
     * Set RetainAllocationsOnMoveAudience value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $retainAllocationsOnMoveAudience
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setRetainAllocationsOnMoveAudience($retainAllocationsOnMoveAudience = null)
    {
        // validation for constraint: boolean
        if (!is_null($retainAllocationsOnMoveAudience) && !is_bool($retainAllocationsOnMoveAudience)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($retainAllocationsOnMoveAudience, true), gettype($retainAllocationsOnMoveAudience)), __LINE__);
        }
        if (is_null($retainAllocationsOnMoveAudience) || (is_array($retainAllocationsOnMoveAudience) && empty($retainAllocationsOnMoveAudience))) {
            unset($this->RetainAllocationsOnMoveAudience);
        } else {
            $this->RetainAllocationsOnMoveAudience = $retainAllocationsOnMoveAudience;
        }
        return $this;
    }
    /**
     * Get SellWithoutAllocationsPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSellWithoutAllocationsPolicy()
    {
        return isset($this->SellWithoutAllocationsPolicy) ? $this->SellWithoutAllocationsPolicy : null;
    }
    /**
     * Set SellWithoutAllocationsPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\SellWithoutAllocationsPolicy::valueIsValid()
     * @uses \patest\EnumType\SellWithoutAllocationsPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $sellWithoutAllocationsPolicy
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setSellWithoutAllocationsPolicy($sellWithoutAllocationsPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\SellWithoutAllocationsPolicy::valueIsValid($sellWithoutAllocationsPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\SellWithoutAllocationsPolicy', is_array($sellWithoutAllocationsPolicy) ? implode(', ', $sellWithoutAllocationsPolicy) : var_export($sellWithoutAllocationsPolicy, true), implode(', ', \patest\EnumType\SellWithoutAllocationsPolicy::getValidValues())), __LINE__);
        }
        if (is_null($sellWithoutAllocationsPolicy) || (is_array($sellWithoutAllocationsPolicy) && empty($sellWithoutAllocationsPolicy))) {
            unset($this->SellWithoutAllocationsPolicy);
        } else {
            $this->SellWithoutAllocationsPolicy = $sellWithoutAllocationsPolicy;
        }
        return $this;
    }
    /**
     * Get SocailDistancingIsAutoApplyLockOnExistingSales value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSocailDistancingIsAutoApplyLockOnExistingSales()
    {
        return isset($this->SocailDistancingIsAutoApplyLockOnExistingSales) ? $this->SocailDistancingIsAutoApplyLockOnExistingSales : null;
    }
    /**
     * Set SocailDistancingIsAutoApplyLockOnExistingSales value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $socailDistancingIsAutoApplyLockOnExistingSales
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setSocailDistancingIsAutoApplyLockOnExistingSales($socailDistancingIsAutoApplyLockOnExistingSales = null)
    {
        // validation for constraint: boolean
        if (!is_null($socailDistancingIsAutoApplyLockOnExistingSales) && !is_bool($socailDistancingIsAutoApplyLockOnExistingSales)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($socailDistancingIsAutoApplyLockOnExistingSales, true), gettype($socailDistancingIsAutoApplyLockOnExistingSales)), __LINE__);
        }
        if (is_null($socailDistancingIsAutoApplyLockOnExistingSales) || (is_array($socailDistancingIsAutoApplyLockOnExistingSales) && empty($socailDistancingIsAutoApplyLockOnExistingSales))) {
            unset($this->SocailDistancingIsAutoApplyLockOnExistingSales);
        } else {
            $this->SocailDistancingIsAutoApplyLockOnExistingSales = $socailDistancingIsAutoApplyLockOnExistingSales;
        }
        return $this;
    }
    /**
     * Get SocialDistanceRows value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSocialDistanceRows()
    {
        return isset($this->SocialDistanceRows) ? $this->SocialDistanceRows : null;
    }
    /**
     * Set SocialDistanceRows value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $socialDistanceRows
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setSocialDistanceRows($socialDistanceRows = null)
    {
        // validation for constraint: int
        if (!is_null($socialDistanceRows) && !(is_int($socialDistanceRows) || ctype_digit($socialDistanceRows))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($socialDistanceRows, true), gettype($socialDistanceRows)), __LINE__);
        }
        if (is_null($socialDistanceRows) || (is_array($socialDistanceRows) && empty($socialDistanceRows))) {
            unset($this->SocialDistanceRows);
        } else {
            $this->SocialDistanceRows = $socialDistanceRows;
        }
        return $this;
    }
    /**
     * Get SocialDistanceSide value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSocialDistanceSide()
    {
        return isset($this->SocialDistanceSide) ? $this->SocialDistanceSide : null;
    }
    /**
     * Set SocialDistanceSide value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $socialDistanceSide
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setSocialDistanceSide($socialDistanceSide = null)
    {
        // validation for constraint: int
        if (!is_null($socialDistanceSide) && !(is_int($socialDistanceSide) || ctype_digit($socialDistanceSide))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($socialDistanceSide, true), gettype($socialDistanceSide)), __LINE__);
        }
        if (is_null($socialDistanceSide) || (is_array($socialDistanceSide) && empty($socialDistanceSide))) {
            unset($this->SocialDistanceSide);
        } else {
            $this->SocialDistanceSide = $socialDistanceSide;
        }
        return $this;
    }
    /**
     * Get SocialDistancingLockId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSocialDistancingLockId()
    {
        return isset($this->SocialDistancingLockId) ? $this->SocialDistancingLockId : null;
    }
    /**
     * Set SocialDistancingLockId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $socialDistancingLockId
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setSocialDistancingLockId($socialDistancingLockId = null)
    {
        // validation for constraint: string
        if (!is_null($socialDistancingLockId) && !is_string($socialDistancingLockId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($socialDistancingLockId, true), gettype($socialDistancingLockId)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($socialDistancingLockId) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $socialDistancingLockId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($socialDistancingLockId, true)), __LINE__);
        }
        if (is_null($socialDistancingLockId) || (is_array($socialDistancingLockId) && empty($socialDistancingLockId))) {
            unset($this->SocialDistancingLockId);
        } else {
            $this->SocialDistancingLockId = $socialDistancingLockId;
        }
        return $this;
    }
    /**
     * Get SocialDistancingMaxCapacityPct value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSocialDistancingMaxCapacityPct()
    {
        return isset($this->SocialDistancingMaxCapacityPct) ? $this->SocialDistancingMaxCapacityPct : null;
    }
    /**
     * Set SocialDistancingMaxCapacityPct value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $socialDistancingMaxCapacityPct
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setSocialDistancingMaxCapacityPct($socialDistancingMaxCapacityPct = null)
    {
        // validation for constraint: int
        if (!is_null($socialDistancingMaxCapacityPct) && !(is_int($socialDistancingMaxCapacityPct) || ctype_digit($socialDistancingMaxCapacityPct))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($socialDistancingMaxCapacityPct, true), gettype($socialDistancingMaxCapacityPct)), __LINE__);
        }
        if (is_null($socialDistancingMaxCapacityPct) || (is_array($socialDistancingMaxCapacityPct) && empty($socialDistancingMaxCapacityPct))) {
            unset($this->SocialDistancingMaxCapacityPct);
        } else {
            $this->SocialDistancingMaxCapacityPct = $socialDistancingMaxCapacityPct;
        }
        return $this;
    }
    /**
     * Get TicketRegularPriceCalcMethod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketRegularPriceCalcMethod()
    {
        return isset($this->TicketRegularPriceCalcMethod) ? $this->TicketRegularPriceCalcMethod : null;
    }
    /**
     * Set TicketRegularPriceCalcMethod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketRegularPriceCalcMethod::valueIsValid()
     * @uses \patest\EnumType\TicketRegularPriceCalcMethod::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ticketRegularPriceCalcMethod
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setTicketRegularPriceCalcMethod($ticketRegularPriceCalcMethod = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketRegularPriceCalcMethod::valueIsValid($ticketRegularPriceCalcMethod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketRegularPriceCalcMethod', is_array($ticketRegularPriceCalcMethod) ? implode(', ', $ticketRegularPriceCalcMethod) : var_export($ticketRegularPriceCalcMethod, true), implode(', ', \patest\EnumType\TicketRegularPriceCalcMethod::getValidValues())), __LINE__);
        }
        if (is_null($ticketRegularPriceCalcMethod) || (is_array($ticketRegularPriceCalcMethod) && empty($ticketRegularPriceCalcMethod))) {
            unset($this->TicketRegularPriceCalcMethod);
        } else {
            $this->TicketRegularPriceCalcMethod = $ticketRegularPriceCalcMethod;
        }
        return $this;
    }
    /**
     * Get TicketResalePolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketResalePolicy()
    {
        return isset($this->TicketResalePolicy) ? $this->TicketResalePolicy : null;
    }
    /**
     * Set TicketResalePolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketResalePolicy::valueIsValid()
     * @uses \patest\EnumType\TicketResalePolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ticketResalePolicy
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setTicketResalePolicy($ticketResalePolicy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketResalePolicy::valueIsValid($ticketResalePolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketResalePolicy', is_array($ticketResalePolicy) ? implode(', ', $ticketResalePolicy) : var_export($ticketResalePolicy, true), implode(', ', \patest\EnumType\TicketResalePolicy::getValidValues())), __LINE__);
        }
        if (is_null($ticketResalePolicy) || (is_array($ticketResalePolicy) && empty($ticketResalePolicy))) {
            unset($this->TicketResalePolicy);
        } else {
            $this->TicketResalePolicy = $ticketResalePolicy;
        }
        return $this;
    }
    /**
     * Get TicketSchemeLevelOfParallelism value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTicketSchemeLevelOfParallelism()
    {
        return isset($this->TicketSchemeLevelOfParallelism) ? $this->TicketSchemeLevelOfParallelism : null;
    }
    /**
     * Set TicketSchemeLevelOfParallelism value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ticketSchemeLevelOfParallelism
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setTicketSchemeLevelOfParallelism($ticketSchemeLevelOfParallelism = null)
    {
        // validation for constraint: int
        if (!is_null($ticketSchemeLevelOfParallelism) && !(is_int($ticketSchemeLevelOfParallelism) || ctype_digit($ticketSchemeLevelOfParallelism))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($ticketSchemeLevelOfParallelism, true), gettype($ticketSchemeLevelOfParallelism)), __LINE__);
        }
        if (is_null($ticketSchemeLevelOfParallelism) || (is_array($ticketSchemeLevelOfParallelism) && empty($ticketSchemeLevelOfParallelism))) {
            unset($this->TicketSchemeLevelOfParallelism);
        } else {
            $this->TicketSchemeLevelOfParallelism = $ticketSchemeLevelOfParallelism;
        }
        return $this;
    }
    /**
     * Get UnloadFutureEventSeatingPlanManagerTimeoutHr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUnloadFutureEventSeatingPlanManagerTimeoutHr()
    {
        return isset($this->UnloadFutureEventSeatingPlanManagerTimeoutHr) ? $this->UnloadFutureEventSeatingPlanManagerTimeoutHr : null;
    }
    /**
     * Set UnloadFutureEventSeatingPlanManagerTimeoutHr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $unloadFutureEventSeatingPlanManagerTimeoutHr
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setUnloadFutureEventSeatingPlanManagerTimeoutHr($unloadFutureEventSeatingPlanManagerTimeoutHr = null)
    {
        // validation for constraint: int
        if (!is_null($unloadFutureEventSeatingPlanManagerTimeoutHr) && !(is_int($unloadFutureEventSeatingPlanManagerTimeoutHr) || ctype_digit($unloadFutureEventSeatingPlanManagerTimeoutHr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($unloadFutureEventSeatingPlanManagerTimeoutHr, true), gettype($unloadFutureEventSeatingPlanManagerTimeoutHr)), __LINE__);
        }
        if (is_null($unloadFutureEventSeatingPlanManagerTimeoutHr) || (is_array($unloadFutureEventSeatingPlanManagerTimeoutHr) && empty($unloadFutureEventSeatingPlanManagerTimeoutHr))) {
            unset($this->UnloadFutureEventSeatingPlanManagerTimeoutHr);
        } else {
            $this->UnloadFutureEventSeatingPlanManagerTimeoutHr = $unloadFutureEventSeatingPlanManagerTimeoutHr;
        }
        return $this;
    }
    /**
     * Get UnloadPastEventSeatingPlanManagerTimeoutHr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUnloadPastEventSeatingPlanManagerTimeoutHr()
    {
        return isset($this->UnloadPastEventSeatingPlanManagerTimeoutHr) ? $this->UnloadPastEventSeatingPlanManagerTimeoutHr : null;
    }
    /**
     * Set UnloadPastEventSeatingPlanManagerTimeoutHr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $unloadPastEventSeatingPlanManagerTimeoutHr
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setUnloadPastEventSeatingPlanManagerTimeoutHr($unloadPastEventSeatingPlanManagerTimeoutHr = null)
    {
        // validation for constraint: int
        if (!is_null($unloadPastEventSeatingPlanManagerTimeoutHr) && !(is_int($unloadPastEventSeatingPlanManagerTimeoutHr) || ctype_digit($unloadPastEventSeatingPlanManagerTimeoutHr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($unloadPastEventSeatingPlanManagerTimeoutHr, true), gettype($unloadPastEventSeatingPlanManagerTimeoutHr)), __LINE__);
        }
        if (is_null($unloadPastEventSeatingPlanManagerTimeoutHr) || (is_array($unloadPastEventSeatingPlanManagerTimeoutHr) && empty($unloadPastEventSeatingPlanManagerTimeoutHr))) {
            unset($this->UnloadPastEventSeatingPlanManagerTimeoutHr);
        } else {
            $this->UnloadPastEventSeatingPlanManagerTimeoutHr = $unloadPastEventSeatingPlanManagerTimeoutHr;
        }
        return $this;
    }
    /**
     * Get UpdateCustomSeatPricesClusterNotificationChunkSize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUpdateCustomSeatPricesClusterNotificationChunkSize()
    {
        return isset($this->UpdateCustomSeatPricesClusterNotificationChunkSize) ? $this->UpdateCustomSeatPricesClusterNotificationChunkSize : null;
    }
    /**
     * Set UpdateCustomSeatPricesClusterNotificationChunkSize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $updateCustomSeatPricesClusterNotificationChunkSize
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setUpdateCustomSeatPricesClusterNotificationChunkSize($updateCustomSeatPricesClusterNotificationChunkSize = null)
    {
        // validation for constraint: int
        if (!is_null($updateCustomSeatPricesClusterNotificationChunkSize) && !(is_int($updateCustomSeatPricesClusterNotificationChunkSize) || ctype_digit($updateCustomSeatPricesClusterNotificationChunkSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($updateCustomSeatPricesClusterNotificationChunkSize, true), gettype($updateCustomSeatPricesClusterNotificationChunkSize)), __LINE__);
        }
        if (is_null($updateCustomSeatPricesClusterNotificationChunkSize) || (is_array($updateCustomSeatPricesClusterNotificationChunkSize) && empty($updateCustomSeatPricesClusterNotificationChunkSize))) {
            unset($this->UpdateCustomSeatPricesClusterNotificationChunkSize);
        } else {
            $this->UpdateCustomSeatPricesClusterNotificationChunkSize = $updateCustomSeatPricesClusterNotificationChunkSize;
        }
        return $this;
    }
    /**
     * Get UpdateCustomSeatPricesSQLChunkSize value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUpdateCustomSeatPricesSQLChunkSize()
    {
        return isset($this->UpdateCustomSeatPricesSQLChunkSize) ? $this->UpdateCustomSeatPricesSQLChunkSize : null;
    }
    /**
     * Set UpdateCustomSeatPricesSQLChunkSize value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $updateCustomSeatPricesSQLChunkSize
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setUpdateCustomSeatPricesSQLChunkSize($updateCustomSeatPricesSQLChunkSize = null)
    {
        // validation for constraint: int
        if (!is_null($updateCustomSeatPricesSQLChunkSize) && !(is_int($updateCustomSeatPricesSQLChunkSize) || ctype_digit($updateCustomSeatPricesSQLChunkSize))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($updateCustomSeatPricesSQLChunkSize, true), gettype($updateCustomSeatPricesSQLChunkSize)), __LINE__);
        }
        if (is_null($updateCustomSeatPricesSQLChunkSize) || (is_array($updateCustomSeatPricesSQLChunkSize) && empty($updateCustomSeatPricesSQLChunkSize))) {
            unset($this->UpdateCustomSeatPricesSQLChunkSize);
        } else {
            $this->UpdateCustomSeatPricesSQLChunkSize = $updateCustomSeatPricesSQLChunkSize;
        }
        return $this;
    }
    /**
     * Get VerifyIsolatedSeatsOnAppChannels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVerifyIsolatedSeatsOnAppChannels()
    {
        return isset($this->VerifyIsolatedSeatsOnAppChannels) ? $this->VerifyIsolatedSeatsOnAppChannels : null;
    }
    /**
     * Set VerifyIsolatedSeatsOnAppChannels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $verifyIsolatedSeatsOnAppChannels
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setVerifyIsolatedSeatsOnAppChannels($verifyIsolatedSeatsOnAppChannels = null)
    {
        // validation for constraint: string
        if (!is_null($verifyIsolatedSeatsOnAppChannels) && !is_string($verifyIsolatedSeatsOnAppChannels)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($verifyIsolatedSeatsOnAppChannels, true), gettype($verifyIsolatedSeatsOnAppChannels)), __LINE__);
        }
        if (is_null($verifyIsolatedSeatsOnAppChannels) || (is_array($verifyIsolatedSeatsOnAppChannels) && empty($verifyIsolatedSeatsOnAppChannels))) {
            unset($this->VerifyIsolatedSeatsOnAppChannels);
        } else {
            $this->VerifyIsolatedSeatsOnAppChannels = $verifyIsolatedSeatsOnAppChannels;
        }
        return $this;
    }
    /**
     * Get VerifyNewEventsAreInTheFuture value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getVerifyNewEventsAreInTheFuture()
    {
        return isset($this->VerifyNewEventsAreInTheFuture) ? $this->VerifyNewEventsAreInTheFuture : null;
    }
    /**
     * Set VerifyNewEventsAreInTheFuture value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $verifyNewEventsAreInTheFuture
     * @return \patest\StructType\Security_TicketingCompanyParameters
     */
    public function setVerifyNewEventsAreInTheFuture($verifyNewEventsAreInTheFuture = null)
    {
        // validation for constraint: boolean
        if (!is_null($verifyNewEventsAreInTheFuture) && !is_bool($verifyNewEventsAreInTheFuture)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($verifyNewEventsAreInTheFuture, true), gettype($verifyNewEventsAreInTheFuture)), __LINE__);
        }
        if (is_null($verifyNewEventsAreInTheFuture) || (is_array($verifyNewEventsAreInTheFuture) && empty($verifyNewEventsAreInTheFuture))) {
            unset($this->VerifyNewEventsAreInTheFuture);
        } else {
            $this->VerifyNewEventsAreInTheFuture = $verifyNewEventsAreInTheFuture;
        }
        return $this;
    }
}
