<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.SubscriptionsCompanyParameters StructType
 * @subpackage Structs
 */
class Security_SubscriptionsCompanyParameters extends Security_CompanyParameterBase
{
    /**
     * The AffectTicketsToPastEventsOnChangeSubscriptionDetails
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AffectTicketsToPastEventsOnChangeSubscriptionDetails;
    /**
     * The AllowReplaceSeatOfExtraChargedSubscriberTicketOnLevel
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AllowReplaceSeatOfExtraChargedSubscriberTicketOnLevel;
    /**
     * The AllowTicketCompensation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowTicketCompensation;
    /**
     * The BonusTicketsParticipateInSubscriptionPricing
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $BonusTicketsParticipateInSubscriptionPricing;
    /**
     * The CanPurchaserRenewSubscriptionRegardlessOfOwner
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CanPurchaserRenewSubscriptionRegardlessOfOwner;
    /**
     * The CheckPerUserLimitationsOfSubsOnEveryBasketChange
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $CheckPerUserLimitationsOfSubsOnEveryBasketChange;
    /**
     * The DefaultSelectedSeason
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefaultSelectedSeason;
    /**
     * The DisplayFullyUtilizedSubscription
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DisplayFullyUtilizedSubscription;
    /**
     * The DoNotAlwaysSuggestSubscriberTicketsAssignment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DoNotAlwaysSuggestSubscriberTicketsAssignment;
    /**
     * The DoNotDisplayOldSeasons
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DoNotDisplayOldSeasons;
    /**
     * The EnforceReturningSubscriberTicketOnSubscriptionAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $EnforceReturningSubscriberTicketOnSubscriptionAccount;
    /**
     * The KeepSeriesRestrictionsOnEventDetach
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $KeepSeriesRestrictionsOnEventDetach;
    /**
     * The RelationshipTypeIdsForSubscriptionRenew
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RelationshipTypeIdsForSubscriptionRenew;
    /**
     * The ReplaceSubscriberTicketScreenPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReplaceSubscriberTicketScreenPolicy;
    /**
     * The RestrictionPropagationAccordingToOriginator
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $RestrictionPropagationAccordingToOriginator;
    /**
     * The ShouldAutoCopyLocksAndAllocationsFromSeriesToEventUponLinkage
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ShouldAutoCopyLocksAndAllocationsFromSeriesToEventUponLinkage;
    /**
     * The TicketDateEnforcementPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TicketDateEnforcementPolicy;
    /**
     * Constructor method for Security.SubscriptionsCompanyParameters
     * @uses Security_SubscriptionsCompanyParameters::setAffectTicketsToPastEventsOnChangeSubscriptionDetails()
     * @uses Security_SubscriptionsCompanyParameters::setAllowReplaceSeatOfExtraChargedSubscriberTicketOnLevel()
     * @uses Security_SubscriptionsCompanyParameters::setAllowTicketCompensation()
     * @uses Security_SubscriptionsCompanyParameters::setBonusTicketsParticipateInSubscriptionPricing()
     * @uses Security_SubscriptionsCompanyParameters::setCanPurchaserRenewSubscriptionRegardlessOfOwner()
     * @uses Security_SubscriptionsCompanyParameters::setCheckPerUserLimitationsOfSubsOnEveryBasketChange()
     * @uses Security_SubscriptionsCompanyParameters::setDefaultSelectedSeason()
     * @uses Security_SubscriptionsCompanyParameters::setDisplayFullyUtilizedSubscription()
     * @uses Security_SubscriptionsCompanyParameters::setDoNotAlwaysSuggestSubscriberTicketsAssignment()
     * @uses Security_SubscriptionsCompanyParameters::setDoNotDisplayOldSeasons()
     * @uses Security_SubscriptionsCompanyParameters::setEnforceReturningSubscriberTicketOnSubscriptionAccount()
     * @uses Security_SubscriptionsCompanyParameters::setKeepSeriesRestrictionsOnEventDetach()
     * @uses Security_SubscriptionsCompanyParameters::setRelationshipTypeIdsForSubscriptionRenew()
     * @uses Security_SubscriptionsCompanyParameters::setReplaceSubscriberTicketScreenPolicy()
     * @uses Security_SubscriptionsCompanyParameters::setRestrictionPropagationAccordingToOriginator()
     * @uses Security_SubscriptionsCompanyParameters::setShouldAutoCopyLocksAndAllocationsFromSeriesToEventUponLinkage()
     * @uses Security_SubscriptionsCompanyParameters::setTicketDateEnforcementPolicy()
     * @param bool $affectTicketsToPastEventsOnChangeSubscriptionDetails
     * @param int $allowReplaceSeatOfExtraChargedSubscriberTicketOnLevel
     * @param bool $allowTicketCompensation
     * @param bool $bonusTicketsParticipateInSubscriptionPricing
     * @param bool $canPurchaserRenewSubscriptionRegardlessOfOwner
     * @param bool $checkPerUserLimitationsOfSubsOnEveryBasketChange
     * @param string $defaultSelectedSeason
     * @param bool $displayFullyUtilizedSubscription
     * @param bool $doNotAlwaysSuggestSubscriberTicketsAssignment
     * @param string $doNotDisplayOldSeasons
     * @param bool $enforceReturningSubscriberTicketOnSubscriptionAccount
     * @param bool $keepSeriesRestrictionsOnEventDetach
     * @param string $relationshipTypeIdsForSubscriptionRenew
     * @param string $replaceSubscriberTicketScreenPolicy
     * @param bool $restrictionPropagationAccordingToOriginator
     * @param bool $shouldAutoCopyLocksAndAllocationsFromSeriesToEventUponLinkage
     * @param string $ticketDateEnforcementPolicy
     */
    public function __construct($affectTicketsToPastEventsOnChangeSubscriptionDetails = null, $allowReplaceSeatOfExtraChargedSubscriberTicketOnLevel = null, $allowTicketCompensation = null, $bonusTicketsParticipateInSubscriptionPricing = null, $canPurchaserRenewSubscriptionRegardlessOfOwner = null, $checkPerUserLimitationsOfSubsOnEveryBasketChange = null, $defaultSelectedSeason = null, $displayFullyUtilizedSubscription = null, $doNotAlwaysSuggestSubscriberTicketsAssignment = null, $doNotDisplayOldSeasons = null, $enforceReturningSubscriberTicketOnSubscriptionAccount = null, $keepSeriesRestrictionsOnEventDetach = null, $relationshipTypeIdsForSubscriptionRenew = null, $replaceSubscriberTicketScreenPolicy = null, $restrictionPropagationAccordingToOriginator = null, $shouldAutoCopyLocksAndAllocationsFromSeriesToEventUponLinkage = null, $ticketDateEnforcementPolicy = null)
    {
        $this
            ->setAffectTicketsToPastEventsOnChangeSubscriptionDetails($affectTicketsToPastEventsOnChangeSubscriptionDetails)
            ->setAllowReplaceSeatOfExtraChargedSubscriberTicketOnLevel($allowReplaceSeatOfExtraChargedSubscriberTicketOnLevel)
            ->setAllowTicketCompensation($allowTicketCompensation)
            ->setBonusTicketsParticipateInSubscriptionPricing($bonusTicketsParticipateInSubscriptionPricing)
            ->setCanPurchaserRenewSubscriptionRegardlessOfOwner($canPurchaserRenewSubscriptionRegardlessOfOwner)
            ->setCheckPerUserLimitationsOfSubsOnEveryBasketChange($checkPerUserLimitationsOfSubsOnEveryBasketChange)
            ->setDefaultSelectedSeason($defaultSelectedSeason)
            ->setDisplayFullyUtilizedSubscription($displayFullyUtilizedSubscription)
            ->setDoNotAlwaysSuggestSubscriberTicketsAssignment($doNotAlwaysSuggestSubscriberTicketsAssignment)
            ->setDoNotDisplayOldSeasons($doNotDisplayOldSeasons)
            ->setEnforceReturningSubscriberTicketOnSubscriptionAccount($enforceReturningSubscriberTicketOnSubscriptionAccount)
            ->setKeepSeriesRestrictionsOnEventDetach($keepSeriesRestrictionsOnEventDetach)
            ->setRelationshipTypeIdsForSubscriptionRenew($relationshipTypeIdsForSubscriptionRenew)
            ->setReplaceSubscriberTicketScreenPolicy($replaceSubscriberTicketScreenPolicy)
            ->setRestrictionPropagationAccordingToOriginator($restrictionPropagationAccordingToOriginator)
            ->setShouldAutoCopyLocksAndAllocationsFromSeriesToEventUponLinkage($shouldAutoCopyLocksAndAllocationsFromSeriesToEventUponLinkage)
            ->setTicketDateEnforcementPolicy($ticketDateEnforcementPolicy);
    }
    /**
     * Get AffectTicketsToPastEventsOnChangeSubscriptionDetails value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAffectTicketsToPastEventsOnChangeSubscriptionDetails()
    {
        return isset($this->AffectTicketsToPastEventsOnChangeSubscriptionDetails) ? $this->AffectTicketsToPastEventsOnChangeSubscriptionDetails : null;
    }
    /**
     * Set AffectTicketsToPastEventsOnChangeSubscriptionDetails value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $affectTicketsToPastEventsOnChangeSubscriptionDetails
     * @return \patest\StructType\Security_SubscriptionsCompanyParameters
     */
    public function setAffectTicketsToPastEventsOnChangeSubscriptionDetails($affectTicketsToPastEventsOnChangeSubscriptionDetails = null)
    {
        // validation for constraint: boolean
        if (!is_null($affectTicketsToPastEventsOnChangeSubscriptionDetails) && !is_bool($affectTicketsToPastEventsOnChangeSubscriptionDetails)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($affectTicketsToPastEventsOnChangeSubscriptionDetails, true), gettype($affectTicketsToPastEventsOnChangeSubscriptionDetails)), __LINE__);
        }
        if (is_null($affectTicketsToPastEventsOnChangeSubscriptionDetails) || (is_array($affectTicketsToPastEventsOnChangeSubscriptionDetails) && empty($affectTicketsToPastEventsOnChangeSubscriptionDetails))) {
            unset($this->AffectTicketsToPastEventsOnChangeSubscriptionDetails);
        } else {
            $this->AffectTicketsToPastEventsOnChangeSubscriptionDetails = $affectTicketsToPastEventsOnChangeSubscriptionDetails;
        }
        return $this;
    }
    /**
     * Get AllowReplaceSeatOfExtraChargedSubscriberTicketOnLevel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAllowReplaceSeatOfExtraChargedSubscriberTicketOnLevel()
    {
        return isset($this->AllowReplaceSeatOfExtraChargedSubscriberTicketOnLevel) ? $this->AllowReplaceSeatOfExtraChargedSubscriberTicketOnLevel : null;
    }
    /**
     * Set AllowReplaceSeatOfExtraChargedSubscriberTicketOnLevel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $allowReplaceSeatOfExtraChargedSubscriberTicketOnLevel
     * @return \patest\StructType\Security_SubscriptionsCompanyParameters
     */
    public function setAllowReplaceSeatOfExtraChargedSubscriberTicketOnLevel($allowReplaceSeatOfExtraChargedSubscriberTicketOnLevel = null)
    {
        // validation for constraint: int
        if (!is_null($allowReplaceSeatOfExtraChargedSubscriberTicketOnLevel) && !(is_int($allowReplaceSeatOfExtraChargedSubscriberTicketOnLevel) || ctype_digit($allowReplaceSeatOfExtraChargedSubscriberTicketOnLevel))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($allowReplaceSeatOfExtraChargedSubscriberTicketOnLevel, true), gettype($allowReplaceSeatOfExtraChargedSubscriberTicketOnLevel)), __LINE__);
        }
        if (is_null($allowReplaceSeatOfExtraChargedSubscriberTicketOnLevel) || (is_array($allowReplaceSeatOfExtraChargedSubscriberTicketOnLevel) && empty($allowReplaceSeatOfExtraChargedSubscriberTicketOnLevel))) {
            unset($this->AllowReplaceSeatOfExtraChargedSubscriberTicketOnLevel);
        } else {
            $this->AllowReplaceSeatOfExtraChargedSubscriberTicketOnLevel = $allowReplaceSeatOfExtraChargedSubscriberTicketOnLevel;
        }
        return $this;
    }
    /**
     * Get AllowTicketCompensation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowTicketCompensation()
    {
        return isset($this->AllowTicketCompensation) ? $this->AllowTicketCompensation : null;
    }
    /**
     * Set AllowTicketCompensation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowTicketCompensation
     * @return \patest\StructType\Security_SubscriptionsCompanyParameters
     */
    public function setAllowTicketCompensation($allowTicketCompensation = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowTicketCompensation) && !is_bool($allowTicketCompensation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowTicketCompensation, true), gettype($allowTicketCompensation)), __LINE__);
        }
        if (is_null($allowTicketCompensation) || (is_array($allowTicketCompensation) && empty($allowTicketCompensation))) {
            unset($this->AllowTicketCompensation);
        } else {
            $this->AllowTicketCompensation = $allowTicketCompensation;
        }
        return $this;
    }
    /**
     * Get BonusTicketsParticipateInSubscriptionPricing value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getBonusTicketsParticipateInSubscriptionPricing()
    {
        return isset($this->BonusTicketsParticipateInSubscriptionPricing) ? $this->BonusTicketsParticipateInSubscriptionPricing : null;
    }
    /**
     * Set BonusTicketsParticipateInSubscriptionPricing value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $bonusTicketsParticipateInSubscriptionPricing
     * @return \patest\StructType\Security_SubscriptionsCompanyParameters
     */
    public function setBonusTicketsParticipateInSubscriptionPricing($bonusTicketsParticipateInSubscriptionPricing = null)
    {
        // validation for constraint: boolean
        if (!is_null($bonusTicketsParticipateInSubscriptionPricing) && !is_bool($bonusTicketsParticipateInSubscriptionPricing)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bonusTicketsParticipateInSubscriptionPricing, true), gettype($bonusTicketsParticipateInSubscriptionPricing)), __LINE__);
        }
        if (is_null($bonusTicketsParticipateInSubscriptionPricing) || (is_array($bonusTicketsParticipateInSubscriptionPricing) && empty($bonusTicketsParticipateInSubscriptionPricing))) {
            unset($this->BonusTicketsParticipateInSubscriptionPricing);
        } else {
            $this->BonusTicketsParticipateInSubscriptionPricing = $bonusTicketsParticipateInSubscriptionPricing;
        }
        return $this;
    }
    /**
     * Get CanPurchaserRenewSubscriptionRegardlessOfOwner value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCanPurchaserRenewSubscriptionRegardlessOfOwner()
    {
        return isset($this->CanPurchaserRenewSubscriptionRegardlessOfOwner) ? $this->CanPurchaserRenewSubscriptionRegardlessOfOwner : null;
    }
    /**
     * Set CanPurchaserRenewSubscriptionRegardlessOfOwner value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $canPurchaserRenewSubscriptionRegardlessOfOwner
     * @return \patest\StructType\Security_SubscriptionsCompanyParameters
     */
    public function setCanPurchaserRenewSubscriptionRegardlessOfOwner($canPurchaserRenewSubscriptionRegardlessOfOwner = null)
    {
        // validation for constraint: boolean
        if (!is_null($canPurchaserRenewSubscriptionRegardlessOfOwner) && !is_bool($canPurchaserRenewSubscriptionRegardlessOfOwner)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($canPurchaserRenewSubscriptionRegardlessOfOwner, true), gettype($canPurchaserRenewSubscriptionRegardlessOfOwner)), __LINE__);
        }
        if (is_null($canPurchaserRenewSubscriptionRegardlessOfOwner) || (is_array($canPurchaserRenewSubscriptionRegardlessOfOwner) && empty($canPurchaserRenewSubscriptionRegardlessOfOwner))) {
            unset($this->CanPurchaserRenewSubscriptionRegardlessOfOwner);
        } else {
            $this->CanPurchaserRenewSubscriptionRegardlessOfOwner = $canPurchaserRenewSubscriptionRegardlessOfOwner;
        }
        return $this;
    }
    /**
     * Get CheckPerUserLimitationsOfSubsOnEveryBasketChange value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getCheckPerUserLimitationsOfSubsOnEveryBasketChange()
    {
        return isset($this->CheckPerUserLimitationsOfSubsOnEveryBasketChange) ? $this->CheckPerUserLimitationsOfSubsOnEveryBasketChange : null;
    }
    /**
     * Set CheckPerUserLimitationsOfSubsOnEveryBasketChange value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $checkPerUserLimitationsOfSubsOnEveryBasketChange
     * @return \patest\StructType\Security_SubscriptionsCompanyParameters
     */
    public function setCheckPerUserLimitationsOfSubsOnEveryBasketChange($checkPerUserLimitationsOfSubsOnEveryBasketChange = null)
    {
        // validation for constraint: boolean
        if (!is_null($checkPerUserLimitationsOfSubsOnEveryBasketChange) && !is_bool($checkPerUserLimitationsOfSubsOnEveryBasketChange)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($checkPerUserLimitationsOfSubsOnEveryBasketChange, true), gettype($checkPerUserLimitationsOfSubsOnEveryBasketChange)), __LINE__);
        }
        if (is_null($checkPerUserLimitationsOfSubsOnEveryBasketChange) || (is_array($checkPerUserLimitationsOfSubsOnEveryBasketChange) && empty($checkPerUserLimitationsOfSubsOnEveryBasketChange))) {
            unset($this->CheckPerUserLimitationsOfSubsOnEveryBasketChange);
        } else {
            $this->CheckPerUserLimitationsOfSubsOnEveryBasketChange = $checkPerUserLimitationsOfSubsOnEveryBasketChange;
        }
        return $this;
    }
    /**
     * Get DefaultSelectedSeason value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultSelectedSeason()
    {
        return isset($this->DefaultSelectedSeason) ? $this->DefaultSelectedSeason : null;
    }
    /**
     * Set DefaultSelectedSeason value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultSelectedSeason
     * @return \patest\StructType\Security_SubscriptionsCompanyParameters
     */
    public function setDefaultSelectedSeason($defaultSelectedSeason = null)
    {
        // validation for constraint: string
        if (!is_null($defaultSelectedSeason) && !is_string($defaultSelectedSeason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultSelectedSeason, true), gettype($defaultSelectedSeason)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($defaultSelectedSeason) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $defaultSelectedSeason)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($defaultSelectedSeason, true)), __LINE__);
        }
        if (is_null($defaultSelectedSeason) || (is_array($defaultSelectedSeason) && empty($defaultSelectedSeason))) {
            unset($this->DefaultSelectedSeason);
        } else {
            $this->DefaultSelectedSeason = $defaultSelectedSeason;
        }
        return $this;
    }
    /**
     * Get DisplayFullyUtilizedSubscription value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDisplayFullyUtilizedSubscription()
    {
        return isset($this->DisplayFullyUtilizedSubscription) ? $this->DisplayFullyUtilizedSubscription : null;
    }
    /**
     * Set DisplayFullyUtilizedSubscription value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $displayFullyUtilizedSubscription
     * @return \patest\StructType\Security_SubscriptionsCompanyParameters
     */
    public function setDisplayFullyUtilizedSubscription($displayFullyUtilizedSubscription = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayFullyUtilizedSubscription) && !is_bool($displayFullyUtilizedSubscription)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayFullyUtilizedSubscription, true), gettype($displayFullyUtilizedSubscription)), __LINE__);
        }
        if (is_null($displayFullyUtilizedSubscription) || (is_array($displayFullyUtilizedSubscription) && empty($displayFullyUtilizedSubscription))) {
            unset($this->DisplayFullyUtilizedSubscription);
        } else {
            $this->DisplayFullyUtilizedSubscription = $displayFullyUtilizedSubscription;
        }
        return $this;
    }
    /**
     * Get DoNotAlwaysSuggestSubscriberTicketsAssignment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDoNotAlwaysSuggestSubscriberTicketsAssignment()
    {
        return isset($this->DoNotAlwaysSuggestSubscriberTicketsAssignment) ? $this->DoNotAlwaysSuggestSubscriberTicketsAssignment : null;
    }
    /**
     * Set DoNotAlwaysSuggestSubscriberTicketsAssignment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $doNotAlwaysSuggestSubscriberTicketsAssignment
     * @return \patest\StructType\Security_SubscriptionsCompanyParameters
     */
    public function setDoNotAlwaysSuggestSubscriberTicketsAssignment($doNotAlwaysSuggestSubscriberTicketsAssignment = null)
    {
        // validation for constraint: boolean
        if (!is_null($doNotAlwaysSuggestSubscriberTicketsAssignment) && !is_bool($doNotAlwaysSuggestSubscriberTicketsAssignment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($doNotAlwaysSuggestSubscriberTicketsAssignment, true), gettype($doNotAlwaysSuggestSubscriberTicketsAssignment)), __LINE__);
        }
        if (is_null($doNotAlwaysSuggestSubscriberTicketsAssignment) || (is_array($doNotAlwaysSuggestSubscriberTicketsAssignment) && empty($doNotAlwaysSuggestSubscriberTicketsAssignment))) {
            unset($this->DoNotAlwaysSuggestSubscriberTicketsAssignment);
        } else {
            $this->DoNotAlwaysSuggestSubscriberTicketsAssignment = $doNotAlwaysSuggestSubscriberTicketsAssignment;
        }
        return $this;
    }
    /**
     * Get DoNotDisplayOldSeasons value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDoNotDisplayOldSeasons()
    {
        return isset($this->DoNotDisplayOldSeasons) ? $this->DoNotDisplayOldSeasons : null;
    }
    /**
     * Set DoNotDisplayOldSeasons value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $doNotDisplayOldSeasons
     * @return \patest\StructType\Security_SubscriptionsCompanyParameters
     */
    public function setDoNotDisplayOldSeasons($doNotDisplayOldSeasons = null)
    {
        // validation for constraint: string
        if (!is_null($doNotDisplayOldSeasons) && !is_string($doNotDisplayOldSeasons)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($doNotDisplayOldSeasons, true), gettype($doNotDisplayOldSeasons)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($doNotDisplayOldSeasons) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $doNotDisplayOldSeasons)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($doNotDisplayOldSeasons, true)), __LINE__);
        }
        if (is_null($doNotDisplayOldSeasons) || (is_array($doNotDisplayOldSeasons) && empty($doNotDisplayOldSeasons))) {
            unset($this->DoNotDisplayOldSeasons);
        } else {
            $this->DoNotDisplayOldSeasons = $doNotDisplayOldSeasons;
        }
        return $this;
    }
    /**
     * Get EnforceReturningSubscriberTicketOnSubscriptionAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEnforceReturningSubscriberTicketOnSubscriptionAccount()
    {
        return isset($this->EnforceReturningSubscriberTicketOnSubscriptionAccount) ? $this->EnforceReturningSubscriberTicketOnSubscriptionAccount : null;
    }
    /**
     * Set EnforceReturningSubscriberTicketOnSubscriptionAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $enforceReturningSubscriberTicketOnSubscriptionAccount
     * @return \patest\StructType\Security_SubscriptionsCompanyParameters
     */
    public function setEnforceReturningSubscriberTicketOnSubscriptionAccount($enforceReturningSubscriberTicketOnSubscriptionAccount = null)
    {
        // validation for constraint: boolean
        if (!is_null($enforceReturningSubscriberTicketOnSubscriptionAccount) && !is_bool($enforceReturningSubscriberTicketOnSubscriptionAccount)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($enforceReturningSubscriberTicketOnSubscriptionAccount, true), gettype($enforceReturningSubscriberTicketOnSubscriptionAccount)), __LINE__);
        }
        if (is_null($enforceReturningSubscriberTicketOnSubscriptionAccount) || (is_array($enforceReturningSubscriberTicketOnSubscriptionAccount) && empty($enforceReturningSubscriberTicketOnSubscriptionAccount))) {
            unset($this->EnforceReturningSubscriberTicketOnSubscriptionAccount);
        } else {
            $this->EnforceReturningSubscriberTicketOnSubscriptionAccount = $enforceReturningSubscriberTicketOnSubscriptionAccount;
        }
        return $this;
    }
    /**
     * Get KeepSeriesRestrictionsOnEventDetach value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getKeepSeriesRestrictionsOnEventDetach()
    {
        return isset($this->KeepSeriesRestrictionsOnEventDetach) ? $this->KeepSeriesRestrictionsOnEventDetach : null;
    }
    /**
     * Set KeepSeriesRestrictionsOnEventDetach value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $keepSeriesRestrictionsOnEventDetach
     * @return \patest\StructType\Security_SubscriptionsCompanyParameters
     */
    public function setKeepSeriesRestrictionsOnEventDetach($keepSeriesRestrictionsOnEventDetach = null)
    {
        // validation for constraint: boolean
        if (!is_null($keepSeriesRestrictionsOnEventDetach) && !is_bool($keepSeriesRestrictionsOnEventDetach)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($keepSeriesRestrictionsOnEventDetach, true), gettype($keepSeriesRestrictionsOnEventDetach)), __LINE__);
        }
        if (is_null($keepSeriesRestrictionsOnEventDetach) || (is_array($keepSeriesRestrictionsOnEventDetach) && empty($keepSeriesRestrictionsOnEventDetach))) {
            unset($this->KeepSeriesRestrictionsOnEventDetach);
        } else {
            $this->KeepSeriesRestrictionsOnEventDetach = $keepSeriesRestrictionsOnEventDetach;
        }
        return $this;
    }
    /**
     * Get RelationshipTypeIdsForSubscriptionRenew value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRelationshipTypeIdsForSubscriptionRenew()
    {
        return isset($this->RelationshipTypeIdsForSubscriptionRenew) ? $this->RelationshipTypeIdsForSubscriptionRenew : null;
    }
    /**
     * Set RelationshipTypeIdsForSubscriptionRenew value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $relationshipTypeIdsForSubscriptionRenew
     * @return \patest\StructType\Security_SubscriptionsCompanyParameters
     */
    public function setRelationshipTypeIdsForSubscriptionRenew($relationshipTypeIdsForSubscriptionRenew = null)
    {
        // validation for constraint: string
        if (!is_null($relationshipTypeIdsForSubscriptionRenew) && !is_string($relationshipTypeIdsForSubscriptionRenew)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($relationshipTypeIdsForSubscriptionRenew, true), gettype($relationshipTypeIdsForSubscriptionRenew)), __LINE__);
        }
        if (is_null($relationshipTypeIdsForSubscriptionRenew) || (is_array($relationshipTypeIdsForSubscriptionRenew) && empty($relationshipTypeIdsForSubscriptionRenew))) {
            unset($this->RelationshipTypeIdsForSubscriptionRenew);
        } else {
            $this->RelationshipTypeIdsForSubscriptionRenew = $relationshipTypeIdsForSubscriptionRenew;
        }
        return $this;
    }
    /**
     * Get ReplaceSubscriberTicketScreenPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReplaceSubscriberTicketScreenPolicy()
    {
        return isset($this->ReplaceSubscriberTicketScreenPolicy) ? $this->ReplaceSubscriberTicketScreenPolicy : null;
    }
    /**
     * Set ReplaceSubscriberTicketScreenPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\ReplaceSubscriberTicketScreenPolicy::valueIsValid()
     * @uses \patest\EnumType\ReplaceSubscriberTicketScreenPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $replaceSubscriberTicketScreenPolicy
     * @return \patest\StructType\Security_SubscriptionsCompanyParameters
     */
    public function setReplaceSubscriberTicketScreenPolicy($replaceSubscriberTicketScreenPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\ReplaceSubscriberTicketScreenPolicy::valueIsValid($replaceSubscriberTicketScreenPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\ReplaceSubscriberTicketScreenPolicy', is_array($replaceSubscriberTicketScreenPolicy) ? implode(', ', $replaceSubscriberTicketScreenPolicy) : var_export($replaceSubscriberTicketScreenPolicy, true), implode(', ', \patest\EnumType\ReplaceSubscriberTicketScreenPolicy::getValidValues())), __LINE__);
        }
        if (is_null($replaceSubscriberTicketScreenPolicy) || (is_array($replaceSubscriberTicketScreenPolicy) && empty($replaceSubscriberTicketScreenPolicy))) {
            unset($this->ReplaceSubscriberTicketScreenPolicy);
        } else {
            $this->ReplaceSubscriberTicketScreenPolicy = $replaceSubscriberTicketScreenPolicy;
        }
        return $this;
    }
    /**
     * Get RestrictionPropagationAccordingToOriginator value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getRestrictionPropagationAccordingToOriginator()
    {
        return isset($this->RestrictionPropagationAccordingToOriginator) ? $this->RestrictionPropagationAccordingToOriginator : null;
    }
    /**
     * Set RestrictionPropagationAccordingToOriginator value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $restrictionPropagationAccordingToOriginator
     * @return \patest\StructType\Security_SubscriptionsCompanyParameters
     */
    public function setRestrictionPropagationAccordingToOriginator($restrictionPropagationAccordingToOriginator = null)
    {
        // validation for constraint: boolean
        if (!is_null($restrictionPropagationAccordingToOriginator) && !is_bool($restrictionPropagationAccordingToOriginator)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($restrictionPropagationAccordingToOriginator, true), gettype($restrictionPropagationAccordingToOriginator)), __LINE__);
        }
        if (is_null($restrictionPropagationAccordingToOriginator) || (is_array($restrictionPropagationAccordingToOriginator) && empty($restrictionPropagationAccordingToOriginator))) {
            unset($this->RestrictionPropagationAccordingToOriginator);
        } else {
            $this->RestrictionPropagationAccordingToOriginator = $restrictionPropagationAccordingToOriginator;
        }
        return $this;
    }
    /**
     * Get ShouldAutoCopyLocksAndAllocationsFromSeriesToEventUponLinkage value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getShouldAutoCopyLocksAndAllocationsFromSeriesToEventUponLinkage()
    {
        return isset($this->ShouldAutoCopyLocksAndAllocationsFromSeriesToEventUponLinkage) ? $this->ShouldAutoCopyLocksAndAllocationsFromSeriesToEventUponLinkage : null;
    }
    /**
     * Set ShouldAutoCopyLocksAndAllocationsFromSeriesToEventUponLinkage value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $shouldAutoCopyLocksAndAllocationsFromSeriesToEventUponLinkage
     * @return \patest\StructType\Security_SubscriptionsCompanyParameters
     */
    public function setShouldAutoCopyLocksAndAllocationsFromSeriesToEventUponLinkage($shouldAutoCopyLocksAndAllocationsFromSeriesToEventUponLinkage = null)
    {
        // validation for constraint: boolean
        if (!is_null($shouldAutoCopyLocksAndAllocationsFromSeriesToEventUponLinkage) && !is_bool($shouldAutoCopyLocksAndAllocationsFromSeriesToEventUponLinkage)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($shouldAutoCopyLocksAndAllocationsFromSeriesToEventUponLinkage, true), gettype($shouldAutoCopyLocksAndAllocationsFromSeriesToEventUponLinkage)), __LINE__);
        }
        if (is_null($shouldAutoCopyLocksAndAllocationsFromSeriesToEventUponLinkage) || (is_array($shouldAutoCopyLocksAndAllocationsFromSeriesToEventUponLinkage) && empty($shouldAutoCopyLocksAndAllocationsFromSeriesToEventUponLinkage))) {
            unset($this->ShouldAutoCopyLocksAndAllocationsFromSeriesToEventUponLinkage);
        } else {
            $this->ShouldAutoCopyLocksAndAllocationsFromSeriesToEventUponLinkage = $shouldAutoCopyLocksAndAllocationsFromSeriesToEventUponLinkage;
        }
        return $this;
    }
    /**
     * Get TicketDateEnforcementPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTicketDateEnforcementPolicy()
    {
        return isset($this->TicketDateEnforcementPolicy) ? $this->TicketDateEnforcementPolicy : null;
    }
    /**
     * Set TicketDateEnforcementPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\TicketDateEnforcementPolicy::valueIsValid()
     * @uses \patest\EnumType\TicketDateEnforcementPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $ticketDateEnforcementPolicy
     * @return \patest\StructType\Security_SubscriptionsCompanyParameters
     */
    public function setTicketDateEnforcementPolicy($ticketDateEnforcementPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\TicketDateEnforcementPolicy::valueIsValid($ticketDateEnforcementPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\TicketDateEnforcementPolicy', is_array($ticketDateEnforcementPolicy) ? implode(', ', $ticketDateEnforcementPolicy) : var_export($ticketDateEnforcementPolicy, true), implode(', ', \patest\EnumType\TicketDateEnforcementPolicy::getValidValues())), __LINE__);
        }
        if (is_null($ticketDateEnforcementPolicy) || (is_array($ticketDateEnforcementPolicy) && empty($ticketDateEnforcementPolicy))) {
            unset($this->TicketDateEnforcementPolicy);
        } else {
            $this->TicketDateEnforcementPolicy = $ticketDateEnforcementPolicy;
        }
        return $this;
    }
}
