<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.SecurityCompanyParameters StructType
 * @subpackage Structs
 */
class Security_SecurityCompanyParameters extends Security_CompanyParameterBase
{
    /**
     * The AllowSroPluginForAllUsers
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllowSroPluginForAllUsers;
    /**
     * The Client_CheckPasswordDoesNotContainUserName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Client_CheckPasswordDoesNotContainUserName;
    /**
     * The Client_CheckPasswordHistory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Client_CheckPasswordHistory;
    /**
     * The Client_InvalidPasswordAttemptsPeriodInMinutes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Client_InvalidPasswordAttemptsPeriodInMinutes;
    /**
     * The Client_LockPeriodInMinutes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Client_LockPeriodInMinutes;
    /**
     * The Client_MaxInvalidPasswordAttemptsCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Client_MaxInvalidPasswordAttemptsCount;
    /**
     * The Client_MinPasswordLength
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Client_MinPasswordLength;
    /**
     * The Client_PasswordExpirationDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Client_PasswordExpirationDays;
    /**
     * The Client_PasswordMustHaveAlphaNumericCharacters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Client_PasswordMustHaveAlphaNumericCharacters;
    /**
     * The Client_PasswordMustHaveLowerAndUpperCaseCharacters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Client_PasswordMustHaveLowerAndUpperCaseCharacters;
    /**
     * The Client_PasswordMustHaveSpecialCharacters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Client_PasswordMustHaveSpecialCharacters;
    /**
     * The Client_PasswordsHistoryDepth
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Client_PasswordsHistoryDepth;
    /**
     * The Client_PciCompliant
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Client_PciCompliant;
    /**
     * The Client_UserMustChangePasswordOnFirstLogin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Client_UserMustChangePasswordOnFirstLogin;
    /**
     * The ContextExpirationMinutes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ContextExpirationMinutes;
    /**
     * The filterGeneric
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $filterGeneric;
    /**
     * The filterHuman
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $filterHuman;
    /**
     * The filterSeatGeekHuman
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $filterSeatGeekHuman;
    /**
     * The filterThirdPartyHuman
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $filterThirdPartyHuman;
    /**
     * The ResetPasswordTokenExpiryInHours
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ResetPasswordTokenExpiryInHours;
    /**
     * The TrustedDomains
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TrustedDomains;
    /**
     * The UserRequestExpiryInHours
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $UserRequestExpiryInHours;
    /**
     * The User_CheckPasswordDoesNotContainUserName
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $User_CheckPasswordDoesNotContainUserName;
    /**
     * The User_CheckPasswordHistory
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $User_CheckPasswordHistory;
    /**
     * The User_InvalidPasswordAttemptsPeriodInMinutes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $User_InvalidPasswordAttemptsPeriodInMinutes;
    /**
     * The User_LockPeriodInMinutes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $User_LockPeriodInMinutes;
    /**
     * The User_MaxInvalidPasswordAttemptsCount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $User_MaxInvalidPasswordAttemptsCount;
    /**
     * The User_MinPasswordLength
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $User_MinPasswordLength;
    /**
     * The User_PasswordExpirationDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $User_PasswordExpirationDays;
    /**
     * The User_PasswordMustHaveAlphaNumericCharacters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $User_PasswordMustHaveAlphaNumericCharacters;
    /**
     * The User_PasswordMustHaveLowerAndUpperCaseCharacters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $User_PasswordMustHaveLowerAndUpperCaseCharacters;
    /**
     * The User_PasswordMustHaveSpecialCharacters
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $User_PasswordMustHaveSpecialCharacters;
    /**
     * The User_PasswordsHistoryDepth
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $User_PasswordsHistoryDepth;
    /**
     * The User_UserMustChangePasswordOnFirstLogin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $User_UserMustChangePasswordOnFirstLogin;
    /**
     * The VerifyRegistrationTokenExpiryInHours
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $VerifyRegistrationTokenExpiryInHours;
    /**
     * Constructor method for Security.SecurityCompanyParameters
     * @uses Security_SecurityCompanyParameters::setAllowSroPluginForAllUsers()
     * @uses Security_SecurityCompanyParameters::setClient_CheckPasswordDoesNotContainUserName()
     * @uses Security_SecurityCompanyParameters::setClient_CheckPasswordHistory()
     * @uses Security_SecurityCompanyParameters::setClient_InvalidPasswordAttemptsPeriodInMinutes()
     * @uses Security_SecurityCompanyParameters::setClient_LockPeriodInMinutes()
     * @uses Security_SecurityCompanyParameters::setClient_MaxInvalidPasswordAttemptsCount()
     * @uses Security_SecurityCompanyParameters::setClient_MinPasswordLength()
     * @uses Security_SecurityCompanyParameters::setClient_PasswordExpirationDays()
     * @uses Security_SecurityCompanyParameters::setClient_PasswordMustHaveAlphaNumericCharacters()
     * @uses Security_SecurityCompanyParameters::setClient_PasswordMustHaveLowerAndUpperCaseCharacters()
     * @uses Security_SecurityCompanyParameters::setClient_PasswordMustHaveSpecialCharacters()
     * @uses Security_SecurityCompanyParameters::setClient_PasswordsHistoryDepth()
     * @uses Security_SecurityCompanyParameters::setClient_PciCompliant()
     * @uses Security_SecurityCompanyParameters::setClient_UserMustChangePasswordOnFirstLogin()
     * @uses Security_SecurityCompanyParameters::setContextExpirationMinutes()
     * @uses Security_SecurityCompanyParameters::setFilterGeneric()
     * @uses Security_SecurityCompanyParameters::setFilterHuman()
     * @uses Security_SecurityCompanyParameters::setFilterSeatGeekHuman()
     * @uses Security_SecurityCompanyParameters::setFilterThirdPartyHuman()
     * @uses Security_SecurityCompanyParameters::setResetPasswordTokenExpiryInHours()
     * @uses Security_SecurityCompanyParameters::setTrustedDomains()
     * @uses Security_SecurityCompanyParameters::setUserRequestExpiryInHours()
     * @uses Security_SecurityCompanyParameters::setUser_CheckPasswordDoesNotContainUserName()
     * @uses Security_SecurityCompanyParameters::setUser_CheckPasswordHistory()
     * @uses Security_SecurityCompanyParameters::setUser_InvalidPasswordAttemptsPeriodInMinutes()
     * @uses Security_SecurityCompanyParameters::setUser_LockPeriodInMinutes()
     * @uses Security_SecurityCompanyParameters::setUser_MaxInvalidPasswordAttemptsCount()
     * @uses Security_SecurityCompanyParameters::setUser_MinPasswordLength()
     * @uses Security_SecurityCompanyParameters::setUser_PasswordExpirationDays()
     * @uses Security_SecurityCompanyParameters::setUser_PasswordMustHaveAlphaNumericCharacters()
     * @uses Security_SecurityCompanyParameters::setUser_PasswordMustHaveLowerAndUpperCaseCharacters()
     * @uses Security_SecurityCompanyParameters::setUser_PasswordMustHaveSpecialCharacters()
     * @uses Security_SecurityCompanyParameters::setUser_PasswordsHistoryDepth()
     * @uses Security_SecurityCompanyParameters::setUser_UserMustChangePasswordOnFirstLogin()
     * @uses Security_SecurityCompanyParameters::setVerifyRegistrationTokenExpiryInHours()
     * @param bool $allowSroPluginForAllUsers
     * @param bool $client_CheckPasswordDoesNotContainUserName
     * @param bool $client_CheckPasswordHistory
     * @param int $client_InvalidPasswordAttemptsPeriodInMinutes
     * @param int $client_LockPeriodInMinutes
     * @param int $client_MaxInvalidPasswordAttemptsCount
     * @param int $client_MinPasswordLength
     * @param int $client_PasswordExpirationDays
     * @param bool $client_PasswordMustHaveAlphaNumericCharacters
     * @param bool $client_PasswordMustHaveLowerAndUpperCaseCharacters
     * @param bool $client_PasswordMustHaveSpecialCharacters
     * @param int $client_PasswordsHistoryDepth
     * @param bool $client_PciCompliant
     * @param bool $client_UserMustChangePasswordOnFirstLogin
     * @param int $contextExpirationMinutes
     * @param bool $filterGeneric
     * @param bool $filterHuman
     * @param bool $filterSeatGeekHuman
     * @param bool $filterThirdPartyHuman
     * @param int $resetPasswordTokenExpiryInHours
     * @param string $trustedDomains
     * @param int $userRequestExpiryInHours
     * @param bool $user_CheckPasswordDoesNotContainUserName
     * @param bool $user_CheckPasswordHistory
     * @param int $user_InvalidPasswordAttemptsPeriodInMinutes
     * @param int $user_LockPeriodInMinutes
     * @param int $user_MaxInvalidPasswordAttemptsCount
     * @param int $user_MinPasswordLength
     * @param int $user_PasswordExpirationDays
     * @param bool $user_PasswordMustHaveAlphaNumericCharacters
     * @param bool $user_PasswordMustHaveLowerAndUpperCaseCharacters
     * @param bool $user_PasswordMustHaveSpecialCharacters
     * @param int $user_PasswordsHistoryDepth
     * @param bool $user_UserMustChangePasswordOnFirstLogin
     * @param int $verifyRegistrationTokenExpiryInHours
     */
    public function __construct($allowSroPluginForAllUsers = null, $client_CheckPasswordDoesNotContainUserName = null, $client_CheckPasswordHistory = null, $client_InvalidPasswordAttemptsPeriodInMinutes = null, $client_LockPeriodInMinutes = null, $client_MaxInvalidPasswordAttemptsCount = null, $client_MinPasswordLength = null, $client_PasswordExpirationDays = null, $client_PasswordMustHaveAlphaNumericCharacters = null, $client_PasswordMustHaveLowerAndUpperCaseCharacters = null, $client_PasswordMustHaveSpecialCharacters = null, $client_PasswordsHistoryDepth = null, $client_PciCompliant = null, $client_UserMustChangePasswordOnFirstLogin = null, $contextExpirationMinutes = null, $filterGeneric = null, $filterHuman = null, $filterSeatGeekHuman = null, $filterThirdPartyHuman = null, $resetPasswordTokenExpiryInHours = null, $trustedDomains = null, $userRequestExpiryInHours = null, $user_CheckPasswordDoesNotContainUserName = null, $user_CheckPasswordHistory = null, $user_InvalidPasswordAttemptsPeriodInMinutes = null, $user_LockPeriodInMinutes = null, $user_MaxInvalidPasswordAttemptsCount = null, $user_MinPasswordLength = null, $user_PasswordExpirationDays = null, $user_PasswordMustHaveAlphaNumericCharacters = null, $user_PasswordMustHaveLowerAndUpperCaseCharacters = null, $user_PasswordMustHaveSpecialCharacters = null, $user_PasswordsHistoryDepth = null, $user_UserMustChangePasswordOnFirstLogin = null, $verifyRegistrationTokenExpiryInHours = null)
    {
        $this
            ->setAllowSroPluginForAllUsers($allowSroPluginForAllUsers)
            ->setClient_CheckPasswordDoesNotContainUserName($client_CheckPasswordDoesNotContainUserName)
            ->setClient_CheckPasswordHistory($client_CheckPasswordHistory)
            ->setClient_InvalidPasswordAttemptsPeriodInMinutes($client_InvalidPasswordAttemptsPeriodInMinutes)
            ->setClient_LockPeriodInMinutes($client_LockPeriodInMinutes)
            ->setClient_MaxInvalidPasswordAttemptsCount($client_MaxInvalidPasswordAttemptsCount)
            ->setClient_MinPasswordLength($client_MinPasswordLength)
            ->setClient_PasswordExpirationDays($client_PasswordExpirationDays)
            ->setClient_PasswordMustHaveAlphaNumericCharacters($client_PasswordMustHaveAlphaNumericCharacters)
            ->setClient_PasswordMustHaveLowerAndUpperCaseCharacters($client_PasswordMustHaveLowerAndUpperCaseCharacters)
            ->setClient_PasswordMustHaveSpecialCharacters($client_PasswordMustHaveSpecialCharacters)
            ->setClient_PasswordsHistoryDepth($client_PasswordsHistoryDepth)
            ->setClient_PciCompliant($client_PciCompliant)
            ->setClient_UserMustChangePasswordOnFirstLogin($client_UserMustChangePasswordOnFirstLogin)
            ->setContextExpirationMinutes($contextExpirationMinutes)
            ->setFilterGeneric($filterGeneric)
            ->setFilterHuman($filterHuman)
            ->setFilterSeatGeekHuman($filterSeatGeekHuman)
            ->setFilterThirdPartyHuman($filterThirdPartyHuman)
            ->setResetPasswordTokenExpiryInHours($resetPasswordTokenExpiryInHours)
            ->setTrustedDomains($trustedDomains)
            ->setUserRequestExpiryInHours($userRequestExpiryInHours)
            ->setUser_CheckPasswordDoesNotContainUserName($user_CheckPasswordDoesNotContainUserName)
            ->setUser_CheckPasswordHistory($user_CheckPasswordHistory)
            ->setUser_InvalidPasswordAttemptsPeriodInMinutes($user_InvalidPasswordAttemptsPeriodInMinutes)
            ->setUser_LockPeriodInMinutes($user_LockPeriodInMinutes)
            ->setUser_MaxInvalidPasswordAttemptsCount($user_MaxInvalidPasswordAttemptsCount)
            ->setUser_MinPasswordLength($user_MinPasswordLength)
            ->setUser_PasswordExpirationDays($user_PasswordExpirationDays)
            ->setUser_PasswordMustHaveAlphaNumericCharacters($user_PasswordMustHaveAlphaNumericCharacters)
            ->setUser_PasswordMustHaveLowerAndUpperCaseCharacters($user_PasswordMustHaveLowerAndUpperCaseCharacters)
            ->setUser_PasswordMustHaveSpecialCharacters($user_PasswordMustHaveSpecialCharacters)
            ->setUser_PasswordsHistoryDepth($user_PasswordsHistoryDepth)
            ->setUser_UserMustChangePasswordOnFirstLogin($user_UserMustChangePasswordOnFirstLogin)
            ->setVerifyRegistrationTokenExpiryInHours($verifyRegistrationTokenExpiryInHours);
    }
    /**
     * Get AllowSroPluginForAllUsers value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllowSroPluginForAllUsers()
    {
        return isset($this->AllowSroPluginForAllUsers) ? $this->AllowSroPluginForAllUsers : null;
    }
    /**
     * Set AllowSroPluginForAllUsers value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allowSroPluginForAllUsers
     * @return \patest\StructType\Security_SecurityCompanyParameters
     */
    public function setAllowSroPluginForAllUsers($allowSroPluginForAllUsers = null)
    {
        // validation for constraint: boolean
        if (!is_null($allowSroPluginForAllUsers) && !is_bool($allowSroPluginForAllUsers)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allowSroPluginForAllUsers, true), gettype($allowSroPluginForAllUsers)), __LINE__);
        }
        if (is_null($allowSroPluginForAllUsers) || (is_array($allowSroPluginForAllUsers) && empty($allowSroPluginForAllUsers))) {
            unset($this->AllowSroPluginForAllUsers);
        } else {
            $this->AllowSroPluginForAllUsers = $allowSroPluginForAllUsers;
        }
        return $this;
    }
    /**
     * Get Client_CheckPasswordDoesNotContainUserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getClient_CheckPasswordDoesNotContainUserName()
    {
        return isset($this->Client_CheckPasswordDoesNotContainUserName) ? $this->Client_CheckPasswordDoesNotContainUserName : null;
    }
    /**
     * Set Client_CheckPasswordDoesNotContainUserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $client_CheckPasswordDoesNotContainUserName
     * @return \patest\StructType\Security_SecurityCompanyParameters
     */
    public function setClient_CheckPasswordDoesNotContainUserName($client_CheckPasswordDoesNotContainUserName = null)
    {
        // validation for constraint: boolean
        if (!is_null($client_CheckPasswordDoesNotContainUserName) && !is_bool($client_CheckPasswordDoesNotContainUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($client_CheckPasswordDoesNotContainUserName, true), gettype($client_CheckPasswordDoesNotContainUserName)), __LINE__);
        }
        if (is_null($client_CheckPasswordDoesNotContainUserName) || (is_array($client_CheckPasswordDoesNotContainUserName) && empty($client_CheckPasswordDoesNotContainUserName))) {
            unset($this->Client_CheckPasswordDoesNotContainUserName);
        } else {
            $this->Client_CheckPasswordDoesNotContainUserName = $client_CheckPasswordDoesNotContainUserName;
        }
        return $this;
    }
    /**
     * Get Client_CheckPasswordHistory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getClient_CheckPasswordHistory()
    {
        return isset($this->Client_CheckPasswordHistory) ? $this->Client_CheckPasswordHistory : null;
    }
    /**
     * Set Client_CheckPasswordHistory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $client_CheckPasswordHistory
     * @return \patest\StructType\Security_SecurityCompanyParameters
     */
    public function setClient_CheckPasswordHistory($client_CheckPasswordHistory = null)
    {
        // validation for constraint: boolean
        if (!is_null($client_CheckPasswordHistory) && !is_bool($client_CheckPasswordHistory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($client_CheckPasswordHistory, true), gettype($client_CheckPasswordHistory)), __LINE__);
        }
        if (is_null($client_CheckPasswordHistory) || (is_array($client_CheckPasswordHistory) && empty($client_CheckPasswordHistory))) {
            unset($this->Client_CheckPasswordHistory);
        } else {
            $this->Client_CheckPasswordHistory = $client_CheckPasswordHistory;
        }
        return $this;
    }
    /**
     * Get Client_InvalidPasswordAttemptsPeriodInMinutes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getClient_InvalidPasswordAttemptsPeriodInMinutes()
    {
        return isset($this->Client_InvalidPasswordAttemptsPeriodInMinutes) ? $this->Client_InvalidPasswordAttemptsPeriodInMinutes : null;
    }
    /**
     * Set Client_InvalidPasswordAttemptsPeriodInMinutes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $client_InvalidPasswordAttemptsPeriodInMinutes
     * @return \patest\StructType\Security_SecurityCompanyParameters
     */
    public function setClient_InvalidPasswordAttemptsPeriodInMinutes($client_InvalidPasswordAttemptsPeriodInMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($client_InvalidPasswordAttemptsPeriodInMinutes) && !(is_int($client_InvalidPasswordAttemptsPeriodInMinutes) || ctype_digit($client_InvalidPasswordAttemptsPeriodInMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($client_InvalidPasswordAttemptsPeriodInMinutes, true), gettype($client_InvalidPasswordAttemptsPeriodInMinutes)), __LINE__);
        }
        if (is_null($client_InvalidPasswordAttemptsPeriodInMinutes) || (is_array($client_InvalidPasswordAttemptsPeriodInMinutes) && empty($client_InvalidPasswordAttemptsPeriodInMinutes))) {
            unset($this->Client_InvalidPasswordAttemptsPeriodInMinutes);
        } else {
            $this->Client_InvalidPasswordAttemptsPeriodInMinutes = $client_InvalidPasswordAttemptsPeriodInMinutes;
        }
        return $this;
    }
    /**
     * Get Client_LockPeriodInMinutes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getClient_LockPeriodInMinutes()
    {
        return isset($this->Client_LockPeriodInMinutes) ? $this->Client_LockPeriodInMinutes : null;
    }
    /**
     * Set Client_LockPeriodInMinutes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $client_LockPeriodInMinutes
     * @return \patest\StructType\Security_SecurityCompanyParameters
     */
    public function setClient_LockPeriodInMinutes($client_LockPeriodInMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($client_LockPeriodInMinutes) && !(is_int($client_LockPeriodInMinutes) || ctype_digit($client_LockPeriodInMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($client_LockPeriodInMinutes, true), gettype($client_LockPeriodInMinutes)), __LINE__);
        }
        if (is_null($client_LockPeriodInMinutes) || (is_array($client_LockPeriodInMinutes) && empty($client_LockPeriodInMinutes))) {
            unset($this->Client_LockPeriodInMinutes);
        } else {
            $this->Client_LockPeriodInMinutes = $client_LockPeriodInMinutes;
        }
        return $this;
    }
    /**
     * Get Client_MaxInvalidPasswordAttemptsCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getClient_MaxInvalidPasswordAttemptsCount()
    {
        return isset($this->Client_MaxInvalidPasswordAttemptsCount) ? $this->Client_MaxInvalidPasswordAttemptsCount : null;
    }
    /**
     * Set Client_MaxInvalidPasswordAttemptsCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $client_MaxInvalidPasswordAttemptsCount
     * @return \patest\StructType\Security_SecurityCompanyParameters
     */
    public function setClient_MaxInvalidPasswordAttemptsCount($client_MaxInvalidPasswordAttemptsCount = null)
    {
        // validation for constraint: int
        if (!is_null($client_MaxInvalidPasswordAttemptsCount) && !(is_int($client_MaxInvalidPasswordAttemptsCount) || ctype_digit($client_MaxInvalidPasswordAttemptsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($client_MaxInvalidPasswordAttemptsCount, true), gettype($client_MaxInvalidPasswordAttemptsCount)), __LINE__);
        }
        if (is_null($client_MaxInvalidPasswordAttemptsCount) || (is_array($client_MaxInvalidPasswordAttemptsCount) && empty($client_MaxInvalidPasswordAttemptsCount))) {
            unset($this->Client_MaxInvalidPasswordAttemptsCount);
        } else {
            $this->Client_MaxInvalidPasswordAttemptsCount = $client_MaxInvalidPasswordAttemptsCount;
        }
        return $this;
    }
    /**
     * Get Client_MinPasswordLength value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getClient_MinPasswordLength()
    {
        return isset($this->Client_MinPasswordLength) ? $this->Client_MinPasswordLength : null;
    }
    /**
     * Set Client_MinPasswordLength value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $client_MinPasswordLength
     * @return \patest\StructType\Security_SecurityCompanyParameters
     */
    public function setClient_MinPasswordLength($client_MinPasswordLength = null)
    {
        // validation for constraint: int
        if (!is_null($client_MinPasswordLength) && !(is_int($client_MinPasswordLength) || ctype_digit($client_MinPasswordLength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($client_MinPasswordLength, true), gettype($client_MinPasswordLength)), __LINE__);
        }
        if (is_null($client_MinPasswordLength) || (is_array($client_MinPasswordLength) && empty($client_MinPasswordLength))) {
            unset($this->Client_MinPasswordLength);
        } else {
            $this->Client_MinPasswordLength = $client_MinPasswordLength;
        }
        return $this;
    }
    /**
     * Get Client_PasswordExpirationDays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getClient_PasswordExpirationDays()
    {
        return isset($this->Client_PasswordExpirationDays) ? $this->Client_PasswordExpirationDays : null;
    }
    /**
     * Set Client_PasswordExpirationDays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $client_PasswordExpirationDays
     * @return \patest\StructType\Security_SecurityCompanyParameters
     */
    public function setClient_PasswordExpirationDays($client_PasswordExpirationDays = null)
    {
        // validation for constraint: int
        if (!is_null($client_PasswordExpirationDays) && !(is_int($client_PasswordExpirationDays) || ctype_digit($client_PasswordExpirationDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($client_PasswordExpirationDays, true), gettype($client_PasswordExpirationDays)), __LINE__);
        }
        if (is_null($client_PasswordExpirationDays) || (is_array($client_PasswordExpirationDays) && empty($client_PasswordExpirationDays))) {
            unset($this->Client_PasswordExpirationDays);
        } else {
            $this->Client_PasswordExpirationDays = $client_PasswordExpirationDays;
        }
        return $this;
    }
    /**
     * Get Client_PasswordMustHaveAlphaNumericCharacters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getClient_PasswordMustHaveAlphaNumericCharacters()
    {
        return isset($this->Client_PasswordMustHaveAlphaNumericCharacters) ? $this->Client_PasswordMustHaveAlphaNumericCharacters : null;
    }
    /**
     * Set Client_PasswordMustHaveAlphaNumericCharacters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $client_PasswordMustHaveAlphaNumericCharacters
     * @return \patest\StructType\Security_SecurityCompanyParameters
     */
    public function setClient_PasswordMustHaveAlphaNumericCharacters($client_PasswordMustHaveAlphaNumericCharacters = null)
    {
        // validation for constraint: boolean
        if (!is_null($client_PasswordMustHaveAlphaNumericCharacters) && !is_bool($client_PasswordMustHaveAlphaNumericCharacters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($client_PasswordMustHaveAlphaNumericCharacters, true), gettype($client_PasswordMustHaveAlphaNumericCharacters)), __LINE__);
        }
        if (is_null($client_PasswordMustHaveAlphaNumericCharacters) || (is_array($client_PasswordMustHaveAlphaNumericCharacters) && empty($client_PasswordMustHaveAlphaNumericCharacters))) {
            unset($this->Client_PasswordMustHaveAlphaNumericCharacters);
        } else {
            $this->Client_PasswordMustHaveAlphaNumericCharacters = $client_PasswordMustHaveAlphaNumericCharacters;
        }
        return $this;
    }
    /**
     * Get Client_PasswordMustHaveLowerAndUpperCaseCharacters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getClient_PasswordMustHaveLowerAndUpperCaseCharacters()
    {
        return isset($this->Client_PasswordMustHaveLowerAndUpperCaseCharacters) ? $this->Client_PasswordMustHaveLowerAndUpperCaseCharacters : null;
    }
    /**
     * Set Client_PasswordMustHaveLowerAndUpperCaseCharacters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $client_PasswordMustHaveLowerAndUpperCaseCharacters
     * @return \patest\StructType\Security_SecurityCompanyParameters
     */
    public function setClient_PasswordMustHaveLowerAndUpperCaseCharacters($client_PasswordMustHaveLowerAndUpperCaseCharacters = null)
    {
        // validation for constraint: boolean
        if (!is_null($client_PasswordMustHaveLowerAndUpperCaseCharacters) && !is_bool($client_PasswordMustHaveLowerAndUpperCaseCharacters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($client_PasswordMustHaveLowerAndUpperCaseCharacters, true), gettype($client_PasswordMustHaveLowerAndUpperCaseCharacters)), __LINE__);
        }
        if (is_null($client_PasswordMustHaveLowerAndUpperCaseCharacters) || (is_array($client_PasswordMustHaveLowerAndUpperCaseCharacters) && empty($client_PasswordMustHaveLowerAndUpperCaseCharacters))) {
            unset($this->Client_PasswordMustHaveLowerAndUpperCaseCharacters);
        } else {
            $this->Client_PasswordMustHaveLowerAndUpperCaseCharacters = $client_PasswordMustHaveLowerAndUpperCaseCharacters;
        }
        return $this;
    }
    /**
     * Get Client_PasswordMustHaveSpecialCharacters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getClient_PasswordMustHaveSpecialCharacters()
    {
        return isset($this->Client_PasswordMustHaveSpecialCharacters) ? $this->Client_PasswordMustHaveSpecialCharacters : null;
    }
    /**
     * Set Client_PasswordMustHaveSpecialCharacters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $client_PasswordMustHaveSpecialCharacters
     * @return \patest\StructType\Security_SecurityCompanyParameters
     */
    public function setClient_PasswordMustHaveSpecialCharacters($client_PasswordMustHaveSpecialCharacters = null)
    {
        // validation for constraint: boolean
        if (!is_null($client_PasswordMustHaveSpecialCharacters) && !is_bool($client_PasswordMustHaveSpecialCharacters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($client_PasswordMustHaveSpecialCharacters, true), gettype($client_PasswordMustHaveSpecialCharacters)), __LINE__);
        }
        if (is_null($client_PasswordMustHaveSpecialCharacters) || (is_array($client_PasswordMustHaveSpecialCharacters) && empty($client_PasswordMustHaveSpecialCharacters))) {
            unset($this->Client_PasswordMustHaveSpecialCharacters);
        } else {
            $this->Client_PasswordMustHaveSpecialCharacters = $client_PasswordMustHaveSpecialCharacters;
        }
        return $this;
    }
    /**
     * Get Client_PasswordsHistoryDepth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getClient_PasswordsHistoryDepth()
    {
        return isset($this->Client_PasswordsHistoryDepth) ? $this->Client_PasswordsHistoryDepth : null;
    }
    /**
     * Set Client_PasswordsHistoryDepth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $client_PasswordsHistoryDepth
     * @return \patest\StructType\Security_SecurityCompanyParameters
     */
    public function setClient_PasswordsHistoryDepth($client_PasswordsHistoryDepth = null)
    {
        // validation for constraint: int
        if (!is_null($client_PasswordsHistoryDepth) && !(is_int($client_PasswordsHistoryDepth) || ctype_digit($client_PasswordsHistoryDepth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($client_PasswordsHistoryDepth, true), gettype($client_PasswordsHistoryDepth)), __LINE__);
        }
        if (is_null($client_PasswordsHistoryDepth) || (is_array($client_PasswordsHistoryDepth) && empty($client_PasswordsHistoryDepth))) {
            unset($this->Client_PasswordsHistoryDepth);
        } else {
            $this->Client_PasswordsHistoryDepth = $client_PasswordsHistoryDepth;
        }
        return $this;
    }
    /**
     * Get Client_PciCompliant value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getClient_PciCompliant()
    {
        return isset($this->Client_PciCompliant) ? $this->Client_PciCompliant : null;
    }
    /**
     * Set Client_PciCompliant value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $client_PciCompliant
     * @return \patest\StructType\Security_SecurityCompanyParameters
     */
    public function setClient_PciCompliant($client_PciCompliant = null)
    {
        // validation for constraint: boolean
        if (!is_null($client_PciCompliant) && !is_bool($client_PciCompliant)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($client_PciCompliant, true), gettype($client_PciCompliant)), __LINE__);
        }
        if (is_null($client_PciCompliant) || (is_array($client_PciCompliant) && empty($client_PciCompliant))) {
            unset($this->Client_PciCompliant);
        } else {
            $this->Client_PciCompliant = $client_PciCompliant;
        }
        return $this;
    }
    /**
     * Get Client_UserMustChangePasswordOnFirstLogin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getClient_UserMustChangePasswordOnFirstLogin()
    {
        return isset($this->Client_UserMustChangePasswordOnFirstLogin) ? $this->Client_UserMustChangePasswordOnFirstLogin : null;
    }
    /**
     * Set Client_UserMustChangePasswordOnFirstLogin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $client_UserMustChangePasswordOnFirstLogin
     * @return \patest\StructType\Security_SecurityCompanyParameters
     */
    public function setClient_UserMustChangePasswordOnFirstLogin($client_UserMustChangePasswordOnFirstLogin = null)
    {
        // validation for constraint: boolean
        if (!is_null($client_UserMustChangePasswordOnFirstLogin) && !is_bool($client_UserMustChangePasswordOnFirstLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($client_UserMustChangePasswordOnFirstLogin, true), gettype($client_UserMustChangePasswordOnFirstLogin)), __LINE__);
        }
        if (is_null($client_UserMustChangePasswordOnFirstLogin) || (is_array($client_UserMustChangePasswordOnFirstLogin) && empty($client_UserMustChangePasswordOnFirstLogin))) {
            unset($this->Client_UserMustChangePasswordOnFirstLogin);
        } else {
            $this->Client_UserMustChangePasswordOnFirstLogin = $client_UserMustChangePasswordOnFirstLogin;
        }
        return $this;
    }
    /**
     * Get ContextExpirationMinutes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getContextExpirationMinutes()
    {
        return isset($this->ContextExpirationMinutes) ? $this->ContextExpirationMinutes : null;
    }
    /**
     * Set ContextExpirationMinutes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $contextExpirationMinutes
     * @return \patest\StructType\Security_SecurityCompanyParameters
     */
    public function setContextExpirationMinutes($contextExpirationMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($contextExpirationMinutes) && !(is_int($contextExpirationMinutes) || ctype_digit($contextExpirationMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($contextExpirationMinutes, true), gettype($contextExpirationMinutes)), __LINE__);
        }
        if (is_null($contextExpirationMinutes) || (is_array($contextExpirationMinutes) && empty($contextExpirationMinutes))) {
            unset($this->ContextExpirationMinutes);
        } else {
            $this->ContextExpirationMinutes = $contextExpirationMinutes;
        }
        return $this;
    }
    /**
     * Get filterGeneric value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getFilterGeneric()
    {
        return isset($this->filterGeneric) ? $this->filterGeneric : null;
    }
    /**
     * Set filterGeneric value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $filterGeneric
     * @return \patest\StructType\Security_SecurityCompanyParameters
     */
    public function setFilterGeneric($filterGeneric = null)
    {
        // validation for constraint: boolean
        if (!is_null($filterGeneric) && !is_bool($filterGeneric)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($filterGeneric, true), gettype($filterGeneric)), __LINE__);
        }
        if (is_null($filterGeneric) || (is_array($filterGeneric) && empty($filterGeneric))) {
            unset($this->filterGeneric);
        } else {
            $this->filterGeneric = $filterGeneric;
        }
        return $this;
    }
    /**
     * Get filterHuman value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getFilterHuman()
    {
        return isset($this->filterHuman) ? $this->filterHuman : null;
    }
    /**
     * Set filterHuman value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $filterHuman
     * @return \patest\StructType\Security_SecurityCompanyParameters
     */
    public function setFilterHuman($filterHuman = null)
    {
        // validation for constraint: boolean
        if (!is_null($filterHuman) && !is_bool($filterHuman)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($filterHuman, true), gettype($filterHuman)), __LINE__);
        }
        if (is_null($filterHuman) || (is_array($filterHuman) && empty($filterHuman))) {
            unset($this->filterHuman);
        } else {
            $this->filterHuman = $filterHuman;
        }
        return $this;
    }
    /**
     * Get filterSeatGeekHuman value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getFilterSeatGeekHuman()
    {
        return isset($this->filterSeatGeekHuman) ? $this->filterSeatGeekHuman : null;
    }
    /**
     * Set filterSeatGeekHuman value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $filterSeatGeekHuman
     * @return \patest\StructType\Security_SecurityCompanyParameters
     */
    public function setFilterSeatGeekHuman($filterSeatGeekHuman = null)
    {
        // validation for constraint: boolean
        if (!is_null($filterSeatGeekHuman) && !is_bool($filterSeatGeekHuman)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($filterSeatGeekHuman, true), gettype($filterSeatGeekHuman)), __LINE__);
        }
        if (is_null($filterSeatGeekHuman) || (is_array($filterSeatGeekHuman) && empty($filterSeatGeekHuman))) {
            unset($this->filterSeatGeekHuman);
        } else {
            $this->filterSeatGeekHuman = $filterSeatGeekHuman;
        }
        return $this;
    }
    /**
     * Get filterThirdPartyHuman value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getFilterThirdPartyHuman()
    {
        return isset($this->filterThirdPartyHuman) ? $this->filterThirdPartyHuman : null;
    }
    /**
     * Set filterThirdPartyHuman value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $filterThirdPartyHuman
     * @return \patest\StructType\Security_SecurityCompanyParameters
     */
    public function setFilterThirdPartyHuman($filterThirdPartyHuman = null)
    {
        // validation for constraint: boolean
        if (!is_null($filterThirdPartyHuman) && !is_bool($filterThirdPartyHuman)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($filterThirdPartyHuman, true), gettype($filterThirdPartyHuman)), __LINE__);
        }
        if (is_null($filterThirdPartyHuman) || (is_array($filterThirdPartyHuman) && empty($filterThirdPartyHuman))) {
            unset($this->filterThirdPartyHuman);
        } else {
            $this->filterThirdPartyHuman = $filterThirdPartyHuman;
        }
        return $this;
    }
    /**
     * Get ResetPasswordTokenExpiryInHours value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getResetPasswordTokenExpiryInHours()
    {
        return isset($this->ResetPasswordTokenExpiryInHours) ? $this->ResetPasswordTokenExpiryInHours : null;
    }
    /**
     * Set ResetPasswordTokenExpiryInHours value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $resetPasswordTokenExpiryInHours
     * @return \patest\StructType\Security_SecurityCompanyParameters
     */
    public function setResetPasswordTokenExpiryInHours($resetPasswordTokenExpiryInHours = null)
    {
        // validation for constraint: int
        if (!is_null($resetPasswordTokenExpiryInHours) && !(is_int($resetPasswordTokenExpiryInHours) || ctype_digit($resetPasswordTokenExpiryInHours))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($resetPasswordTokenExpiryInHours, true), gettype($resetPasswordTokenExpiryInHours)), __LINE__);
        }
        if (is_null($resetPasswordTokenExpiryInHours) || (is_array($resetPasswordTokenExpiryInHours) && empty($resetPasswordTokenExpiryInHours))) {
            unset($this->ResetPasswordTokenExpiryInHours);
        } else {
            $this->ResetPasswordTokenExpiryInHours = $resetPasswordTokenExpiryInHours;
        }
        return $this;
    }
    /**
     * Get TrustedDomains value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTrustedDomains()
    {
        return isset($this->TrustedDomains) ? $this->TrustedDomains : null;
    }
    /**
     * Set TrustedDomains value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $trustedDomains
     * @return \patest\StructType\Security_SecurityCompanyParameters
     */
    public function setTrustedDomains($trustedDomains = null)
    {
        // validation for constraint: string
        if (!is_null($trustedDomains) && !is_string($trustedDomains)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($trustedDomains, true), gettype($trustedDomains)), __LINE__);
        }
        if (is_null($trustedDomains) || (is_array($trustedDomains) && empty($trustedDomains))) {
            unset($this->TrustedDomains);
        } else {
            $this->TrustedDomains = $trustedDomains;
        }
        return $this;
    }
    /**
     * Get UserRequestExpiryInHours value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUserRequestExpiryInHours()
    {
        return isset($this->UserRequestExpiryInHours) ? $this->UserRequestExpiryInHours : null;
    }
    /**
     * Set UserRequestExpiryInHours value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $userRequestExpiryInHours
     * @return \patest\StructType\Security_SecurityCompanyParameters
     */
    public function setUserRequestExpiryInHours($userRequestExpiryInHours = null)
    {
        // validation for constraint: int
        if (!is_null($userRequestExpiryInHours) && !(is_int($userRequestExpiryInHours) || ctype_digit($userRequestExpiryInHours))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($userRequestExpiryInHours, true), gettype($userRequestExpiryInHours)), __LINE__);
        }
        if (is_null($userRequestExpiryInHours) || (is_array($userRequestExpiryInHours) && empty($userRequestExpiryInHours))) {
            unset($this->UserRequestExpiryInHours);
        } else {
            $this->UserRequestExpiryInHours = $userRequestExpiryInHours;
        }
        return $this;
    }
    /**
     * Get User_CheckPasswordDoesNotContainUserName value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUser_CheckPasswordDoesNotContainUserName()
    {
        return isset($this->User_CheckPasswordDoesNotContainUserName) ? $this->User_CheckPasswordDoesNotContainUserName : null;
    }
    /**
     * Set User_CheckPasswordDoesNotContainUserName value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $user_CheckPasswordDoesNotContainUserName
     * @return \patest\StructType\Security_SecurityCompanyParameters
     */
    public function setUser_CheckPasswordDoesNotContainUserName($user_CheckPasswordDoesNotContainUserName = null)
    {
        // validation for constraint: boolean
        if (!is_null($user_CheckPasswordDoesNotContainUserName) && !is_bool($user_CheckPasswordDoesNotContainUserName)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($user_CheckPasswordDoesNotContainUserName, true), gettype($user_CheckPasswordDoesNotContainUserName)), __LINE__);
        }
        if (is_null($user_CheckPasswordDoesNotContainUserName) || (is_array($user_CheckPasswordDoesNotContainUserName) && empty($user_CheckPasswordDoesNotContainUserName))) {
            unset($this->User_CheckPasswordDoesNotContainUserName);
        } else {
            $this->User_CheckPasswordDoesNotContainUserName = $user_CheckPasswordDoesNotContainUserName;
        }
        return $this;
    }
    /**
     * Get User_CheckPasswordHistory value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUser_CheckPasswordHistory()
    {
        return isset($this->User_CheckPasswordHistory) ? $this->User_CheckPasswordHistory : null;
    }
    /**
     * Set User_CheckPasswordHistory value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $user_CheckPasswordHistory
     * @return \patest\StructType\Security_SecurityCompanyParameters
     */
    public function setUser_CheckPasswordHistory($user_CheckPasswordHistory = null)
    {
        // validation for constraint: boolean
        if (!is_null($user_CheckPasswordHistory) && !is_bool($user_CheckPasswordHistory)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($user_CheckPasswordHistory, true), gettype($user_CheckPasswordHistory)), __LINE__);
        }
        if (is_null($user_CheckPasswordHistory) || (is_array($user_CheckPasswordHistory) && empty($user_CheckPasswordHistory))) {
            unset($this->User_CheckPasswordHistory);
        } else {
            $this->User_CheckPasswordHistory = $user_CheckPasswordHistory;
        }
        return $this;
    }
    /**
     * Get User_InvalidPasswordAttemptsPeriodInMinutes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUser_InvalidPasswordAttemptsPeriodInMinutes()
    {
        return isset($this->User_InvalidPasswordAttemptsPeriodInMinutes) ? $this->User_InvalidPasswordAttemptsPeriodInMinutes : null;
    }
    /**
     * Set User_InvalidPasswordAttemptsPeriodInMinutes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $user_InvalidPasswordAttemptsPeriodInMinutes
     * @return \patest\StructType\Security_SecurityCompanyParameters
     */
    public function setUser_InvalidPasswordAttemptsPeriodInMinutes($user_InvalidPasswordAttemptsPeriodInMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($user_InvalidPasswordAttemptsPeriodInMinutes) && !(is_int($user_InvalidPasswordAttemptsPeriodInMinutes) || ctype_digit($user_InvalidPasswordAttemptsPeriodInMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($user_InvalidPasswordAttemptsPeriodInMinutes, true), gettype($user_InvalidPasswordAttemptsPeriodInMinutes)), __LINE__);
        }
        if (is_null($user_InvalidPasswordAttemptsPeriodInMinutes) || (is_array($user_InvalidPasswordAttemptsPeriodInMinutes) && empty($user_InvalidPasswordAttemptsPeriodInMinutes))) {
            unset($this->User_InvalidPasswordAttemptsPeriodInMinutes);
        } else {
            $this->User_InvalidPasswordAttemptsPeriodInMinutes = $user_InvalidPasswordAttemptsPeriodInMinutes;
        }
        return $this;
    }
    /**
     * Get User_LockPeriodInMinutes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUser_LockPeriodInMinutes()
    {
        return isset($this->User_LockPeriodInMinutes) ? $this->User_LockPeriodInMinutes : null;
    }
    /**
     * Set User_LockPeriodInMinutes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $user_LockPeriodInMinutes
     * @return \patest\StructType\Security_SecurityCompanyParameters
     */
    public function setUser_LockPeriodInMinutes($user_LockPeriodInMinutes = null)
    {
        // validation for constraint: int
        if (!is_null($user_LockPeriodInMinutes) && !(is_int($user_LockPeriodInMinutes) || ctype_digit($user_LockPeriodInMinutes))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($user_LockPeriodInMinutes, true), gettype($user_LockPeriodInMinutes)), __LINE__);
        }
        if (is_null($user_LockPeriodInMinutes) || (is_array($user_LockPeriodInMinutes) && empty($user_LockPeriodInMinutes))) {
            unset($this->User_LockPeriodInMinutes);
        } else {
            $this->User_LockPeriodInMinutes = $user_LockPeriodInMinutes;
        }
        return $this;
    }
    /**
     * Get User_MaxInvalidPasswordAttemptsCount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUser_MaxInvalidPasswordAttemptsCount()
    {
        return isset($this->User_MaxInvalidPasswordAttemptsCount) ? $this->User_MaxInvalidPasswordAttemptsCount : null;
    }
    /**
     * Set User_MaxInvalidPasswordAttemptsCount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $user_MaxInvalidPasswordAttemptsCount
     * @return \patest\StructType\Security_SecurityCompanyParameters
     */
    public function setUser_MaxInvalidPasswordAttemptsCount($user_MaxInvalidPasswordAttemptsCount = null)
    {
        // validation for constraint: int
        if (!is_null($user_MaxInvalidPasswordAttemptsCount) && !(is_int($user_MaxInvalidPasswordAttemptsCount) || ctype_digit($user_MaxInvalidPasswordAttemptsCount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($user_MaxInvalidPasswordAttemptsCount, true), gettype($user_MaxInvalidPasswordAttemptsCount)), __LINE__);
        }
        if (is_null($user_MaxInvalidPasswordAttemptsCount) || (is_array($user_MaxInvalidPasswordAttemptsCount) && empty($user_MaxInvalidPasswordAttemptsCount))) {
            unset($this->User_MaxInvalidPasswordAttemptsCount);
        } else {
            $this->User_MaxInvalidPasswordAttemptsCount = $user_MaxInvalidPasswordAttemptsCount;
        }
        return $this;
    }
    /**
     * Get User_MinPasswordLength value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUser_MinPasswordLength()
    {
        return isset($this->User_MinPasswordLength) ? $this->User_MinPasswordLength : null;
    }
    /**
     * Set User_MinPasswordLength value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $user_MinPasswordLength
     * @return \patest\StructType\Security_SecurityCompanyParameters
     */
    public function setUser_MinPasswordLength($user_MinPasswordLength = null)
    {
        // validation for constraint: int
        if (!is_null($user_MinPasswordLength) && !(is_int($user_MinPasswordLength) || ctype_digit($user_MinPasswordLength))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($user_MinPasswordLength, true), gettype($user_MinPasswordLength)), __LINE__);
        }
        if (is_null($user_MinPasswordLength) || (is_array($user_MinPasswordLength) && empty($user_MinPasswordLength))) {
            unset($this->User_MinPasswordLength);
        } else {
            $this->User_MinPasswordLength = $user_MinPasswordLength;
        }
        return $this;
    }
    /**
     * Get User_PasswordExpirationDays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUser_PasswordExpirationDays()
    {
        return isset($this->User_PasswordExpirationDays) ? $this->User_PasswordExpirationDays : null;
    }
    /**
     * Set User_PasswordExpirationDays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $user_PasswordExpirationDays
     * @return \patest\StructType\Security_SecurityCompanyParameters
     */
    public function setUser_PasswordExpirationDays($user_PasswordExpirationDays = null)
    {
        // validation for constraint: int
        if (!is_null($user_PasswordExpirationDays) && !(is_int($user_PasswordExpirationDays) || ctype_digit($user_PasswordExpirationDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($user_PasswordExpirationDays, true), gettype($user_PasswordExpirationDays)), __LINE__);
        }
        if (is_null($user_PasswordExpirationDays) || (is_array($user_PasswordExpirationDays) && empty($user_PasswordExpirationDays))) {
            unset($this->User_PasswordExpirationDays);
        } else {
            $this->User_PasswordExpirationDays = $user_PasswordExpirationDays;
        }
        return $this;
    }
    /**
     * Get User_PasswordMustHaveAlphaNumericCharacters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUser_PasswordMustHaveAlphaNumericCharacters()
    {
        return isset($this->User_PasswordMustHaveAlphaNumericCharacters) ? $this->User_PasswordMustHaveAlphaNumericCharacters : null;
    }
    /**
     * Set User_PasswordMustHaveAlphaNumericCharacters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $user_PasswordMustHaveAlphaNumericCharacters
     * @return \patest\StructType\Security_SecurityCompanyParameters
     */
    public function setUser_PasswordMustHaveAlphaNumericCharacters($user_PasswordMustHaveAlphaNumericCharacters = null)
    {
        // validation for constraint: boolean
        if (!is_null($user_PasswordMustHaveAlphaNumericCharacters) && !is_bool($user_PasswordMustHaveAlphaNumericCharacters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($user_PasswordMustHaveAlphaNumericCharacters, true), gettype($user_PasswordMustHaveAlphaNumericCharacters)), __LINE__);
        }
        if (is_null($user_PasswordMustHaveAlphaNumericCharacters) || (is_array($user_PasswordMustHaveAlphaNumericCharacters) && empty($user_PasswordMustHaveAlphaNumericCharacters))) {
            unset($this->User_PasswordMustHaveAlphaNumericCharacters);
        } else {
            $this->User_PasswordMustHaveAlphaNumericCharacters = $user_PasswordMustHaveAlphaNumericCharacters;
        }
        return $this;
    }
    /**
     * Get User_PasswordMustHaveLowerAndUpperCaseCharacters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUser_PasswordMustHaveLowerAndUpperCaseCharacters()
    {
        return isset($this->User_PasswordMustHaveLowerAndUpperCaseCharacters) ? $this->User_PasswordMustHaveLowerAndUpperCaseCharacters : null;
    }
    /**
     * Set User_PasswordMustHaveLowerAndUpperCaseCharacters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $user_PasswordMustHaveLowerAndUpperCaseCharacters
     * @return \patest\StructType\Security_SecurityCompanyParameters
     */
    public function setUser_PasswordMustHaveLowerAndUpperCaseCharacters($user_PasswordMustHaveLowerAndUpperCaseCharacters = null)
    {
        // validation for constraint: boolean
        if (!is_null($user_PasswordMustHaveLowerAndUpperCaseCharacters) && !is_bool($user_PasswordMustHaveLowerAndUpperCaseCharacters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($user_PasswordMustHaveLowerAndUpperCaseCharacters, true), gettype($user_PasswordMustHaveLowerAndUpperCaseCharacters)), __LINE__);
        }
        if (is_null($user_PasswordMustHaveLowerAndUpperCaseCharacters) || (is_array($user_PasswordMustHaveLowerAndUpperCaseCharacters) && empty($user_PasswordMustHaveLowerAndUpperCaseCharacters))) {
            unset($this->User_PasswordMustHaveLowerAndUpperCaseCharacters);
        } else {
            $this->User_PasswordMustHaveLowerAndUpperCaseCharacters = $user_PasswordMustHaveLowerAndUpperCaseCharacters;
        }
        return $this;
    }
    /**
     * Get User_PasswordMustHaveSpecialCharacters value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUser_PasswordMustHaveSpecialCharacters()
    {
        return isset($this->User_PasswordMustHaveSpecialCharacters) ? $this->User_PasswordMustHaveSpecialCharacters : null;
    }
    /**
     * Set User_PasswordMustHaveSpecialCharacters value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $user_PasswordMustHaveSpecialCharacters
     * @return \patest\StructType\Security_SecurityCompanyParameters
     */
    public function setUser_PasswordMustHaveSpecialCharacters($user_PasswordMustHaveSpecialCharacters = null)
    {
        // validation for constraint: boolean
        if (!is_null($user_PasswordMustHaveSpecialCharacters) && !is_bool($user_PasswordMustHaveSpecialCharacters)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($user_PasswordMustHaveSpecialCharacters, true), gettype($user_PasswordMustHaveSpecialCharacters)), __LINE__);
        }
        if (is_null($user_PasswordMustHaveSpecialCharacters) || (is_array($user_PasswordMustHaveSpecialCharacters) && empty($user_PasswordMustHaveSpecialCharacters))) {
            unset($this->User_PasswordMustHaveSpecialCharacters);
        } else {
            $this->User_PasswordMustHaveSpecialCharacters = $user_PasswordMustHaveSpecialCharacters;
        }
        return $this;
    }
    /**
     * Get User_PasswordsHistoryDepth value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUser_PasswordsHistoryDepth()
    {
        return isset($this->User_PasswordsHistoryDepth) ? $this->User_PasswordsHistoryDepth : null;
    }
    /**
     * Set User_PasswordsHistoryDepth value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $user_PasswordsHistoryDepth
     * @return \patest\StructType\Security_SecurityCompanyParameters
     */
    public function setUser_PasswordsHistoryDepth($user_PasswordsHistoryDepth = null)
    {
        // validation for constraint: int
        if (!is_null($user_PasswordsHistoryDepth) && !(is_int($user_PasswordsHistoryDepth) || ctype_digit($user_PasswordsHistoryDepth))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($user_PasswordsHistoryDepth, true), gettype($user_PasswordsHistoryDepth)), __LINE__);
        }
        if (is_null($user_PasswordsHistoryDepth) || (is_array($user_PasswordsHistoryDepth) && empty($user_PasswordsHistoryDepth))) {
            unset($this->User_PasswordsHistoryDepth);
        } else {
            $this->User_PasswordsHistoryDepth = $user_PasswordsHistoryDepth;
        }
        return $this;
    }
    /**
     * Get User_UserMustChangePasswordOnFirstLogin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUser_UserMustChangePasswordOnFirstLogin()
    {
        return isset($this->User_UserMustChangePasswordOnFirstLogin) ? $this->User_UserMustChangePasswordOnFirstLogin : null;
    }
    /**
     * Set User_UserMustChangePasswordOnFirstLogin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $user_UserMustChangePasswordOnFirstLogin
     * @return \patest\StructType\Security_SecurityCompanyParameters
     */
    public function setUser_UserMustChangePasswordOnFirstLogin($user_UserMustChangePasswordOnFirstLogin = null)
    {
        // validation for constraint: boolean
        if (!is_null($user_UserMustChangePasswordOnFirstLogin) && !is_bool($user_UserMustChangePasswordOnFirstLogin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($user_UserMustChangePasswordOnFirstLogin, true), gettype($user_UserMustChangePasswordOnFirstLogin)), __LINE__);
        }
        if (is_null($user_UserMustChangePasswordOnFirstLogin) || (is_array($user_UserMustChangePasswordOnFirstLogin) && empty($user_UserMustChangePasswordOnFirstLogin))) {
            unset($this->User_UserMustChangePasswordOnFirstLogin);
        } else {
            $this->User_UserMustChangePasswordOnFirstLogin = $user_UserMustChangePasswordOnFirstLogin;
        }
        return $this;
    }
    /**
     * Get VerifyRegistrationTokenExpiryInHours value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getVerifyRegistrationTokenExpiryInHours()
    {
        return isset($this->VerifyRegistrationTokenExpiryInHours) ? $this->VerifyRegistrationTokenExpiryInHours : null;
    }
    /**
     * Set VerifyRegistrationTokenExpiryInHours value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $verifyRegistrationTokenExpiryInHours
     * @return \patest\StructType\Security_SecurityCompanyParameters
     */
    public function setVerifyRegistrationTokenExpiryInHours($verifyRegistrationTokenExpiryInHours = null)
    {
        // validation for constraint: int
        if (!is_null($verifyRegistrationTokenExpiryInHours) && !(is_int($verifyRegistrationTokenExpiryInHours) || ctype_digit($verifyRegistrationTokenExpiryInHours))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($verifyRegistrationTokenExpiryInHours, true), gettype($verifyRegistrationTokenExpiryInHours)), __LINE__);
        }
        if (is_null($verifyRegistrationTokenExpiryInHours) || (is_array($verifyRegistrationTokenExpiryInHours) && empty($verifyRegistrationTokenExpiryInHours))) {
            unset($this->VerifyRegistrationTokenExpiryInHours);
        } else {
            $this->VerifyRegistrationTokenExpiryInHours = $verifyRegistrationTokenExpiryInHours;
        }
        return $this;
    }
}
