<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.SeatGeekParameters StructType
 * @subpackage Structs
 */
class Security_SeatGeekParameters extends Security_CompanyParameterBase
{
    /**
     * The MaxNumberEventStatusRequested
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxNumberEventStatusRequested;
    /**
     * The MaxSecondsWaitBeforeErrorEventStatus
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MaxSecondsWaitBeforeErrorEventStatus;
    /**
     * Constructor method for Security.SeatGeekParameters
     * @uses Security_SeatGeekParameters::setMaxNumberEventStatusRequested()
     * @uses Security_SeatGeekParameters::setMaxSecondsWaitBeforeErrorEventStatus()
     * @param int $maxNumberEventStatusRequested
     * @param int $maxSecondsWaitBeforeErrorEventStatus
     */
    public function __construct($maxNumberEventStatusRequested = null, $maxSecondsWaitBeforeErrorEventStatus = null)
    {
        $this
            ->setMaxNumberEventStatusRequested($maxNumberEventStatusRequested)
            ->setMaxSecondsWaitBeforeErrorEventStatus($maxSecondsWaitBeforeErrorEventStatus);
    }
    /**
     * Get MaxNumberEventStatusRequested value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxNumberEventStatusRequested()
    {
        return isset($this->MaxNumberEventStatusRequested) ? $this->MaxNumberEventStatusRequested : null;
    }
    /**
     * Set MaxNumberEventStatusRequested value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxNumberEventStatusRequested
     * @return \patest\StructType\Security_SeatGeekParameters
     */
    public function setMaxNumberEventStatusRequested($maxNumberEventStatusRequested = null)
    {
        // validation for constraint: int
        if (!is_null($maxNumberEventStatusRequested) && !(is_int($maxNumberEventStatusRequested) || ctype_digit($maxNumberEventStatusRequested))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxNumberEventStatusRequested, true), gettype($maxNumberEventStatusRequested)), __LINE__);
        }
        if (is_null($maxNumberEventStatusRequested) || (is_array($maxNumberEventStatusRequested) && empty($maxNumberEventStatusRequested))) {
            unset($this->MaxNumberEventStatusRequested);
        } else {
            $this->MaxNumberEventStatusRequested = $maxNumberEventStatusRequested;
        }
        return $this;
    }
    /**
     * Get MaxSecondsWaitBeforeErrorEventStatus value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMaxSecondsWaitBeforeErrorEventStatus()
    {
        return isset($this->MaxSecondsWaitBeforeErrorEventStatus) ? $this->MaxSecondsWaitBeforeErrorEventStatus : null;
    }
    /**
     * Set MaxSecondsWaitBeforeErrorEventStatus value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $maxSecondsWaitBeforeErrorEventStatus
     * @return \patest\StructType\Security_SeatGeekParameters
     */
    public function setMaxSecondsWaitBeforeErrorEventStatus($maxSecondsWaitBeforeErrorEventStatus = null)
    {
        // validation for constraint: int
        if (!is_null($maxSecondsWaitBeforeErrorEventStatus) && !(is_int($maxSecondsWaitBeforeErrorEventStatus) || ctype_digit($maxSecondsWaitBeforeErrorEventStatus))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($maxSecondsWaitBeforeErrorEventStatus, true), gettype($maxSecondsWaitBeforeErrorEventStatus)), __LINE__);
        }
        if (is_null($maxSecondsWaitBeforeErrorEventStatus) || (is_array($maxSecondsWaitBeforeErrorEventStatus) && empty($maxSecondsWaitBeforeErrorEventStatus))) {
            unset($this->MaxSecondsWaitBeforeErrorEventStatus);
        } else {
            $this->MaxSecondsWaitBeforeErrorEventStatus = $maxSecondsWaitBeforeErrorEventStatus;
        }
        return $this;
    }
}
