<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.SalesUserParameters StructType
 * @subpackage Structs
 */
class Security_SalesUserParameters extends Security_UserParametersBase
{
    /**
     * The AutoOpenEditBasketWindow
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AutoOpenEditBasketWindow;
    /**
     * The AvailableDefaultPriceType
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AvailableDefaultPriceType;
    /**
     * The BasketStateMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BasketStateMode;
    /**
     * The BsroDisplayEventReviewOnSelection
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $BsroDisplayEventReviewOnSelection;
    /**
     * The BsroQuickSearchDefaultHall
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BsroQuickSearchDefaultHall;
    /**
     * The BsroQuickSearchDefaultOrganizationUnit
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $BsroQuickSearchDefaultOrganizationUnit;
    /**
     * The BundlesDefaultQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $BundlesDefaultQuantity;
    /**
     * The DefaultQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DefaultQuantity;
    /**
     * The DefaultSalesMode
     * Meta information extracted from the WSDL
     * - base: xs:string
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $DefaultSalesMode;
    /**
     * The DefaultSalesRep
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultSalesRep;
    /**
     * The DefaultSolicitor
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DefaultSolicitor;
    /**
     * The DisplayedPriceIs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DisplayedPriceIs;
    /**
     * The DisplayPriceTypesOnButton
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DisplayPriceTypesOnButton;
    /**
     * The DisplayTransactionSummaryAtEnd
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DisplayTransactionSummaryAtEnd;
    /**
     * The ExcludeActionsWhenSettingRestrictions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExcludeActionsWhenSettingRestrictions;
    /**
     * The GiftVocherDefaultQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $GiftVocherDefaultQuantity;
    /**
     * The HiddenBasketColumns
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HiddenBasketColumns;
    /**
     * The HiddenEventsGridColumns
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HiddenEventsGridColumns;
    /**
     * The HiddenSeatListColumns
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HiddenSeatListColumns;
    /**
     * The ImplicitSettlementDisplayWarning
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ImplicitSettlementDisplayWarning;
    /**
     * The MembershipDefaultQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MembershipDefaultQuantity;
    /**
     * The MerchandiseDefaultQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MerchandiseDefaultQuantity;
    /**
     * The MinimizeBasketWhenDisplayingSeatingPlan
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MinimizeBasketWhenDisplayingSeatingPlan;
    /**
     * The NewSalesDefaultTab
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NewSalesDefaultTab;
    /**
     * The NewSeatingPlanDefaultView
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NewSeatingPlanDefaultView;
    /**
     * The ReturnToOriginalDate
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ReturnToOriginalDate;
    /**
     * The ReturnToUserOu
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ReturnToUserOu;
    /**
     * The SalesDefaultTab
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SalesDefaultTab;
    /**
     * The SalesSaleModeStartupAs
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SalesSaleModeStartupAs;
    /**
     * The SeatingPlanDefaultView
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SeatingPlanDefaultView;
    /**
     * The SelectionOBOAccount
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SelectionOBOAccount;
    /**
     * The SubscriptionDefaultQuantity
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SubscriptionDefaultQuantity;
    /**
     * Constructor method for Security.SalesUserParameters
     * @uses Security_SalesUserParameters::setAutoOpenEditBasketWindow()
     * @uses Security_SalesUserParameters::setAvailableDefaultPriceType()
     * @uses Security_SalesUserParameters::setBasketStateMode()
     * @uses Security_SalesUserParameters::setBsroDisplayEventReviewOnSelection()
     * @uses Security_SalesUserParameters::setBsroQuickSearchDefaultHall()
     * @uses Security_SalesUserParameters::setBsroQuickSearchDefaultOrganizationUnit()
     * @uses Security_SalesUserParameters::setBundlesDefaultQuantity()
     * @uses Security_SalesUserParameters::setDefaultQuantity()
     * @uses Security_SalesUserParameters::setDefaultSalesMode()
     * @uses Security_SalesUserParameters::setDefaultSalesRep()
     * @uses Security_SalesUserParameters::setDefaultSolicitor()
     * @uses Security_SalesUserParameters::setDisplayedPriceIs()
     * @uses Security_SalesUserParameters::setDisplayPriceTypesOnButton()
     * @uses Security_SalesUserParameters::setDisplayTransactionSummaryAtEnd()
     * @uses Security_SalesUserParameters::setExcludeActionsWhenSettingRestrictions()
     * @uses Security_SalesUserParameters::setGiftVocherDefaultQuantity()
     * @uses Security_SalesUserParameters::setHiddenBasketColumns()
     * @uses Security_SalesUserParameters::setHiddenEventsGridColumns()
     * @uses Security_SalesUserParameters::setHiddenSeatListColumns()
     * @uses Security_SalesUserParameters::setImplicitSettlementDisplayWarning()
     * @uses Security_SalesUserParameters::setMembershipDefaultQuantity()
     * @uses Security_SalesUserParameters::setMerchandiseDefaultQuantity()
     * @uses Security_SalesUserParameters::setMinimizeBasketWhenDisplayingSeatingPlan()
     * @uses Security_SalesUserParameters::setNewSalesDefaultTab()
     * @uses Security_SalesUserParameters::setNewSeatingPlanDefaultView()
     * @uses Security_SalesUserParameters::setReturnToOriginalDate()
     * @uses Security_SalesUserParameters::setReturnToUserOu()
     * @uses Security_SalesUserParameters::setSalesDefaultTab()
     * @uses Security_SalesUserParameters::setSalesSaleModeStartupAs()
     * @uses Security_SalesUserParameters::setSeatingPlanDefaultView()
     * @uses Security_SalesUserParameters::setSelectionOBOAccount()
     * @uses Security_SalesUserParameters::setSubscriptionDefaultQuantity()
     * @param bool $autoOpenEditBasketWindow
     * @param string $availableDefaultPriceType
     * @param string $basketStateMode
     * @param bool $bsroDisplayEventReviewOnSelection
     * @param string $bsroQuickSearchDefaultHall
     * @param string $bsroQuickSearchDefaultOrganizationUnit
     * @param int $bundlesDefaultQuantity
     * @param int $defaultQuantity
     * @param string $defaultSalesMode
     * @param string $defaultSalesRep
     * @param string $defaultSolicitor
     * @param int $displayedPriceIs
     * @param bool $displayPriceTypesOnButton
     * @param bool $displayTransactionSummaryAtEnd
     * @param string $excludeActionsWhenSettingRestrictions
     * @param int $giftVocherDefaultQuantity
     * @param string $hiddenBasketColumns
     * @param string $hiddenEventsGridColumns
     * @param string $hiddenSeatListColumns
     * @param bool $implicitSettlementDisplayWarning
     * @param int $membershipDefaultQuantity
     * @param int $merchandiseDefaultQuantity
     * @param bool $minimizeBasketWhenDisplayingSeatingPlan
     * @param string $newSalesDefaultTab
     * @param string $newSeatingPlanDefaultView
     * @param bool $returnToOriginalDate
     * @param bool $returnToUserOu
     * @param string $salesDefaultTab
     * @param int $salesSaleModeStartupAs
     * @param int $seatingPlanDefaultView
     * @param int $selectionOBOAccount
     * @param int $subscriptionDefaultQuantity
     */
    public function __construct($autoOpenEditBasketWindow = null, $availableDefaultPriceType = null, $basketStateMode = null, $bsroDisplayEventReviewOnSelection = null, $bsroQuickSearchDefaultHall = null, $bsroQuickSearchDefaultOrganizationUnit = null, $bundlesDefaultQuantity = null, $defaultQuantity = null, $defaultSalesMode = null, $defaultSalesRep = null, $defaultSolicitor = null, $displayedPriceIs = null, $displayPriceTypesOnButton = null, $displayTransactionSummaryAtEnd = null, $excludeActionsWhenSettingRestrictions = null, $giftVocherDefaultQuantity = null, $hiddenBasketColumns = null, $hiddenEventsGridColumns = null, $hiddenSeatListColumns = null, $implicitSettlementDisplayWarning = null, $membershipDefaultQuantity = null, $merchandiseDefaultQuantity = null, $minimizeBasketWhenDisplayingSeatingPlan = null, $newSalesDefaultTab = null, $newSeatingPlanDefaultView = null, $returnToOriginalDate = null, $returnToUserOu = null, $salesDefaultTab = null, $salesSaleModeStartupAs = null, $seatingPlanDefaultView = null, $selectionOBOAccount = null, $subscriptionDefaultQuantity = null)
    {
        $this
            ->setAutoOpenEditBasketWindow($autoOpenEditBasketWindow)
            ->setAvailableDefaultPriceType($availableDefaultPriceType)
            ->setBasketStateMode($basketStateMode)
            ->setBsroDisplayEventReviewOnSelection($bsroDisplayEventReviewOnSelection)
            ->setBsroQuickSearchDefaultHall($bsroQuickSearchDefaultHall)
            ->setBsroQuickSearchDefaultOrganizationUnit($bsroQuickSearchDefaultOrganizationUnit)
            ->setBundlesDefaultQuantity($bundlesDefaultQuantity)
            ->setDefaultQuantity($defaultQuantity)
            ->setDefaultSalesMode($defaultSalesMode)
            ->setDefaultSalesRep($defaultSalesRep)
            ->setDefaultSolicitor($defaultSolicitor)
            ->setDisplayedPriceIs($displayedPriceIs)
            ->setDisplayPriceTypesOnButton($displayPriceTypesOnButton)
            ->setDisplayTransactionSummaryAtEnd($displayTransactionSummaryAtEnd)
            ->setExcludeActionsWhenSettingRestrictions($excludeActionsWhenSettingRestrictions)
            ->setGiftVocherDefaultQuantity($giftVocherDefaultQuantity)
            ->setHiddenBasketColumns($hiddenBasketColumns)
            ->setHiddenEventsGridColumns($hiddenEventsGridColumns)
            ->setHiddenSeatListColumns($hiddenSeatListColumns)
            ->setImplicitSettlementDisplayWarning($implicitSettlementDisplayWarning)
            ->setMembershipDefaultQuantity($membershipDefaultQuantity)
            ->setMerchandiseDefaultQuantity($merchandiseDefaultQuantity)
            ->setMinimizeBasketWhenDisplayingSeatingPlan($minimizeBasketWhenDisplayingSeatingPlan)
            ->setNewSalesDefaultTab($newSalesDefaultTab)
            ->setNewSeatingPlanDefaultView($newSeatingPlanDefaultView)
            ->setReturnToOriginalDate($returnToOriginalDate)
            ->setReturnToUserOu($returnToUserOu)
            ->setSalesDefaultTab($salesDefaultTab)
            ->setSalesSaleModeStartupAs($salesSaleModeStartupAs)
            ->setSeatingPlanDefaultView($seatingPlanDefaultView)
            ->setSelectionOBOAccount($selectionOBOAccount)
            ->setSubscriptionDefaultQuantity($subscriptionDefaultQuantity);
    }
    /**
     * Get AutoOpenEditBasketWindow value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAutoOpenEditBasketWindow()
    {
        return isset($this->AutoOpenEditBasketWindow) ? $this->AutoOpenEditBasketWindow : null;
    }
    /**
     * Set AutoOpenEditBasketWindow value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $autoOpenEditBasketWindow
     * @return \patest\StructType\Security_SalesUserParameters
     */
    public function setAutoOpenEditBasketWindow($autoOpenEditBasketWindow = null)
    {
        // validation for constraint: boolean
        if (!is_null($autoOpenEditBasketWindow) && !is_bool($autoOpenEditBasketWindow)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($autoOpenEditBasketWindow, true), gettype($autoOpenEditBasketWindow)), __LINE__);
        }
        if (is_null($autoOpenEditBasketWindow) || (is_array($autoOpenEditBasketWindow) && empty($autoOpenEditBasketWindow))) {
            unset($this->AutoOpenEditBasketWindow);
        } else {
            $this->AutoOpenEditBasketWindow = $autoOpenEditBasketWindow;
        }
        return $this;
    }
    /**
     * Get AvailableDefaultPriceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAvailableDefaultPriceType()
    {
        return isset($this->AvailableDefaultPriceType) ? $this->AvailableDefaultPriceType : null;
    }
    /**
     * Set AvailableDefaultPriceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $availableDefaultPriceType
     * @return \patest\StructType\Security_SalesUserParameters
     */
    public function setAvailableDefaultPriceType($availableDefaultPriceType = null)
    {
        // validation for constraint: string
        if (!is_null($availableDefaultPriceType) && !is_string($availableDefaultPriceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($availableDefaultPriceType, true), gettype($availableDefaultPriceType)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($availableDefaultPriceType) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $availableDefaultPriceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($availableDefaultPriceType, true)), __LINE__);
        }
        if (is_null($availableDefaultPriceType) || (is_array($availableDefaultPriceType) && empty($availableDefaultPriceType))) {
            unset($this->AvailableDefaultPriceType);
        } else {
            $this->AvailableDefaultPriceType = $availableDefaultPriceType;
        }
        return $this;
    }
    /**
     * Get BasketStateMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBasketStateMode()
    {
        return isset($this->BasketStateMode) ? $this->BasketStateMode : null;
    }
    /**
     * Set BasketStateMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BasketStateMode::valueIsValid()
     * @uses \patest\EnumType\BasketStateMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $basketStateMode
     * @return \patest\StructType\Security_SalesUserParameters
     */
    public function setBasketStateMode($basketStateMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BasketStateMode::valueIsValid($basketStateMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BasketStateMode', is_array($basketStateMode) ? implode(', ', $basketStateMode) : var_export($basketStateMode, true), implode(', ', \patest\EnumType\BasketStateMode::getValidValues())), __LINE__);
        }
        if (is_null($basketStateMode) || (is_array($basketStateMode) && empty($basketStateMode))) {
            unset($this->BasketStateMode);
        } else {
            $this->BasketStateMode = $basketStateMode;
        }
        return $this;
    }
    /**
     * Get BsroDisplayEventReviewOnSelection value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getBsroDisplayEventReviewOnSelection()
    {
        return isset($this->BsroDisplayEventReviewOnSelection) ? $this->BsroDisplayEventReviewOnSelection : null;
    }
    /**
     * Set BsroDisplayEventReviewOnSelection value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $bsroDisplayEventReviewOnSelection
     * @return \patest\StructType\Security_SalesUserParameters
     */
    public function setBsroDisplayEventReviewOnSelection($bsroDisplayEventReviewOnSelection = null)
    {
        // validation for constraint: boolean
        if (!is_null($bsroDisplayEventReviewOnSelection) && !is_bool($bsroDisplayEventReviewOnSelection)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($bsroDisplayEventReviewOnSelection, true), gettype($bsroDisplayEventReviewOnSelection)), __LINE__);
        }
        if (is_null($bsroDisplayEventReviewOnSelection) || (is_array($bsroDisplayEventReviewOnSelection) && empty($bsroDisplayEventReviewOnSelection))) {
            unset($this->BsroDisplayEventReviewOnSelection);
        } else {
            $this->BsroDisplayEventReviewOnSelection = $bsroDisplayEventReviewOnSelection;
        }
        return $this;
    }
    /**
     * Get BsroQuickSearchDefaultHall value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBsroQuickSearchDefaultHall()
    {
        return isset($this->BsroQuickSearchDefaultHall) ? $this->BsroQuickSearchDefaultHall : null;
    }
    /**
     * Set BsroQuickSearchDefaultHall value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bsroQuickSearchDefaultHall
     * @return \patest\StructType\Security_SalesUserParameters
     */
    public function setBsroQuickSearchDefaultHall($bsroQuickSearchDefaultHall = null)
    {
        // validation for constraint: string
        if (!is_null($bsroQuickSearchDefaultHall) && !is_string($bsroQuickSearchDefaultHall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bsroQuickSearchDefaultHall, true), gettype($bsroQuickSearchDefaultHall)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($bsroQuickSearchDefaultHall) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $bsroQuickSearchDefaultHall)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($bsroQuickSearchDefaultHall, true)), __LINE__);
        }
        if (is_null($bsroQuickSearchDefaultHall) || (is_array($bsroQuickSearchDefaultHall) && empty($bsroQuickSearchDefaultHall))) {
            unset($this->BsroQuickSearchDefaultHall);
        } else {
            $this->BsroQuickSearchDefaultHall = $bsroQuickSearchDefaultHall;
        }
        return $this;
    }
    /**
     * Get BsroQuickSearchDefaultOrganizationUnit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBsroQuickSearchDefaultOrganizationUnit()
    {
        return isset($this->BsroQuickSearchDefaultOrganizationUnit) ? $this->BsroQuickSearchDefaultOrganizationUnit : null;
    }
    /**
     * Set BsroQuickSearchDefaultOrganizationUnit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $bsroQuickSearchDefaultOrganizationUnit
     * @return \patest\StructType\Security_SalesUserParameters
     */
    public function setBsroQuickSearchDefaultOrganizationUnit($bsroQuickSearchDefaultOrganizationUnit = null)
    {
        // validation for constraint: string
        if (!is_null($bsroQuickSearchDefaultOrganizationUnit) && !is_string($bsroQuickSearchDefaultOrganizationUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($bsroQuickSearchDefaultOrganizationUnit, true), gettype($bsroQuickSearchDefaultOrganizationUnit)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($bsroQuickSearchDefaultOrganizationUnit) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $bsroQuickSearchDefaultOrganizationUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($bsroQuickSearchDefaultOrganizationUnit, true)), __LINE__);
        }
        if (is_null($bsroQuickSearchDefaultOrganizationUnit) || (is_array($bsroQuickSearchDefaultOrganizationUnit) && empty($bsroQuickSearchDefaultOrganizationUnit))) {
            unset($this->BsroQuickSearchDefaultOrganizationUnit);
        } else {
            $this->BsroQuickSearchDefaultOrganizationUnit = $bsroQuickSearchDefaultOrganizationUnit;
        }
        return $this;
    }
    /**
     * Get BundlesDefaultQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getBundlesDefaultQuantity()
    {
        return isset($this->BundlesDefaultQuantity) ? $this->BundlesDefaultQuantity : null;
    }
    /**
     * Set BundlesDefaultQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $bundlesDefaultQuantity
     * @return \patest\StructType\Security_SalesUserParameters
     */
    public function setBundlesDefaultQuantity($bundlesDefaultQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($bundlesDefaultQuantity) && !(is_int($bundlesDefaultQuantity) || ctype_digit($bundlesDefaultQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($bundlesDefaultQuantity, true), gettype($bundlesDefaultQuantity)), __LINE__);
        }
        if (is_null($bundlesDefaultQuantity) || (is_array($bundlesDefaultQuantity) && empty($bundlesDefaultQuantity))) {
            unset($this->BundlesDefaultQuantity);
        } else {
            $this->BundlesDefaultQuantity = $bundlesDefaultQuantity;
        }
        return $this;
    }
    /**
     * Get DefaultQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDefaultQuantity()
    {
        return isset($this->DefaultQuantity) ? $this->DefaultQuantity : null;
    }
    /**
     * Set DefaultQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $defaultQuantity
     * @return \patest\StructType\Security_SalesUserParameters
     */
    public function setDefaultQuantity($defaultQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($defaultQuantity) && !(is_int($defaultQuantity) || ctype_digit($defaultQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($defaultQuantity, true), gettype($defaultQuantity)), __LINE__);
        }
        if (is_null($defaultQuantity) || (is_array($defaultQuantity) && empty($defaultQuantity))) {
            unset($this->DefaultQuantity);
        } else {
            $this->DefaultQuantity = $defaultQuantity;
        }
        return $this;
    }
    /**
     * Get DefaultSalesMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultSalesMode()
    {
        return isset($this->DefaultSalesMode) ? $this->DefaultSalesMode : null;
    }
    /**
     * Set DefaultSalesMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultSalesMode
     * @return \patest\StructType\Security_SalesUserParameters
     */
    public function setDefaultSalesMode($defaultSalesMode = null)
    {
        // validation for constraint: string
        if (!is_null($defaultSalesMode) && !is_string($defaultSalesMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultSalesMode, true), gettype($defaultSalesMode)), __LINE__);
        }
        // validation for constraint: pattern([\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12})
        if (!is_null($defaultSalesMode) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $defaultSalesMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}', var_export($defaultSalesMode, true)), __LINE__);
        }
        if (is_null($defaultSalesMode) || (is_array($defaultSalesMode) && empty($defaultSalesMode))) {
            unset($this->DefaultSalesMode);
        } else {
            $this->DefaultSalesMode = $defaultSalesMode;
        }
        return $this;
    }
    /**
     * Get DefaultSalesRep value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultSalesRep()
    {
        return isset($this->DefaultSalesRep) ? $this->DefaultSalesRep : null;
    }
    /**
     * Set DefaultSalesRep value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultSalesRep
     * @return \patest\StructType\Security_SalesUserParameters
     */
    public function setDefaultSalesRep($defaultSalesRep = null)
    {
        // validation for constraint: string
        if (!is_null($defaultSalesRep) && !is_string($defaultSalesRep)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultSalesRep, true), gettype($defaultSalesRep)), __LINE__);
        }
        if (is_null($defaultSalesRep) || (is_array($defaultSalesRep) && empty($defaultSalesRep))) {
            unset($this->DefaultSalesRep);
        } else {
            $this->DefaultSalesRep = $defaultSalesRep;
        }
        return $this;
    }
    /**
     * Get DefaultSolicitor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDefaultSolicitor()
    {
        return isset($this->DefaultSolicitor) ? $this->DefaultSolicitor : null;
    }
    /**
     * Set DefaultSolicitor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $defaultSolicitor
     * @return \patest\StructType\Security_SalesUserParameters
     */
    public function setDefaultSolicitor($defaultSolicitor = null)
    {
        // validation for constraint: string
        if (!is_null($defaultSolicitor) && !is_string($defaultSolicitor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($defaultSolicitor, true), gettype($defaultSolicitor)), __LINE__);
        }
        if (is_null($defaultSolicitor) || (is_array($defaultSolicitor) && empty($defaultSolicitor))) {
            unset($this->DefaultSolicitor);
        } else {
            $this->DefaultSolicitor = $defaultSolicitor;
        }
        return $this;
    }
    /**
     * Get DisplayedPriceIs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDisplayedPriceIs()
    {
        return isset($this->DisplayedPriceIs) ? $this->DisplayedPriceIs : null;
    }
    /**
     * Set DisplayedPriceIs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $displayedPriceIs
     * @return \patest\StructType\Security_SalesUserParameters
     */
    public function setDisplayedPriceIs($displayedPriceIs = null)
    {
        // validation for constraint: int
        if (!is_null($displayedPriceIs) && !(is_int($displayedPriceIs) || ctype_digit($displayedPriceIs))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($displayedPriceIs, true), gettype($displayedPriceIs)), __LINE__);
        }
        if (is_null($displayedPriceIs) || (is_array($displayedPriceIs) && empty($displayedPriceIs))) {
            unset($this->DisplayedPriceIs);
        } else {
            $this->DisplayedPriceIs = $displayedPriceIs;
        }
        return $this;
    }
    /**
     * Get DisplayPriceTypesOnButton value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDisplayPriceTypesOnButton()
    {
        return isset($this->DisplayPriceTypesOnButton) ? $this->DisplayPriceTypesOnButton : null;
    }
    /**
     * Set DisplayPriceTypesOnButton value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $displayPriceTypesOnButton
     * @return \patest\StructType\Security_SalesUserParameters
     */
    public function setDisplayPriceTypesOnButton($displayPriceTypesOnButton = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayPriceTypesOnButton) && !is_bool($displayPriceTypesOnButton)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayPriceTypesOnButton, true), gettype($displayPriceTypesOnButton)), __LINE__);
        }
        if (is_null($displayPriceTypesOnButton) || (is_array($displayPriceTypesOnButton) && empty($displayPriceTypesOnButton))) {
            unset($this->DisplayPriceTypesOnButton);
        } else {
            $this->DisplayPriceTypesOnButton = $displayPriceTypesOnButton;
        }
        return $this;
    }
    /**
     * Get DisplayTransactionSummaryAtEnd value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDisplayTransactionSummaryAtEnd()
    {
        return isset($this->DisplayTransactionSummaryAtEnd) ? $this->DisplayTransactionSummaryAtEnd : null;
    }
    /**
     * Set DisplayTransactionSummaryAtEnd value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $displayTransactionSummaryAtEnd
     * @return \patest\StructType\Security_SalesUserParameters
     */
    public function setDisplayTransactionSummaryAtEnd($displayTransactionSummaryAtEnd = null)
    {
        // validation for constraint: boolean
        if (!is_null($displayTransactionSummaryAtEnd) && !is_bool($displayTransactionSummaryAtEnd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($displayTransactionSummaryAtEnd, true), gettype($displayTransactionSummaryAtEnd)), __LINE__);
        }
        if (is_null($displayTransactionSummaryAtEnd) || (is_array($displayTransactionSummaryAtEnd) && empty($displayTransactionSummaryAtEnd))) {
            unset($this->DisplayTransactionSummaryAtEnd);
        } else {
            $this->DisplayTransactionSummaryAtEnd = $displayTransactionSummaryAtEnd;
        }
        return $this;
    }
    /**
     * Get ExcludeActionsWhenSettingRestrictions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExcludeActionsWhenSettingRestrictions()
    {
        return isset($this->ExcludeActionsWhenSettingRestrictions) ? $this->ExcludeActionsWhenSettingRestrictions : null;
    }
    /**
     * Set ExcludeActionsWhenSettingRestrictions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $excludeActionsWhenSettingRestrictions
     * @return \patest\StructType\Security_SalesUserParameters
     */
    public function setExcludeActionsWhenSettingRestrictions($excludeActionsWhenSettingRestrictions = null)
    {
        // validation for constraint: string
        if (!is_null($excludeActionsWhenSettingRestrictions) && !is_string($excludeActionsWhenSettingRestrictions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($excludeActionsWhenSettingRestrictions, true), gettype($excludeActionsWhenSettingRestrictions)), __LINE__);
        }
        if (is_null($excludeActionsWhenSettingRestrictions) || (is_array($excludeActionsWhenSettingRestrictions) && empty($excludeActionsWhenSettingRestrictions))) {
            unset($this->ExcludeActionsWhenSettingRestrictions);
        } else {
            $this->ExcludeActionsWhenSettingRestrictions = $excludeActionsWhenSettingRestrictions;
        }
        return $this;
    }
    /**
     * Get GiftVocherDefaultQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getGiftVocherDefaultQuantity()
    {
        return isset($this->GiftVocherDefaultQuantity) ? $this->GiftVocherDefaultQuantity : null;
    }
    /**
     * Set GiftVocherDefaultQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $giftVocherDefaultQuantity
     * @return \patest\StructType\Security_SalesUserParameters
     */
    public function setGiftVocherDefaultQuantity($giftVocherDefaultQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($giftVocherDefaultQuantity) && !(is_int($giftVocherDefaultQuantity) || ctype_digit($giftVocherDefaultQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($giftVocherDefaultQuantity, true), gettype($giftVocherDefaultQuantity)), __LINE__);
        }
        if (is_null($giftVocherDefaultQuantity) || (is_array($giftVocherDefaultQuantity) && empty($giftVocherDefaultQuantity))) {
            unset($this->GiftVocherDefaultQuantity);
        } else {
            $this->GiftVocherDefaultQuantity = $giftVocherDefaultQuantity;
        }
        return $this;
    }
    /**
     * Get HiddenBasketColumns value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHiddenBasketColumns()
    {
        return isset($this->HiddenBasketColumns) ? $this->HiddenBasketColumns : null;
    }
    /**
     * Set HiddenBasketColumns value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hiddenBasketColumns
     * @return \patest\StructType\Security_SalesUserParameters
     */
    public function setHiddenBasketColumns($hiddenBasketColumns = null)
    {
        // validation for constraint: string
        if (!is_null($hiddenBasketColumns) && !is_string($hiddenBasketColumns)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hiddenBasketColumns, true), gettype($hiddenBasketColumns)), __LINE__);
        }
        if (is_null($hiddenBasketColumns) || (is_array($hiddenBasketColumns) && empty($hiddenBasketColumns))) {
            unset($this->HiddenBasketColumns);
        } else {
            $this->HiddenBasketColumns = $hiddenBasketColumns;
        }
        return $this;
    }
    /**
     * Get HiddenEventsGridColumns value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHiddenEventsGridColumns()
    {
        return isset($this->HiddenEventsGridColumns) ? $this->HiddenEventsGridColumns : null;
    }
    /**
     * Set HiddenEventsGridColumns value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hiddenEventsGridColumns
     * @return \patest\StructType\Security_SalesUserParameters
     */
    public function setHiddenEventsGridColumns($hiddenEventsGridColumns = null)
    {
        // validation for constraint: string
        if (!is_null($hiddenEventsGridColumns) && !is_string($hiddenEventsGridColumns)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hiddenEventsGridColumns, true), gettype($hiddenEventsGridColumns)), __LINE__);
        }
        if (is_null($hiddenEventsGridColumns) || (is_array($hiddenEventsGridColumns) && empty($hiddenEventsGridColumns))) {
            unset($this->HiddenEventsGridColumns);
        } else {
            $this->HiddenEventsGridColumns = $hiddenEventsGridColumns;
        }
        return $this;
    }
    /**
     * Get HiddenSeatListColumns value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHiddenSeatListColumns()
    {
        return isset($this->HiddenSeatListColumns) ? $this->HiddenSeatListColumns : null;
    }
    /**
     * Set HiddenSeatListColumns value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hiddenSeatListColumns
     * @return \patest\StructType\Security_SalesUserParameters
     */
    public function setHiddenSeatListColumns($hiddenSeatListColumns = null)
    {
        // validation for constraint: string
        if (!is_null($hiddenSeatListColumns) && !is_string($hiddenSeatListColumns)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hiddenSeatListColumns, true), gettype($hiddenSeatListColumns)), __LINE__);
        }
        if (is_null($hiddenSeatListColumns) || (is_array($hiddenSeatListColumns) && empty($hiddenSeatListColumns))) {
            unset($this->HiddenSeatListColumns);
        } else {
            $this->HiddenSeatListColumns = $hiddenSeatListColumns;
        }
        return $this;
    }
    /**
     * Get ImplicitSettlementDisplayWarning value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getImplicitSettlementDisplayWarning()
    {
        return isset($this->ImplicitSettlementDisplayWarning) ? $this->ImplicitSettlementDisplayWarning : null;
    }
    /**
     * Set ImplicitSettlementDisplayWarning value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $implicitSettlementDisplayWarning
     * @return \patest\StructType\Security_SalesUserParameters
     */
    public function setImplicitSettlementDisplayWarning($implicitSettlementDisplayWarning = null)
    {
        // validation for constraint: boolean
        if (!is_null($implicitSettlementDisplayWarning) && !is_bool($implicitSettlementDisplayWarning)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($implicitSettlementDisplayWarning, true), gettype($implicitSettlementDisplayWarning)), __LINE__);
        }
        if (is_null($implicitSettlementDisplayWarning) || (is_array($implicitSettlementDisplayWarning) && empty($implicitSettlementDisplayWarning))) {
            unset($this->ImplicitSettlementDisplayWarning);
        } else {
            $this->ImplicitSettlementDisplayWarning = $implicitSettlementDisplayWarning;
        }
        return $this;
    }
    /**
     * Get MembershipDefaultQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMembershipDefaultQuantity()
    {
        return isset($this->MembershipDefaultQuantity) ? $this->MembershipDefaultQuantity : null;
    }
    /**
     * Set MembershipDefaultQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $membershipDefaultQuantity
     * @return \patest\StructType\Security_SalesUserParameters
     */
    public function setMembershipDefaultQuantity($membershipDefaultQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($membershipDefaultQuantity) && !(is_int($membershipDefaultQuantity) || ctype_digit($membershipDefaultQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($membershipDefaultQuantity, true), gettype($membershipDefaultQuantity)), __LINE__);
        }
        if (is_null($membershipDefaultQuantity) || (is_array($membershipDefaultQuantity) && empty($membershipDefaultQuantity))) {
            unset($this->MembershipDefaultQuantity);
        } else {
            $this->MembershipDefaultQuantity = $membershipDefaultQuantity;
        }
        return $this;
    }
    /**
     * Get MerchandiseDefaultQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMerchandiseDefaultQuantity()
    {
        return isset($this->MerchandiseDefaultQuantity) ? $this->MerchandiseDefaultQuantity : null;
    }
    /**
     * Set MerchandiseDefaultQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $merchandiseDefaultQuantity
     * @return \patest\StructType\Security_SalesUserParameters
     */
    public function setMerchandiseDefaultQuantity($merchandiseDefaultQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($merchandiseDefaultQuantity) && !(is_int($merchandiseDefaultQuantity) || ctype_digit($merchandiseDefaultQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($merchandiseDefaultQuantity, true), gettype($merchandiseDefaultQuantity)), __LINE__);
        }
        if (is_null($merchandiseDefaultQuantity) || (is_array($merchandiseDefaultQuantity) && empty($merchandiseDefaultQuantity))) {
            unset($this->MerchandiseDefaultQuantity);
        } else {
            $this->MerchandiseDefaultQuantity = $merchandiseDefaultQuantity;
        }
        return $this;
    }
    /**
     * Get MinimizeBasketWhenDisplayingSeatingPlan value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMinimizeBasketWhenDisplayingSeatingPlan()
    {
        return isset($this->MinimizeBasketWhenDisplayingSeatingPlan) ? $this->MinimizeBasketWhenDisplayingSeatingPlan : null;
    }
    /**
     * Set MinimizeBasketWhenDisplayingSeatingPlan value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $minimizeBasketWhenDisplayingSeatingPlan
     * @return \patest\StructType\Security_SalesUserParameters
     */
    public function setMinimizeBasketWhenDisplayingSeatingPlan($minimizeBasketWhenDisplayingSeatingPlan = null)
    {
        // validation for constraint: boolean
        if (!is_null($minimizeBasketWhenDisplayingSeatingPlan) && !is_bool($minimizeBasketWhenDisplayingSeatingPlan)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($minimizeBasketWhenDisplayingSeatingPlan, true), gettype($minimizeBasketWhenDisplayingSeatingPlan)), __LINE__);
        }
        if (is_null($minimizeBasketWhenDisplayingSeatingPlan) || (is_array($minimizeBasketWhenDisplayingSeatingPlan) && empty($minimizeBasketWhenDisplayingSeatingPlan))) {
            unset($this->MinimizeBasketWhenDisplayingSeatingPlan);
        } else {
            $this->MinimizeBasketWhenDisplayingSeatingPlan = $minimizeBasketWhenDisplayingSeatingPlan;
        }
        return $this;
    }
    /**
     * Get NewSalesDefaultTab value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewSalesDefaultTab()
    {
        return isset($this->NewSalesDefaultTab) ? $this->NewSalesDefaultTab : null;
    }
    /**
     * Set NewSalesDefaultTab value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newSalesDefaultTab
     * @return \patest\StructType\Security_SalesUserParameters
     */
    public function setNewSalesDefaultTab($newSalesDefaultTab = null)
    {
        // validation for constraint: string
        if (!is_null($newSalesDefaultTab) && !is_string($newSalesDefaultTab)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newSalesDefaultTab, true), gettype($newSalesDefaultTab)), __LINE__);
        }
        if (is_null($newSalesDefaultTab) || (is_array($newSalesDefaultTab) && empty($newSalesDefaultTab))) {
            unset($this->NewSalesDefaultTab);
        } else {
            $this->NewSalesDefaultTab = $newSalesDefaultTab;
        }
        return $this;
    }
    /**
     * Get NewSeatingPlanDefaultView value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNewSeatingPlanDefaultView()
    {
        return isset($this->NewSeatingPlanDefaultView) ? $this->NewSeatingPlanDefaultView : null;
    }
    /**
     * Set NewSeatingPlanDefaultView value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $newSeatingPlanDefaultView
     * @return \patest\StructType\Security_SalesUserParameters
     */
    public function setNewSeatingPlanDefaultView($newSeatingPlanDefaultView = null)
    {
        // validation for constraint: string
        if (!is_null($newSeatingPlanDefaultView) && !is_string($newSeatingPlanDefaultView)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($newSeatingPlanDefaultView, true), gettype($newSeatingPlanDefaultView)), __LINE__);
        }
        if (is_null($newSeatingPlanDefaultView) || (is_array($newSeatingPlanDefaultView) && empty($newSeatingPlanDefaultView))) {
            unset($this->NewSeatingPlanDefaultView);
        } else {
            $this->NewSeatingPlanDefaultView = $newSeatingPlanDefaultView;
        }
        return $this;
    }
    /**
     * Get ReturnToOriginalDate value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getReturnToOriginalDate()
    {
        return isset($this->ReturnToOriginalDate) ? $this->ReturnToOriginalDate : null;
    }
    /**
     * Set ReturnToOriginalDate value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $returnToOriginalDate
     * @return \patest\StructType\Security_SalesUserParameters
     */
    public function setReturnToOriginalDate($returnToOriginalDate = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnToOriginalDate) && !is_bool($returnToOriginalDate)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($returnToOriginalDate, true), gettype($returnToOriginalDate)), __LINE__);
        }
        if (is_null($returnToOriginalDate) || (is_array($returnToOriginalDate) && empty($returnToOriginalDate))) {
            unset($this->ReturnToOriginalDate);
        } else {
            $this->ReturnToOriginalDate = $returnToOriginalDate;
        }
        return $this;
    }
    /**
     * Get ReturnToUserOu value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getReturnToUserOu()
    {
        return isset($this->ReturnToUserOu) ? $this->ReturnToUserOu : null;
    }
    /**
     * Set ReturnToUserOu value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $returnToUserOu
     * @return \patest\StructType\Security_SalesUserParameters
     */
    public function setReturnToUserOu($returnToUserOu = null)
    {
        // validation for constraint: boolean
        if (!is_null($returnToUserOu) && !is_bool($returnToUserOu)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($returnToUserOu, true), gettype($returnToUserOu)), __LINE__);
        }
        if (is_null($returnToUserOu) || (is_array($returnToUserOu) && empty($returnToUserOu))) {
            unset($this->ReturnToUserOu);
        } else {
            $this->ReturnToUserOu = $returnToUserOu;
        }
        return $this;
    }
    /**
     * Get SalesDefaultTab value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSalesDefaultTab()
    {
        return isset($this->SalesDefaultTab) ? $this->SalesDefaultTab : null;
    }
    /**
     * Set SalesDefaultTab value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $salesDefaultTab
     * @return \patest\StructType\Security_SalesUserParameters
     */
    public function setSalesDefaultTab($salesDefaultTab = null)
    {
        // validation for constraint: string
        if (!is_null($salesDefaultTab) && !is_string($salesDefaultTab)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($salesDefaultTab, true), gettype($salesDefaultTab)), __LINE__);
        }
        if (is_null($salesDefaultTab) || (is_array($salesDefaultTab) && empty($salesDefaultTab))) {
            unset($this->SalesDefaultTab);
        } else {
            $this->SalesDefaultTab = $salesDefaultTab;
        }
        return $this;
    }
    /**
     * Get SalesSaleModeStartupAs value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSalesSaleModeStartupAs()
    {
        return isset($this->SalesSaleModeStartupAs) ? $this->SalesSaleModeStartupAs : null;
    }
    /**
     * Set SalesSaleModeStartupAs value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $salesSaleModeStartupAs
     * @return \patest\StructType\Security_SalesUserParameters
     */
    public function setSalesSaleModeStartupAs($salesSaleModeStartupAs = null)
    {
        // validation for constraint: int
        if (!is_null($salesSaleModeStartupAs) && !(is_int($salesSaleModeStartupAs) || ctype_digit($salesSaleModeStartupAs))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($salesSaleModeStartupAs, true), gettype($salesSaleModeStartupAs)), __LINE__);
        }
        if (is_null($salesSaleModeStartupAs) || (is_array($salesSaleModeStartupAs) && empty($salesSaleModeStartupAs))) {
            unset($this->SalesSaleModeStartupAs);
        } else {
            $this->SalesSaleModeStartupAs = $salesSaleModeStartupAs;
        }
        return $this;
    }
    /**
     * Get SeatingPlanDefaultView value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSeatingPlanDefaultView()
    {
        return isset($this->SeatingPlanDefaultView) ? $this->SeatingPlanDefaultView : null;
    }
    /**
     * Set SeatingPlanDefaultView value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $seatingPlanDefaultView
     * @return \patest\StructType\Security_SalesUserParameters
     */
    public function setSeatingPlanDefaultView($seatingPlanDefaultView = null)
    {
        // validation for constraint: int
        if (!is_null($seatingPlanDefaultView) && !(is_int($seatingPlanDefaultView) || ctype_digit($seatingPlanDefaultView))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($seatingPlanDefaultView, true), gettype($seatingPlanDefaultView)), __LINE__);
        }
        if (is_null($seatingPlanDefaultView) || (is_array($seatingPlanDefaultView) && empty($seatingPlanDefaultView))) {
            unset($this->SeatingPlanDefaultView);
        } else {
            $this->SeatingPlanDefaultView = $seatingPlanDefaultView;
        }
        return $this;
    }
    /**
     * Get SelectionOBOAccount value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSelectionOBOAccount()
    {
        return isset($this->SelectionOBOAccount) ? $this->SelectionOBOAccount : null;
    }
    /**
     * Set SelectionOBOAccount value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $selectionOBOAccount
     * @return \patest\StructType\Security_SalesUserParameters
     */
    public function setSelectionOBOAccount($selectionOBOAccount = null)
    {
        // validation for constraint: int
        if (!is_null($selectionOBOAccount) && !(is_int($selectionOBOAccount) || ctype_digit($selectionOBOAccount))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($selectionOBOAccount, true), gettype($selectionOBOAccount)), __LINE__);
        }
        if (is_null($selectionOBOAccount) || (is_array($selectionOBOAccount) && empty($selectionOBOAccount))) {
            unset($this->SelectionOBOAccount);
        } else {
            $this->SelectionOBOAccount = $selectionOBOAccount;
        }
        return $this;
    }
    /**
     * Get SubscriptionDefaultQuantity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSubscriptionDefaultQuantity()
    {
        return isset($this->SubscriptionDefaultQuantity) ? $this->SubscriptionDefaultQuantity : null;
    }
    /**
     * Set SubscriptionDefaultQuantity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $subscriptionDefaultQuantity
     * @return \patest\StructType\Security_SalesUserParameters
     */
    public function setSubscriptionDefaultQuantity($subscriptionDefaultQuantity = null)
    {
        // validation for constraint: int
        if (!is_null($subscriptionDefaultQuantity) && !(is_int($subscriptionDefaultQuantity) || ctype_digit($subscriptionDefaultQuantity))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($subscriptionDefaultQuantity, true), gettype($subscriptionDefaultQuantity)), __LINE__);
        }
        if (is_null($subscriptionDefaultQuantity) || (is_array($subscriptionDefaultQuantity) && empty($subscriptionDefaultQuantity))) {
            unset($this->SubscriptionDefaultQuantity);
        } else {
            $this->SubscriptionDefaultQuantity = $subscriptionDefaultQuantity;
        }
        return $this;
    }
}
