<?php

namespace patest\StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for Security.SalesCompanyParameters StructType
 * @subpackage Structs
 */
class Security_SalesCompanyParameters extends Security_CompanyParameterBase
{
    /**
     * The AfterMidnightTimeOffset
     * Meta information extracted from the WSDL
     * - base: xs:duration
     * - maxInclusive: P10675199DT2H48M5.4775807S
     * - minInclusive: -P10675199DT2H48M5.4775808S
     * - minOccurs: 0
     * - nillable: true
     * - pattern: \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?
     * - type: tns:duration
     * @var string
     */
    public $AfterMidnightTimeOffset;
    /**
     * The AllEventsAreGa
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AllEventsAreGa;
    /**
     * The AlwaysSuggestOwnersAssignment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AlwaysSuggestOwnersAssignment;
    /**
     * The AlwaysSuggestSubsidyAssignment
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $AlwaysSuggestSubsidyAssignment;
    /**
     * The AutoReleaseSeatsTimeoutMin
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AutoReleaseSeatsTimeoutMin;
    /**
     * The AvailabilityGaugeHighOccupancyNominalThreshold
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AvailabilityGaugeHighOccupancyNominalThreshold;
    /**
     * The AvailabilityGaugeHighOccupancyPercentageThreshold
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AvailabilityGaugeHighOccupancyPercentageThreshold;
    /**
     * The AvailabilityGaugeLowOccupancyNominalThreshold
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AvailabilityGaugeLowOccupancyNominalThreshold;
    /**
     * The AvailabilityGaugeLowOccupancyPercentageThreshold
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $AvailabilityGaugeLowOccupancyPercentageThreshold;
    /**
     * The BasketGroupingPerPriceType
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $BasketGroupingPerPriceType;
    /**
     * The BasketStateMode
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $BasketStateMode;
    /**
     * The DefaultShiftOpenSum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \patest\StructType\Money
     */
    public $DefaultShiftOpenSum;
    /**
     * The DisplayAdvertisingPhaseInReservation
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DisplayAdvertisingPhaseInReservation;
    /**
     * The EventsCrossOrgUnitsSalesPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EventsCrossOrgUnitsSalesPolicy;
    /**
     * The ExcludeActionsWhenSettingRestrictions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ExcludeActionsWhenSettingRestrictions;
    /**
     * The FilterHallViewerPriceLevels
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $FilterHallViewerPriceLevels;
    /**
     * The FollowupFromDays
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $FollowupFromDays;
    /**
     * The FollowupInEventSaleSearchCountOnlySpecificEventTickets
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $FollowupInEventSaleSearchCountOnlySpecificEventTickets;
    /**
     * The GiftVouchersCrossOrgUnitsSalesPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $GiftVouchersCrossOrgUnitsSalesPolicy;
    /**
     * The HiddenSeatAttributes
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $HiddenSeatAttributes;
    /**
     * The IsCloseAfterMidnight
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $IsCloseAfterMidnight;
    /**
     * The MembershipCrossOrgUnitsSalesPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MembershipCrossOrgUnitsSalesPolicy;
    /**
     * The MerchandiseCrossOrgUnitsSalesPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MerchandiseCrossOrgUnitsSalesPolicy;
    /**
     * The NotBasketNetTotalInsteadTotal
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NotBasketNetTotalInsteadTotal;
    /**
     * The NumberOfDaysWhenRetrievingFutureEvents
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumberOfDaysWhenRetrievingFutureEvents;
    /**
     * The SalesPopupSeatInfo
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SalesPopupSeatInfo;
    /**
     * The SeriesCrossOrgUnitsSalesPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SeriesCrossOrgUnitsSalesPolicy;
    /**
     * The SetShiftOpenSum
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SetShiftOpenSum;
    /**
     * The UnloadFutureEventSeatingPlanManagerTimeoutHr
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $UnloadFutureEventSeatingPlanManagerTimeoutHr;
    /**
     * The UnloadPastEventSeatingPlanManagerTimeoutHr
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $UnloadPastEventSeatingPlanManagerTimeoutHr;
    /**
     * The UseAdvertisingRules
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UseAdvertisingRules;
    /**
     * The UseCrossOrgUnitsSalesPolicy
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UseCrossOrgUnitsSalesPolicy;
    /**
     * The UseGroupingTransactions
     * Meta information extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UseGroupingTransactions;
    /**
     * Constructor method for Security.SalesCompanyParameters
     * @uses Security_SalesCompanyParameters::setAfterMidnightTimeOffset()
     * @uses Security_SalesCompanyParameters::setAllEventsAreGa()
     * @uses Security_SalesCompanyParameters::setAlwaysSuggestOwnersAssignment()
     * @uses Security_SalesCompanyParameters::setAlwaysSuggestSubsidyAssignment()
     * @uses Security_SalesCompanyParameters::setAutoReleaseSeatsTimeoutMin()
     * @uses Security_SalesCompanyParameters::setAvailabilityGaugeHighOccupancyNominalThreshold()
     * @uses Security_SalesCompanyParameters::setAvailabilityGaugeHighOccupancyPercentageThreshold()
     * @uses Security_SalesCompanyParameters::setAvailabilityGaugeLowOccupancyNominalThreshold()
     * @uses Security_SalesCompanyParameters::setAvailabilityGaugeLowOccupancyPercentageThreshold()
     * @uses Security_SalesCompanyParameters::setBasketGroupingPerPriceType()
     * @uses Security_SalesCompanyParameters::setBasketStateMode()
     * @uses Security_SalesCompanyParameters::setDefaultShiftOpenSum()
     * @uses Security_SalesCompanyParameters::setDisplayAdvertisingPhaseInReservation()
     * @uses Security_SalesCompanyParameters::setEventsCrossOrgUnitsSalesPolicy()
     * @uses Security_SalesCompanyParameters::setExcludeActionsWhenSettingRestrictions()
     * @uses Security_SalesCompanyParameters::setFilterHallViewerPriceLevels()
     * @uses Security_SalesCompanyParameters::setFollowupFromDays()
     * @uses Security_SalesCompanyParameters::setFollowupInEventSaleSearchCountOnlySpecificEventTickets()
     * @uses Security_SalesCompanyParameters::setGiftVouchersCrossOrgUnitsSalesPolicy()
     * @uses Security_SalesCompanyParameters::setHiddenSeatAttributes()
     * @uses Security_SalesCompanyParameters::setIsCloseAfterMidnight()
     * @uses Security_SalesCompanyParameters::setMembershipCrossOrgUnitsSalesPolicy()
     * @uses Security_SalesCompanyParameters::setMerchandiseCrossOrgUnitsSalesPolicy()
     * @uses Security_SalesCompanyParameters::setNotBasketNetTotalInsteadTotal()
     * @uses Security_SalesCompanyParameters::setNumberOfDaysWhenRetrievingFutureEvents()
     * @uses Security_SalesCompanyParameters::setSalesPopupSeatInfo()
     * @uses Security_SalesCompanyParameters::setSeriesCrossOrgUnitsSalesPolicy()
     * @uses Security_SalesCompanyParameters::setSetShiftOpenSum()
     * @uses Security_SalesCompanyParameters::setUnloadFutureEventSeatingPlanManagerTimeoutHr()
     * @uses Security_SalesCompanyParameters::setUnloadPastEventSeatingPlanManagerTimeoutHr()
     * @uses Security_SalesCompanyParameters::setUseAdvertisingRules()
     * @uses Security_SalesCompanyParameters::setUseCrossOrgUnitsSalesPolicy()
     * @uses Security_SalesCompanyParameters::setUseGroupingTransactions()
     * @param string $afterMidnightTimeOffset
     * @param bool $allEventsAreGa
     * @param bool $alwaysSuggestOwnersAssignment
     * @param bool $alwaysSuggestSubsidyAssignment
     * @param int $autoReleaseSeatsTimeoutMin
     * @param int $availabilityGaugeHighOccupancyNominalThreshold
     * @param int $availabilityGaugeHighOccupancyPercentageThreshold
     * @param int $availabilityGaugeLowOccupancyNominalThreshold
     * @param int $availabilityGaugeLowOccupancyPercentageThreshold
     * @param bool $basketGroupingPerPriceType
     * @param string $basketStateMode
     * @param \patest\StructType\Money $defaultShiftOpenSum
     * @param string $displayAdvertisingPhaseInReservation
     * @param string $eventsCrossOrgUnitsSalesPolicy
     * @param string $excludeActionsWhenSettingRestrictions
     * @param bool $filterHallViewerPriceLevels
     * @param int $followupFromDays
     * @param bool $followupInEventSaleSearchCountOnlySpecificEventTickets
     * @param string $giftVouchersCrossOrgUnitsSalesPolicy
     * @param string $hiddenSeatAttributes
     * @param bool $isCloseAfterMidnight
     * @param string $membershipCrossOrgUnitsSalesPolicy
     * @param string $merchandiseCrossOrgUnitsSalesPolicy
     * @param bool $notBasketNetTotalInsteadTotal
     * @param int $numberOfDaysWhenRetrievingFutureEvents
     * @param bool $salesPopupSeatInfo
     * @param string $seriesCrossOrgUnitsSalesPolicy
     * @param bool $setShiftOpenSum
     * @param int $unloadFutureEventSeatingPlanManagerTimeoutHr
     * @param int $unloadPastEventSeatingPlanManagerTimeoutHr
     * @param bool $useAdvertisingRules
     * @param bool $useCrossOrgUnitsSalesPolicy
     * @param bool $useGroupingTransactions
     */
    public function __construct($afterMidnightTimeOffset = null, $allEventsAreGa = null, $alwaysSuggestOwnersAssignment = null, $alwaysSuggestSubsidyAssignment = null, $autoReleaseSeatsTimeoutMin = null, $availabilityGaugeHighOccupancyNominalThreshold = null, $availabilityGaugeHighOccupancyPercentageThreshold = null, $availabilityGaugeLowOccupancyNominalThreshold = null, $availabilityGaugeLowOccupancyPercentageThreshold = null, $basketGroupingPerPriceType = null, $basketStateMode = null, \patest\StructType\Money $defaultShiftOpenSum = null, $displayAdvertisingPhaseInReservation = null, $eventsCrossOrgUnitsSalesPolicy = null, $excludeActionsWhenSettingRestrictions = null, $filterHallViewerPriceLevels = null, $followupFromDays = null, $followupInEventSaleSearchCountOnlySpecificEventTickets = null, $giftVouchersCrossOrgUnitsSalesPolicy = null, $hiddenSeatAttributes = null, $isCloseAfterMidnight = null, $membershipCrossOrgUnitsSalesPolicy = null, $merchandiseCrossOrgUnitsSalesPolicy = null, $notBasketNetTotalInsteadTotal = null, $numberOfDaysWhenRetrievingFutureEvents = null, $salesPopupSeatInfo = null, $seriesCrossOrgUnitsSalesPolicy = null, $setShiftOpenSum = null, $unloadFutureEventSeatingPlanManagerTimeoutHr = null, $unloadPastEventSeatingPlanManagerTimeoutHr = null, $useAdvertisingRules = null, $useCrossOrgUnitsSalesPolicy = null, $useGroupingTransactions = null)
    {
        $this
            ->setAfterMidnightTimeOffset($afterMidnightTimeOffset)
            ->setAllEventsAreGa($allEventsAreGa)
            ->setAlwaysSuggestOwnersAssignment($alwaysSuggestOwnersAssignment)
            ->setAlwaysSuggestSubsidyAssignment($alwaysSuggestSubsidyAssignment)
            ->setAutoReleaseSeatsTimeoutMin($autoReleaseSeatsTimeoutMin)
            ->setAvailabilityGaugeHighOccupancyNominalThreshold($availabilityGaugeHighOccupancyNominalThreshold)
            ->setAvailabilityGaugeHighOccupancyPercentageThreshold($availabilityGaugeHighOccupancyPercentageThreshold)
            ->setAvailabilityGaugeLowOccupancyNominalThreshold($availabilityGaugeLowOccupancyNominalThreshold)
            ->setAvailabilityGaugeLowOccupancyPercentageThreshold($availabilityGaugeLowOccupancyPercentageThreshold)
            ->setBasketGroupingPerPriceType($basketGroupingPerPriceType)
            ->setBasketStateMode($basketStateMode)
            ->setDefaultShiftOpenSum($defaultShiftOpenSum)
            ->setDisplayAdvertisingPhaseInReservation($displayAdvertisingPhaseInReservation)
            ->setEventsCrossOrgUnitsSalesPolicy($eventsCrossOrgUnitsSalesPolicy)
            ->setExcludeActionsWhenSettingRestrictions($excludeActionsWhenSettingRestrictions)
            ->setFilterHallViewerPriceLevels($filterHallViewerPriceLevels)
            ->setFollowupFromDays($followupFromDays)
            ->setFollowupInEventSaleSearchCountOnlySpecificEventTickets($followupInEventSaleSearchCountOnlySpecificEventTickets)
            ->setGiftVouchersCrossOrgUnitsSalesPolicy($giftVouchersCrossOrgUnitsSalesPolicy)
            ->setHiddenSeatAttributes($hiddenSeatAttributes)
            ->setIsCloseAfterMidnight($isCloseAfterMidnight)
            ->setMembershipCrossOrgUnitsSalesPolicy($membershipCrossOrgUnitsSalesPolicy)
            ->setMerchandiseCrossOrgUnitsSalesPolicy($merchandiseCrossOrgUnitsSalesPolicy)
            ->setNotBasketNetTotalInsteadTotal($notBasketNetTotalInsteadTotal)
            ->setNumberOfDaysWhenRetrievingFutureEvents($numberOfDaysWhenRetrievingFutureEvents)
            ->setSalesPopupSeatInfo($salesPopupSeatInfo)
            ->setSeriesCrossOrgUnitsSalesPolicy($seriesCrossOrgUnitsSalesPolicy)
            ->setSetShiftOpenSum($setShiftOpenSum)
            ->setUnloadFutureEventSeatingPlanManagerTimeoutHr($unloadFutureEventSeatingPlanManagerTimeoutHr)
            ->setUnloadPastEventSeatingPlanManagerTimeoutHr($unloadPastEventSeatingPlanManagerTimeoutHr)
            ->setUseAdvertisingRules($useAdvertisingRules)
            ->setUseCrossOrgUnitsSalesPolicy($useCrossOrgUnitsSalesPolicy)
            ->setUseGroupingTransactions($useGroupingTransactions);
    }
    /**
     * Get AfterMidnightTimeOffset value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAfterMidnightTimeOffset()
    {
        return isset($this->AfterMidnightTimeOffset) ? $this->AfterMidnightTimeOffset : null;
    }
    /**
     * Set AfterMidnightTimeOffset value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $afterMidnightTimeOffset
     * @return \patest\StructType\Security_SalesCompanyParameters
     */
    public function setAfterMidnightTimeOffset($afterMidnightTimeOffset = null)
    {
        // validation for constraint: string
        if (!is_null($afterMidnightTimeOffset) && !is_string($afterMidnightTimeOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($afterMidnightTimeOffset, true), gettype($afterMidnightTimeOffset)), __LINE__);
        }
        // validation for constraint: maxInclusive(P10675199DT2H48M5.4775807S)
        if (!is_null($afterMidnightTimeOffset) && false === mb_strpos($afterMidnightTimeOffset, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $afterMidnightTimeOffset)))) > \DateTime::createFromFormat('U', $time)->add(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775807S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically less than or equal to P10675199DT2H48M5.4775807S', var_export($afterMidnightTimeOffset, true)), __LINE__);
        }
        // validation for constraint: minInclusive(-P10675199DT2H48M5.4775808S)
        if (!is_null($afterMidnightTimeOffset) && false !== mb_strpos($afterMidnightTimeOffset, '-') && ($time = (string) time()) && \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', str_replace('-', '', $afterMidnightTimeOffset)))) < \DateTime::createFromFormat('U', $time)->sub(new \DateInterval(preg_replace('/(.*)(\.[0-9]*S)/', '$1S', 'P10675199DT2H48M5.4775808S')))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, the value must be chronologically greater than or equal to -P10675199DT2H48M5.4775808S', var_export($afterMidnightTimeOffset, true)), __LINE__);
        }
        // validation for constraint: pattern(\-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?)
        if (!is_null($afterMidnightTimeOffset) && !preg_match('/\\-?P(\\d*D)?(T(\\d*H)?(\\d*M)?(\\d*(\\.\\d*)?S)?)?/', $afterMidnightTimeOffset)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a literal that is among the set of character sequences denoted by the regular expression \-?P(\d*D)?(T(\d*H)?(\d*M)?(\d*(\.\d*)?S)?)?', var_export($afterMidnightTimeOffset, true)), __LINE__);
        }
        if (is_null($afterMidnightTimeOffset) || (is_array($afterMidnightTimeOffset) && empty($afterMidnightTimeOffset))) {
            unset($this->AfterMidnightTimeOffset);
        } else {
            $this->AfterMidnightTimeOffset = $afterMidnightTimeOffset;
        }
        return $this;
    }
    /**
     * Get AllEventsAreGa value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAllEventsAreGa()
    {
        return isset($this->AllEventsAreGa) ? $this->AllEventsAreGa : null;
    }
    /**
     * Set AllEventsAreGa value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $allEventsAreGa
     * @return \patest\StructType\Security_SalesCompanyParameters
     */
    public function setAllEventsAreGa($allEventsAreGa = null)
    {
        // validation for constraint: boolean
        if (!is_null($allEventsAreGa) && !is_bool($allEventsAreGa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($allEventsAreGa, true), gettype($allEventsAreGa)), __LINE__);
        }
        if (is_null($allEventsAreGa) || (is_array($allEventsAreGa) && empty($allEventsAreGa))) {
            unset($this->AllEventsAreGa);
        } else {
            $this->AllEventsAreGa = $allEventsAreGa;
        }
        return $this;
    }
    /**
     * Get AlwaysSuggestOwnersAssignment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAlwaysSuggestOwnersAssignment()
    {
        return isset($this->AlwaysSuggestOwnersAssignment) ? $this->AlwaysSuggestOwnersAssignment : null;
    }
    /**
     * Set AlwaysSuggestOwnersAssignment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $alwaysSuggestOwnersAssignment
     * @return \patest\StructType\Security_SalesCompanyParameters
     */
    public function setAlwaysSuggestOwnersAssignment($alwaysSuggestOwnersAssignment = null)
    {
        // validation for constraint: boolean
        if (!is_null($alwaysSuggestOwnersAssignment) && !is_bool($alwaysSuggestOwnersAssignment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($alwaysSuggestOwnersAssignment, true), gettype($alwaysSuggestOwnersAssignment)), __LINE__);
        }
        if (is_null($alwaysSuggestOwnersAssignment) || (is_array($alwaysSuggestOwnersAssignment) && empty($alwaysSuggestOwnersAssignment))) {
            unset($this->AlwaysSuggestOwnersAssignment);
        } else {
            $this->AlwaysSuggestOwnersAssignment = $alwaysSuggestOwnersAssignment;
        }
        return $this;
    }
    /**
     * Get AlwaysSuggestSubsidyAssignment value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAlwaysSuggestSubsidyAssignment()
    {
        return isset($this->AlwaysSuggestSubsidyAssignment) ? $this->AlwaysSuggestSubsidyAssignment : null;
    }
    /**
     * Set AlwaysSuggestSubsidyAssignment value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $alwaysSuggestSubsidyAssignment
     * @return \patest\StructType\Security_SalesCompanyParameters
     */
    public function setAlwaysSuggestSubsidyAssignment($alwaysSuggestSubsidyAssignment = null)
    {
        // validation for constraint: boolean
        if (!is_null($alwaysSuggestSubsidyAssignment) && !is_bool($alwaysSuggestSubsidyAssignment)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($alwaysSuggestSubsidyAssignment, true), gettype($alwaysSuggestSubsidyAssignment)), __LINE__);
        }
        if (is_null($alwaysSuggestSubsidyAssignment) || (is_array($alwaysSuggestSubsidyAssignment) && empty($alwaysSuggestSubsidyAssignment))) {
            unset($this->AlwaysSuggestSubsidyAssignment);
        } else {
            $this->AlwaysSuggestSubsidyAssignment = $alwaysSuggestSubsidyAssignment;
        }
        return $this;
    }
    /**
     * Get AutoReleaseSeatsTimeoutMin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAutoReleaseSeatsTimeoutMin()
    {
        return isset($this->AutoReleaseSeatsTimeoutMin) ? $this->AutoReleaseSeatsTimeoutMin : null;
    }
    /**
     * Set AutoReleaseSeatsTimeoutMin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $autoReleaseSeatsTimeoutMin
     * @return \patest\StructType\Security_SalesCompanyParameters
     */
    public function setAutoReleaseSeatsTimeoutMin($autoReleaseSeatsTimeoutMin = null)
    {
        // validation for constraint: int
        if (!is_null($autoReleaseSeatsTimeoutMin) && !(is_int($autoReleaseSeatsTimeoutMin) || ctype_digit($autoReleaseSeatsTimeoutMin))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($autoReleaseSeatsTimeoutMin, true), gettype($autoReleaseSeatsTimeoutMin)), __LINE__);
        }
        if (is_null($autoReleaseSeatsTimeoutMin) || (is_array($autoReleaseSeatsTimeoutMin) && empty($autoReleaseSeatsTimeoutMin))) {
            unset($this->AutoReleaseSeatsTimeoutMin);
        } else {
            $this->AutoReleaseSeatsTimeoutMin = $autoReleaseSeatsTimeoutMin;
        }
        return $this;
    }
    /**
     * Get AvailabilityGaugeHighOccupancyNominalThreshold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAvailabilityGaugeHighOccupancyNominalThreshold()
    {
        return isset($this->AvailabilityGaugeHighOccupancyNominalThreshold) ? $this->AvailabilityGaugeHighOccupancyNominalThreshold : null;
    }
    /**
     * Set AvailabilityGaugeHighOccupancyNominalThreshold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $availabilityGaugeHighOccupancyNominalThreshold
     * @return \patest\StructType\Security_SalesCompanyParameters
     */
    public function setAvailabilityGaugeHighOccupancyNominalThreshold($availabilityGaugeHighOccupancyNominalThreshold = null)
    {
        // validation for constraint: int
        if (!is_null($availabilityGaugeHighOccupancyNominalThreshold) && !(is_int($availabilityGaugeHighOccupancyNominalThreshold) || ctype_digit($availabilityGaugeHighOccupancyNominalThreshold))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($availabilityGaugeHighOccupancyNominalThreshold, true), gettype($availabilityGaugeHighOccupancyNominalThreshold)), __LINE__);
        }
        if (is_null($availabilityGaugeHighOccupancyNominalThreshold) || (is_array($availabilityGaugeHighOccupancyNominalThreshold) && empty($availabilityGaugeHighOccupancyNominalThreshold))) {
            unset($this->AvailabilityGaugeHighOccupancyNominalThreshold);
        } else {
            $this->AvailabilityGaugeHighOccupancyNominalThreshold = $availabilityGaugeHighOccupancyNominalThreshold;
        }
        return $this;
    }
    /**
     * Get AvailabilityGaugeHighOccupancyPercentageThreshold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAvailabilityGaugeHighOccupancyPercentageThreshold()
    {
        return isset($this->AvailabilityGaugeHighOccupancyPercentageThreshold) ? $this->AvailabilityGaugeHighOccupancyPercentageThreshold : null;
    }
    /**
     * Set AvailabilityGaugeHighOccupancyPercentageThreshold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $availabilityGaugeHighOccupancyPercentageThreshold
     * @return \patest\StructType\Security_SalesCompanyParameters
     */
    public function setAvailabilityGaugeHighOccupancyPercentageThreshold($availabilityGaugeHighOccupancyPercentageThreshold = null)
    {
        // validation for constraint: int
        if (!is_null($availabilityGaugeHighOccupancyPercentageThreshold) && !(is_int($availabilityGaugeHighOccupancyPercentageThreshold) || ctype_digit($availabilityGaugeHighOccupancyPercentageThreshold))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($availabilityGaugeHighOccupancyPercentageThreshold, true), gettype($availabilityGaugeHighOccupancyPercentageThreshold)), __LINE__);
        }
        if (is_null($availabilityGaugeHighOccupancyPercentageThreshold) || (is_array($availabilityGaugeHighOccupancyPercentageThreshold) && empty($availabilityGaugeHighOccupancyPercentageThreshold))) {
            unset($this->AvailabilityGaugeHighOccupancyPercentageThreshold);
        } else {
            $this->AvailabilityGaugeHighOccupancyPercentageThreshold = $availabilityGaugeHighOccupancyPercentageThreshold;
        }
        return $this;
    }
    /**
     * Get AvailabilityGaugeLowOccupancyNominalThreshold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAvailabilityGaugeLowOccupancyNominalThreshold()
    {
        return isset($this->AvailabilityGaugeLowOccupancyNominalThreshold) ? $this->AvailabilityGaugeLowOccupancyNominalThreshold : null;
    }
    /**
     * Set AvailabilityGaugeLowOccupancyNominalThreshold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $availabilityGaugeLowOccupancyNominalThreshold
     * @return \patest\StructType\Security_SalesCompanyParameters
     */
    public function setAvailabilityGaugeLowOccupancyNominalThreshold($availabilityGaugeLowOccupancyNominalThreshold = null)
    {
        // validation for constraint: int
        if (!is_null($availabilityGaugeLowOccupancyNominalThreshold) && !(is_int($availabilityGaugeLowOccupancyNominalThreshold) || ctype_digit($availabilityGaugeLowOccupancyNominalThreshold))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($availabilityGaugeLowOccupancyNominalThreshold, true), gettype($availabilityGaugeLowOccupancyNominalThreshold)), __LINE__);
        }
        if (is_null($availabilityGaugeLowOccupancyNominalThreshold) || (is_array($availabilityGaugeLowOccupancyNominalThreshold) && empty($availabilityGaugeLowOccupancyNominalThreshold))) {
            unset($this->AvailabilityGaugeLowOccupancyNominalThreshold);
        } else {
            $this->AvailabilityGaugeLowOccupancyNominalThreshold = $availabilityGaugeLowOccupancyNominalThreshold;
        }
        return $this;
    }
    /**
     * Get AvailabilityGaugeLowOccupancyPercentageThreshold value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAvailabilityGaugeLowOccupancyPercentageThreshold()
    {
        return isset($this->AvailabilityGaugeLowOccupancyPercentageThreshold) ? $this->AvailabilityGaugeLowOccupancyPercentageThreshold : null;
    }
    /**
     * Set AvailabilityGaugeLowOccupancyPercentageThreshold value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $availabilityGaugeLowOccupancyPercentageThreshold
     * @return \patest\StructType\Security_SalesCompanyParameters
     */
    public function setAvailabilityGaugeLowOccupancyPercentageThreshold($availabilityGaugeLowOccupancyPercentageThreshold = null)
    {
        // validation for constraint: int
        if (!is_null($availabilityGaugeLowOccupancyPercentageThreshold) && !(is_int($availabilityGaugeLowOccupancyPercentageThreshold) || ctype_digit($availabilityGaugeLowOccupancyPercentageThreshold))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($availabilityGaugeLowOccupancyPercentageThreshold, true), gettype($availabilityGaugeLowOccupancyPercentageThreshold)), __LINE__);
        }
        if (is_null($availabilityGaugeLowOccupancyPercentageThreshold) || (is_array($availabilityGaugeLowOccupancyPercentageThreshold) && empty($availabilityGaugeLowOccupancyPercentageThreshold))) {
            unset($this->AvailabilityGaugeLowOccupancyPercentageThreshold);
        } else {
            $this->AvailabilityGaugeLowOccupancyPercentageThreshold = $availabilityGaugeLowOccupancyPercentageThreshold;
        }
        return $this;
    }
    /**
     * Get BasketGroupingPerPriceType value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getBasketGroupingPerPriceType()
    {
        return isset($this->BasketGroupingPerPriceType) ? $this->BasketGroupingPerPriceType : null;
    }
    /**
     * Set BasketGroupingPerPriceType value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $basketGroupingPerPriceType
     * @return \patest\StructType\Security_SalesCompanyParameters
     */
    public function setBasketGroupingPerPriceType($basketGroupingPerPriceType = null)
    {
        // validation for constraint: boolean
        if (!is_null($basketGroupingPerPriceType) && !is_bool($basketGroupingPerPriceType)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($basketGroupingPerPriceType, true), gettype($basketGroupingPerPriceType)), __LINE__);
        }
        if (is_null($basketGroupingPerPriceType) || (is_array($basketGroupingPerPriceType) && empty($basketGroupingPerPriceType))) {
            unset($this->BasketGroupingPerPriceType);
        } else {
            $this->BasketGroupingPerPriceType = $basketGroupingPerPriceType;
        }
        return $this;
    }
    /**
     * Get BasketStateMode value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBasketStateMode()
    {
        return isset($this->BasketStateMode) ? $this->BasketStateMode : null;
    }
    /**
     * Set BasketStateMode value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\BasketStateMode::valueIsValid()
     * @uses \patest\EnumType\BasketStateMode::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $basketStateMode
     * @return \patest\StructType\Security_SalesCompanyParameters
     */
    public function setBasketStateMode($basketStateMode = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\BasketStateMode::valueIsValid($basketStateMode)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\BasketStateMode', is_array($basketStateMode) ? implode(', ', $basketStateMode) : var_export($basketStateMode, true), implode(', ', \patest\EnumType\BasketStateMode::getValidValues())), __LINE__);
        }
        if (is_null($basketStateMode) || (is_array($basketStateMode) && empty($basketStateMode))) {
            unset($this->BasketStateMode);
        } else {
            $this->BasketStateMode = $basketStateMode;
        }
        return $this;
    }
    /**
     * Get DefaultShiftOpenSum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \patest\StructType\Money|null
     */
    public function getDefaultShiftOpenSum()
    {
        return isset($this->DefaultShiftOpenSum) ? $this->DefaultShiftOpenSum : null;
    }
    /**
     * Set DefaultShiftOpenSum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \patest\StructType\Money $defaultShiftOpenSum
     * @return \patest\StructType\Security_SalesCompanyParameters
     */
    public function setDefaultShiftOpenSum(\patest\StructType\Money $defaultShiftOpenSum = null)
    {
        if (is_null($defaultShiftOpenSum) || (is_array($defaultShiftOpenSum) && empty($defaultShiftOpenSum))) {
            unset($this->DefaultShiftOpenSum);
        } else {
            $this->DefaultShiftOpenSum = $defaultShiftOpenSum;
        }
        return $this;
    }
    /**
     * Get DisplayAdvertisingPhaseInReservation value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDisplayAdvertisingPhaseInReservation()
    {
        return isset($this->DisplayAdvertisingPhaseInReservation) ? $this->DisplayAdvertisingPhaseInReservation : null;
    }
    /**
     * Set DisplayAdvertisingPhaseInReservation value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\DisplayAdvertisingPhaseInReservation::valueIsValid()
     * @uses \patest\EnumType\DisplayAdvertisingPhaseInReservation::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $displayAdvertisingPhaseInReservation
     * @return \patest\StructType\Security_SalesCompanyParameters
     */
    public function setDisplayAdvertisingPhaseInReservation($displayAdvertisingPhaseInReservation = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\DisplayAdvertisingPhaseInReservation::valueIsValid($displayAdvertisingPhaseInReservation)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\DisplayAdvertisingPhaseInReservation', is_array($displayAdvertisingPhaseInReservation) ? implode(', ', $displayAdvertisingPhaseInReservation) : var_export($displayAdvertisingPhaseInReservation, true), implode(', ', \patest\EnumType\DisplayAdvertisingPhaseInReservation::getValidValues())), __LINE__);
        }
        if (is_null($displayAdvertisingPhaseInReservation) || (is_array($displayAdvertisingPhaseInReservation) && empty($displayAdvertisingPhaseInReservation))) {
            unset($this->DisplayAdvertisingPhaseInReservation);
        } else {
            $this->DisplayAdvertisingPhaseInReservation = $displayAdvertisingPhaseInReservation;
        }
        return $this;
    }
    /**
     * Get EventsCrossOrgUnitsSalesPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEventsCrossOrgUnitsSalesPolicy()
    {
        return isset($this->EventsCrossOrgUnitsSalesPolicy) ? $this->EventsCrossOrgUnitsSalesPolicy : null;
    }
    /**
     * Set EventsCrossOrgUnitsSalesPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CrossOrgUnitsSalesPolicy::valueIsValid()
     * @uses \patest\EnumType\CrossOrgUnitsSalesPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $eventsCrossOrgUnitsSalesPolicy
     * @return \patest\StructType\Security_SalesCompanyParameters
     */
    public function setEventsCrossOrgUnitsSalesPolicy($eventsCrossOrgUnitsSalesPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\CrossOrgUnitsSalesPolicy::valueIsValid($eventsCrossOrgUnitsSalesPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CrossOrgUnitsSalesPolicy', is_array($eventsCrossOrgUnitsSalesPolicy) ? implode(', ', $eventsCrossOrgUnitsSalesPolicy) : var_export($eventsCrossOrgUnitsSalesPolicy, true), implode(', ', \patest\EnumType\CrossOrgUnitsSalesPolicy::getValidValues())), __LINE__);
        }
        if (is_null($eventsCrossOrgUnitsSalesPolicy) || (is_array($eventsCrossOrgUnitsSalesPolicy) && empty($eventsCrossOrgUnitsSalesPolicy))) {
            unset($this->EventsCrossOrgUnitsSalesPolicy);
        } else {
            $this->EventsCrossOrgUnitsSalesPolicy = $eventsCrossOrgUnitsSalesPolicy;
        }
        return $this;
    }
    /**
     * Get ExcludeActionsWhenSettingRestrictions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getExcludeActionsWhenSettingRestrictions()
    {
        return isset($this->ExcludeActionsWhenSettingRestrictions) ? $this->ExcludeActionsWhenSettingRestrictions : null;
    }
    /**
     * Set ExcludeActionsWhenSettingRestrictions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $excludeActionsWhenSettingRestrictions
     * @return \patest\StructType\Security_SalesCompanyParameters
     */
    public function setExcludeActionsWhenSettingRestrictions($excludeActionsWhenSettingRestrictions = null)
    {
        // validation for constraint: string
        if (!is_null($excludeActionsWhenSettingRestrictions) && !is_string($excludeActionsWhenSettingRestrictions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($excludeActionsWhenSettingRestrictions, true), gettype($excludeActionsWhenSettingRestrictions)), __LINE__);
        }
        if (is_null($excludeActionsWhenSettingRestrictions) || (is_array($excludeActionsWhenSettingRestrictions) && empty($excludeActionsWhenSettingRestrictions))) {
            unset($this->ExcludeActionsWhenSettingRestrictions);
        } else {
            $this->ExcludeActionsWhenSettingRestrictions = $excludeActionsWhenSettingRestrictions;
        }
        return $this;
    }
    /**
     * Get FilterHallViewerPriceLevels value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getFilterHallViewerPriceLevels()
    {
        return isset($this->FilterHallViewerPriceLevels) ? $this->FilterHallViewerPriceLevels : null;
    }
    /**
     * Set FilterHallViewerPriceLevels value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $filterHallViewerPriceLevels
     * @return \patest\StructType\Security_SalesCompanyParameters
     */
    public function setFilterHallViewerPriceLevels($filterHallViewerPriceLevels = null)
    {
        // validation for constraint: boolean
        if (!is_null($filterHallViewerPriceLevels) && !is_bool($filterHallViewerPriceLevels)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($filterHallViewerPriceLevels, true), gettype($filterHallViewerPriceLevels)), __LINE__);
        }
        if (is_null($filterHallViewerPriceLevels) || (is_array($filterHallViewerPriceLevels) && empty($filterHallViewerPriceLevels))) {
            unset($this->FilterHallViewerPriceLevels);
        } else {
            $this->FilterHallViewerPriceLevels = $filterHallViewerPriceLevels;
        }
        return $this;
    }
    /**
     * Get FollowupFromDays value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getFollowupFromDays()
    {
        return isset($this->FollowupFromDays) ? $this->FollowupFromDays : null;
    }
    /**
     * Set FollowupFromDays value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $followupFromDays
     * @return \patest\StructType\Security_SalesCompanyParameters
     */
    public function setFollowupFromDays($followupFromDays = null)
    {
        // validation for constraint: int
        if (!is_null($followupFromDays) && !(is_int($followupFromDays) || ctype_digit($followupFromDays))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($followupFromDays, true), gettype($followupFromDays)), __LINE__);
        }
        if (is_null($followupFromDays) || (is_array($followupFromDays) && empty($followupFromDays))) {
            unset($this->FollowupFromDays);
        } else {
            $this->FollowupFromDays = $followupFromDays;
        }
        return $this;
    }
    /**
     * Get FollowupInEventSaleSearchCountOnlySpecificEventTickets value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getFollowupInEventSaleSearchCountOnlySpecificEventTickets()
    {
        return isset($this->FollowupInEventSaleSearchCountOnlySpecificEventTickets) ? $this->FollowupInEventSaleSearchCountOnlySpecificEventTickets : null;
    }
    /**
     * Set FollowupInEventSaleSearchCountOnlySpecificEventTickets value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $followupInEventSaleSearchCountOnlySpecificEventTickets
     * @return \patest\StructType\Security_SalesCompanyParameters
     */
    public function setFollowupInEventSaleSearchCountOnlySpecificEventTickets($followupInEventSaleSearchCountOnlySpecificEventTickets = null)
    {
        // validation for constraint: boolean
        if (!is_null($followupInEventSaleSearchCountOnlySpecificEventTickets) && !is_bool($followupInEventSaleSearchCountOnlySpecificEventTickets)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($followupInEventSaleSearchCountOnlySpecificEventTickets, true), gettype($followupInEventSaleSearchCountOnlySpecificEventTickets)), __LINE__);
        }
        if (is_null($followupInEventSaleSearchCountOnlySpecificEventTickets) || (is_array($followupInEventSaleSearchCountOnlySpecificEventTickets) && empty($followupInEventSaleSearchCountOnlySpecificEventTickets))) {
            unset($this->FollowupInEventSaleSearchCountOnlySpecificEventTickets);
        } else {
            $this->FollowupInEventSaleSearchCountOnlySpecificEventTickets = $followupInEventSaleSearchCountOnlySpecificEventTickets;
        }
        return $this;
    }
    /**
     * Get GiftVouchersCrossOrgUnitsSalesPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGiftVouchersCrossOrgUnitsSalesPolicy()
    {
        return isset($this->GiftVouchersCrossOrgUnitsSalesPolicy) ? $this->GiftVouchersCrossOrgUnitsSalesPolicy : null;
    }
    /**
     * Set GiftVouchersCrossOrgUnitsSalesPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CrossOrgUnitsSalesPolicy::valueIsValid()
     * @uses \patest\EnumType\CrossOrgUnitsSalesPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $giftVouchersCrossOrgUnitsSalesPolicy
     * @return \patest\StructType\Security_SalesCompanyParameters
     */
    public function setGiftVouchersCrossOrgUnitsSalesPolicy($giftVouchersCrossOrgUnitsSalesPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\CrossOrgUnitsSalesPolicy::valueIsValid($giftVouchersCrossOrgUnitsSalesPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CrossOrgUnitsSalesPolicy', is_array($giftVouchersCrossOrgUnitsSalesPolicy) ? implode(', ', $giftVouchersCrossOrgUnitsSalesPolicy) : var_export($giftVouchersCrossOrgUnitsSalesPolicy, true), implode(', ', \patest\EnumType\CrossOrgUnitsSalesPolicy::getValidValues())), __LINE__);
        }
        if (is_null($giftVouchersCrossOrgUnitsSalesPolicy) || (is_array($giftVouchersCrossOrgUnitsSalesPolicy) && empty($giftVouchersCrossOrgUnitsSalesPolicy))) {
            unset($this->GiftVouchersCrossOrgUnitsSalesPolicy);
        } else {
            $this->GiftVouchersCrossOrgUnitsSalesPolicy = $giftVouchersCrossOrgUnitsSalesPolicy;
        }
        return $this;
    }
    /**
     * Get HiddenSeatAttributes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getHiddenSeatAttributes()
    {
        return isset($this->HiddenSeatAttributes) ? $this->HiddenSeatAttributes : null;
    }
    /**
     * Set HiddenSeatAttributes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $hiddenSeatAttributes
     * @return \patest\StructType\Security_SalesCompanyParameters
     */
    public function setHiddenSeatAttributes($hiddenSeatAttributes = null)
    {
        // validation for constraint: string
        if (!is_null($hiddenSeatAttributes) && !is_string($hiddenSeatAttributes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a string, %s given', var_export($hiddenSeatAttributes, true), gettype($hiddenSeatAttributes)), __LINE__);
        }
        if (is_null($hiddenSeatAttributes) || (is_array($hiddenSeatAttributes) && empty($hiddenSeatAttributes))) {
            unset($this->HiddenSeatAttributes);
        } else {
            $this->HiddenSeatAttributes = $hiddenSeatAttributes;
        }
        return $this;
    }
    /**
     * Get IsCloseAfterMidnight value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getIsCloseAfterMidnight()
    {
        return isset($this->IsCloseAfterMidnight) ? $this->IsCloseAfterMidnight : null;
    }
    /**
     * Set IsCloseAfterMidnight value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $isCloseAfterMidnight
     * @return \patest\StructType\Security_SalesCompanyParameters
     */
    public function setIsCloseAfterMidnight($isCloseAfterMidnight = null)
    {
        // validation for constraint: boolean
        if (!is_null($isCloseAfterMidnight) && !is_bool($isCloseAfterMidnight)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($isCloseAfterMidnight, true), gettype($isCloseAfterMidnight)), __LINE__);
        }
        if (is_null($isCloseAfterMidnight) || (is_array($isCloseAfterMidnight) && empty($isCloseAfterMidnight))) {
            unset($this->IsCloseAfterMidnight);
        } else {
            $this->IsCloseAfterMidnight = $isCloseAfterMidnight;
        }
        return $this;
    }
    /**
     * Get MembershipCrossOrgUnitsSalesPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMembershipCrossOrgUnitsSalesPolicy()
    {
        return isset($this->MembershipCrossOrgUnitsSalesPolicy) ? $this->MembershipCrossOrgUnitsSalesPolicy : null;
    }
    /**
     * Set MembershipCrossOrgUnitsSalesPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CrossOrgUnitsSalesPolicy::valueIsValid()
     * @uses \patest\EnumType\CrossOrgUnitsSalesPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $membershipCrossOrgUnitsSalesPolicy
     * @return \patest\StructType\Security_SalesCompanyParameters
     */
    public function setMembershipCrossOrgUnitsSalesPolicy($membershipCrossOrgUnitsSalesPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\CrossOrgUnitsSalesPolicy::valueIsValid($membershipCrossOrgUnitsSalesPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CrossOrgUnitsSalesPolicy', is_array($membershipCrossOrgUnitsSalesPolicy) ? implode(', ', $membershipCrossOrgUnitsSalesPolicy) : var_export($membershipCrossOrgUnitsSalesPolicy, true), implode(', ', \patest\EnumType\CrossOrgUnitsSalesPolicy::getValidValues())), __LINE__);
        }
        if (is_null($membershipCrossOrgUnitsSalesPolicy) || (is_array($membershipCrossOrgUnitsSalesPolicy) && empty($membershipCrossOrgUnitsSalesPolicy))) {
            unset($this->MembershipCrossOrgUnitsSalesPolicy);
        } else {
            $this->MembershipCrossOrgUnitsSalesPolicy = $membershipCrossOrgUnitsSalesPolicy;
        }
        return $this;
    }
    /**
     * Get MerchandiseCrossOrgUnitsSalesPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMerchandiseCrossOrgUnitsSalesPolicy()
    {
        return isset($this->MerchandiseCrossOrgUnitsSalesPolicy) ? $this->MerchandiseCrossOrgUnitsSalesPolicy : null;
    }
    /**
     * Set MerchandiseCrossOrgUnitsSalesPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CrossOrgUnitsSalesPolicy::valueIsValid()
     * @uses \patest\EnumType\CrossOrgUnitsSalesPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $merchandiseCrossOrgUnitsSalesPolicy
     * @return \patest\StructType\Security_SalesCompanyParameters
     */
    public function setMerchandiseCrossOrgUnitsSalesPolicy($merchandiseCrossOrgUnitsSalesPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\CrossOrgUnitsSalesPolicy::valueIsValid($merchandiseCrossOrgUnitsSalesPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CrossOrgUnitsSalesPolicy', is_array($merchandiseCrossOrgUnitsSalesPolicy) ? implode(', ', $merchandiseCrossOrgUnitsSalesPolicy) : var_export($merchandiseCrossOrgUnitsSalesPolicy, true), implode(', ', \patest\EnumType\CrossOrgUnitsSalesPolicy::getValidValues())), __LINE__);
        }
        if (is_null($merchandiseCrossOrgUnitsSalesPolicy) || (is_array($merchandiseCrossOrgUnitsSalesPolicy) && empty($merchandiseCrossOrgUnitsSalesPolicy))) {
            unset($this->MerchandiseCrossOrgUnitsSalesPolicy);
        } else {
            $this->MerchandiseCrossOrgUnitsSalesPolicy = $merchandiseCrossOrgUnitsSalesPolicy;
        }
        return $this;
    }
    /**
     * Get NotBasketNetTotalInsteadTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNotBasketNetTotalInsteadTotal()
    {
        return isset($this->NotBasketNetTotalInsteadTotal) ? $this->NotBasketNetTotalInsteadTotal : null;
    }
    /**
     * Set NotBasketNetTotalInsteadTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $notBasketNetTotalInsteadTotal
     * @return \patest\StructType\Security_SalesCompanyParameters
     */
    public function setNotBasketNetTotalInsteadTotal($notBasketNetTotalInsteadTotal = null)
    {
        // validation for constraint: boolean
        if (!is_null($notBasketNetTotalInsteadTotal) && !is_bool($notBasketNetTotalInsteadTotal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($notBasketNetTotalInsteadTotal, true), gettype($notBasketNetTotalInsteadTotal)), __LINE__);
        }
        if (is_null($notBasketNetTotalInsteadTotal) || (is_array($notBasketNetTotalInsteadTotal) && empty($notBasketNetTotalInsteadTotal))) {
            unset($this->NotBasketNetTotalInsteadTotal);
        } else {
            $this->NotBasketNetTotalInsteadTotal = $notBasketNetTotalInsteadTotal;
        }
        return $this;
    }
    /**
     * Get NumberOfDaysWhenRetrievingFutureEvents value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumberOfDaysWhenRetrievingFutureEvents()
    {
        return isset($this->NumberOfDaysWhenRetrievingFutureEvents) ? $this->NumberOfDaysWhenRetrievingFutureEvents : null;
    }
    /**
     * Set NumberOfDaysWhenRetrievingFutureEvents value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numberOfDaysWhenRetrievingFutureEvents
     * @return \patest\StructType\Security_SalesCompanyParameters
     */
    public function setNumberOfDaysWhenRetrievingFutureEvents($numberOfDaysWhenRetrievingFutureEvents = null)
    {
        // validation for constraint: int
        if (!is_null($numberOfDaysWhenRetrievingFutureEvents) && !(is_int($numberOfDaysWhenRetrievingFutureEvents) || ctype_digit($numberOfDaysWhenRetrievingFutureEvents))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($numberOfDaysWhenRetrievingFutureEvents, true), gettype($numberOfDaysWhenRetrievingFutureEvents)), __LINE__);
        }
        if (is_null($numberOfDaysWhenRetrievingFutureEvents) || (is_array($numberOfDaysWhenRetrievingFutureEvents) && empty($numberOfDaysWhenRetrievingFutureEvents))) {
            unset($this->NumberOfDaysWhenRetrievingFutureEvents);
        } else {
            $this->NumberOfDaysWhenRetrievingFutureEvents = $numberOfDaysWhenRetrievingFutureEvents;
        }
        return $this;
    }
    /**
     * Get SalesPopupSeatInfo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSalesPopupSeatInfo()
    {
        return isset($this->SalesPopupSeatInfo) ? $this->SalesPopupSeatInfo : null;
    }
    /**
     * Set SalesPopupSeatInfo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $salesPopupSeatInfo
     * @return \patest\StructType\Security_SalesCompanyParameters
     */
    public function setSalesPopupSeatInfo($salesPopupSeatInfo = null)
    {
        // validation for constraint: boolean
        if (!is_null($salesPopupSeatInfo) && !is_bool($salesPopupSeatInfo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($salesPopupSeatInfo, true), gettype($salesPopupSeatInfo)), __LINE__);
        }
        if (is_null($salesPopupSeatInfo) || (is_array($salesPopupSeatInfo) && empty($salesPopupSeatInfo))) {
            unset($this->SalesPopupSeatInfo);
        } else {
            $this->SalesPopupSeatInfo = $salesPopupSeatInfo;
        }
        return $this;
    }
    /**
     * Get SeriesCrossOrgUnitsSalesPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeriesCrossOrgUnitsSalesPolicy()
    {
        return isset($this->SeriesCrossOrgUnitsSalesPolicy) ? $this->SeriesCrossOrgUnitsSalesPolicy : null;
    }
    /**
     * Set SeriesCrossOrgUnitsSalesPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @uses \patest\EnumType\CrossOrgUnitsSalesPolicy::valueIsValid()
     * @uses \patest\EnumType\CrossOrgUnitsSalesPolicy::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $seriesCrossOrgUnitsSalesPolicy
     * @return \patest\StructType\Security_SalesCompanyParameters
     */
    public function setSeriesCrossOrgUnitsSalesPolicy($seriesCrossOrgUnitsSalesPolicy = null)
    {
        // validation for constraint: enumeration
        if (!\patest\EnumType\CrossOrgUnitsSalesPolicy::valueIsValid($seriesCrossOrgUnitsSalesPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value(s) %s, please use one of: %s from enumeration class \patest\EnumType\CrossOrgUnitsSalesPolicy', is_array($seriesCrossOrgUnitsSalesPolicy) ? implode(', ', $seriesCrossOrgUnitsSalesPolicy) : var_export($seriesCrossOrgUnitsSalesPolicy, true), implode(', ', \patest\EnumType\CrossOrgUnitsSalesPolicy::getValidValues())), __LINE__);
        }
        if (is_null($seriesCrossOrgUnitsSalesPolicy) || (is_array($seriesCrossOrgUnitsSalesPolicy) && empty($seriesCrossOrgUnitsSalesPolicy))) {
            unset($this->SeriesCrossOrgUnitsSalesPolicy);
        } else {
            $this->SeriesCrossOrgUnitsSalesPolicy = $seriesCrossOrgUnitsSalesPolicy;
        }
        return $this;
    }
    /**
     * Get SetShiftOpenSum value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSetShiftOpenSum()
    {
        return isset($this->SetShiftOpenSum) ? $this->SetShiftOpenSum : null;
    }
    /**
     * Set SetShiftOpenSum value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $setShiftOpenSum
     * @return \patest\StructType\Security_SalesCompanyParameters
     */
    public function setSetShiftOpenSum($setShiftOpenSum = null)
    {
        // validation for constraint: boolean
        if (!is_null($setShiftOpenSum) && !is_bool($setShiftOpenSum)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($setShiftOpenSum, true), gettype($setShiftOpenSum)), __LINE__);
        }
        if (is_null($setShiftOpenSum) || (is_array($setShiftOpenSum) && empty($setShiftOpenSum))) {
            unset($this->SetShiftOpenSum);
        } else {
            $this->SetShiftOpenSum = $setShiftOpenSum;
        }
        return $this;
    }
    /**
     * Get UnloadFutureEventSeatingPlanManagerTimeoutHr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUnloadFutureEventSeatingPlanManagerTimeoutHr()
    {
        return isset($this->UnloadFutureEventSeatingPlanManagerTimeoutHr) ? $this->UnloadFutureEventSeatingPlanManagerTimeoutHr : null;
    }
    /**
     * Set UnloadFutureEventSeatingPlanManagerTimeoutHr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $unloadFutureEventSeatingPlanManagerTimeoutHr
     * @return \patest\StructType\Security_SalesCompanyParameters
     */
    public function setUnloadFutureEventSeatingPlanManagerTimeoutHr($unloadFutureEventSeatingPlanManagerTimeoutHr = null)
    {
        // validation for constraint: int
        if (!is_null($unloadFutureEventSeatingPlanManagerTimeoutHr) && !(is_int($unloadFutureEventSeatingPlanManagerTimeoutHr) || ctype_digit($unloadFutureEventSeatingPlanManagerTimeoutHr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($unloadFutureEventSeatingPlanManagerTimeoutHr, true), gettype($unloadFutureEventSeatingPlanManagerTimeoutHr)), __LINE__);
        }
        if (is_null($unloadFutureEventSeatingPlanManagerTimeoutHr) || (is_array($unloadFutureEventSeatingPlanManagerTimeoutHr) && empty($unloadFutureEventSeatingPlanManagerTimeoutHr))) {
            unset($this->UnloadFutureEventSeatingPlanManagerTimeoutHr);
        } else {
            $this->UnloadFutureEventSeatingPlanManagerTimeoutHr = $unloadFutureEventSeatingPlanManagerTimeoutHr;
        }
        return $this;
    }
    /**
     * Get UnloadPastEventSeatingPlanManagerTimeoutHr value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getUnloadPastEventSeatingPlanManagerTimeoutHr()
    {
        return isset($this->UnloadPastEventSeatingPlanManagerTimeoutHr) ? $this->UnloadPastEventSeatingPlanManagerTimeoutHr : null;
    }
    /**
     * Set UnloadPastEventSeatingPlanManagerTimeoutHr value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $unloadPastEventSeatingPlanManagerTimeoutHr
     * @return \patest\StructType\Security_SalesCompanyParameters
     */
    public function setUnloadPastEventSeatingPlanManagerTimeoutHr($unloadPastEventSeatingPlanManagerTimeoutHr = null)
    {
        // validation for constraint: int
        if (!is_null($unloadPastEventSeatingPlanManagerTimeoutHr) && !(is_int($unloadPastEventSeatingPlanManagerTimeoutHr) || ctype_digit($unloadPastEventSeatingPlanManagerTimeoutHr))) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide an integer value, %s given', var_export($unloadPastEventSeatingPlanManagerTimeoutHr, true), gettype($unloadPastEventSeatingPlanManagerTimeoutHr)), __LINE__);
        }
        if (is_null($unloadPastEventSeatingPlanManagerTimeoutHr) || (is_array($unloadPastEventSeatingPlanManagerTimeoutHr) && empty($unloadPastEventSeatingPlanManagerTimeoutHr))) {
            unset($this->UnloadPastEventSeatingPlanManagerTimeoutHr);
        } else {
            $this->UnloadPastEventSeatingPlanManagerTimeoutHr = $unloadPastEventSeatingPlanManagerTimeoutHr;
        }
        return $this;
    }
    /**
     * Get UseAdvertisingRules value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUseAdvertisingRules()
    {
        return isset($this->UseAdvertisingRules) ? $this->UseAdvertisingRules : null;
    }
    /**
     * Set UseAdvertisingRules value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $useAdvertisingRules
     * @return \patest\StructType\Security_SalesCompanyParameters
     */
    public function setUseAdvertisingRules($useAdvertisingRules = null)
    {
        // validation for constraint: boolean
        if (!is_null($useAdvertisingRules) && !is_bool($useAdvertisingRules)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useAdvertisingRules, true), gettype($useAdvertisingRules)), __LINE__);
        }
        if (is_null($useAdvertisingRules) || (is_array($useAdvertisingRules) && empty($useAdvertisingRules))) {
            unset($this->UseAdvertisingRules);
        } else {
            $this->UseAdvertisingRules = $useAdvertisingRules;
        }
        return $this;
    }
    /**
     * Get UseCrossOrgUnitsSalesPolicy value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUseCrossOrgUnitsSalesPolicy()
    {
        return isset($this->UseCrossOrgUnitsSalesPolicy) ? $this->UseCrossOrgUnitsSalesPolicy : null;
    }
    /**
     * Set UseCrossOrgUnitsSalesPolicy value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $useCrossOrgUnitsSalesPolicy
     * @return \patest\StructType\Security_SalesCompanyParameters
     */
    public function setUseCrossOrgUnitsSalesPolicy($useCrossOrgUnitsSalesPolicy = null)
    {
        // validation for constraint: boolean
        if (!is_null($useCrossOrgUnitsSalesPolicy) && !is_bool($useCrossOrgUnitsSalesPolicy)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useCrossOrgUnitsSalesPolicy, true), gettype($useCrossOrgUnitsSalesPolicy)), __LINE__);
        }
        if (is_null($useCrossOrgUnitsSalesPolicy) || (is_array($useCrossOrgUnitsSalesPolicy) && empty($useCrossOrgUnitsSalesPolicy))) {
            unset($this->UseCrossOrgUnitsSalesPolicy);
        } else {
            $this->UseCrossOrgUnitsSalesPolicy = $useCrossOrgUnitsSalesPolicy;
        }
        return $this;
    }
    /**
     * Get UseGroupingTransactions value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUseGroupingTransactions()
    {
        return isset($this->UseGroupingTransactions) ? $this->UseGroupingTransactions : null;
    }
    /**
     * Set UseGroupingTransactions value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $useGroupingTransactions
     * @return \patest\StructType\Security_SalesCompanyParameters
     */
    public function setUseGroupingTransactions($useGroupingTransactions = null)
    {
        // validation for constraint: boolean
        if (!is_null($useGroupingTransactions) && !is_bool($useGroupingTransactions)) {
            throw new \InvalidArgumentException(sprintf('Invalid value %s, please provide a bool, %s given', var_export($useGroupingTransactions, true), gettype($useGroupingTransactions)), __LINE__);
        }
        if (is_null($useGroupingTransactions) || (is_array($useGroupingTransactions) && empty($useGroupingTransactions))) {
            unset($this->UseGroupingTransactions);
        } else {
            $this->UseGroupingTransactions = $useGroupingTransactions;
        }
        return $this;
    }
}
